package com.elitesland.fin.repo.writeoff;

import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.param.recorder.RecOrderExPageParam;
import com.elitesland.fin.application.facade.vo.recorder.RecOrderExVo;
import com.elitesland.fin.domain.entity.recorder.QRecOrderDO;
import com.elitesland.fin.domain.entity.recorder.QRecOrderExDo;
import com.elitesland.fin.domain.entity.recorder.QRecOrderExDtlDo;
import com.elitesland.fin.domain.entity.recorder.RecOrderExDo;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import org.springframework.stereotype.Repository;

/**
 * 收款单
 *
 * @author lucan.liu
 * @since 2023/9/27
 */
@Repository
public class RecOrderExRepoProc extends BaseRepoProc<RecOrderExDo> {

    private static final QRecOrderExDo qRecOrderExDo = QRecOrderExDo.recOrderExDo;
    private static final QRecOrderDO qRecOrderDO = QRecOrderDO.recOrderDO;
    private static final QRecOrderExDtlDo qRecOrderExDtlDo = QRecOrderExDtlDo.recOrderExDtlDo;

    protected RecOrderExRepoProc() {
        super(qRecOrderExDo);
    }

    /**
     * 查询收款单明细、明细扩展集合.
     *
     * @param query 查询条件
     * @return 查询结果集
     */
    public PagingVO<RecOrderExVo> page(RecOrderExPageParam query) {

        Predicate predicate = PredicateBuilder.builder()
                .andLike(qRecOrderDO.recOrderNo, query.getRecOrderNo())
                .andEq(qRecOrderDO.ouCode, query.getRecOuCode())
                .andEq(qRecOrderDO.buCode, query.getBuCode())
                .andEq(qRecOrderDO.custCode, query.getCustCode())
                .andGoe(qRecOrderDO.totalAmt, query.getTotalAmtFrom())
                .andLoe(qRecOrderDO.totalAmt, query.getTotalAmtTo())
                .andLike(qRecOrderDO.sourceNo, query.getSourceNo())
                .andEq(qRecOrderDO.initFlag, query.getInitFlag())
                .andEq(qRecOrderExDo.invoiceNumber, query.getInvoiceNumber())
                .andEq(qRecOrderExDo.remark, query.getRemark())
                .andEq(qRecOrderExDo.redFlushSign, query.getRedFlushSign())
                .andBetween(qRecOrderExDo.createTime, query.getCreateTimeStart(), query.getCreateTimeEnd())
                .andBetween(qRecOrderExDo.createTime, query.getReDateStart(), query.getReDateEnd())
                .andEq(qRecOrderExDtlDo.businessCode, query.getBusinessCode())
                .andEq(qRecOrderDO.saleUser, query.getBusinessCode())
                .andEq(qRecOrderDO.verState, query.getVerState())
                .andIn(qRecOrderDO.verState, query.getVerStateList())
                .andIn(qRecOrderDO.id,query.getIds())
                .build();

        JPAQuery<RecOrderExVo> select = jpaQueryFactory.select(Projections.bean(RecOrderExVo.class,
                        qRecOrderExDo.id.as("extId"),
                        qRecOrderExDo.invoiceNumber,
                        qRecOrderExDo.relateId,
                        qRecOrderExDo.redFlushSign,
                        qRecOrderExDo.thirdPaymentAssistance,
                        qRecOrderExDo.consumerCardSsistance,
                        qRecOrderExDo.creditCardAssistance,
                        qRecOrderExDo.payType,
                        qRecOrderExDo.recBank,
                        qRecOrderExDo.payBank,
                        qRecOrderExDo.deleteFlag,
                        qRecOrderExDo.tenantId,
                        qRecOrderExDo.belongOrgId,
                        qRecOrderExDo.tenantOrgId,
                        qRecOrderExDo.createTime,
                        qRecOrderExDo.updater,
                        qRecOrderExDo.modifyTime,
                        qRecOrderExDo.creator,
                        qRecOrderExDo.remark,
                        qRecOrderDO.id,
                        qRecOrderDO.sourceNo,
                        qRecOrderDO.ouCode,
                        qRecOrderDO.ouName,
                        qRecOrderDO.buCode,
                        qRecOrderDO.buName,
                        qRecOrderDO.arTypeName,
                        qRecOrderDO.arTypeCode,
                        qRecOrderDO.recTypeCode,
                        qRecOrderDO.recTypeName,
                        qRecOrderDO.recOrderNo,
                        qRecOrderDO.currCode,
                        qRecOrderDO.currName,
                        qRecOrderDO.totalAmt,
                        qRecOrderDO.totalCurAmt,
                        qRecOrderDO.auditUserId,
                        qRecOrderDO.auditUser,
                        qRecOrderDO.auditDate,
                        qRecOrderDO.orderState,
                        qRecOrderDO.exchangeRate,
                        qRecOrderDO.initFlag,
                        qRecOrderDO.realRecAmt,
                        qRecOrderDO.realRecCurAmt,
                        qRecOrderDO.reDate,
                        qRecOrderDO.reFlag,
                        qRecOrderDO.auditRejection,
                        qRecOrderDO.createMode,
                        qRecOrderDO.verState,
                        qRecOrderDO.verAmt,
                        qRecOrderDO.custCode,
                        qRecOrderDO.custName,
                        qRecOrderDO.recOuCode,
                        qRecOrderDO.recOuName,
                        qRecOrderDO.taxAmt,
                        qRecOrderDO.recOrderType,
                        qRecOrderDO.saleUser,
                        qRecOrderDO.creator,
                        qRecOrderDO.remark,
                        qRecOrderDO.taxCurAmt,
                        qRecOrderDO.createTime,
                        qRecOrderDO.modifyTime,
                        qRecOrderDO.updater,
                        qRecOrderDO.approvedTime,
                        qRecOrderDO.submitTime,
                        qRecOrderDO.docType,
                        qRecOrderExDtlDo.id.as("dtExId")
                ))
                .from(qRecOrderExDo)
                .leftJoin(qRecOrderExDtlDo).on(qRecOrderExDo.id.eq(qRecOrderExDtlDo.masId))
                .where(predicate)
                .groupBy(qRecOrderExDo.id);
        return super.queryByPage(select, query.getPageRequest(), qRecOrderExDo.createTime.desc());
    }

}
