/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.repo.creditaccount;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.dto.creditaccount.CreditAccountIocDTO;
import com.elitesland.fin.application.facade.param.creditaccount.CreditAccountIocParam;
import com.elitesland.fin.application.facade.vo.creditaccount.CreditAccountIocParamVO;
import com.elitesland.fin.entity.creditaccount.QCreditAccountIocDO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class CreditAccountIocRepoProc {
    private final JPAQueryFactory jpaQueryFactory;
    private final QCreditAccountIocDO jpaQDo = QCreditAccountIocDO.creditAccountIocDO;

    public PagingVO<CreditAccountIocDTO> search(CreditAccountIocParamVO param) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(CreditAccountIocDTO.class, (Expression[])new Expression[]{this.jpaQDo.id, this.jpaQDo.ioCode, this.jpaQDo.ioName, this.jpaQDo.ioType, this.jpaQDo.status, this.jpaQDo.remark, this.jpaQDo.createUserId, this.jpaQDo.creator, this.jpaQDo.createTime, this.jpaQDo.modifyUserId, this.jpaQDo.updater, this.jpaQDo.modifyTime, this.jpaQDo.deleteFlag, this.jpaQDo.tenantId, this.jpaQDo.auditDataVersion})).from((EntityPath)this.jpaQDo);
        if (param != null) {
            jpaQuery.where(this.where(param));
            param.fillOrders(jpaQuery, this.jpaQDo);
            param.setPaging(jpaQuery);
        }
        jpaQuery.where((Predicate)this.jpaQDo.deleteFlag.eq((Object)0).or((Predicate)this.jpaQDo.deleteFlag.isNull()));
        return PagingVO.builder().total(jpaQuery.fetchCount()).records(jpaQuery.fetch()).build();
    }

    public JPAQuery<CreditAccountIocDTO> select(CreditAccountIocParamVO param) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(CreditAccountIocDTO.class, (Expression[])new Expression[]{this.jpaQDo.id, this.jpaQDo.ioCode, this.jpaQDo.ioName, this.jpaQDo.ioType, this.jpaQDo.status, this.jpaQDo.remark, this.jpaQDo.createUserId, this.jpaQDo.creator, this.jpaQDo.createTime, this.jpaQDo.modifyUserId, this.jpaQDo.updater, this.jpaQDo.modifyTime, this.jpaQDo.deleteFlag, this.jpaQDo.tenantId, this.jpaQDo.auditDataVersion})).from((EntityPath)this.jpaQDo);
        if (Objects.nonNull(param)) {
            jpaQuery.where(this.where(param));
            if (!CollectionUtils.isEmpty((Collection)param.getOrders())) {
                param.fillOrders(jpaQuery, this.jpaQDo);
            }
        }
        jpaQuery.where((Predicate)this.jpaQDo.deleteFlag.eq((Object)0).or((Predicate)this.jpaQDo.deleteFlag.isNull()));
        return jpaQuery;
    }

    public Predicate where(CreditAccountIocParamVO param) {
        BooleanExpression predicate = this.jpaQDo.isNotNull();
        if (param.getId() != null) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.jpaQDo.id.eq((Object)param.getId()));
        }
        if (!CollectionUtils.isEmpty(param.getIdList())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.jpaQDo.id.in(param.getIdList()));
        }
        if (!StringUtils.isEmpty((String)param.getKeyword())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.jpaQDo.ioCode.like("%" + param.getKeyword() + "%").or((Predicate)this.jpaQDo.ioName.like("%" + param.getKeyword() + "%")));
        }
        if (!StringUtils.isEmpty((String)param.getIoCode())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.jpaQDo.ioCode.eq((Object)param.getIoCode()));
        }
        if (!CollectionUtils.isEmpty(param.getIoCodeList())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.jpaQDo.ioCode.in(param.getIoCodeList()));
        }
        if (!StringUtils.isEmpty((String)param.getIoName())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.jpaQDo.ioName.eq((Object)param.getIoName()));
        }
        if (!StringUtils.isEmpty((String)param.getIoType())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.jpaQDo.ioType.eq((Object)param.getIoType()));
        }
        if (!StringUtils.isEmpty((String)param.getStatus())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.jpaQDo.status.eq((Object)param.getStatus()));
        }
        return predicate;
    }

    public JPAUpdateClause updateDeleteFlagByIds(Integer deleteFlag, List<Long> idList) {
        BooleanExpression predicate = this.jpaQDo.isNotNull();
        return this.jpaQueryFactory.update((EntityPath)this.jpaQDo).set(this.jpaQDo.deleteFlag, (Object)deleteFlag).where(new Predicate[]{ExpressionUtils.and((Predicate)predicate, (Predicate)this.jpaQDo.id.in(idList))});
    }

    private <T> JPAQuery<T> query(Class<T> cls) {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(cls, (Expression[])new Expression[]{this.jpaQDo.id, this.jpaQDo.ioCode, this.jpaQDo.ioName, this.jpaQDo.ioType, this.jpaQDo.status, this.jpaQDo.remark, this.jpaQDo.createUserId, this.jpaQDo.creator, this.jpaQDo.createTime, this.jpaQDo.modifyUserId, this.jpaQDo.updater, this.jpaQDo.modifyTime, this.jpaQDo.deleteFlag, this.jpaQDo.tenantId, this.jpaQDo.auditDataVersion})).from((EntityPath)this.jpaQDo);
    }

    public List<CreditAccountIocDTO> queryByAccountIocParam(CreditAccountIocParam accountIocParam) {
        JPAQuery<CreditAccountIocDTO> jpaQuery = this.query(CreditAccountIocDTO.class);
        if (CollectionUtils.isNotEmpty(accountIocParam.getIoCodeSet())) {
            jpaQuery.where((Predicate)this.jpaQDo.ioCode.in(accountIocParam.getIoCodeSet()));
        }
        if (CollectionUtils.isNotEmpty(accountIocParam.getIoNameSet())) {
            jpaQuery.where((Predicate)this.jpaQDo.ioName.in(accountIocParam.getIoNameSet()));
        }
        if (StringUtils.isNotEmpty((String)accountIocParam.getState())) {
            jpaQuery.where((Predicate)this.jpaQDo.status.in((Object[])new String[]{accountIocParam.getState()}));
        }
        return jpaQuery.fetch();
    }

    public CreditAccountIocRepoProc(JPAQueryFactory jpaQueryFactory) {
        this.jpaQueryFactory = jpaQueryFactory;
    }
}

