package com.elitesland.fin.application.facade.vo.aporder;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;

/**
 * @author wang.xl
 * @version V1.0
 * @Package com.elitesland.fin.application.facade.vo.aporder
 * @date 2022/3/17 13:00
 */

@Data
public class ApOrderDtlVO implements Serializable {

    private static final long serialVersionUID = 3046700118505743982L;
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty(value = "总单ID")
    private Long masId;

    @ApiModelProperty(value = "来源单号")
    private String sourceNo;

    @ApiModelProperty(value = "来源行号")
    private Integer sourceLine;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty(value = "商品ID")
    private Long itemId;

    @ApiModelProperty(value = "商品编码")
    private String itemCode;

    @ApiModelProperty(value = "商品名称")
    private String itemName;

    @ApiModelProperty(value = "规格型号")
    private String itemType;

    @ApiModelProperty(value = "小类编码")
    private String smallCateCode;

    @ApiModelProperty(value = "小类名称")
    private String smallCateName;

    @ApiModelProperty(value = "计量单位")
    private String uom;

    @ApiModelProperty(value = "计量单位名称")
    private String uomName;

    @ApiModelProperty(value = "数量")
    private BigDecimal qty;

    @ApiModelProperty(value = "单价")
    private BigDecimal exclTaxPrice;

    @ApiModelProperty(value = "含税单价")
    private BigDecimal price;

    @ApiModelProperty(value = "税率")
    private BigDecimal taxRate;

    @ApiModelProperty(value = "含税总金额")
    private BigDecimal totalAmt;

    @ApiModelProperty(value = "不含税总金额")
    private BigDecimal exclTaxAmt;

    @ApiModelProperty(value = "税额")
    private BigDecimal taxAmt;

    @ApiModelProperty(value = "含税总金额(本位币)")
    private BigDecimal totalCurAmt;

    @ApiModelProperty(value = "不含税总金额(本位币)")
    private BigDecimal exclTaxCurAmt;

    @ApiModelProperty(value = "税额(本位币)")
    private BigDecimal taxCurAmt;

    @ApiModelProperty(value = "备注")
    private String remark;
    private BigDecimal verAmt;
    private BigDecimal unVerAmt;
    private BigDecimal applyVerAmTing;
    private Long apId;
    private String apDocNo;
    @ApiModelProperty("协议编码")
    private String protocolCode;

    @ApiModelProperty("起算日期")
    private LocalDate startCalDate;

    @ApiModelProperty("到期付款日")
    private LocalDate expirePayDate;

    @ApiModelProperty("单位成本")
    private BigDecimal costPrice;

    @ApiModelProperty("应付暂估差异")
    private BigDecimal invoicePriceVariance;
}
