package com.elitesland.fin.application.service.excel.entity;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitesland.fin.application.facade.excel.convert.AmountRoundConverter;
import com.elitesland.fin.application.facade.excel.convert.BigDecimalPruneZeroConverter;
import com.elitesland.fin.application.facade.excel.convert.DateTimeToDateConverter;
import com.elitesland.fin.application.facade.excel.convert.QuantityRoundConverter;
import com.elitesland.fin.utils.excel.convert.annotation.ExcelConvert;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import net.sf.cglib.core.Local;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

@Data
public class ApOrderExportEntity implements Serializable {
    @ApiModelProperty(value = "来源系统单号")
    private String sourceNo;

    @ApiModelProperty(value = "应付单编号")
    private String apOrderNo;
    
    @ApiModelProperty(value = "公司编码")
    private String ouCode;
    
    @ApiModelProperty(value = "公司名称")
    private String ouName;
    
    @ApiModelProperty(value = "来源单据")
    @SysCode(sys = "yst-fin", mod = "AP_DOC_CLS")
    private String createMode;
    private String createModeName;
    
    @ApiModelProperty(value = "应付单类型名称")
    private String apTypeName;
    
    @ApiModelProperty(value = "应付单类型代码")
    private String apTypeCode;
    
    @ApiModelProperty(value = "单据状态")
    @SysCode(sys = "yst-supp", mod = "APPLY_STATUS")
    private String orderState;
    private String orderStateName;
    
    @ApiModelProperty(value = "业务日期")
    @JsonSerialize(using = DateTimeToDateConverter.class)
    private LocalDateTime buDate;
    
    @ApiModelProperty(value = "含税总金额")
    @JsonSerialize(using = AmountRoundConverter.class)
    private BigDecimal totalAmt;
    
    @ApiModelProperty(value = "税额")
    @JsonSerialize(using = AmountRoundConverter.class)
    private BigDecimal taxAmt;
    
    @ApiModelProperty(value = "税额(本位币)")
    @JsonSerialize(using = AmountRoundConverter.class)
    private BigDecimal taxCurAmt;
    
    @ApiModelProperty(value = "含税总金额(本位币)")
    @JsonSerialize(using = AmountRoundConverter.class)
    private BigDecimal totalCurAmt;
    
    @ApiModelProperty(value = "不含税总金额")
    @JsonSerialize(using = AmountRoundConverter.class)
    private BigDecimal exclTaxAmt;
    
    @ApiModelProperty(value = "不含税总金额(本位币)")
    @JsonSerialize(using = AmountRoundConverter.class)
    private BigDecimal exclTaxCurAmt;
    
    @ApiModelProperty(value = "币种编码")
    private String currCode;
    
    @ApiModelProperty(value = "币种")
    private String currName;
    
    @ApiModelProperty(value = "审核人")
    private String auditUser;
    
    @ApiModelProperty(value = "审核时间")
    private LocalDateTime auditDate;
    
    @ApiModelProperty(value = "审批拒绝理由")
    private String auditRejection;
    
    @ApiModelProperty(value = "经办人")
    private String operator;
    
    @ApiModelProperty(value = "是否期初")
    private Boolean initFlag;
    
    @ApiModelProperty(value = "供应商编码")
    private String suppCode;
    
    @ApiModelProperty(value = "供应商名称")
    private String suppName;
    
    @ApiModelProperty(value = "创建人")
    private String creator;
    
    @ApiModelProperty(value = "备注")
    private String remark;
    
    @ApiModelProperty(value = "是否含税")
    private Boolean taxFlag;
    
    @ApiModelProperty(value = "汇率")
    @JsonSerialize(using = BigDecimalPruneZeroConverter.class)
    private BigDecimal exchangeRate;
    
    @ApiModelProperty(value = "部门编码")
    private String buCode;
    
    @ApiModelProperty(value = "部门名称")
    private String buName;
    
    @ApiModelProperty(value = "付款条件")
    private String payMentName;
    private String payMentCode;
    
    @ApiModelProperty(value = "创建日期")
    private LocalDateTime createTime;
    
    @ApiModelProperty(value = "修改人")
    private String updater;
    
    @ApiModelProperty("修改时间")
    private LocalDateTime modifyTime;
    
    @ApiModelProperty(value = "总数量，汇总明细单行数")
    @JsonSerialize(using = QuantityRoundConverter.class)
    private BigDecimal totalCount;
    
    @ApiModelProperty(value = "传输状态")
    private String tranState;
    
    @ApiModelProperty(value = "入账日期")
    private String entryDate;
    
    @ApiModelProperty("本位币编码")
    private String localCurrCode;
    
    @ApiModelProperty("税率")
    @JsonSerialize(using = BigDecimalPruneZeroConverter.class)
    private BigDecimal taxRate;
    
    @ApiModelProperty("本位币名称")
    private String localCurrName;
    
    @ApiModelProperty("核销状态")
    @SysCode(sys = "yst-fin", mod = "VERIFY_STATUS")
    private String verState;
    private String verStateName;
    
    @ApiModelProperty("已核销金额")
    @JsonSerialize(using = AmountRoundConverter.class)
    private BigDecimal verAmt;
    
    @ApiModelProperty("未核销金额")
    @JsonSerialize(using = AmountRoundConverter.class)
    private BigDecimal unVerAmt;
    
    @ApiModelProperty("提交时间")
    private LocalDateTime submitTime;
    
    @ApiModelProperty("审批通过时间")
    private LocalDateTime approvedTime;
    
    @ApiModelProperty("地址号")
    private String addrNo;
    
    @ApiModelProperty("供应商地址号")
    private String suppAddrNo;
    
    @ApiModelProperty("红冲状态")
    private Boolean redState;
    
    @ApiModelProperty("红冲来源")
    private String redSourceNo;
    
    @SysCode(sys = "yst-fin", mod = "DOC_PROPOSED_STATUS")
    @ApiModelProperty("拟定状态")
    private String proposedStatus;
    private String proposedStatusName;
}
