package com.elitesland.fin.application.service.excel.entity;

import com.elitesland.fin.application.facade.excel.convert.AmountRoundConverter;
import com.elitesland.fin.application.facade.excel.convert.BigDecimalPruneZeroConverter;
import com.elitesland.fin.application.facade.excel.convert.DateTimeToDateConverter;
import com.elitesland.fin.utils.excel.convert.annotation.ExcelConvert;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

@Data
public class RecOrderEntity implements Serializable {
    @ApiModelProperty("来源单号")
    private String sourceNo;
    
    @ApiModelProperty("销售公司编码")
    private String ouCode;
    
    @ApiModelProperty("销售公司名称")
    private String ouName;
    
    @ApiModelProperty("应收单类型名称")
    private String arTypeName;
    
    @ApiModelProperty("应收单类型代码")
    private String arTypeCode;
    
    @ApiModelProperty("收款单类型代码")
    private String recTypeCode;
    
    @ApiModelProperty("收款单类型名称")
    private String recTypeName;
    
    @ApiModelProperty("收款单号")
    private String recOrderNo;
    
    @ApiModelProperty("币种编码")
    private String currCode;
    
    @ApiModelProperty("币种")
    private String currName;
    
    @ApiModelProperty("本位币编码")
    private String localCurrCode;
    
    @ApiModelProperty("本位币名称")
    private String localCurrName;
    
    @ApiModelProperty("含税总金额")
    @JsonSerialize(using = AmountRoundConverter.class)
    private BigDecimal totalAmt;
    
    @ApiModelProperty("含税总金额(本位币)")
    @JsonSerialize(using = AmountRoundConverter.class)
    private BigDecimal totalCurAmt;
    
    @ApiModelProperty("审核人")
    private String auditUser;
    
    @ApiModelProperty("审核时间")
    private LocalDateTime auditDate;
    
    @ApiModelProperty("单据状态")
    private String orderState;
    private String orderStateName;
    
    @ApiModelProperty("汇率")
    @JsonSerialize(using = BigDecimalPruneZeroConverter.class)
    private BigDecimal exchangeRate;
    
    @ApiModelProperty("是否期初")
    private Boolean initFlag;
    
    @ApiModelProperty("实际收款金额")
    @JsonSerialize(using = AmountRoundConverter.class)
    private BigDecimal realRecAmt;
    
    @ApiModelProperty("实际收款金额(本位币)")
    @JsonSerialize(using = AmountRoundConverter.class)
    private BigDecimal realRecCurAmt;
    
    @ApiModelProperty("收款日期")
    @JsonSerialize(using = DateTimeToDateConverter.class)
    private LocalDateTime reDate;
    
    @ApiModelProperty("是否预收")
    private Boolean reFlag;
    
    @ApiModelProperty("审核拒绝理由")
    private String auditRejection;
    
    @ApiModelProperty("单据来源")
    private String createMode;
    private String createModeName;
    
    @ApiModelProperty("核销状态")
    private String verState;
    private String verStateName;
    
    @ApiModelProperty("已核销金额")
    @JsonSerialize(using = AmountRoundConverter.class)
    private BigDecimal verAmt;
    
    @ApiModelProperty("客户编码")
    private String custCode;
    
    @ApiModelProperty("客户名称")
    private String custName;
    
    @ApiModelProperty("销售部门编码")
    private String buCode;
    
    @ApiModelProperty("销售部门名称")
    private String buName;
    
    @ApiModelProperty("收款公司编码")
    private String recOuCode;
    
    @ApiModelProperty("收款公司名称")
    private String recOuName;
    
    @ApiModelProperty("销售组织编码")
    private String orgCode;
    
    @ApiModelProperty("销售组织名称")
    private String orgName;
    
    @ApiModelProperty("税额")
    @JsonSerialize(using = AmountRoundConverter.class)
    private BigDecimal taxAmt;
    
    @ApiModelProperty("单据类型")
    private String recOrderTypeName;
    
    @ApiModelProperty("销售业务员")
    private String saleUser;
    
    @ApiModelProperty("未核销金额")
    @JsonSerialize(using = AmountRoundConverter.class)
    private BigDecimal unVerAmt;
    
    @ApiModelProperty("创建人")
    private String creator;
    
    @ApiModelProperty("备注")
    private String remark;
    
    @ApiModelProperty("税额(本位币)")
    @JsonSerialize(using = AmountRoundConverter.class)
    private BigDecimal taxCurAmt;
    
    @ApiModelProperty("创建时间")
    private LocalDateTime createTime;
    
    @ApiModelProperty("修改人")
    private String updater;
    
    @ApiModelProperty("修改时间")
    private LocalDateTime modifyTime;
    
    @ApiModelProperty("提交时间")
    private LocalDateTime submitTime;
    
    @ApiModelProperty("审批通过时间")
    private LocalDateTime approvedTime;
    
    @ApiModelProperty("地址号")
    private String addrNo;
    
    @ApiModelProperty("供应商地址号")
    private String suppAddrNo;
    
    @ApiModelProperty("支付凭证")
    private String applyFile;
    
    @ApiModelProperty("红冲状态")
    private Boolean redState;
    
    @ApiModelProperty("红冲来源")
    private String redSourceNo;
    
    @ApiModelProperty("拟定状态")
    private String proposedStatus;
    private String proposedStatusName;
}
