package com.elitesland.fin.application.service.recorder;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.json.JSONUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.fin.application.convert.recorder.RecOrderConvert;
import com.elitesland.fin.application.convert.rectype.RecTypeConvert;
import com.elitesland.fin.application.facade.dto.writeoff.FinArRecVerificationDTO;
import com.elitesland.fin.application.facade.dto.writeoff.RecOrderAmtUpdateDTO;
import com.elitesland.fin.application.facade.param.recorder.RecOrderSaveParam;
import com.elitesland.fin.application.facade.vo.recorder.RecOrderVO;
import com.elitesland.fin.application.service.workflow.WorkFlowDefKey;
import com.elitesland.fin.application.service.writeoff.FinArRecVerApplyService;
import com.elitesland.fin.common.FinFlexFieldCodeConstant;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.domain.entity.recorder.RecOrder;
import com.elitesland.fin.domain.entity.recorder.RecOrderDtlDO;
import com.elitesland.fin.domain.param.recorder.RecOrderPageParam;
import com.elitesland.fin.domain.service.recorder.RecOrderDomainService;
import com.elitesland.fin.domain.service.rectype.RecTypeDomainService;
import com.elitesland.fin.infr.dto.recorder.RecOrderDTO;
import com.elitesland.fin.infr.dto.recorder.RecOrderDtlDTO;
import com.elitesland.fin.infr.dto.rectype.RecTypeDTO;
import com.elitesland.fin.infr.repo.recorder.RecOrderDtlRepoProc;
import com.elitesland.fin.repo.writeoff.RecOrderDetailRepoProc;
import com.elitesland.fin.rpc.system.SystemRpcService;
import com.elitesland.fin.rpc.workflow.WorkflowRpcService;
import com.elitesland.support.provider.flexField.service.FlexFieldUtilService;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.WorkflowConstant;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.Assert;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author zhiyu.he
 * @date 2022/4/13 11:42
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class RecOrderServiceImpl implements RecOrderService {

    private final RecOrderDomainService recOrderDomainService;

    private final RecTypeDomainService recTypeDomainService;
    private final SystemRpcService systemRpcService;
    private final WorkflowRpcService workflowRpcService;
    private final TransactionTemplate transactionTemplate;
    private final RecOrderDtlRepoProc recOrderDtlRepoProc;
    private final RecOrderDetailRepoProc recOrderDetailRepoProc;
    private FinArRecVerApplyService finArRecVerApplyService;
    private final FlexFieldUtilService flexFieldUtilService;
    @Autowired
    @Lazy
    public void setFinArRecVerApplyService(FinArRecVerApplyService finArRecVerApplyService) {
        this.finArRecVerApplyService = finArRecVerApplyService;
    }

    @SysCodeProc
    @Override
    public PagingVO<RecOrderVO> page(RecOrderPageParam param) {
        PagingVO<RecOrderDTO> page = recOrderDomainService.page(param);
        PagingVO<RecOrderVO> recOrderVOPagingVO = RecOrderConvert.INSTANCE.convertPage(page);
        if(recOrderVOPagingVO!=null&& CollectionUtils.isNotEmpty(recOrderVOPagingVO.getRecords())){
            final List<Long> masIds= recOrderVOPagingVO.getRecords().stream().map(RecOrderVO::getId).collect(Collectors.toList());
            final Map<Long, List<RecOrderDtlDTO>> recOrderDtlDTOMap= recOrderDtlRepoProc.queryByMasIds(masIds).stream().collect(Collectors.groupingBy(RecOrderDtlDTO::getMasId, Collectors.toList()));
            recOrderVOPagingVO.getRecords().forEach(vo -> {
                BigDecimal verAmt = BigDecimal.ZERO;//已核销金额
                BigDecimal verAmting = BigDecimal.ZERO;//核销中金额
                BigDecimal unVerAmt = BigDecimal.ZERO;//未核销金额
                final List<RecOrderDtlDTO> recOrderDtlDTOS = recOrderDtlDTOMap.get(vo.getId());
                if (CollUtil.isNotEmpty(recOrderDtlDTOS)) {
                    for (RecOrderDtlDTO recOrderDtlDTO : recOrderDtlDTOS) {
                        if(recOrderDtlDTO.getVerAmt()!=null){
                            verAmt = verAmt.add(recOrderDtlDTO.getVerAmt());
                        }
                        if(recOrderDtlDTO.getApplyVerAmTing()!=null){
                            verAmting = verAmting.add(recOrderDtlDTO.getApplyVerAmTing());
                        }
                        if(recOrderDtlDTO.getUnVerAmt()!=null){
                            unVerAmt = unVerAmt.add(recOrderDtlDTO.getUnVerAmt());
                        }
                    }
                }
                vo.setVerAmt(verAmt);
                vo.setApplyVerAmTing(verAmting);
                vo.setUnVerAmt(unVerAmt);
                if (unVerAmt.add(verAmting).compareTo(BigDecimal.ZERO) == 0) {
                    vo.setVerState(UdcEnum.FIN_VERIFY_STATUS_YES.getValueCode());
                } else if (unVerAmt.add(verAmting).compareTo(vo.getTotalAmt()) == 0) {
                    vo.setVerState(UdcEnum.FIN_VERIFY_STATUS_AWAIT.getValueCode());
                } else {
                    vo.setVerState(UdcEnum.FIN_VERIFY_STATUS_PART.getValueCode());
                }
            });
            flexFieldUtilService.handleFlexFieldShowNameForVO(FinFlexFieldCodeConstant.REC_ORDER,recOrderVOPagingVO.getRecords());
        }
       /* recOrderVOPagingVO.getRecords().forEach(vo -> {
            if (vo.getVerAmt() != null && vo.getTotalAmt() != null) {
                vo.setUnVerAmt(vo.getTotalAmt().subtract(vo.getVerAmt()));
            }
        });*/
        return recOrderVOPagingVO;
    }
    @SysCodeProc
    @Override
    public PagingVO<RecOrderVO> writeoffPage(RecOrderPageParam param) {
        PagingVO<RecOrderDTO> page = recOrderDomainService.writeoffPage(param);
        PagingVO<RecOrderVO> recOrderVOPagingVO = RecOrderConvert.INSTANCE.convertPage(page);
        if(recOrderVOPagingVO.isEmpty()){
            return recOrderVOPagingVO;
        }
        final List<Long> masIds= recOrderVOPagingVO.getRecords().stream().map(RecOrderVO::getId).collect(Collectors.toList());
        final Map<Long, List<RecOrderDtlDTO>> recOrderDtlDTOMap= recOrderDtlRepoProc.queryByMasIds(masIds).stream().collect(Collectors.groupingBy(RecOrderDtlDTO::getMasId, Collectors.toList()));
        recOrderVOPagingVO.getRecords().forEach(vo -> {
            BigDecimal verAmt = BigDecimal.ZERO;//已核销金额
            BigDecimal verAmting = BigDecimal.ZERO;//核销中金额
            BigDecimal unVerAmt = BigDecimal.ZERO;//未核销金额
            final List<RecOrderDtlDTO> recOrderDtlDTOS = recOrderDtlDTOMap.get(vo.getId());
            if (CollUtil.isNotEmpty(recOrderDtlDTOS)) {
                for (RecOrderDtlDTO recOrderDtlDTO : recOrderDtlDTOS) {
                    verAmt = verAmt.add(recOrderDtlDTO.getVerAmt());
                    verAmting = verAmting.add(recOrderDtlDTO.getApplyVerAmTing());
                    unVerAmt = unVerAmt.add(recOrderDtlDTO.getUnVerAmt());
                }
            }
            vo.setVerAmt(verAmt);
            vo.setApplyVerAmTing(verAmting);
            vo.setUnVerAmt(unVerAmt);
            if (unVerAmt.add(verAmting).compareTo(BigDecimal.ZERO) == 0) {
                vo.setVerState(UdcEnum.FIN_VERIFY_STATUS_YES.getValueCode());
            } else if (unVerAmt.add(verAmting).compareTo(vo.getTotalAmt()) == 0) {
                vo.setVerState(UdcEnum.FIN_VERIFY_STATUS_AWAIT.getValueCode());
            } else {
                vo.setVerState(UdcEnum.FIN_VERIFY_STATUS_PART.getValueCode());
            }
        });
        return recOrderVOPagingVO;
    }
    @SysCodeProc
    @Override
    public RecOrderVO queryById(Long id) {
        RecOrderDTO recOrderDTO = recOrderDomainService.queryById(id, false);
        RecOrderVO recOrderVO = RecOrderConvert.INSTANCE.dtoToVo(recOrderDTO);
        flexFieldUtilService.handleSingleFlexFieldShowNameForVO(FinFlexFieldCodeConstant.REC_ORDER, recOrderVO);
        return recOrderVO;
    }

    @SysCodeProc
    @Override
    public RecOrderVO queryDetailsById(Long id) {
        RecOrderDTO recOrderDTO = recOrderDomainService.queryById(id, true);
        RecOrderVO recOrderVO = RecOrderConvert.INSTANCE.dtoToVo(recOrderDTO);
        return recOrderVO;
    }

    @Transactional(rollbackFor = {Exception.class})
    @Override
    public ApiResult<List<Long>> deleteByIds(List<Long> ids) {
        List<Long> deleteByIds = recOrderDomainService.deleteByIds(ids);
        return ApiResult.ok(deleteByIds);
    }

    @Override
    public ApiResult<RecOrderVO> defaultValue() {
        RecTypeDTO recTypeDTO = recTypeDomainService.defaultValue();
        RecOrderVO recOrderVO = RecTypeConvert.INSTANCE.typeToOrder(recTypeDTO);
        if (recOrderVO == null) {
            return ApiResult.ok(new RecOrderVO());
        }
        return ApiResult.ok(recOrderVO);
    }

    @Transactional(rollbackFor = {Exception.class})
    @Override
    public ApiResult<Long> save(RecOrderSaveParam param) {
        RecOrder order = RecOrderConvert.INSTANCE.convertParam(param);
        Long id = recOrderDomainService.save(order);
        return ApiResult.ok(id);
    }

    @Override
    @Transactional(rollbackFor = {Exception.class})
    public ApiResult<Long> submit(RecOrderSaveParam param) {
        Boolean auto = recTypeDomainService.getAuto(param.getRecTypeId());
        RecOrder order = RecOrderConvert.INSTANCE.convertParam(param);
        //如果收款单类型是自动审核  更新审核人和时间
        if (auto) {
            order.setAuditDate(LocalDateTime.now());
            order.setAuditUser("admin");
            SysUserDTO user = systemRpcService.getUserByName("admin");
            order.setAuditUserId(user.getId());
        }
//        Long id = recOrderDomainService.submit(order, auto);

        transactionTemplate.setPropagationBehavior(TransactionDefinition.PROPAGATION_REQUIRES_NEW);
        Long id = transactionTemplate.execute(transactionStatus -> recOrderDomainService.submit(order, auto));
        if (!auto) {
            // 启动工作流
            startWorkFlow(order, id);
        }else{
            //自动核销
            log.info("收款单审批通过，开始自动核销");
            RecOrderDTO recOrderDTO = new RecOrderDTO();
            recOrderDTO.setId(id);
            finArRecVerApplyService.autoWriteoffRec(recOrderDTO);
        }

        return ApiResult.ok(id);
    }

    private void startWorkFlow(RecOrder order, Long id) {
        if (order.getProcInstId() == null
                || WorkflowConstant.CAN_START_PROC_STATUSES.contains(order.getProcInstStatus())) {
            // 启动流程
            String procInstName = "收款单审核-" + order.getRecOrderNo();
            String procKey = WorkFlowDefKey.FIN_REC_ORDER.name();
            ProcessInfo processInfo = workflowRpcService.startProcess(procKey, procInstName, id.toString(), new HashMap<>());
            recOrderDomainService.updateWorkInfo(processInfo, id);
        }
    }
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void updateMiddleVerAmt(Long recDId, BigDecimal amt) {
        RecOrderDtlDO detail = findDetail(recDId);
        doUpdateVerAmt(getUpdateMiddleVerAmtBuilder(amt, detail).build());
    }
    private RecOrderDtlDO findDetail(Long recDId) {
        RecOrderDtlDO detail = recOrderDetailRepoProc.getExtRecOrderDetailAmt(recDId);
        Assert.notNull(detail, "未查询到收款单明细，明细ID:" + recDId);
        return detail;
    }

    private void doUpdateVerAmt(RecOrderAmtUpdateDTO update) {
        if (recOrderDetailRepoProc.updateExtVerAmt(update) == 0) {
            throw new BusinessException("更新核销金额失败，请稍后重试");
        }
    }

    @NotNull
    private RecOrderAmtUpdateDTO.RecOrderAmtUpdateDTOBuilder getUpdateMiddleVerAmtBuilder(BigDecimal amt, RecOrderDtlDO detail) {

        BigDecimal unVerAmt = detail.getUnVerAmt().subtract(amt);
        BigDecimal verAmting = detail.getApplyVerAmTing().add(amt);

        if (detail.getTotalAmt().compareTo(unVerAmt.add(verAmting).add(detail.getVerAmt())) != 0) {
            throw new BusinessException("请核对金额数据");
        }

        return RecOrderAmtUpdateDTO.builder()
                .arDId(detail.getId())
                .unVerAmt(unVerAmt)
                .verAmting(verAmting)
                .verAmt(detail.getVerAmt())
                .version(detail.getVersion());

    }
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void updateVerAmt(Long recDId, BigDecimal amt, String verType) {
        RecOrderDtlDO detail = findDetail(recDId);
        doUpdateVerAmt(getUpdateVerAmtBuilder(amt, detail, verType).build());
    }
    @NotNull
    private RecOrderAmtUpdateDTO.RecOrderAmtUpdateDTOBuilder getUpdateVerAmtBuilder(BigDecimal amt, RecOrderDtlDO detail, String verType) {
        String infoStr = JSONUtil.toJsonStr(detail);
        log.info("计算收款单核销金额,{}-{}", amt, infoStr);
        // 取消核销
        if (FinArRecVerificationDTO.VerType.CANCEL.equals(verType)) {

            BigDecimal verAmt = detail.getVerAmt().subtract(amt);
            BigDecimal unVerAmt = detail.getUnVerAmt().add(amt);
            log.info("取消核销,{}-{}-{}", infoStr, verAmt, unVerAmt);
            if (detail.getTotalAmt().compareTo(unVerAmt.add(detail.getApplyVerAmTing()).add(verAmt)) != 0) {
                throw new BusinessException("请核对金额数据");
            }

            return RecOrderAmtUpdateDTO.builder()
                    .arDId(detail.getId())
                    .unVerAmt(unVerAmt)
                    .verAmting(detail.getApplyVerAmTing())
                    .verAmt(verAmt)
                    .version(detail.getAuditDataVersion());

        } else {

            BigDecimal verAmting = detail.getApplyVerAmTing().subtract(amt);
            BigDecimal verAmt = detail.getVerAmt().add(amt);
            log.info("核销通过,{}-{}-{}", infoStr, verAmting, verAmt);
            if (detail.getTotalAmt().compareTo(detail.getUnVerAmt().add(verAmting).add(verAmt)) != 0) {
                throw new BusinessException("请核对金额数据");
            }

            return RecOrderAmtUpdateDTO.builder()
                    .arDId(detail.getId())
                    .unVerAmt(detail.getUnVerAmt())
                    .verAmting(verAmting)
                    .verAmt(verAmt)
                    .version(detail.getAuditDataVersion());

        }

    }

}
