package com.elitesland.fin.application.service.saleinv;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.param.saleinv.SaleInvDtlParam;
import com.elitesland.fin.application.facade.param.saleinv.SaleInvParam;
import com.elitesland.fin.application.facade.vo.saleinv.SaleInvDtlVO;
import com.elitesland.fin.application.facade.vo.saleinv.SaleInvSumVO;
import com.elitesland.fin.application.facade.vo.saleinv.SaleInvVO;
import com.elitesland.fin.application.facade.vo.saleinv.SaleInvdDtlVO;
import com.elitesland.fin.domain.param.saleinv.SaleInvDtlPageParam;
import com.elitesland.fin.domain.param.saleinv.SaleInvPageParam;

import java.util.List;

/**
 * @author wang.xl
 * @version V1.0
 * @Package com.elitesland.fin.application.service.saleinv
 * @date 2022/5/6 14:35
 */
public interface SaleInvService {

    PagingVO<SaleInvVO> page(SaleInvPageParam param);

    List<SaleInvDtlVO> getList(Long masId);

    List<SaleInvDtlVO> getSummaryList(List<SaleInvDtlParam> saleInvDtlParamList);

    SaleInvVO get(Long id);

    Long save(SaleInvParam saleInvParam);

    Long del(List<Long> ids);

    Long update(SaleInvParam saleInvParam);

    Long submit(SaleInvParam saleInvParam);

    List<SaleInvdDtlVO> getInvdLists(Long masId);

    Long updateInvInfo(SaleInvParam saleInvParam);

    PagingVO<SaleInvDtlVO> dtlPage(SaleInvDtlPageParam saleInvDtlPageParam);

    SaleInvVO queryAmt();

    SaleInvSumVO selectListSum(SaleInvPageParam param);

    /**
     * 金税开票-自动生成应收单
     *
     * @param saleInvParam 销售发票ID
     * @return
     */
    void autoCreateArOrder(SaleInvParam saleInvParam);

}
