package com.elitesland.fin.application.service.unionpay.impl;

import cn.hutool.core.lang.Assert;
import com.cloudt.apm.common.exception.BusinessException;
import com.elitesland.fin.application.service.unionpay.OfflinePayService;
import com.elitesland.fin.application.service.unionpay.entity.enums.ReceiptStatusEnum;
import com.elitesland.fin.application.service.unionpay.entity.req.SendPayReq;
import com.elitesland.fin.domain.param.recorder.RecOrderRpcPageRespVo;
import com.elitesland.fin.domain.param.recorder.RecOrderRpcTwoParam;
import com.elitesland.fin.entity.account.AccountStorageDO;
import com.elitesland.fin.infr.repo.recorder.RecOrderDtlRepo;
import com.elitesland.fin.infr.repo.recorder.RecOrderDtlRepoProc;
import com.elitesland.fin.infr.repo.recorder.RecOrderRpcFiledRepo;
import com.elitesland.fin.infr.repo.recorder.RecOrderRpcFiledRepoProc;
import com.elitesland.fin.repo.account.AccountStorageDetailRepo;
import com.elitesland.fin.repo.account.AccountStorageRepo;
import com.elitesland.fin.repo.account.AccountStorageRepoProc;
import com.elitesland.fin.service.flow.AccountFlowRpcService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * @author gyj
 * @Date 2023/7/18
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class OfflinePayServiceImpl implements OfflinePayService {


    @Autowired
    private AccountStorageRepo accountStorageRepo;

    @Autowired
    private AccountStorageRepoProc accountStorageRepoProc;

    @Autowired
    private RecOrderRpcFiledRepo recOrderRpcFiledRepo;
    @Autowired
    private AccountStorageDetailRepo accountStorageDetailRepo;

    private final AccountFlowRpcService accountFlowRpcService;

    private final RecOrderRpcFiledRepoProc recOrderRpcFiledRepoProc;

    private final RecOrderDtlRepo recOrderDtlRepo;
    private final RecOrderDtlRepoProc recOrderDtlRepoProc;

    @Override
    @Transactional
    public Long offlinePay(SendPayReq payReq) {
        checkOfflinePayParam(payReq);

        String receiptStatus = accountStorageRepo.getReceiptStatusByOrderId(payReq.getPayOrderId());
        if (!ReceiptStatusEnum.PENDING_PAY.getCode().equals(receiptStatus)) {
            log.error("当前储值单单据状态非待支付状态，不能重复发起支付，单据流水号为:[{}]", payReq.getPayOrderId());
            throw new BusinessException("当前储值单单据状态非待支付状态，无法重复发起支付，单据流水号为:" + payReq.getPayOrderId());
        }

        //修改储值订单与收款单单据状态为待审批
        AccountStorageDO storageDO = new AccountStorageDO();
        storageDO.setId(payReq.getStorageId());
        storageDO.setReceiptStatus(payReq.getReceiptStatus());

        //更新汇款银行/汇款账号
        accountStorageRepoProc.updateAccountStorage(payReq);

        //更新收款方式/收款账户/收款账号/支付文件
        recOrderRpcFiledRepoProc.updateRecOrderDtl(payReq);

        //更新收款单状态
        recOrderRpcFiledRepo.updateReceiptStatus(payReq.getPayOrderId(), payReq.getReceiptStatus());

        //更新支付凭证
        recOrderRpcFiledRepoProc.updateRecOrderExtend(payReq);

        //获取收款单信息
        RecOrderRpcTwoParam recOrderRpcTwoParam = new RecOrderRpcTwoParam();
        recOrderRpcTwoParam.setSourceNo(payReq.getPayOrderId());

        List<RecOrderRpcPageRespVo> recOrderRpcPageRespVoList = recOrderRpcFiledRepoProc.queryRecOrderPrc(recOrderRpcTwoParam);
        Assert.notEmpty(recOrderRpcPageRespVoList, "查询不到收款单信息");
        Assert.isTrue(recOrderRpcPageRespVoList.size() == 1, "查询到多条收款单信息");

        RecOrderRpcPageRespVo recOrderRpcPageRespVo = recOrderRpcPageRespVoList.get(0);
        Long id = recOrderRpcPageRespVo.getId();
        recOrderDtlRepoProc.updateByMasId(payReq,id);
        return recOrderRpcPageRespVoList.get(0).getId();
    }

    private void checkOfflinePayParam(SendPayReq sendPayReq) {
        Assert.notEmpty(sendPayReq.getRecType(),"收款方式必填");
        Assert.notEmpty(sendPayReq.getRemitterAccount(),"汇款账号必填");
//        Assert.notEmpty(sendPayReq.getRemitterBankCode(),"汇款银行编码必填");
        Assert.notEmpty(sendPayReq.getRemitterBankName(),"汇款银行名称必填");
        Assert.notEmpty(sendPayReq.getReceiptStatus(),"单据状态必填");
        Assert.notEmpty(sendPayReq.getPayOrderId(),"支付流水号必填");
        Assert.notEmpty(sendPayReq.getRecBank(),"收款银行必填");
        Assert.notEmpty(sendPayReq.getRecAcc(),"收款账号必填");
        Assert.notEmpty(sendPayReq.getApplyFile(),"支付凭证必填");
    }
}