package com.elitesland.fin.application.service.writeoff;

import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitesland.fin.application.convert.writeoff.FinApPayVerApplyApHeadConvert;
import com.elitesland.fin.application.facade.dto.writeoff.FinApPayVerApplyApHeadSaveDTO;
import com.elitesland.fin.application.facade.param.writeoff.FinApPayVerApplyQuery;
import com.elitesland.fin.application.facade.vo.writeoff.FinApPayVerApplyApHeadVO;
import com.elitesland.fin.common.FinFlexFieldCodeConstant;
import com.elitesland.fin.domain.entity.writeoff.FinApPayVerApplyApHeadDO;
import com.elitesland.fin.repo.writeoff.FinApPayVerApplyApHeadRepo;
import com.elitesland.fin.repo.writeoff.FinApPayVerApplyApHeadRepoProc;
import com.elitesland.support.provider.flexField.service.FlexFieldUtilService;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 核销申请.
 *
 * @author shihao.ma
 * @since 2023/9/6
 */
@Service
@RequiredArgsConstructor
public class FinApPayVerApplyApHeadServiceImpl implements FinApPayVerApplyApHeadService {

    private final FinApPayVerApplyApHeadRepo finApPayVerApplyApHeadRepo;

    private final FinApPayVerApplyApHeadRepoProc finApPayVerApplyApHeadRepoProc;
    private final FlexFieldUtilService flexFieldUtilService;

    @Override
    public Long create(Long masId, FinApPayVerApplyApHeadSaveDTO param) {
        Assert.notNull(masId, "主表ID不能为Null");

        FinApPayVerApplyApHeadDO entity = FinApPayVerApplyApHeadConvert.INSTANCE.DTO2DO(param);
        entity.setMasId(masId);
        flexFieldUtilService.handFlexFieldValueFeference(FinFlexFieldCodeConstant.FIN_AP_PAY_VER_APPLY_AP_HEAD, entity);
        return finApPayVerApplyApHeadRepo.save(entity).getId();
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteByMasId(Collection<Long> masIds) {
        finApPayVerApplyApHeadRepoProc.deleteByMasId(masIds);
    }

    @Override
    @SysCodeProc
    public List<FinApPayVerApplyApHeadVO> listByMasIds(Collection<Long> masIds) {
        return finApPayVerApplyApHeadRepoProc.listByMasIds(masIds)
                .stream()
                .map(FinApPayVerApplyApHeadConvert.INSTANCE::DO2VO)
                .collect(Collectors.toList());
    }

	@Override
	@SysCodeProc
	public List<FinApPayVerApplyApHeadVO> listByIds(FinApPayVerApplyQuery query,Collection<Long> ids) {
		return finApPayVerApplyApHeadRepoProc.listByIds(query,ids)
				.stream()
				.map(FinApPayVerApplyApHeadConvert.INSTANCE::DO2VO)
				.collect(Collectors.toList());
	}
}
