package com.elitesland.fin.application.service.writeoff;

import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitesland.fin.application.convert.writeoff.FinApPayVerApplyApConvert;
import com.elitesland.fin.application.facade.dto.writeoff.FinApPayVerApplyApSaveDTO;
import com.elitesland.fin.application.facade.param.writeoff.FinApPayVerApplyApQuery;
import com.elitesland.fin.application.facade.param.writeoff.FinApPayVerApplyQuery;
import com.elitesland.fin.application.facade.vo.writeoff.FinApPayVerApplyApVO;
import com.elitesland.fin.domain.entity.writeoff.FinApPayVerApplyApDO;
import com.elitesland.fin.repo.writeoff.FinApPayVerApplyApRepoProc;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 核销申请.
 *
 * @author shihao.ma
 * @since 2023/9/6
 */
@Service
@RequiredArgsConstructor
public class FinApPayVerApplyApServiceImpl implements FinApPayVerApplyApService {

    private final FinApPayVerApplyApRepoProc finApPayVerApplyApRepoProc;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void createBatch(Long masId, List<FinApPayVerApplyApSaveDTO> saveList) {
        Assert.notNull(masId, "主表ID不能为Null");
        if (CollectionUtils.isEmpty(saveList)) {
            return;
        }
        finApPayVerApplyApRepoProc.save(saveList.stream()
                .map(e -> {
                    FinApPayVerApplyApDO entity = FinApPayVerApplyApConvert.INSTANCE.save2Do(e);
                    entity.setMasId(masId);
                    return entity;
                }).collect(Collectors.toList()));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteByMasId(Collection<Long> masIds) {
        finApPayVerApplyApRepoProc.deleteByMasId(masIds);
    }

    @Override
    @SysCodeProc
    public List<FinApPayVerApplyApVO> listByMasIds(Collection<Long> masIds) {
        return finApPayVerApplyApRepoProc.listByMasIds(masIds)
                .stream()
                .map(FinApPayVerApplyApConvert.INSTANCE::entity2Vo)
                .collect(Collectors.toList());
    }

	/**
	 * 根据条件查询核销应收单明细
	 *
	 * @param query
	 * @return
	 */
	@Override
	public List<FinApPayVerApplyApVO> listByQuery(FinApPayVerApplyApQuery query) {
		return finApPayVerApplyApRepoProc.listByQuery(query)
				.stream()
				.map(FinApPayVerApplyApConvert.INSTANCE::entity2Vo)
				.collect(Collectors.toList());
	}

	/**
	 * 通过第三方应收单号或者第三方应收单明细ID查询
	 * @param applyQuery
	 * @return
	 */
	@Override
	public List<FinApPayVerApplyApVO> listByOutArDocNoOrDId(FinApPayVerApplyQuery applyQuery) {
		/*if(StrUtil.isEmpty(applyQuery.getOutApDocNo()) && StrUtil.isEmpty(applyQuery.getOutApDId())){
			return null;
		}*/
		return finApPayVerApplyApRepoProc.listByOutApDocNoOrDId(applyQuery);
	}
}
