package com.elitesland.fin.application.service.writeoff;

import cn.hutool.core.util.StrUtil;
import com.elitesland.fin.application.convert.writeoff.FinApPayVerApplyPayConvert;
import com.elitesland.fin.application.facade.dto.writeoff.FinApPayVerApplyPaySaveDTO;
import com.elitesland.fin.application.facade.param.writeoff.FinApPayVerApplyPayQuery;
import com.elitesland.fin.application.facade.param.writeoff.FinApPayVerApplyQuery;
import com.elitesland.fin.application.facade.vo.writeoff.FinApPayVerApplyPayVO;
import com.elitesland.fin.domain.entity.writeoff.FinApPayVerApplyPayDO;
import com.elitesland.fin.repo.writeoff.FinApPayVerApplyPayRepoProc;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 核销申请.
 *
 * @author shihao.ma
 * @since 2023/9/6
 */
@Service
@RequiredArgsConstructor
public class FinApPayVerApplyPayServiceImpl implements FinApPayVerApplyPayService {

    private final FinApPayVerApplyPayRepoProc finApPayVerApplyPayRepoProc;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void createBatch(Long masId, List<FinApPayVerApplyPaySaveDTO> saveList) {
        Assert.notNull(masId, "主表ID不能为Null");
        if (CollectionUtils.isEmpty(saveList)) {
            return;
        }
        finApPayVerApplyPayRepoProc.save(saveList.stream()
                .map(e -> {
                    FinApPayVerApplyPayDO entity = FinApPayVerApplyPayConvert.INSTANCE.save2Do(e);
                    entity.setMasId(masId);
                    return entity;
                }).collect(Collectors.toList()));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteByMasId(Collection<Long> masIds) {
        finApPayVerApplyPayRepoProc.deleteByMasId(masIds);
    }

    @Override
    public List<FinApPayVerApplyPayVO> listByMasIds(Collection<Long> masIds) {
        return finApPayVerApplyPayRepoProc.listByMasIds(masIds)
                .stream()
                .map(FinApPayVerApplyPayConvert.INSTANCE::entity2Vo)
                .collect(Collectors.toList());
    }

	/**
	 * 根据条件查询核销收款单明细
	 *
	 * @param query
	 * @return
	 */
	@Override
	public List<FinApPayVerApplyPayVO> listByQuery(FinApPayVerApplyPayQuery query) {
		return finApPayVerApplyPayRepoProc.listByQuery(query)
				.stream()
				.map(FinApPayVerApplyPayConvert.INSTANCE::entity2Vo)
				.collect(Collectors.toList());
	}

	/**
	 * 通过第三方收款单号或者明细ID查询
	 *
	 * @param query
	 * @return
	 */
	@Override
	public List<FinApPayVerApplyPayVO> listByOutRecDocNoOrDId(FinApPayVerApplyQuery query) {
	/*	if(StrUtil.isEmpty(query.getOutPayDocNo()) && StrUtil.isEmpty(query.getOutPayDId())){
			return null;
		}*/
		return finApPayVerApplyPayRepoProc.listByOutRecDocNoOrDId(query);
	}
}
