package com.elitesland.fin.domain.entity.recorder;

import cn.hutool.core.lang.Assert;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.exception.BusinessException;
import com.elitesland.fin.common.UdcEnum;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.math.RoundingMode;

/**
 * @author zhiyu.he
 * @date 2022/4/13 16:59
 */
@Data
public class RecOrderDtl {
    private Long id;

    private Long masId;

    private String recType;

    private String recKind;

    private String recBank;

    private String recAccount;

    private String recFlow;

    private String sourceNo;

    private Long sourceId;

    private Integer sourceLine;

    private Long sourceLineId;

    private BigDecimal realRecAmt;

    private BigDecimal realRecCurAmt;

    private BigDecimal taxAmt;

    private BigDecimal taxRate;

    private BigDecimal totalAmt;

    private BigDecimal totalCurAmt;

    private BigDecimal taxCurAmt;

    private String expensesType;

    private String remark;

    @ApiModelProperty("扩展表关联字段")
    private Long relateId;
    @ApiModelProperty("未核销金额")
    private BigDecimal unVerAmt;
    @ApiModelProperty("已核销金额")
    private BigDecimal verAmt;
    @ApiModelProperty("核销申请中金额")
    private BigDecimal applyVerAmTing;
//
//    @ApiModelProperty("客户编码")
//    private String es10;
//
//    @ApiModelProperty("收款性质")
//    private String es11;
//
//    @ApiModelProperty("销售组织编码")
//    private String es12;
//
//    @ApiModelProperty("业务员编码")
//    private String es13;
//
//    @ApiModelProperty("币种")
//    private String es14;
//
//    @ApiModelProperty("汇率")
//    private BigDecimal es15;
//
//    @ApiModelProperty("收款银行账户")
//    private String es16;
//
//    @ApiModelProperty("付款银行账户")
//    private String es17;
//
//    @ApiModelProperty("第三方应收单明细id")
//    private Long es18;

    public void checkMoney(BigDecimal exchangeRate) {
        //总金额=实际支付金额
        if (totalAmt.compareTo(realRecAmt) != 0) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "明细行总金额与实际支付金额不等!");
        }
        //总金额本位币=总金额*汇率；
        if (totalCurAmt.compareTo(totalAmt.multiply(exchangeRate).setScale(2, RoundingMode.HALF_UP)) != 0) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "明细行总金额(本位币)与总金额*汇率不等!");
        }
        //实际收款金额本位币=实际收款金额*汇率；
        if (realRecCurAmt.compareTo(realRecAmt.multiply(exchangeRate).setScale(2, RoundingMode.HALF_UP)) != 0) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "明细行实际收款金额(本位币)与实际收款金额*汇率不等!");
        }
        //税额=总金额*税率；
        if (taxAmt.compareTo(totalAmt.multiply(taxRate).setScale(2, RoundingMode.HALF_UP)) != 0) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "明细行税额与总金额*税率不等!");
        }
        //税额本位币=税额*汇率；
        if (taxCurAmt.compareTo(taxAmt.multiply(exchangeRate).setScale(2, RoundingMode.HALF_UP)) != 0) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "明细行税额(本位币)与税额*汇率不等!");
        }

    }

    //必填项非空校验
    public void checkNotNull(Boolean flag, String createMode) {

        // 来源手工
        if (createMode.equals(UdcEnum.FIN_REC_DOC_CLS_MANU.getValueCode())) {
            //新增时不校验付款单ID
            if (flag) {
                Assert.notNull(this.masId, "收款单ID不能为空");
            }
            Assert.notNull(this.totalAmt, "总金额不能为空");
            Assert.notNull(this.totalCurAmt, "总金额(本位币)不能为空");
            Assert.notNull(this.recBank, "收款银行账户不能为空");
            Assert.notNull(this.recAccount, "收款银行账号不能为空");
            Assert.notNull(this.recType, "收款方式不能为空");
            Assert.notNull(this.taxRate, "税率不能为空");
        }
        // 来源销售订单
        if (UdcEnum.FIN_REC_DOC_CLS_SO.getValueCode().equals(createMode)) {
            Assert.notNull(this.sourceLine, "来源行号不能为空");
            Assert.notNull(this.sourceNo, "来源单号不能为空");
            Assert.notNull(this.realRecAmt, "实际收款金额不能为空");
            Assert.notNull(this.recType, "收款方式不能为空");
            Assert.notNull(this.totalAmt, "总金额不能为空");

        }
    }

}
