package com.elitesland.fin.domain.param.payorder;

import com.elitescloud.boot.core.support.customfield.common.AbstractCustomFieldQueryParam;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @author zhiyu.he
 * @date 2022/3/16 10:32
 */
@Data
public class PayOrderPageParam extends AbstractCustomFieldQueryParam {

    private static final long serialVersionUID = -6336410737207556968L;
    @ApiModelProperty("公司ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("供应商ID")
    private Long suppId;

    @ApiModelProperty("付款单号")
    private String payOrderNo;

    @ApiModelProperty("状态'")
    private String orderState;

    @ApiModelProperty("是否期初")
    private Boolean initFlag;

    @ApiModelProperty("是否预付'")
    private Boolean apFlag;

    @ApiModelProperty("来源系统单号")
    private String sourceNo;

    @ApiModelProperty("付款单类型ID")
    private Long payTypeId;

    @ApiModelProperty("业务日期开始")
    private LocalDateTime buDateStart;

    @ApiModelProperty("业务日期结束")
    private LocalDateTime buDateEnd;

    @ApiModelProperty("总金额从")
    private BigDecimal totalAmtFrom;

    @ApiModelProperty("总金额至")
    private BigDecimal totalAmtTo;

    @ApiModelProperty("币种编码")
    private String currCode;

    @ApiModelProperty("经办人")
    private String operator;

    @ApiModelProperty("明细行来源单号")
    private String sourceNoDtl;

    @ApiModelProperty("来源单据")
    private String createMode;

    @ApiModelProperty("核销状态")
    private String verState;

    @ApiModelProperty("红冲状态")
    private Boolean redState;

    @ApiModelProperty("红冲来源")
    private String redSourceNo;

    @ApiModelProperty("拟定状态,DRAFT：草稿，PROPOSING：拟定中，PROPOSED_FAIL：拟定失败，PROPOSED_SUCCESS：拟定成功，SENDING：传输中，SEND_FAIL：传输失败，SEND_SUCCESS：传输成功")
    private String proposedStatus;
    @ApiModelProperty(value = "经办人ID")
    private Long operUserId;
    @ApiModelProperty(value = "预计付款日期")
    private LocalDateTime apDateStart;
    private LocalDateTime apDateEnd;
    private String writeOfFAmtCon;
}
