package com.elitesland.fin.entity.account;

import com.elitescloud.boot.core.support.customfield.common.CustomFieldBaseModel;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * @author : http://www.chiner.pro
 * @date : 2023-3-2
 * @desc : 账户表
 */
@Entity
@Table(name = "account")
@org.hibernate.annotations.Table(appliesTo = "account", comment = "账户表")
@Data
@DynamicInsert
@DynamicUpdate
@EqualsAndHashCode(callSuper = true)
@Where(clause = "delete_flag = 0")
public class AccountDO extends CustomFieldBaseModel {

    @Column(name = "sec_ou_code", columnDefinition = "varchar(32) comment '归属公司编码'")
    private String secOuCode;

    @Column(name = "sec_ou_name", columnDefinition = "varchar(32) comment '归属公司名称'")
    private String secOuName;

    @Column(name = "sec_franchisee_code", columnDefinition = "varchar(32) comment '归属加盟商编码'")
    private String secFranchiseeCode;

    @Column(name = "account_holder_type", columnDefinition = "varchar(32) comment '开户主体类型'")
    private String accountHolderType;

    @Column(name = "account_holder_name", columnDefinition = "varchar(64) comment '开户主体名称'")
    private String accountHolderName;

    @Column(name = "account_holder_code", columnDefinition = "varchar(32) comment '开户主体编码'")
    private String accountHolderCode;

    @Column(name = "account_code", columnDefinition = "varchar(32) comment '账户编码'")
    private String accountCode;

    @Column(name = "account_name", columnDefinition = "varchar(64) comment '账户名称'")
    private String accountName;

    @Column(name = "account_type", columnDefinition = "varchar(32) comment '账户类型'")
    private String accountType;

    @Column(name = "account_amount", columnDefinition = "decimal(18,8) comment '账户金额'")
    private BigDecimal accountAmount;

    @Column(name = "account_occupancy_amount", columnDefinition = "decimal(18,8) comment '账户占用金额'")
    private BigDecimal accountOccupancyAmount;

    @Column(name = "account_available_amount", columnDefinition = "decimal(18,8) comment '账户可用金额'")
    private BigDecimal accountAvailableAmount;

    @Column(name = "state", columnDefinition = "varchar(32) comment '状态'")
    private String state;

    @Column(name = "default_account", columnDefinition = "tinyint(1) comment '默认账户'")
    private boolean defaultAccount;
}