package com.elitesland.fin.infr.factory.apverrec;

import cn.hutool.core.collection.CollUtil;
import com.elitesland.fin.common.FinConstant;
import com.elitesland.fin.domain.param.apverrec.ApVerRecPageParam;
import com.elitesland.fin.infr.dto.aporder.ApOrderDTO;
import com.elitesland.fin.infr.dto.apverrec.ApVerRecDtlDTO;
import com.elitesland.fin.infr.dto.payorder.PayOrderDTO;
import com.elitesland.fin.infr.repo.aporder.ApOrderRepoProc;
import com.elitesland.fin.infr.repo.apverrec.ApVerRecDtlRepoProc;
import com.elitesland.fin.infr.repo.payorder.PayOrderRepoProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author Jason.zhao
 * @date 2022/4/26 13:30
 */
@RequiredArgsConstructor
@Component
public class ApVerRecFactory {

    private final ApVerRecDtlRepoProc apVerRecDtlRepoProc;

    private final ApOrderRepoProc apOrderRepoProc;

    private final PayOrderRepoProc payOrderRepoProc;

    public PagingVO<ApVerRecDtlDTO> page(ApVerRecPageParam pageParam){
        PagingVO<ApVerRecDtlDTO> page = apVerRecDtlRepoProc.page(pageParam);
        List<ApVerRecDtlDTO> records = page.getRecords();
        List<Long> payIds = records.stream().filter(t -> t.getOrderType().equals(FinConstant.PAY)).map(ApVerRecDtlDTO::getOrderId).collect(Collectors.toList());
        if(CollUtil.isNotEmpty(payIds)){
            Map<Long, PayOrderDTO> payOrderDTOMap = payOrderRepoProc.queryByIds(payIds).stream().collect(Collectors.toMap(PayOrderDTO::getId, t -> t));
            records.stream().forEach(t->{
                if(payOrderDTOMap.containsKey(t.getOrderId())) {
                    t.setTotalAmt(payOrderDTOMap.get(t.getOrderId()).getTotalAmt());
                    t.setVerAmt(payOrderDTOMap.get(t.getOrderId()).getVerAmt());
                    t.setVerState(payOrderDTOMap.get(t.getOrderId()).getVerState());
                }
            });
        }
        List<Long> apIds = records.stream().filter(t -> t.getOrderType().equals(FinConstant.AP)).map(ApVerRecDtlDTO::getOrderId).collect(Collectors.toList());
        if(CollUtil.isNotEmpty(apIds)){
            Map<Long, ApOrderDTO> apOrderDTOMap = apOrderRepoProc.queryByIds(apIds).stream().collect(Collectors.toMap(ApOrderDTO::getId, t -> t));
            records.stream().forEach(t->{
                if(apOrderDTOMap.containsKey(t.getOrderId())) {
                    t.setTotalAmt(apOrderDTOMap.get(t.getOrderId()).getTotalAmt());
                    t.setVerAmt(apOrderDTOMap.get(t.getOrderId()).getVerAmt());
                    t.setVerState(apOrderDTOMap.get(t.getOrderId()).getVerState());
                }
            });
        }
        return page;
    }

}
