package com.elitesland.fin.infr.factory.arorder;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.domain.param.arorder.ArOrderPageParam;
import com.elitesland.fin.infr.dto.arorder.ArOrderDTO;
import com.elitesland.fin.infr.dto.arorder.ArOrderDtlDTO;
import com.elitesland.fin.infr.repo.arorder.ArOrderDtlRepoProc;
import com.elitesland.fin.infr.repo.arorder.ArOrderRepoProc;
import lombok.RequiredArgsConstructor;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author wang.xl
 * @version V1.0
 * @Package com.elitesland.fin.infr.factory.arorder
 * @date 2022/4/12 17:52
 */
@RequiredArgsConstructor
@Component
public class ArOrderFactory {

    private final ArOrderDtlRepoProc arOrderDtlRepoProc;
    private final ArOrderRepoProc arOrderRepoProc;

    public PagingVO<ArOrderDTO> page(ArOrderPageParam arOrderPageParam) {
        List<Long> masId = arOrderDtlRepoProc.findBySourceId(arOrderPageParam.getSourceNoDtl());
        PagingVO<ArOrderDTO> page = arOrderRepoProc.page(arOrderPageParam, masId);
        if(page!=null&& CollectionUtils.isNotEmpty(page.getRecords())){
            final List<Long> masIds = page.getRecords().stream().map(ArOrderDTO::getId).collect(Collectors.toList());
            final List<ArOrderDtlDTO> arOrderDtlDTOS = arOrderDtlRepoProc.listByMasIds(masIds);
            final Map<Long, List<ArOrderDtlDTO>> arOrderDtlDTOMap= arOrderDtlDTOS.stream().collect(Collectors.groupingBy(ArOrderDtlDTO::getMasId, Collectors.toList()));
            page.getRecords().stream().forEach(v->{
                BigDecimal verAmt = BigDecimal.ZERO;//已核销金额
                BigDecimal verAmting = BigDecimal.ZERO;//核销中金额
                BigDecimal unVerAmt = BigDecimal.ZERO;//未核销金额
                final List<ArOrderDtlDTO> arOrderDtlDTOS1 = arOrderDtlDTOMap.get(v.getId());
                if (CollUtil.isNotEmpty(arOrderDtlDTOS1)) {
                    for (ArOrderDtlDTO arOrderDtlDTO : arOrderDtlDTOS1) {
                        verAmt = verAmt.add(arOrderDtlDTO.getVerAmt());
                        verAmting = verAmting.add(arOrderDtlDTO.getApplyVerAmTing());
                        unVerAmt = unVerAmt.add(arOrderDtlDTO.getUnVerAmt());
                    }
                }
                v.setVerAmt(verAmt);
                //v.setApplyVerAmTing(verAmting);
                v.setUnVerAmt(unVerAmt);
                if (unVerAmt.add(verAmting).compareTo(BigDecimal.ZERO) == 0) {
                    v.setVerState(UdcEnum.FIN_VERIFY_STATUS_YES.getValueCode());
                } else if (unVerAmt.add(verAmting).compareTo(v.getTotalAmt()) == 0) {
                    v.setVerState(UdcEnum.FIN_VERIFY_STATUS_AWAIT.getValueCode());
                } else {
                    v.setVerState(UdcEnum.FIN_VERIFY_STATUS_PART.getValueCode());
                }
            });
        }
        return page;
    }
    
    public Long pageCount(ArOrderPageParam arOrderPageParam) {
        List<Long> masId = arOrderDtlRepoProc.findBySourceId(arOrderPageParam.getSourceNoDtl());
        return 0l;
    }
    public PagingVO<ArOrderDTO> writeoffPage(ArOrderPageParam arOrderPageParam) {
        List<Long> masIds = arOrderDtlRepoProc.findUnverBySourceId(arOrderPageParam);
        if(CollectionUtils.isEmpty(masIds)){
            return new PagingVO<>(0,new ArrayList<>());
        }
        PagingVO<ArOrderDTO> page = arOrderRepoProc.unverPage(arOrderPageParam, masIds);
        return page;
    }
}
