package com.elitesland.fin.infr.repo.arorder;

import com.elitesland.fin.domain.entity.arorder.ArOrderDtlDO;
import com.elitesland.fin.domain.entity.arorder.ArOrderDtlRecordDO;
import java.util.List;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.stereotype.Repository;

/**
 * @author wang.xl
 * @version V1.0
 * @Package com.elitesland.fin.infr.repo.aporder
 * @date 2022/3/16 10:40
 */
@Repository
public interface ArOrderDtlRepo extends JpaRepository<ArOrderDtlDO, Long>, QuerydslPredicateExecutor<ArOrderDtlDO> {

    /**
     * 根据主表id查询应收单明细记录表
     * @param masId 主表id
     * @return
     */
    List<ArOrderDtlDO> findAllByMasId(Long masId);
}
