package com.elitesland.fin.repo.creditaccount;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.dto.creditaccount.CreditAccountIocDTO;
import com.elitesland.fin.application.facade.param.creditaccount.CreditAccountIocParam;
import com.elitesland.fin.application.facade.vo.creditaccount.CreditAccountIocParamVO;
import com.elitesland.fin.entity.creditaccount.QCreditAccountIocDO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.AllArgsConstructor;
import lombok.val;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Objects;

/**
 * @author gyj
 * @date 2023/05/24 18:23
 */
@Component
@AllArgsConstructor
public class CreditAccountIocRepoProc {
    private final JPAQueryFactory jpaQueryFactory;
    private final QCreditAccountIocDO  jpaQDo = QCreditAccountIocDO.creditAccountIocDO;

    public PagingVO<CreditAccountIocDTO> search(CreditAccountIocParamVO param) {
        val jpaQuery = jpaQueryFactory.select(
                Projections.bean(
                        CreditAccountIocDTO.class,
                        jpaQDo.id,
                        jpaQDo.ioCode,
                        jpaQDo.ioName,
                        jpaQDo.ioType,
                        jpaQDo.status,
                        jpaQDo.remark,
                        jpaQDo.createUserId,
                        jpaQDo.creator,
                        jpaQDo.createTime,
                        jpaQDo.modifyUserId,
                        jpaQDo.updater,
                        jpaQDo.modifyTime,
                        jpaQDo.deleteFlag,
                        jpaQDo.tenantId,
                        jpaQDo.auditDataVersion
                )
        ).from(jpaQDo);
        if (param != null) {
            jpaQuery.where(where(param));
            param.fillOrders(jpaQuery, jpaQDo);
            param.setPaging(jpaQuery);
        }
        jpaQuery.where(jpaQDo.deleteFlag.eq(0).or(jpaQDo.deleteFlag.isNull()));
        return PagingVO.<CreditAccountIocDTO>builder()
                .total(jpaQuery.fetchCount())
                .records(jpaQuery.fetch())
                .build();
    }

    public JPAQuery<CreditAccountIocDTO> select(CreditAccountIocParamVO param) {
        val jpaQuery = jpaQueryFactory.select(
                Projections.bean(
                        CreditAccountIocDTO.class,
                        jpaQDo.id,
                        jpaQDo.ioCode,
                        jpaQDo.ioName,
                        jpaQDo.ioType,
                        jpaQDo.status,
                        jpaQDo.remark,
                        jpaQDo.createUserId,
                        jpaQDo.creator,
                        jpaQDo.createTime,
                        jpaQDo.modifyUserId,
                        jpaQDo.updater,
                        jpaQDo.modifyTime,
                        jpaQDo.deleteFlag,
                        jpaQDo.tenantId,
                        jpaQDo.auditDataVersion
                )
        ).from(jpaQDo);
        if (Objects.nonNull(param)) {
            jpaQuery.where(where(param));
            if (!CollectionUtils.isEmpty(param.getOrders())) {
                param.fillOrders(jpaQuery, jpaQDo);
            }
        }
        jpaQuery.where(jpaQDo.deleteFlag.eq(0).or(jpaQDo.deleteFlag.isNull()));
        return jpaQuery;
    }

    public Predicate where(CreditAccountIocParamVO param) {
        Predicate predicate = jpaQDo.isNotNull();
        // predicate = ExpressionUtils.and(predicate, jpaQDo.deleteFlag.eq(0).or(jpaQDo.deleteFlag.isNull()));


        if (param.getId()!=null) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.id.eq(param.getId()));
        }
        if (!CollectionUtils.isEmpty(param.getIdList())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.id.in(param.getIdList()));
        }
        if (!StringUtils.isEmpty(param.getKeyword())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.ioCode.like("%" + param.getKeyword() + "%").or(jpaQDo.ioName.like("%" + param.getKeyword() + "%")));
        }

        if (!StringUtils.isEmpty(param.getIoCode())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.ioCode.eq(param.getIoCode()));
        }
        if (!CollectionUtils.isEmpty(param.getIoCodeList())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.ioCode.in(param.getIoCodeList()));
        }
        if (!StringUtils.isEmpty(param.getIoName())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.ioName.eq(param.getIoName()));
        }

        if (!StringUtils.isEmpty(param.getIoType())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.ioType.eq(param.getIoType()));
        }

        if (!StringUtils.isEmpty(param.getStatus())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.status.eq(param.getStatus()));
        }

        return predicate;
    }


    public JPAUpdateClause updateDeleteFlagByIds(Integer deleteFlag, List<Long> idList) {
        Predicate predicate = jpaQDo.isNotNull();
        return jpaQueryFactory.update(jpaQDo)
                .set(jpaQDo.deleteFlag, deleteFlag)
                .where(ExpressionUtils.and(predicate, jpaQDo.id.in(idList)));
    }

    private <T> JPAQuery<T> query(Class<T> cls) {
        return jpaQueryFactory.select(
                Projections.bean(
                        cls,
                        jpaQDo.id,
                        jpaQDo.ioCode,
                        jpaQDo.ioName,
                        jpaQDo.ioType,
                        jpaQDo.status,
                        jpaQDo.remark,
                        jpaQDo.createUserId,
                        jpaQDo.creator,
                        jpaQDo.createTime,
                        jpaQDo.modifyUserId,
                        jpaQDo.updater,
                        jpaQDo.modifyTime,
                        jpaQDo.deleteFlag,
                        jpaQDo.tenantId,
                        jpaQDo.auditDataVersion
                )
        ).from(jpaQDo);
    }

    public List<CreditAccountIocDTO> queryByAccountIocParam(CreditAccountIocParam accountIocParam) {
        JPAQuery<CreditAccountIocDTO> jpaQuery=query(CreditAccountIocDTO.class);
        if(CollectionUtils.isNotEmpty(accountIocParam.getIoCodeSet())){
            jpaQuery.where(jpaQDo.ioCode.in(accountIocParam.getIoCodeSet()));
        }

        if(CollectionUtils.isNotEmpty(accountIocParam.getIoNameSet())){
            jpaQuery.where(jpaQDo.ioName.in(accountIocParam.getIoNameSet()));
        }

        if(StringUtils.isNotEmpty(accountIocParam.getState())){
            jpaQuery.where(jpaQDo.status.in(accountIocParam.getState()));
        }

        return jpaQuery.fetch();
    }
}
