package com.elitesland.fin.repo.creditaccount;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.StrUtil;
import com.elitescloud.boot.core.support.customfield.service.impl.CustomFieldJpaServiceUtil;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.convert.creditaccount.CreditAccountConvert;
import com.elitesland.fin.application.facade.dto.creditaccount.CreditAccountDTO;
import com.elitesland.fin.application.facade.dto.creditaccount.CreditAccountInitialLimitDTO;
import com.elitesland.fin.application.facade.param.creditaccount.CreditAccountInitialLimitParam;
import com.elitesland.fin.application.facade.param.creditaccount.CreditAccountPageParam;
import com.elitesland.fin.application.facade.param.creditaccount.CreditAccountParam;
import com.elitesland.fin.application.facade.vo.creditaccount.CreditAccountPageVO;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.entity.creditaccount.CreditAccountDO;
import com.elitesland.fin.entity.creditaccount.QCreditAccountDO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.StringExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAUpdateClause;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;

/**
 * @author wang.xl
 * @version V1.0
 * @Package com.elitesland.fin.repo
 * @date 2023/2/16 15:00
 */
@Repository

public class CreditAccountRepoProc extends BaseRepoProc<CreditAccountDO> {

    private final static QCreditAccountDO Q_DO = QCreditAccountDO.creditAccountDO;

    @Autowired
    private CreditAccountRepo creditAccountRepo;

    protected CreditAccountRepoProc() {
        super(Q_DO);
    }


    /*public PagingVO<CreditAccountPageVO> search(CreditAccountPageParam pageParam) {
        Predicate predicate = commonBuilder(CreditAccountConvert.INSTANCE.pageParam2QueryParam(pageParam)).build();
        JPAQuery<CreditAccountPageVO> query = select(CreditAccountPageVO.class).where(predicate);
        pageParam.setPaging(query);
        pageParam.fillOrders(query, Q_DO);
        return PagingVO.<CreditAccountPageVO>builder()
                .total(query.fetchCount())
                .records(query.fetch())
                .build();
    }*/

    public JPAQuery<CreditAccountPageVO> buildJPAQuery(CreditAccountPageParam pageParam) {
        Predicate predicate = commonBuilder(CreditAccountConvert.INSTANCE.pageParam2QueryParam(pageParam)).build();
        Predicate predicate2 = whereCreditAccount(pageParam);
        JPAQuery<CreditAccountPageVO> query = select(CreditAccountPageVO.class).where(predicate).where(predicate2);
        return query;
    }

    public List<CreditAccountPageVO> queryList(CreditAccountPageParam pageParam) {
        JPAQuery<CreditAccountPageVO> query = buildJPAQuery(pageParam);
        return query.fetch();
    }


    public PagingVO<CreditAccountPageVO> search(CreditAccountPageParam pageParam) {
        JPAQuery<CreditAccountPageVO> query = buildJPAQuery(pageParam);
        pageParam.setPaging(query);
        pageParam.fillOrders(query, Q_DO);
        return PagingVO.<CreditAccountPageVO>builder()
                .total(query.fetchCount())
                .records(query.fetch())
                .build();
    }


    private <T> JPAQuery<T> select(Class<T> cls) {
        return jpaQueryFactory.select(Projections.bean(cls,
                Q_DO.id,
                Q_DO.ouCode,
                Q_DO.ouId,
                Q_DO.ouName,
                Q_DO.objectType,
                Q_DO.objectName,
                Q_DO.creditAccountCode,
                Q_DO.creditAccountName,
                Q_DO.creditAccountType,
                Q_DO.objectCode,
                Q_DO.creditAccountLimit,
                Q_DO.creditAccountUsedLimit,
                Q_DO.creditAccountOccupancyLimit,
                Q_DO.creditAccountAvailableLimit,
                Q_DO.status,
                Q_DO.remark,
                Q_DO.createTime,
                Q_DO.creator,
                Q_DO.createUserId,
                Q_DO.modifyTime,
                Q_DO.modifyUserId,
                Q_DO.updater,
                Q_DO.tenantId,
                Q_DO.extensionInfo
        )).from(Q_DO);
    }

    private PredicateBuilder commonBuilder(CreditAccountParam param) {
        return PredicateBuilder.builder()
                .andLike(StrUtil.isNotBlank(param.getOuName()), Q_DO.ouName, param.getOuName())
                .andLike(StrUtil.isNotBlank(param.getCreditAccountCodeName()), new StringExpression[]{Q_DO.creditAccountCode, Q_DO.creditAccountName}, param.getCreditAccountCodeName())
                .andEq(StrUtil.isNotBlank(param.getOuCode()), Q_DO.ouCode, param.getOuCode())
                .andLike(StrUtil.isNotBlank(param.getObjectName()), Q_DO.objectName, param.getObjectName())
                .andEq(StrUtil.isNotBlank(param.getObjectCode()), Q_DO.objectCode, param.getObjectCode())
                .andEq(StrUtil.isNotBlank(param.getStatus()), Q_DO.status, param.getStatus())
                .andIn(CollectionUtil.isNotEmpty(param.getCreditAccountCodes()), Q_DO.creditAccountCode, param.getCreditAccountCodes())
                .andIn(CollectionUtil.isNotEmpty(param.getIds()), Q_DO.id, param.getIds())
				.andGoe(param.getCreditAccountLimitStart() != null, Q_DO.creditAccountLimit, param.getCreditAccountLimitStart())
				.andLoe(param.getCreditAccountLimitEnd() != null, Q_DO.creditAccountLimit, param.getCreditAccountLimitEnd())
                .andEq(StringUtils.isNotEmpty(param.getCreditAccountType()), Q_DO.creditAccountType, param.getCreditAccountType());

    }

    private Predicate whereCreditAccount(CreditAccountPageParam param) {
        List<Predicate> predicates = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(param.getOuCodeList())){
            predicates.add(Q_DO.ouCode.in(param.getOuCodeList()));
        }
        if(CollectionUtils.isNotEmpty(param.getObjectCodeList())){
            predicates.add(Q_DO.objectCode.in(param.getObjectCodeList()));
        }
        if(CollectionUtils.isNotEmpty(param.getObjectNameList())){
            predicates.add(Q_DO.objectName.in(param.getObjectNameList()));
        }
        if(CollectionUtils.isNotEmpty(param.getCreditAccountCodeList())){
            predicates.add(Q_DO.creditAccountCode.in(param.getCreditAccountCodeList()));
        }
        if(CollectionUtils.isNotEmpty(param.getCreditAccountNameList())){
            predicates.add(Q_DO.creditAccountName.in(param.getCreditAccountNameList()));
        }
        //增加扩展字段查询条件begin
        Predicate customFieldPredicate= CustomFieldJpaServiceUtil.getPredicate(param.getConditions(), CreditAccountDO.class);
        if(customFieldPredicate!=null){
            predicates.add(customFieldPredicate);
            //predicate= ExpressionUtils.and(predicate,customFieldPredicate);
        }
        //增加扩展字段查询条件end
        return ExpressionUtils.allOf(predicates);
    }

    public List<CreditAccountDTO> findByParam(CreditAccountParam param) {
        Predicate predicate = commonBuilder(param).build();
        JPAQuery<CreditAccountDTO> query = select(CreditAccountDTO.class).where(predicate);
        return query.fetch();
    }

    public List<CreditAccountDTO> getAccountByAccountParam(CreditAccountParam param) {
        Predicate predicate = commonBuilder(param).build();
        JPAQuery<CreditAccountDTO> query = select(CreditAccountDTO.class).where(predicate);
        return query.fetch();
    }

    public List<CreditAccountInitialLimitDTO> findByInitialParam(List<CreditAccountInitialLimitParam> params) {

        List<Predicate> predicates = new ArrayList<>();

        params.stream().forEach(param -> {
            Predicate predicate = PredicateBuilder.builder()
                    .andEq(StrUtil.isNotBlank(param.getCreditAccountName()), Q_DO.creditAccountName, param.getCreditAccountName())
                    .andEq(StrUtil.isNotBlank(param.getCreditAccountCode()), Q_DO.creditAccountCode, param.getCreditAccountCode())
                    .build();
            predicates.add(predicate);
        });

        JPAQuery<CreditAccountInitialLimitDTO> jpaQuery = jpaQueryFactory.select(Projections.bean(CreditAccountInitialLimitDTO.class,
                Q_DO.creditAccountCode,
                Q_DO.creditAccountName
        )).from(Q_DO).where(ExpressionUtils.anyOf(predicates));
        return jpaQuery.fetch();
    }

    public void updateByParam(List<CreditAccountParam> params) {
        params.stream().forEach(param -> {
                    JPAUpdateClause updateClause = jpaQueryFactory.update(Q_DO);
                    updateClause.set(Q_DO.creditAccountLimit, param.getCreditAccountLimit())
                            .set(Q_DO.creditAccountOccupancyLimit, param.getCreditAccountOccupancyLimit())
                            .set(Q_DO.creditAccountUsedLimit, param.getCreditAccountUsedLimit())
                            .set(Q_DO.creditAccountAvailableLimit, param.getCreditAccountAvailableLimit());
                    updateClause.set(Q_DO.modifyTime, LocalDateTime.now());
                    if (StrUtil.isNotBlank(param.getStatus())) {
                        updateClause.set(Q_DO.status, param.getStatus());
                    }
                    updateClause.where(Q_DO.creditAccountCode.eq(param.getCreditAccountCodeName()));
                    updateClause.execute();
                }
        );
    }

    public CreditAccountDO findByCreditAccountCode(String creditAccountCode) {
        List<CreditAccountDO> creditAccountDOList = creditAccountRepo.findAllByCreditAccountCode(creditAccountCode);
        Assert.notEmpty(creditAccountDOList, "信用账户不存在");
        Assert.isTrue(creditAccountDOList.size() == 1, "查询到多条信用账户");
        CreditAccountDO creditAccountDO = creditAccountDOList.get(0);
        Assert.equals(creditAccountDO.getStatus(), UdcEnum.FIN_ACTIVE_STATUS_ACTIVE.getValueCode(), "信用账户已经被禁用");
        return creditAccountDOList.get(0);
    }
    public CreditAccountDO findByCreditObjectCode(String objectCode) {
        List<CreditAccountDO> creditAccountDOList = creditAccountRepo.findAllByObjectCode(objectCode);
        Assert.notEmpty(creditAccountDOList, "信用账户不存在");
        Assert.isTrue(creditAccountDOList.size() == 1, "查询到多条信用账户");
        return creditAccountDOList.get(0);
    }

    public String findByCreditAccountName(String creditAccountName) {
        JPAQuery<String> query = jpaQueryFactory.select(Q_DO.creditAccountCode).from(Q_DO).
                where(Q_DO.creditAccountName.eq(creditAccountName));
        return query.fetchOne();
    }
    public CreditAccountDTO get(Long id) {
        CreditAccountDTO creditAccountDTO = select(CreditAccountDTO.class)
                .where(Q_DO.id.eq(id))
                .fetchOne();
        return creditAccountDTO;
    }
    public CreditAccountDTO getDTOByCreditAccountCode(String creditAccountCode) {
        List<CreditAccountDTO> creditAccountDTOS = select(CreditAccountDTO.class)
                .where(Q_DO.creditAccountCode.eq(creditAccountCode))
                .fetch();
        Assert.notEmpty(creditAccountDTOS, "信用账户不存在");
        Assert.isTrue(creditAccountDTOS.size() == 1, "查询到多条信用账户");
        CreditAccountDTO creditAccountDTO = creditAccountDTOS.get(0);
        Assert.equals(creditAccountDTO.getStatus(), UdcEnum.FIN_ACTIVE_STATUS_ACTIVE.getValueCode(), "信用账户已经被禁用");
        return creditAccountDTO;
    }
}
