package com.elitesland.fin.repo.writeoff;

import com.elitescloud.boot.core.support.customfield.service.impl.CustomFieldJpaServiceUtil;
import com.elitescloud.boot.jpa.common.JpaPredicateBuilder;
import com.elitesland.fin.application.facade.param.writeoff.FinApPayVerApplyQuery;
import com.elitesland.fin.domain.entity.writeoff.FinApPayVerApplyPayHeadDO;
import com.elitesland.fin.domain.entity.writeoff.QFinApPayVerApplyPayHeadDO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Repository;

import java.util.Collection;
import java.util.List;

/**
 * 核销申请.
 *
 * @author shihao.ma
 * @since 2023/9/6
 */
@Repository
@RequiredArgsConstructor
public class FinApPayVerApplyPayHeadRepoProc {

    private final QFinApPayVerApplyPayHeadDO QDO = QFinApPayVerApplyPayHeadDO.finApPayVerApplyPayHeadDO;

    private final JPAQueryFactory jpaQueryFactory;

    public long deleteByMasId(Collection<Long> masIds) {
        return jpaQueryFactory.delete(QDO)
                .where(QDO.masId.in(masIds))
                .execute();
    }

    public List<FinApPayVerApplyPayHeadDO> listByMasIds(Collection<Long> masIds) {
        return jpaQueryFactory.select(QDO)
                .from(QDO)
                .where(QDO.masId.in(masIds))
                .fetch();
    }

	public List<FinApPayVerApplyPayHeadDO> listByIds(FinApPayVerApplyQuery query,Collection<Long> ids) {
        Predicate predicate = JpaPredicateBuilder.builder().getPredicate();
        if(query!=null){
            // 应付单号
            if(StringUtils.isNotBlank(query.getPayOrderNo())){
                predicate = ExpressionUtils.and(
                        predicate,QDO.payOrderNo.like("%"+query.getPayOrderNo()+"%")
                );
            }
            if(null!=query.getPayOperUserId()){
                predicate = ExpressionUtils.and(
                        predicate,QDO.operUserId.eq(query.getPayOperUserId())
                );
            }
            if(null!=query.getPaySuppId()){
                predicate = ExpressionUtils.and(
                        predicate,QDO.suppId.eq(query.getPaySuppId())
                );
            }
            if(StringUtils.isNotBlank(query.getApOuCode())){
                predicate = ExpressionUtils.and(
                        predicate,QDO.ouCode.eq(query.getApOuCode())
                );
            }
        }
        if(CollectionUtils.isNotEmpty(ids)){
            predicate = ExpressionUtils.and(
                    predicate,QDO.id.in(ids)
            );
        }
        //增加扩展字段查询条件begin
        Predicate customFieldPredicate= CustomFieldJpaServiceUtil.getPredicate(query.getPayConditions(), FinApPayVerApplyPayHeadDO.class);
        if(customFieldPredicate!=null){
            //predicates.add(customFieldPredicate);
            predicate= ExpressionUtils.and(predicate,customFieldPredicate);
        }
        //增加扩展字段查询条件end
		return jpaQueryFactory.select(QDO)
				.from(QDO)
				.where(predicate)
				.fetch();
	}
}
