/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.domain.service.arorder;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.map.MapUtil;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitesland.fin.application.convert.arorder.ArOrderDtlRecordConvert;
import com.elitesland.fin.application.convert.arorder.ArOrderRecordConvert;
import com.elitesland.fin.application.facade.param.arorder.ArOrderRecordSaveParam;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.domain.entity.arorder.ArOrderDtlRecordDO;
import com.elitesland.fin.domain.entity.arorder.ArOrderRecordDO;
import com.elitesland.fin.domain.param.arorder.ArOrderRecordParam;
import com.elitesland.fin.domain.service.arorder.ArOrderRecordDomainService;
import com.elitesland.fin.infr.dto.arorder.ArOrderDtlRecordDTO;
import com.elitesland.fin.infr.dto.arorder.ArOrderRecordDTO;
import com.elitesland.fin.infr.repo.arorder.ArOrderDtlRecordRepo;
import com.elitesland.fin.infr.repo.arorder.ArOrderDtlRecordRepoProc;
import com.elitesland.fin.infr.repo.arorder.ArOrderRecordRepo;
import com.elitesland.fin.infr.repo.arorder.ArOrderRecordRepoProc;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ArOrderRecordDomainServiceImpl
implements ArOrderRecordDomainService {
    private final ArOrderRecordRepo arOrderRecordRepo;
    private final ArOrderRecordRepoProc arOrderRecordRepoProc;
    private final ArOrderDtlRecordRepo arOrderDtlRecordRepo;
    private final ArOrderDtlRecordRepoProc arOrderDtlRecordRepoProc;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long save(ArOrderRecordSaveParam saveParam) {
        ArOrderRecordDO arOrderRecordDO = ArOrderRecordConvert.INSTANCE.paramConvertDo(saveParam);
        if (StringUtils.isBlank((CharSequence)arOrderRecordDO.getArFlag())) {
            arOrderRecordDO.setArFlag(UdcEnum.AR_FLAG_TYPE_0.getValueCode());
        }
        ArOrderRecordDO newArOrderRecordDO = (ArOrderRecordDO)this.arOrderRecordRepo.save(arOrderRecordDO);
        Long arOrderRecordId = newArOrderRecordDO.getId();
        List<ArOrderDtlRecordDO> arOrderDtlRecordDOList = ArOrderDtlRecordConvert.INSTANCE.paramConvertDoBatch(saveParam.getArOrderDtlRecordSaveParams());
        arOrderDtlRecordDOList.forEach(arOrderDtlRecordDO -> arOrderDtlRecordDO.setMasId(arOrderRecordId));
        this.arOrderDtlRecordRepo.saveAll(arOrderDtlRecordDOList);
        return arOrderRecordId;
    }

    @Override
    @SysCodeProc
    public ArOrderRecordDTO selectById(Long id) {
        Optional optional = this.arOrderRecordRepo.findById(id);
        if (optional.isEmpty()) {
            return null;
        }
        ArOrderRecordDTO arOrderRecordDTO = ArOrderRecordConvert.INSTANCE.doConvertDto((ArOrderRecordDO)optional.get());
        return arOrderRecordDTO;
    }

    @Override
    @SysCodeProc
    public List<ArOrderRecordDTO> selectByParam(ArOrderRecordParam param) {
        List<ArOrderRecordDO> arOrderRecordDOS = this.arOrderRecordRepoProc.selectArOrderRecordByParam(param);
        if (CollectionUtil.isEmpty(arOrderRecordDOS)) {
            return Collections.EMPTY_LIST;
        }
        List<ArOrderRecordDTO> arOrderRecordDTOList = ArOrderRecordConvert.INSTANCE.doConvertDtoBatch(arOrderRecordDOS);
        return arOrderRecordDTOList;
    }

    @Override
    @SysCodeProc
    public List<ArOrderRecordDTO> selectDetailsByParam(ArOrderRecordParam param) {
        List<ArOrderRecordDO> arOrderRecordDOS = this.arOrderRecordRepoProc.selectArOrderRecordByParam(param);
        if (CollectionUtil.isEmpty(arOrderRecordDOS)) {
            return Collections.EMPTY_LIST;
        }
        List<ArOrderRecordDTO> arOrderRecordDTOList = ArOrderRecordConvert.INSTANCE.doConvertDtoBatch(arOrderRecordDOS);
        List<Long> arOrderRecordIds = arOrderRecordDOS.stream().map(BaseModel::getId).filter(Objects::nonNull).collect(Collectors.toList());
        List<ArOrderDtlRecordDO> arOrderDtlRecordDOList = this.arOrderDtlRecordRepo.findAllByMasIdIn(arOrderRecordIds);
        List<ArOrderDtlRecordDTO> arOrderDtlRecordDTOS = ArOrderDtlRecordConvert.INSTANCE.doConvertDtoBatch(arOrderDtlRecordDOList);
        Map<Long, List<ArOrderDtlRecordDTO>> dtlMap = arOrderDtlRecordDTOS.stream().collect(Collectors.groupingBy(ArOrderDtlRecordDTO::getMasId));
        arOrderRecordDTOList.forEach(arOrderRecordDTO -> {
            if (MapUtil.isNotEmpty((Map)dtlMap)) {
                List dtlRecordDTOS = (List)dtlMap.get(arOrderRecordDTO.getId());
                arOrderRecordDTO.setArOrderDtlRecordDTOS(dtlRecordDTOS);
            }
        });
        return arOrderRecordDTOList;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateArFlagById(Long id, String arFlag) {
        this.arOrderRecordRepoProc.updateArFlagById(id, arFlag);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateArFlagAndFailMsgById(Long id, String arFlag, String failMsg) {
        this.arOrderRecordRepoProc.updateArFlagAndFailMsgById(id, arFlag, failMsg);
    }

    @Override
    public List<Long> selectIdBySourceNo(List<String> sourceNos) {
        return this.arOrderRecordRepoProc.selectIdBySourceNo(sourceNos);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void softDeleteByIds(List<Long> ids) {
        this.arOrderRecordRepoProc.updateDeleteFlagById(ids);
        this.arOrderDtlRecordRepoProc.updateDeleteFlagByMasId(ids);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteByIds(List<Long> ids) {
        this.arOrderRecordRepo.deleteAllByIdIn(ids);
        this.arOrderDtlRecordRepo.deleteAllByMasIdIn(ids);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void softDeleteBySourceNos(List<String> sourceNos) {
        List<Long> arOrderRecordIds = this.arOrderRecordRepoProc.selectIdBySourceNo(sourceNos);
        if (CollectionUtil.isNotEmpty(arOrderRecordIds)) {
            this.arOrderRecordRepoProc.updateDeleteFlagById(arOrderRecordIds);
            this.arOrderDtlRecordRepoProc.updateDeleteFlagByMasId(arOrderRecordIds);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBySourceNos(List<String> sourceNos) {
        List<Long> arOrderRecordIds = this.arOrderRecordRepoProc.selectIdBySourceNo(sourceNos);
        if (CollectionUtil.isNotEmpty(arOrderRecordIds)) {
            this.arOrderRecordRepo.deleteAllByIdIn(arOrderRecordIds);
            this.arOrderDtlRecordRepo.deleteAllByMasIdIn(arOrderRecordIds);
        }
    }

    public ArOrderRecordDomainServiceImpl(ArOrderRecordRepo arOrderRecordRepo, ArOrderRecordRepoProc arOrderRecordRepoProc, ArOrderDtlRecordRepo arOrderDtlRecordRepo, ArOrderDtlRecordRepoProc arOrderDtlRecordRepoProc) {
        this.arOrderRecordRepo = arOrderRecordRepo;
        this.arOrderRecordRepoProc = arOrderRecordRepoProc;
        this.arOrderDtlRecordRepo = arOrderDtlRecordRepo;
        this.arOrderDtlRecordRepoProc = arOrderDtlRecordRepoProc;
    }
}

