/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.rocketmq.input;

import com.alibaba.fastjson.JSON;
import com.elitesland.fin.application.facade.param.creditaccountflow.CreditAccountFlowParam;
import com.elitesland.fin.application.facade.param.flow.AccountFlowParam;
import com.elitesland.fin.application.service.creditaccountflow.CreditAccountFlowService;
import com.elitesland.fin.application.service.flow.AccountFlowService;
import com.elitesland.fin.param.arorder.ArOrderRpcParam;
import com.elitesland.fin.param.recorder.RecOrderRpcParam;
import com.elitesland.fin.rocketmq.channel.FinSalMqProcessor;
import com.elitesland.fin.service.arorder.ArOrderRpcService;
import com.elitesland.fin.service.recorder.RecOrderRpcService;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.stream.annotation.EnableBinding;
import org.springframework.cloud.stream.annotation.StreamListener;
import org.springframework.messaging.handler.annotation.Headers;
import org.springframework.messaging.handler.annotation.Payload;
import org.springframework.stereotype.Component;

@Component
@EnableBinding(value={FinSalMqProcessor.class})
public class ArOrderConsumer {
    private static final Logger log = LoggerFactory.getLogger(ArOrderConsumer.class);
    private final ArOrderRpcService arOrderRpcService;
    private final RecOrderRpcService recOrderRpcService;
    private final AccountFlowService accountFlowService;
    private final CreditAccountFlowService creditAccountFlowService;

    @StreamListener(value="yst-corder-fin-input", condition="headers['tag']=='ar'")
    public void saveArOrder(@Payload ArOrderRpcParam arOrderRpcParam, @Headers Map<?, ?> headers) {
        log.info("=====================\u9500\u552e\u5e94\u6536\u5355\u6d88\u606f\u4fe1\u606fheaders={},arOrderRpcParam={}", headers, (Object)JSON.toJSONString((Object)arOrderRpcParam));
        Long resId = this.arOrderRpcService.save(arOrderRpcParam);
        String sourceNo = arOrderRpcParam.getSourceNo();
        if (resId != null) {
            log.info("=====================\u9500\u552e\u5e94\u6536\u5355\u6d88\u606f\u7ed3\u675f\u5355\u53f7sourceNo={},headers={}", (Object)sourceNo, headers);
        } else {
            log.info("=====================\u9500\u552e\u5e94\u6536\u5355\u6d88\u606f\u5df2\u6d88\u8d39headers={},arOrderRpcParam={}", headers, (Object)JSON.toJSONString((Object)arOrderRpcParam));
        }
    }

    @StreamListener(value="yst-corder-fin-input", condition="headers['tag']=='rec'")
    public void saveRecOrder(@Payload RecOrderRpcParam recOrderRpcParam, @Headers Map<?, ?> headers) {
        log.info("=====================\u9500\u552e\u6536\u6b3e\u5355\u6d88\u606f\u4fe1\u606fheaders={},apOrderRpcParam={}", headers, (Object)JSON.toJSONString((Object)recOrderRpcParam));
        Long resId = this.recOrderRpcService.save(recOrderRpcParam);
        String sourceNo = recOrderRpcParam.getSourceNo();
        if (resId != null) {
            log.info("=====================\u9500\u552e\u6536\u6b3e\u5355\u6d88\u606f\u7ed3\u675f\u5355\u53f7sourceNo={},headers={}", (Object)sourceNo, headers);
        } else {
            log.info("=====================\u9500\u552e\u6536\u6b3e\u5355\u6d88\u606f\u5df2\u6d88\u8d39headers={},apOrderRpcParam={}", headers, (Object)JSON.toJSONString((Object)recOrderRpcParam));
        }
    }

    @StreamListener(value="approve-account-flow-input")
    public void approveAccountFlow(@Payload AccountFlowParam accountFlowParam) {
        log.info("\u5f00\u59cb\u6d88\u8d39\u4fe1\u606f,\u63a5\u6536\u7684\u6d88\u606f message\uff1a" + accountFlowParam);
        this.accountFlowService.approve(accountFlowParam);
        log.info("MQ\u4fe1\u606f\u6d88\u8d39\u6210\u529f");
    }

    @StreamListener(value="generate-account-flow-input")
    public void generateAccountFlow(@Payload AccountFlowParam accountFlowParam) {
        log.info("\u5f00\u59cb\u6d88\u8d39\u4fe1\u606f,\u63a5\u6536\u7684\u6d88\u606f message\uff1a" + accountFlowParam);
        this.accountFlowService.generateAccountFlow(accountFlowParam);
        log.info("MQ\u4fe1\u606f\u6d88\u8d39\u6210\u529f");
    }

    @StreamListener(value="approve-credit-account-flow-input")
    public void approveCreditAccountFlow(@Payload CreditAccountFlowParam creditAccountFlowParam) {
        log.info("\u5f00\u59cb\u6d88\u8d39\u4fe1\u606f,\u63a5\u6536\u7684\u6d88\u606f message\uff1a" + creditAccountFlowParam);
        this.creditAccountFlowService.approve(creditAccountFlowParam);
        log.info("MQ\u4fe1\u606f\u6d88\u8d39\u6210\u529f");
    }

    @StreamListener(value="generate-credit-account-flow-input")
    public void generateCreditAccountFlow(@Payload CreditAccountFlowParam creditAccountFlowParam) {
        log.info("\u5f00\u59cb\u6d88\u8d39\u4fe1\u606f,\u63a5\u6536\u7684\u6d88\u606f message\uff1a" + creditAccountFlowParam);
        this.creditAccountFlowService.generateCreditAccountFlow(creditAccountFlowParam);
        log.info("MQ\u4fe1\u606f\u6d88\u8d39\u6210\u529f");
    }

    public ArOrderConsumer(ArOrderRpcService arOrderRpcService, RecOrderRpcService recOrderRpcService, AccountFlowService accountFlowService, CreditAccountFlowService creditAccountFlowService) {
        this.arOrderRpcService = arOrderRpcService;
        this.recOrderRpcService = recOrderRpcService;
        this.accountFlowService = accountFlowService;
        this.creditAccountFlowService = creditAccountFlowService;
    }
}

