/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class HttpUtil {
    private static final Logger log = LoggerFactory.getLogger(HttpUtil.class);
    private static final RestTemplate REST_TEMPLATE = new RestTemplate();

    public static JSONObject post(String url, Object data) {
        return HttpUtil.post(url, data, JSONObject.class);
    }

    public static <T> T post(String url, Object data, Class<T> returnClass) {
        log.info("\u53d1\u9001HTTP post\u8bf7\u6c42 url: {},data: {}", (Object)url, data);
        String resultStr = (String)REST_TEMPLATE.postForObject(url, data, String.class, new Object[0]);
        log.info("HTTP POST\u8bf7\u6c42\u8fd4\u56de\u6570\u636e: {}", (Object)resultStr);
        return (T)JSON.parseObject((String)resultStr, returnClass);
    }

    public static <T> T post(String url, Object data, HttpHeaders requestHeaders, Class<T> returnClass) {
        log.info("\u53d1\u9001HTTP post\u8bf7\u6c42 url: {},data: {},header:{}", new Object[]{url, data, requestHeaders});
        HttpEntity requestEntity = new HttpEntity(data, (MultiValueMap)requestHeaders);
        String resultStr = (String)REST_TEMPLATE.postForObject(url, (Object)requestEntity, String.class, new Object[0]);
        log.info("HTTP POST\u8bf7\u6c42\u8fd4\u56de\u6570\u636e: {}", (Object)resultStr);
        return (T)JSON.parseObject((String)resultStr, returnClass);
    }

    public static <T> T get(String url, Class<T> returnClass) {
        log.info("\u53d1\u9001HTTP GET\u8bf7\u6c42 url: {}", (Object)url);
        String resultStr = (String)REST_TEMPLATE.getForObject(URI.create(url), String.class);
        log.info("HTTP GET\u8bf7\u6c42\u8fd4\u56de\u6570\u636e: {}", (Object)resultStr);
        return (T)JSON.parseObject((String)resultStr, returnClass);
    }

    public static <T> T get(String url, Object data, HttpHeaders requestHeaders, Class<T> returnClass) {
        log.info("\u53d1\u9001HTTP get\u8bf7\u6c42 url: {},data: {}", (Object)url, data);
        HttpEntity requestEntity = new HttpEntity(data, (MultiValueMap)requestHeaders);
        ResponseEntity exchange = REST_TEMPLATE.exchange(url, HttpMethod.GET, requestEntity, returnClass, new Object[0]);
        log.info("HTTP GET\u8bf7\u6c42\u8fd4\u56de\u6570\u636e: {}", (Object)exchange);
        return (T)exchange.getBody();
    }

    public static <T> T postFormData(String url, Map<String, Object> data, Class<T> returnClass) {
        log.info("\u53d1\u9001HTTP POST \u8868\u5355\u8bf7\u6c42 url: {} ,data: {}", (Object)url, data);
        String resultStr = (String)REST_TEMPLATE.postForObject(url, data, String.class, new Object[0]);
        log.info("HTTP POST\u8868\u5355\u8bf7\u6c42\u8fd4\u56de\u6570\u636e: {}", (Object)resultStr);
        return (T)JSON.parseObject((String)resultStr, returnClass);
    }

    public static String postXml(String url, String xmlString) {
        log.info("\u53d1\u9001HTTP POST XML \u8bf7\u6c42 url: {} ,data: {}", (Object)url, (Object)xmlString);
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.setContentType(MediaType.APPLICATION_XML);
        String resultStr = (String)REST_TEMPLATE.postForObject(url, (Object)new HttpEntity((Object)xmlString, (MultiValueMap)httpHeaders), String.class, new Object[0]);
        log.info("HTTP POST XML\u8fd4\u56de\u6570\u636e: {}", (Object)resultStr);
        return resultStr;
    }

    static {
        REST_TEMPLATE.getMessageConverters().set(1, new StringHttpMessageConverter(StandardCharsets.UTF_8));
    }
}

