/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.domain.service.aporder;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.StrUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.seq.SeqNumProvider;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.fin.application.convert.aporder.ApOrderConvert;
import com.elitesland.fin.application.convert.aporder.ApOrderDtlConvert;
import com.elitesland.fin.application.convert.aporder.ApOrderDtlGroupConvert;
import com.elitesland.fin.application.facade.param.paymentperiod.ReceiptPaymentAgreementDtlPageParam;
import com.elitesland.fin.application.facade.vo.paymentperiod.ReceiptPaymentAgreementDtlVO;
import com.elitesland.fin.application.facade.vo.paymentperiod.ReceiptPaymentAgreementVO;
import com.elitesland.fin.application.service.inputinv.InputInvService;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.domain.entity.aporder.ApOrder;
import com.elitesland.fin.domain.entity.aporder.ApOrderDO;
import com.elitesland.fin.domain.entity.aporder.ApOrderDtl;
import com.elitesland.fin.domain.entity.aporder.ApOrderDtlDO;
import com.elitesland.fin.domain.entity.aporder.ApOrderDtlGroup;
import com.elitesland.fin.domain.entity.aporder.ApOrderDtlGroupDO;
import com.elitesland.fin.domain.param.aporder.ApOrderPageParam;
import com.elitesland.fin.domain.param.aporder.ApOrderParam;
import com.elitesland.fin.domain.service.aporder.ApOrderDomainService;
import com.elitesland.fin.domain.service.apordertopay.ApOrderToPayDomainService;
import com.elitesland.fin.domain.service.arorder.ArOrderDomainService;
import com.elitesland.fin.domain.service.paymentperiod.ReceiptPaymentAgreementDomainService;
import com.elitesland.fin.domain.service.paymentperiod.ReceiptPaymentAgreementDtlDomainService;
import com.elitesland.fin.infr.dto.aporder.ApOrderDTO;
import com.elitesland.fin.infr.dto.aporder.ApOrderDtlDTO;
import com.elitesland.fin.infr.dto.aporder.ApOrderDtlGroupDTO;
import com.elitesland.fin.infr.dto.apordertopay.ApOrderToPayDTO;
import com.elitesland.fin.infr.dto.common.ApVerDTO;
import com.elitesland.fin.infr.factory.aporder.ApOrderFactory;
import com.elitesland.fin.infr.repo.aporder.ApOrderDtlGroupRepo;
import com.elitesland.fin.infr.repo.aporder.ApOrderDtlGroupRepoProc;
import com.elitesland.fin.infr.repo.aporder.ApOrderDtlRepo;
import com.elitesland.fin.infr.repo.aporder.ApOrderDtlRepoProc;
import com.elitesland.fin.infr.repo.aporder.ApOrderRepo;
import com.elitesland.fin.infr.repo.aporder.ApOrderRepoProc;
import com.elitesland.fin.rpc.pur.RmiPurRpcService;
import com.elitesland.fin.rpc.ystsupp.RmiSupportRpcService;
import com.elitesland.fin.utils.BeanUtils;
import com.elitesland.pur.dto.account.PurAccountCheckQtyDTO;
import com.elitesland.pur.dto.account.PurAccountDTO;
import com.elitesland.pur.provider.PurAccountProvider;
import com.elitesland.support.provider.flexField.service.FlexFieldUtilService;
import com.elitesland.support.provider.org.dto.OrgOuRpcSimpleDTO;
import com.elitesland.workflow.ProcessInfo;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.retry.annotation.Backoff;
import org.springframework.retry.annotation.Retryable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ApOrderDomainServiceImpl
implements ApOrderDomainService {
    private static final Logger log = LoggerFactory.getLogger(ApOrderDomainServiceImpl.class);
    private final RmiSupportRpcService rmiSupportRpcService;
    private final ApOrderRepo apOrderRepo;
    private final ApOrderRepoProc apOrderRepoProc;
    private final ApOrderDtlRepoProc apOrderDtlRepoProc;
    private final ApOrderDtlRepo apOrderDtlRepo;
    private final ApOrderFactory apOrderFactory;
    private final ApOrderDtlGroupRepo apOrderDtlGroupRepo;
    private final ApOrderDtlGroupRepoProc apOrderDtlGroupRepoProc;
    private final SeqNumProvider sysNumberRuleService;
    private final ApOrderToPayDomainService apOrderToPayDomainService;
    private final RmiPurRpcService rmiPurRpcService;
    private final PurAccountProvider purAccountProvider;
    private final ReceiptPaymentAgreementDomainService receiptPaymentAgreementDomainService;
    private final ReceiptPaymentAgreementDtlDomainService receiptPaymentAgreementDtlDomainService;
    private final ArOrderDomainService arOrderDomainService;
    private final FlexFieldUtilService flexFieldUtilService;
    private final InputInvService inputInvService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long save(ApOrder apOrder) {
        if (apOrder.getVerAmt() == null) {
            apOrder.setDef();
        }
        apOrder.check();
        apOrder.checkDtlList();
        if (apOrder.getCreateMode().equals(UdcEnum.FIN_AP_DOC_CLS_MANU.getValueCode())) {
            apOrder.checkAmt();
            apOrder.checkAmtSum();
        }
        if (apOrder.getCreateMode().equals(UdcEnum.FIN_AP_DOC_CLS_PACCK.getValueCode())) {
            apOrder.setPacckDef();
            apOrder.countByPacck();
            List<ApOrderDtlGroup> apOrderDtlGroups = this.genDtlGroup(apOrder);
            apOrder.setApOrderDtlGroupList(apOrderDtlGroups);
        }
        apOrder.setOrderState(UdcEnum.APPLY_STATUS_DRAFT.getValueCode());
        ApOrderDO apOrderRes = this.saveOrUpdate(apOrder);
        return apOrderRes.getId();
    }

    public List<ApOrderDtlGroup> genDtlGroup(ApOrder apOrder) {
        List<ApOrderDtl> res = apOrder.getApOrderDtlList();
        Map<String, List<ApOrderDtl>> collectMaps = res.stream().collect(Collectors.groupingBy(ApOrderDtl::getItemCode));
        ArrayList<ApOrderDtlGroup> resList = new ArrayList<ApOrderDtlGroup>();
        for (Map.Entry<String, List<ApOrderDtl>> entry : collectMaps.entrySet()) {
            ApOrderDtlGroup apOrderDtlGroup = new ApOrderDtlGroup();
            List<ApOrderDtl> apOrderDtlList = entry.getValue();
            BigDecimal qtySum = apOrderDtlList.stream().map(ApOrderDtl::getQty).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal taxAmtSum = apOrderDtlList.stream().map(ApOrderDtl::getTaxAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal taxCurAmtSum = apOrderDtlList.stream().map(ApOrderDtl::getTaxCurAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal exclTaxAmtSum = apOrderDtlList.stream().map(ApOrderDtl::getExclTaxAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal exclTaxCurAmtSum = apOrderDtlList.stream().map(ApOrderDtl::getExclTaxCurAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal totalAmtSum = apOrderDtlList.stream().map(ApOrderDtl::getTotalAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal totalCurAmtSum = apOrderDtlList.stream().map(ApOrderDtl::getTotalCurAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
            apOrderDtlGroup.setItemId(apOrderDtlList.get(0).getItemId());
            apOrderDtlGroup.setItemCode(apOrderDtlList.get(0).getItemCode());
            apOrderDtlGroup.setItemName(apOrderDtlList.get(0).getItemName());
            apOrderDtlGroup.setSmallCateCode(apOrderDtlList.get(0).getSmallCateCode());
            apOrderDtlGroup.setSmallCateName(apOrderDtlList.get(0).getSmallCateName());
            apOrderDtlGroup.setQty(qtySum);
            apOrderDtlGroup.setTotalAmt(totalAmtSum);
            apOrderDtlGroup.setExclTaxAmt(exclTaxAmtSum);
            apOrderDtlGroup.setTaxAmt(taxAmtSum);
            apOrderDtlGroup.setTotalCurAmt(totalCurAmtSum);
            apOrderDtlGroup.setExclTaxCurAmt(exclTaxCurAmtSum);
            apOrderDtlGroup.setTaxCurAmt(taxCurAmtSum);
            resList.add(apOrderDtlGroup);
        }
        return resList;
    }

    @Transactional(rollbackFor={Exception.class})
    public ApOrderDO saveOrUpdate(ApOrder apOrder) {
        ApOrderDO apOrderDO;
        String ouCode = apOrder.getOuCode();
        OrgOuRpcSimpleDTO orgOuRpcSimpleDTO = this.rmiSupportRpcService.findSimpleByOuCodes(ouCode).orElseThrow(new BusinessException("\u65e0\u6cd5\u83b7\u53d6\u516c\u53f8\u4fe1\u606f,\u65e0\u6cd5\u8fdb\u884c\u5e94\u4ed8\u6682\u4f30\u5dee\u5f02\u8ba1\u7b97"));
        String taxpayerType = orgOuRpcSimpleDTO.getTaxpayerType();
        log.info("\u516c\u53f8\u7f16\u7801:{},\u7eb3\u7a0e\u4eba\u7c7b\u578b:{}", (Object)ouCode, (Object)taxpayerType);
        if (StrUtil.isBlank((CharSequence)taxpayerType)) {
            throw new BusinessException("\u65e0\u6cd5\u516c\u53f8\u83b7\u53d6\u7eb3\u7a0e\u4eba\u7c7b\u578b,\u516c\u53f8\u7f16\u7801:" + ouCode);
        }
        boolean sType = "S".equals(taxpayerType);
        boolean vType = "V".equals(taxpayerType);
        boolean manualModel = apOrder.getCreateMode().equals(UdcEnum.FIN_AR_DOC_CLS_MANU.getValueCode());
        if (CharSequenceUtil.isBlank((CharSequence)apOrder.getApOrderNo())) {
            String apOrderNo = this.sysNumberRuleService.generateCode("yst-fin", "YFD", null);
            apOrder.setApOrderNo(apOrderNo);
        }
        if ((apOrderDO = ApOrderConvert.INSTANCE.convert(apOrder)).getId() == null) {
            apOrderDO.setAuditDataVersion(0);
        }
        this.flexFieldUtilService.handFlexFieldValueFeference("AP_ORDER", (Object)apOrderDO);
        ApOrderDO apOrderRes = (ApOrderDO)this.apOrderRepo.save(apOrderDO);
        this.apOrderDtlRepoProc.delByMasId(Lists.newArrayList((Object[])new Long[]{apOrderRes.getId()}));
        List<ApOrderDtl> apOrderDtlList = apOrder.getApOrderDtlList();
        List<ApOrderDtlDO> apOrderDtlDOS = ApOrderDtlConvert.INSTANCE.convert(apOrderDtlList);
        List<String> protocolCodeList = apOrderDtlDOS.stream().filter(v -> StringUtils.isNotBlank((CharSequence)v.getProtocolCode())).map(v -> v.getProtocolCode()).collect(Collectors.toList());
        List<ReceiptPaymentAgreementVO> receiptPaymentAgreementVOS = null;
        if (CollectionUtils.isNotEmpty(protocolCodeList)) {
            receiptPaymentAgreementVOS = this.receiptPaymentAgreementDomainService.selectByCodes(protocolCodeList);
        }
        Map<Object, Object> protocolCodeIdMap = new HashMap();
        Map<Object, Object> protocolDetailMap = new HashMap();
        if (CollectionUtils.isNotEmpty(receiptPaymentAgreementVOS)) {
            protocolCodeIdMap = receiptPaymentAgreementVOS.stream().collect(Collectors.toMap(v -> v.getProtocolCode(), v -> v.getId()));
            ReceiptPaymentAgreementDtlPageParam queryVO = new ReceiptPaymentAgreementDtlPageParam();
            queryVO.setMasIdList(receiptPaymentAgreementVOS.stream().map(v -> v.getId()).collect(Collectors.toList()));
            List<ReceiptPaymentAgreementDtlVO> receiptPaymentAgreementDtlVOS = this.receiptPaymentAgreementDtlDomainService.selectByParam(queryVO);
            protocolDetailMap = receiptPaymentAgreementDtlVOS.stream().collect(Collectors.groupingBy(v -> v.getMasId(), Collectors.toList()));
        }
        for (ApOrderDtlDO x2 : apOrderDtlDOS) {
            LocalDateTime startCalDate;
            x2.setMasId(apOrderRes.getId());
            if (Objects.isNull(x2.getId())) {
                x2.setAuditDataVersion(0);
            }
            x2.setVerAmt(BigDecimal.ZERO);
            x2.setUnVerAmt(x2.getTotalAmt());
            x2.setApplyVerAmTing(BigDecimal.ZERO);
            ReceiptPaymentAgreementDtlVO receiptPaymentAgreementDtlVO = null;
            if (protocolCodeIdMap.containsKey(x2.getProtocolCode()) && protocolDetailMap.containsKey(protocolCodeIdMap.get(x2.getProtocolCode()))) {
                receiptPaymentAgreementDtlVO = (ReceiptPaymentAgreementDtlVO)((List)protocolDetailMap.get(protocolCodeIdMap.get(x2.getProtocolCode()))).get(0);
            }
            x2.setStartCalDate((startCalDate = this.arOrderDomainService.calculateStartCalDate(apOrder.getCreateMode(), apOrder.getBuDate(), receiptPaymentAgreementDtlVO)) != null ? startCalDate.toLocalDate() : null);
            LocalDateTime expirePayDate = this.arOrderDomainService.calculateExpirePayDate(x2.getStartCalDate(), receiptPaymentAgreementDtlVO);
            x2.setExpirePayDate(expirePayDate != null ? expirePayDate.toLocalDate() : null);
            if (manualModel) {
                x2.setInvoicePriceVariance(BigDecimal.ZERO);
                if (vType) {
                    x2.setCostPrice(x2.getExclTaxPrice());
                } else if (sType) {
                    x2.setCostPrice(x2.getPrice());
                }
            } else {
                if (vType && x2.getCostPrice() != null) {
                    x2.setInvoicePriceVariance(x2.getExclTaxAmt().subtract(this.getOrDefaultNumber(x2.getCostPrice()).multiply(this.getOrDefaultNumber(x2.getQty()))));
                }
                if (sType && x2.getCostPrice() != null) {
                    x2.setInvoicePriceVariance(x2.getTotalAmt().subtract(this.getOrDefaultNumber(x2.getCostPrice()).multiply(this.getOrDefaultNumber(x2.getQty()))));
                }
            }
            this.apOrderDtlRepo.save(x2);
        }
        this.apOrderDtlGroupRepoProc.delByMasId(Lists.newArrayList((Object[])new Long[]{apOrderRes.getId()}));
        List<ApOrderDtlGroup> apOrderDtlGroups = apOrder.getApOrderDtlGroupList();
        if (!manualModel) {
            this.genDtlGroupAgain(apOrderDtlGroups, apOrderDtlDOS);
        }
        if (null != apOrderDtlGroups) {
            List<ApOrderDtlGroupDO> apOrderDtlGroupDOS = ApOrderDtlGroupConvert.INSTANCE.convert(apOrderDtlGroups);
            apOrderDtlGroupDOS.stream().forEach(x -> {
                x.setMasId(apOrderRes.getId());
                this.apOrderDtlGroupRepo.save(x);
            });
        }
        return apOrderRes;
    }

    private void genDtlGroupAgain(List<ApOrderDtlGroup> apOrderDtlGroups, List<ApOrderDtlDO> apOrderDtlDOS) {
        Map<String, List<ApOrderDtlDO>> dtlMap = apOrderDtlDOS.stream().collect(Collectors.groupingBy(ApOrderDtlDO::getItemCode));
        for (ApOrderDtlGroup re : apOrderDtlGroups) {
            String itemCode = re.getItemCode();
            List<ApOrderDtlDO> list = dtlMap.get(itemCode);
            BigDecimal ipvSum = list.stream().map(ApOrderDtlDO::getInvoicePriceVariance).reduce(BigDecimal.ZERO, BigDecimal::add);
            re.setInvoicePriceVariance(ipvSum);
        }
    }

    private BigDecimal getOrDefaultNumber(BigDecimal bigDecimal) {
        if (bigDecimal == null) {
            return BigDecimal.ZERO;
        }
        return bigDecimal;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW, rollbackFor={Exception.class})
    public Long commit(ApOrder apOrder) {
        apOrder.check();
        apOrder.checkDtlList();
        if (apOrder.getVerAmt() == null) {
            apOrder.setDef();
        }
        apOrder.checkAmt();
        apOrder.checkAmtSum();
        if (StringUtils.isBlank((CharSequence)apOrder.getOrderState())) {
            apOrder.setOrderState(UdcEnum.APPLY_STATUS_DOING.getValueCode());
        }
        ApOrderDO apOrderRes = this.saveOrUpdate(apOrder);
        return apOrderRes.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateWorkInfo(ProcessInfo processInfo, Long id) {
        this.apOrderRepoProc.updateWorkInfo(processInfo, id);
    }

    @Override
    public ApOrderDTO getApOrderAndDtl(Long id) {
        ApOrderDTO apOrderDTO = this.get(id);
        List<ApOrderDtlDTO> apOrderDtlDOS = this.apOrderDtlRepoProc.listByMisId(id);
        apOrderDTO.setApOrderDtlDTOList(apOrderDtlDOS);
        List<ApOrderDtlGroupDTO> apOrderDtlGroupDTOS = this.apOrderDtlGroupRepoProc.listByMisId(id);
        apOrderDTO.setApOrderDtlGroupDTOList(apOrderDtlGroupDTOS);
        apOrderDTO.setInvoicePriceVariance(apOrderDtlDOS.stream().filter(e -> e.getInvoicePriceVariance() != null).map(ApOrderDtlDTO::getInvoicePriceVariance).reduce(BigDecimal.ZERO, BigDecimal::add));
        return apOrderDTO;
    }

    @Override
    public List<ApOrderDTO> queryByIds(List<Long> ids) {
        return this.apOrderRepoProc.queryByIds(ids);
    }

    @Override
    public List<ApOrderDTO> getApOrderList(ApOrderParam apOrderParam) {
        List<ApOrderDTO> res = this.apOrderRepoProc.getApOrderList(apOrderParam);
        return res;
    }

    @Override
    public Boolean queryByApTypeId(Long apTypeId) {
        return this.apOrderRepoProc.queryByApTypeId(apTypeId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @Retryable(value={BusinessException.class}, maxAttempts=5, backoff=@Backoff(value=500L))
    public void updateVerAmt(Long id, BigDecimal amt) {
        BigDecimal totalAmt;
        ApVerDTO apVerDTO = this.apOrderRepoProc.queryVerAmtById(id);
        if (Objects.isNull(apVerDTO)) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u5e94\u4ed8\u5355\u4fe1\u606f");
        }
        BigDecimal bigDecimal = totalAmt = Objects.isNull(apVerDTO.getTotalAmt()) ? BigDecimal.ZERO : apVerDTO.getTotalAmt();
        if (apVerDTO.getVerAmt().add(amt).compareTo(totalAmt) > 0) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5f53\u524d\u6838\u9500\u91d1\u989d\u5927\u4e8e\u5e94\u4ed8\u5355\u91d1\u989d\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u91cd\u65b0\u8f93\u5165");
        }
        apVerDTO.setAmtAndVerState(amt);
        long rows = this.apOrderRepoProc.updateVerAmt(apVerDTO);
        if (rows == 0L) {
            throw new BusinessException("\u5e94\u4ed8\u5355\u66f4\u65b0\u5df2\u6838\u9500\u91d1\u989d\u5931\u8d25");
        }
    }

    @Override
    public PagingVO<ApOrderDTO> page(ApOrderPageParam apOrderPageParam) {
        PagingVO<ApOrderDTO> res = this.apOrderFactory.page(apOrderPageParam);
        return res;
    }

    @Override
    public PagingVO<ApOrderDTO> writeoffPage(ApOrderPageParam apOrderPageParam) {
        PagingVO<ApOrderDTO> res = this.apOrderFactory.writeoffPage(apOrderPageParam);
        return res;
    }

    @Override
    public ApOrderDTO get(Long id) {
        ApOrderDTO apOrderDTO = this.apOrderRepoProc.get(id);
        List<ApOrderDtlDTO> apOrderDtlDTOS = this.apOrderDtlRepoProc.listByMisId(id);
        apOrderDTO.setApOrderDtlDTOList(apOrderDtlDTOS);
        return apOrderDTO;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long audit(List<Long> ids, String content, SysUserDTO user) {
        Long res = this.apOrderRepoProc.audit(ids, content, user);
        return res;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long del(List<Long> ids) {
        List<ApOrderDTO> apOrderDTOList = this.apOrderRepoProc.queryByIds(ids);
        HashMap createSourceMap = new HashMap();
        apOrderDTOList.stream().forEach(x -> {
            if (!x.getOrderState().equals(UdcEnum.APPLY_STATUS_DRAFT.getValueCode())) {
                throw new BusinessException("\u975e\u8349\u7a3f\u72b6\u6001\u4e0d\u80fd\u5220\u9664");
            }
            if (Objects.nonNull(x.getSourceNo()) && Objects.isNull(x.getRedSourceNo())) {
                List sorceNos = createSourceMap.getOrDefault(x.getCreateMode(), new ArrayList());
                sorceNos.add(x.getSourceNo());
                createSourceMap.put(x.getCreateMode(), sorceNos);
            }
            if (Objects.nonNull(x.getRedSourceNo())) {
                this.apOrderRepoProc.setRedFlag(x.getRedSourceId(), false);
            }
            if (UdcEnum.FIN_AP_DOC_CLS_PACCK.getValueCode().equals(x.getCreateMode())) {
                this.inputInvService.removeApOrderNo(x.getCreateMode(), x.getSourceNo());
            }
        });
        for (Map.Entry entry : createSourceMap.entrySet()) {
            switch (Optional.ofNullable(UdcEnum.getByValueCode("FIN", "AP_DOC_CLS", (String)entry.getKey())).orElse(UdcEnum.DEFAUT)) {
                case FIN_AP_DOC_CLS_PACCK: {
                    this.rmiPurRpcService.batchUpdateDocStatus(PurAccountDTO.builder().docStatus(UdcEnum.PUR_ACCOUNT_CHECK_STATUS_CONFIRMED.getValueCode()).docNos((List)entry.getValue()).build());
                    break;
                }
            }
        }
        Long res = this.apOrderRepoProc.del(ids);
        this.apOrderDtlRepoProc.delByMasId(ids);
        this.apOrderDtlGroupRepoProc.delByMasId(ids);
        return res;
    }

    @Override
    public void restDocState(List<Long> ids) {
        List<ApOrderDtlDTO> apOrderDtlDTOList;
        List apOrderDOS = this.apOrderRepo.findAllById(ids);
        this.checkCancelDoc(apOrderDOS);
        List<Long> relatePurAccIds = apOrderDOS.stream().filter(a -> UdcEnum.FIN_AP_DOC_CLS_PACCK.getValueCode().equals(a.getCreateMode())).map(BaseModel::getId).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(relatePurAccIds) && !CollectionUtils.isEmpty(apOrderDtlDTOList = this.apOrderDtlRepoProc.listByMasIds(relatePurAccIds))) {
            List purAccountCheckQtyDTOList = apOrderDtlDTOList.stream().map(d -> {
                PurAccountCheckQtyDTO purAccountCheckQtyDTO = new PurAccountCheckQtyDTO();
                purAccountCheckQtyDTO.setDocNo(d.getSourceNo());
                purAccountCheckQtyDTO.setInvoiceQty(d.getQty());
                purAccountCheckQtyDTO.setLineNo(BigDecimal.valueOf(d.getSourceLine().intValue()).negate());
                return purAccountCheckQtyDTO;
            }).collect(Collectors.toList());
            this.purAccountProvider.addInvoiceQty(purAccountCheckQtyDTOList);
        }
        apOrderDOS.forEach(apOrderDO -> {
            apOrderDO.setOrderState(UdcEnum.APPLY_STATUS_DRAFT.getValueCode());
            apOrderDO.setProposedStatus(null);
            apOrderDO.setProcInstId(null);
            apOrderDO.setProcInstStatus(null);
        });
        this.apOrderRepo.saveAll(apOrderDOS);
    }

    void checkCancelDoc(List<ApOrderDO> apOrderDOS) {
        if (CollectionUtils.isEmpty(apOrderDOS)) {
            throw new BusinessException("\u5355\u636e\u4e0d\u5b58\u5728");
        }
        List<Long> ids = apOrderDOS.stream().map(BaseModel::getId).collect(Collectors.toList());
        List<ApOrderDtlDTO> apOrderDtlDTOS = this.apOrderDtlRepoProc.listByMasIds(ids);
        Map<Long, List<ApOrderDtlDTO>> listMap = apOrderDtlDTOS.stream().collect(Collectors.groupingBy(ApOrderDtlDTO::getMasId));
        Map<Long, List<ApOrderToPayDTO>> apOrderPayMap = this.apOrderToPayDomainService.queryByApId(ids).stream().collect(Collectors.groupingBy(ApOrderToPayDTO::getApOrderId));
        apOrderDOS.forEach(apOrderDO -> {
            BigDecimal verAmt;
            String perfix = "\u5355\u53f7\uff1a" + apOrderDO.getApOrderNo() + "-";
            if (CollectionUtils.isNotEmpty((Collection)((Collection)apOrderPayMap.get(apOrderDO.getId())))) {
                throw new BusinessException(perfix + "\u5df2\u7ecf\u751f\u6210\u4ed8\u6b3e\u5355");
            }
            if (!UdcEnum.DOC_PROPOSED_STATUS_DRAFT.getValueCode().equals(apOrderDO.getProposedStatus()) && !UdcEnum.DOC_PROPOSED_STATUS_PROPOSED_FAIL.getValueCode().equals(apOrderDO.getProposedStatus())) {
                throw new BusinessException(perfix + "\u62df\u5b9a\u72b6\u6001\u5fc5\u987b\u4e3a\u8349\u7a3f\u6216\u62df\u5b9a\u5931\u8d25");
            }
            if (listMap.containsKey(apOrderDO.getId()) && CollUtil.isNotEmpty((Collection)((Collection)listMap.get(apOrderDO.getId()))) && CollUtil.isNotEmpty((Collection)((Collection)listMap.get(apOrderDO.getId()))) && BigDecimal.ZERO.compareTo(verAmt = ((List)listMap.get(apOrderDO.getId())).stream().map(ApOrderDtlDTO::getVerAmt).reduce(BigDecimal.ZERO, BigDecimal::add)) != 0) {
                throw new BusinessException(perfix + "\u5df2\u6838\u9500\u91d1\u989d\u5fc5\u987b\u4e3a0");
            }
            if (!UdcEnum.APPLY_STATUS_COMPLETE.getValueCode().equals(apOrderDO.getOrderState())) {
                throw new BusinessException(perfix + "\u5355\u636e\u72b6\u6001\u5fc5\u987b\u4e3a\u5ba1\u6838\u901a\u8fc7");
            }
            if (Boolean.TRUE.equals(apOrderDO.getRedState())) {
                throw new BusinessException(perfix + "\u5355\u636e\u5df2\u7ea2\u51b2");
            }
        });
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApOrder redPunchCreate(Long id) {
        ApOrderDO apOrderDO = (ApOrderDO)this.apOrderRepo.findById(id).get();
        apOrderDO.setRedState(Boolean.TRUE);
        this.apOrderRepo.save(apOrderDO);
        ApOrder newApOrder = (ApOrder)BeanUtils.toBean((Object)apOrderDO, ApOrder.class);
        newApOrder.setOrderState(UdcEnum.APPLY_STATUS_DRAFT.getValueCode());
        newApOrder.setProcInstId(null);
        newApOrder.setProcInstStatus(null);
        newApOrder.setRedState(null);
        newApOrder.setRedSourceNo(apOrderDO.getApOrderNo());
        newApOrder.setRedSourceId(apOrderDO.getId());
        newApOrder.setTaxAmt(apOrderDO.getTaxAmt().negate());
        newApOrder.setTotalAmt(apOrderDO.getTotalAmt().negate());
        newApOrder.setExclTaxAmt(apOrderDO.getExclTaxAmt().negate());
        newApOrder.setTotalCurAmt(apOrderDO.getTotalCurAmt().negate());
        newApOrder.setTaxCurAmt(apOrderDO.getTaxCurAmt().negate());
        newApOrder.setExclTaxCurAmt(apOrderDO.getExclTaxCurAmt().negate());
        newApOrder.setId(null);
        newApOrder.setApOrderNo(null);
        newApOrder.setProposedStatus(null);
        newApOrder.setAuditUser(null);
        newApOrder.setApprovedTime(null);
        newApOrder.setAuditUserId(null);
        newApOrder.setRemark(null);
        List<ApOrderDtlDO> dtls = this.apOrderDtlRepo.findAllByMasId(id);
        List<ApOrderDtl> newDtls = dtls.stream().map(dtl -> {
            ApOrderDtl dtlDO = (ApOrderDtl)BeanUtils.toBean((Object)dtl, ApOrderDtl.class);
            dtlDO.setTaxAmt(dtl.getTaxAmt().negate());
            dtlDO.setTotalAmt(dtl.getTotalAmt().negate());
            dtlDO.setExclTaxAmt(dtl.getExclTaxAmt().negate());
            dtlDO.setTotalCurAmt(dtl.getTotalCurAmt().negate());
            dtlDO.setTaxCurAmt(dtl.getTaxCurAmt().negate());
            dtlDO.setExclTaxCurAmt(dtl.getExclTaxCurAmt().negate());
            dtlDO.setQty(dtlDO.getQty().negate());
            return dtlDO;
        }).collect(Collectors.toList());
        newApOrder.setApOrderDtlList(newDtls);
        List<ApOrderDtlGroupDO> apOrderDtlGroupDOS = this.apOrderDtlGroupRepo.findAllByMasId(id);
        List<ApOrderDtlGroup> groupList = apOrderDtlGroupDOS.stream().map(dtl -> {
            ApOrderDtlGroup dtlDO = (ApOrderDtlGroup)BeanUtils.toBean((Object)dtl, ApOrderDtlGroup.class);
            dtlDO.setTaxAmt(dtl.getTaxAmt().negate());
            dtlDO.setTotalAmt(dtl.getTotalAmt().negate());
            dtlDO.setExclTaxAmt(dtl.getExclTaxAmt().negate());
            dtlDO.setTotalCurAmt(dtl.getTotalCurAmt().negate());
            dtlDO.setTaxCurAmt(dtl.getTaxCurAmt().negate());
            dtlDO.setExclTaxCurAmt(dtl.getExclTaxCurAmt().negate());
            dtlDO.setQty(dtlDO.getQty().negate());
            return dtlDO;
        }).collect(Collectors.toList());
        newApOrder.setApOrderDtlGroupList(groupList);
        return newApOrder;
    }

    public ApOrderDomainServiceImpl(RmiSupportRpcService rmiSupportRpcService, ApOrderRepo apOrderRepo, ApOrderRepoProc apOrderRepoProc, ApOrderDtlRepoProc apOrderDtlRepoProc, ApOrderDtlRepo apOrderDtlRepo, ApOrderFactory apOrderFactory, ApOrderDtlGroupRepo apOrderDtlGroupRepo, ApOrderDtlGroupRepoProc apOrderDtlGroupRepoProc, SeqNumProvider sysNumberRuleService, ApOrderToPayDomainService apOrderToPayDomainService, RmiPurRpcService rmiPurRpcService, PurAccountProvider purAccountProvider, ReceiptPaymentAgreementDomainService receiptPaymentAgreementDomainService, ReceiptPaymentAgreementDtlDomainService receiptPaymentAgreementDtlDomainService, ArOrderDomainService arOrderDomainService, FlexFieldUtilService flexFieldUtilService, InputInvService inputInvService) {
        this.rmiSupportRpcService = rmiSupportRpcService;
        this.apOrderRepo = apOrderRepo;
        this.apOrderRepoProc = apOrderRepoProc;
        this.apOrderDtlRepoProc = apOrderDtlRepoProc;
        this.apOrderDtlRepo = apOrderDtlRepo;
        this.apOrderFactory = apOrderFactory;
        this.apOrderDtlGroupRepo = apOrderDtlGroupRepo;
        this.apOrderDtlGroupRepoProc = apOrderDtlGroupRepoProc;
        this.sysNumberRuleService = sysNumberRuleService;
        this.apOrderToPayDomainService = apOrderToPayDomainService;
        this.rmiPurRpcService = rmiPurRpcService;
        this.purAccountProvider = purAccountProvider;
        this.receiptPaymentAgreementDomainService = receiptPaymentAgreementDomainService;
        this.receiptPaymentAgreementDtlDomainService = receiptPaymentAgreementDtlDomainService;
        this.arOrderDomainService = arOrderDomainService;
        this.flexFieldUtilService = flexFieldUtilService;
        this.inputInvService = inputInvService;
    }
}

