/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.domain.service.saleinv;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.param.saleinv.SaleInvDtlParam;
import com.elitesland.fin.application.facade.vo.saleinv.SaleInvDtlVO;
import com.elitesland.fin.domain.param.saleinv.SaleInvDtlPageParam;
import com.elitesland.fin.domain.service.saleinv.SaleInvDtlDomainService;
import com.elitesland.fin.infr.dto.saleinv.SaleInvDtlDTO;
import com.elitesland.fin.infr.repo.saleinv.SaleInvDtlRepoProc;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
public class SaleInvDtlDomainServiceImp
implements SaleInvDtlDomainService {
    public final SaleInvDtlRepoProc saleInvDtlRepoProc;

    @Override
    public List<SaleInvDtlDTO> getList(Long masId) {
        List<SaleInvDtlDTO> list = this.saleInvDtlRepoProc.getList(masId);
        return list;
    }

    @Override
    public PagingVO<SaleInvDtlDTO> dtlPage(SaleInvDtlPageParam saleInvDtlPageParam) {
        PagingVO<SaleInvDtlDTO> res = this.saleInvDtlRepoProc.dtlPage(saleInvDtlPageParam);
        return res;
    }

    @Override
    public List<SaleInvDtlVO> getSummaryList(List<SaleInvDtlParam> saleInvDtlParamList) {
        Map<String, List<SaleInvDtlParam>> collect = saleInvDtlParamList.stream().collect(Collectors.groupingBy(item -> item.getItemCode().concat(item.getTaxRate().toString())));
        ArrayList<SaleInvDtlVO> result = new ArrayList<SaleInvDtlVO>();
        collect.forEach((itemCode, details) -> {
            SaleInvDtlParam row = (SaleInvDtlParam)details.get(0);
            SaleInvDtlVO curr = new SaleInvDtlVO();
            curr.setId(row.getId());
            curr.setInvNature(row.getInvNature());
            curr.setInvNatureName(row.getInvNatureName());
            curr.setItemId(row.getItemId());
            curr.setItemCode(row.getItemCode());
            curr.setItemName(row.getItemName());
            curr.setTaxCode(row.getTaxCode());
            curr.setTaxName(row.getTaxName());
            curr.setItemType(row.getItemType());
            curr.setUom(row.getUom());
            curr.setUomName(row.getUomName());
            curr.setQty(this.add((List<SaleInvDtlParam>)details, SaleInvDtlParam::getQty));
            BigDecimal priceTotal = this.add((List<SaleInvDtlParam>)details, SaleInvDtlParam::getTotalAmt);
            curr.setPrice(priceTotal.divide(curr.getQty(), 2, RoundingMode.HALF_UP));
            curr.setTotalAmt(this.add((List<SaleInvDtlParam>)details, SaleInvDtlParam::getTotalAmt));
            curr.setTaxRate(row.getTaxRate());
            curr.setTaxAmt(this.add((List<SaleInvDtlParam>)details, SaleInvDtlParam::getTaxAmt));
            curr.setExclTaxAmt(this.add((List<SaleInvDtlParam>)details, SaleInvDtlParam::getExclTaxAmt));
            curr.setFlDeductionAmt(this.add((List<SaleInvDtlParam>)details, SaleInvDtlParam::getFlDeductionAmt));
            curr.setInvDiscountAmt(this.add((List<SaleInvDtlParam>)details, SaleInvDtlParam::getInvDiscountAmt));
            curr.setDiscountAmt(this.add((List<SaleInvDtlParam>)details, SaleInvDtlParam::getDiscountAmt));
            curr.setInvAmt(this.add((List<SaleInvDtlParam>)details, SaleInvDtlParam::getInvAmt));
            result.add(curr);
        });
        return result;
    }

    private BigDecimal add(List<SaleInvDtlParam> details, Function<SaleInvDtlParam, BigDecimal> func) {
        return details.stream().map(func).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    public SaleInvDtlDomainServiceImp(SaleInvDtlRepoProc saleInvDtlRepoProc) {
        this.saleInvDtlRepoProc = saleInvDtlRepoProc;
    }
}

