/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.provider.flow;

import cn.hutool.json.JSONUtil;
import com.elitescloud.boot.core.base.SeqNumProvider;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.fin.application.convert.flow.AccountFlowConvert;
import com.elitesland.fin.application.facade.param.flow.AccountFlowParam;
import com.elitesland.fin.application.facade.vo.flow.AccountFlowVO;
import com.elitesland.fin.application.service.account.AccountIocService;
import com.elitesland.fin.application.service.account.AccountRuleConfigService;
import com.elitesland.fin.application.service.account.AccountService;
import com.elitesland.fin.application.service.flow.AccountFlowService;
import com.elitesland.fin.dto.flow.AccountFlowRpcDTO;
import com.elitesland.fin.param.flow.AccountFlowRpcParam;
import com.elitesland.fin.rocketmq.channel.FinSalMqProcessor;
import com.elitesland.fin.service.flow.AccountFlowRpcService;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.task.TaskExecutor;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rpc/accountFlow"})
public class AccountFlowRpcServiceImpl
implements AccountFlowRpcService {
    private static final Logger log = LoggerFactory.getLogger(AccountFlowRpcServiceImpl.class);
    public final AccountFlowService accountFlowService;
    public final AccountRuleConfigService accountRuleConfigService;
    private final AccountIocService accountIocService;
    private final AccountService accountService;
    private final SeqNumProvider seqNumProvider;
    private final TaskExecutor taskExecutor;
    private final FinSalMqProcessor finSalMqProcessor;
    private final TransactionTemplate transactionTemplate;

    public ApiResult<AccountFlowRpcDTO> save(List<AccountFlowRpcParam> rpcParams) {
        if (CollectionUtils.isEmpty(rpcParams)) {
            return ApiResult.fail((String)"\u6570\u636e\u4e3a\u7a7a");
        }
        List<AccountFlowParam> accountFlowParamList = rpcParams.stream().map(AccountFlowConvert.INSTANCE::rpcParamToParam).collect(Collectors.toList());
        AccountFlowVO accountFlowVO = this.accountFlowService.save(accountFlowParamList);
        return ApiResult.ok();
    }

    public ApiResult<Boolean> checkAccountBalance(AccountFlowRpcParam accountFlowRpcParam) {
        AccountFlowParam accountFlowParam = AccountFlowConvert.INSTANCE.accountFlowRpcParam2AccountFlowParam(accountFlowRpcParam);
        return ApiResult.ok((Object)this.accountFlowService.checkAccountBalance(accountFlowParam));
    }

    public ApiResult<Boolean> generateAccountFlow(AccountFlowRpcParam accountFlowRpcParam) {
        log.info("\u751f\u6210\u4fe1\u7528\u8d26\u6237\u6d41\u6c34rpc\u63a5\u53e3\uff0c\u63a5\u6536\u5230\u53c2\u6570{}", (Object)JSONUtil.toJsonStr((Object)accountFlowRpcParam));
        AccountFlowParam accountFlowParam = AccountFlowConvert.INSTANCE.accountFlowRpcParam2AccountFlowParam(accountFlowRpcParam);
        this.accountFlowService.generateAccountFlow(accountFlowParam);
        return ApiResult.ok();
    }

    public AccountFlowRpcServiceImpl(AccountFlowService accountFlowService, AccountRuleConfigService accountRuleConfigService, AccountIocService accountIocService, AccountService accountService, SeqNumProvider seqNumProvider, TaskExecutor taskExecutor, FinSalMqProcessor finSalMqProcessor, TransactionTemplate transactionTemplate) {
        this.accountFlowService = accountFlowService;
        this.accountRuleConfigService = accountRuleConfigService;
        this.accountIocService = accountIocService;
        this.accountService = accountService;
        this.seqNumProvider = seqNumProvider;
        this.taskExecutor = taskExecutor;
        this.finSalMqProcessor = finSalMqProcessor;
        this.transactionTemplate = transactionTemplate;
    }
}

