/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.rpc.pur;

import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.fin.rpc.pur.RmiPurRpcService;
import com.elitesland.pur.dto.account.PurAccountCheckQtyDTO;
import com.elitesland.pur.dto.account.PurAccountDTO;
import com.elitesland.pur.provider.PurAccountProvider;
import java.time.LocalDateTime;
import java.util.List;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class RmiPurRpcServiceImpl
implements RmiPurRpcService {
    private static final Logger log = LoggerFactory.getLogger(RmiPurRpcServiceImpl.class);
    private final PurAccountProvider purAccountProvider;

    private Object checkError(Supplier<ApiResult> supplier) {
        try {
            ApiResult apiResult = supplier.get();
            if (!apiResult.isSuccess()) {
                log.error("\u91c7\u8d2d\u57df\u8c03\u7528\u5f02\u5e38:{}", (Object)apiResult.getMsg());
                throw new BusinessException(apiResult.getMsg());
            }
            return apiResult.getData();
        }
        catch (Exception e) {
            log.error("\u91c7\u8d2d\u57df\u8c03\u7528\u5f02\u5e38\uff1a", (Throwable)e);
            throw new BusinessException("\u91c7\u8d2d\u57df\u62a5\u9519\uff1a", (Throwable)e);
        }
    }

    @Override
    public void batchUpdateDocStatus(PurAccountDTO purAccountDTO) {
        this.checkError(() -> this.purAccountProvider.batchUpdateDocStatus(purAccountDTO));
    }

    @Override
    public void addInvoiceQty(List<PurAccountCheckQtyDTO> param) {
        log.info("\u8c03\u7528\u91c7\u8d2d\u57df-\u56de\u5199\u91c7\u8d2d\u5bf9\u8d26\u5355\u5f00\u7968\u6570\u91cf\u63a5\u53e3\u5f00\u59cb\uff0c\u65f6\u95f4\uff1a{}\uff0c\u5165\u53c2\uff1a{}", (Object)LocalDateTime.now(), (Object)JSON.toJSONString(param));
        try {
            ApiResult apiResult = this.purAccountProvider.addInvoiceQty(param);
            log.info("\u8c03\u7528\u91c7\u8d2d\u57df-\u56de\u5199\u91c7\u8d2d\u5bf9\u8d26\u5355\u5f00\u7968\u6570\u91cf\u63a5\u53e3\u7ed3\u675f\uff0c\u65f6\u95f4\uff1a{}\uff0c\u51fa\u53c2\uff1a{}", (Object)LocalDateTime.now(), (Object)JSON.toJSONString((Object)apiResult));
            if (apiResult.isFailed()) {
                throw new BusinessException(ApiCode.FAIL, apiResult.getMsg());
            }
        }
        catch (Exception e) {
            log.error("purAccountCheckAddInvoiceQty error:", (Throwable)e);
            throw new BusinessException(ApiCode.FAIL, "\u8c03\u7528\u91c7\u8d2d\u57df-\u56de\u5199\u91c7\u8d2d\u5bf9\u8d26\u5355\u5f00\u7968\u6570\u91cf\u63a5\u53e3\u5931\u8d25\uff1a" + e);
        }
    }

    public RmiPurRpcServiceImpl(PurAccountProvider purAccountProvider) {
        this.purAccountProvider = purAccountProvider;
    }
}

