/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.domain.service.paymentperiod;

import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.convert.paymentperiod.AgingRangeConvert;
import com.elitesland.fin.application.facade.param.paymentperiod.AgingRangePageParam;
import com.elitesland.fin.application.facade.param.paymentperiod.AgingRangeSaveParam;
import com.elitesland.fin.application.facade.vo.paymentperiod.AgingRangePagingVO;
import com.elitesland.fin.application.facade.vo.paymentperiod.AgingRangeVO;
import com.elitesland.fin.domain.entity.paymentperiod.AgingRangeDO;
import com.elitesland.fin.domain.service.paymentperiod.AgingRangeDomainService;
import com.elitesland.fin.infr.repo.paymentperiod.AgingRangeDtlRepo;
import com.elitesland.fin.infr.repo.paymentperiod.AgingRangeDtlRepoProc;
import com.elitesland.fin.infr.repo.paymentperiod.AgingRangeRepo;
import com.elitesland.fin.infr.repo.paymentperiod.AgingRangeRepoProc;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class AgingRangeDomainServiceImpl
implements AgingRangeDomainService {
    private final AgingRangeRepo agingRangeRepo;
    private final AgingRangeRepoProc agingRangeRepoProc;
    private final AgingRangeDtlRepo agingRangeDtlRepo;
    private final AgingRangeDtlRepoProc agingRangeDtlRepoProc;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long save(AgingRangeSaveParam saveParam) {
        AgingRangeDO AgingRangeDO2 = AgingRangeConvert.INSTANCE.saveVoToDo(saveParam);
        Long id = ((AgingRangeDO)this.agingRangeRepo.save(AgingRangeDO2)).getId();
        return id;
    }

    @Override
    @SysCodeProc
    public PagingVO<AgingRangePagingVO> page(AgingRangePageParam pageParam) {
        PagingVO<AgingRangePagingVO> pagingVO = this.agingRangeRepoProc.page(pageParam);
        if (CollectionUtils.isEmpty((Collection)pagingVO.getRecords())) {
            return PagingVO.builder().total(0L).records(Collections.EMPTY_LIST).build();
        }
        return pagingVO;
    }

    @Override
    @SysCodeProc
    public AgingRangeVO findById(Long id) {
        if (Objects.isNull(id)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "ID\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        Optional optional = this.agingRangeRepo.findById(id);
        if (optional.isEmpty()) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u672a\u67e5\u8be2\u5230\u6570\u636e\u4fe1\u606f!");
        }
        return AgingRangeConvert.INSTANCE.doToRespVo((AgingRangeDO)optional.get());
    }

    @Override
    @SysCodeProc
    public AgingRangeVO selectById(Long id) {
        if (Objects.isNull(id)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "ID\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        AgingRangePageParam queryVO = new AgingRangePageParam();
        queryVO.setId(id);
        List<AgingRangeVO> respVOList = this.agingRangeRepoProc.selectListByParam(queryVO);
        if (CollectionUtils.isEmpty(respVOList)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u672a\u67e5\u8be2\u5230\u6570\u636e\u4fe1\u606f!");
        }
        if (respVOList.size() > 1) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u67e5\u8be2\u5230\u591a\u6761\u6570\u636e\u4fe1\u606f!");
        }
        AgingRangeVO agreementVO = respVOList.get(0);
        return agreementVO;
    }

    @Override
    @SysCodeProc
    public AgingRangeVO selectByCode(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        AgingRangePageParam queryVO = new AgingRangePageParam();
        queryVO.setAgingRangeCode(code);
        List<AgingRangeVO> respVOList = this.agingRangeRepoProc.selectListByParam(queryVO);
        if (CollectionUtils.isEmpty(respVOList)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u672a\u67e5\u8be2\u5230\u6570\u636e\u4fe1\u606f!");
        }
        if (respVOList.size() > 1) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u67e5\u8be2\u5230\u591a\u6761\u6570\u636e\u4fe1\u606f!");
        }
        AgingRangeVO agreementVO = respVOList.get(0);
        return agreementVO;
    }

    @Override
    @SysCodeProc
    public List<AgingRangeVO> selectByParam(AgingRangePageParam queryVO) {
        List<AgingRangeVO> agreementVOList = this.agingRangeRepoProc.selectListByParam(queryVO);
        if (CollectionUtils.isEmpty(agreementVOList)) {
            return Collections.EMPTY_LIST;
        }
        return agreementVOList;
    }

    @Override
    @SysCodeProc
    public AgingRangeVO checkSelectByParam(AgingRangePageParam queryVO) {
        AgingRangeVO agreementVO = this.agingRangeRepoProc.checkSelectByParam(queryVO);
        return agreementVO;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateStatusBatch(String status, List<Long> ids) {
        this.agingRangeRepoProc.updateStatusBatch(status, ids);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateStatusById(String status, Long id) {
        this.agingRangeRepoProc.updateStatusById(status, id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateDeleteFlagBatch(Integer deleteFlag, List<Long> ids) {
        this.agingRangeRepoProc.updateDeleteFlagBatch(deleteFlag, ids);
    }

    public AgingRangeDomainServiceImpl(AgingRangeRepo agingRangeRepo, AgingRangeRepoProc agingRangeRepoProc, AgingRangeDtlRepo agingRangeDtlRepo, AgingRangeDtlRepoProc agingRangeDtlRepoProc) {
        this.agingRangeRepo = agingRangeRepo;
        this.agingRangeRepoProc = agingRangeRepoProc;
        this.agingRangeDtlRepo = agingRangeDtlRepo;
        this.agingRangeDtlRepoProc = agingRangeDtlRepoProc;
    }
}

