/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.service.workflow.payorder;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.system.param.SysUserIdFlowRoleRpcParam;
import com.elitescloud.cloudt.system.service.SysUserFlowRoleRpcService;
import com.elitesland.fin.application.facade.dto.writeoff.FinApPayApplyApprovalDTO;
import com.elitesland.fin.application.facade.param.recorder.RecOrderDtlSaveParam;
import com.elitesland.fin.application.facade.param.recorder.RecOrderSaveParam;
import com.elitesland.fin.application.facade.vo.writeoff.FinApPayVerApplyApVO;
import com.elitesland.fin.application.facade.vo.writeoff.FinApPayVerApplyPayVO;
import com.elitesland.fin.application.facade.vo.writeoff.FinApPayVerApplyVO;
import com.elitesland.fin.application.service.recorder.RecOrderService;
import com.elitesland.fin.application.service.workflow.payorder.PayOrderProcessService;
import com.elitesland.fin.application.service.writeoff.FinApPayVerApplyService;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.domain.entity.payorder.QPayOrderDO;
import com.elitesland.fin.domain.entity.recorder.RecOrderDO;
import com.elitesland.fin.domain.entity.writeoff.FinApPayVerApplyDO;
import com.elitesland.fin.domain.service.aporder.ApOrderDtlDomainService;
import com.elitesland.fin.domain.service.payorder.PayOrderDtlDomainService;
import com.elitesland.fin.infr.dto.payorder.PayOrderDTO;
import com.elitesland.fin.infr.dto.payorder.PayOrderDtlDTO;
import com.elitesland.fin.infr.repo.payorder.PayOrderDtlRepoProc;
import com.elitesland.fin.infr.repo.payorder.PayOrderRepoProc;
import com.elitesland.fin.infr.repo.recorder.RecOrderRepoProc;
import com.elitesland.fin.repo.writeoff.FinApPayVerApplyPayHeadRepoProc;
import com.elitesland.fin.repo.writeoff.FinApPayVerApplyPayRepoProc;
import com.elitesland.fin.repo.writeoff.FinApPayVerApplyRepoProc;
import com.elitesland.fin.rpc.pur.RmiPurRpcService;
import com.elitesland.pur.dto.supp.PurSuppBaseDTO;
import com.elitesland.workflow.CommentInfo;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PayOrderProcessServiceImpl
implements PayOrderProcessService {
    private static final Logger log = LoggerFactory.getLogger(PayOrderProcessServiceImpl.class);
    @Autowired
    @Lazy
    private RecOrderService recOrderService;
    private final RecOrderRepoProc recOrderRepoProc;
    private final RmiPurRpcService rmiPurRpcService;
    private final ApOrderDtlDomainService apOrderDtlDomainService;
    private final PayOrderDtlDomainService payOrderDtlDomainService;
    private final FinApPayVerApplyRepoProc finApPayVerApplyRepoProc;
    private final FinApPayVerApplyPayRepoProc finApPayVerApplyPayRepoProc;
    private final FinApPayVerApplyPayHeadRepoProc finApPayVerApplyPayHeadRepoProc;
    private final SysUserFlowRoleRpcService sysUserFlowRoleRpcService;
    private final PayOrderRepoProc payOrderRepoProc;
    private final PayOrderDtlRepoProc payOrderDtlRepoProc;
    private final JPAQueryFactory jpaQueryFactory;
    private final FinApPayVerApplyService finApPayVerApplyService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void processStatusChange(long id, ProcInstStatus procInstStatus, CommentInfo commentInfo) {
        List<Long> ids;
        List<Long> byPayId;
        PayOrderDTO payOrderDTO = this.payOrderRepoProc.queryById(id);
        List<PayOrderDtlDTO> payOrderDtlDTOS = this.payOrderDtlRepoProc.queryByMasId(id);
        if (payOrderDTO == null) {
            throw new com.elitescloud.cloudt.common.exception.BusinessException("\u5355\u636e(id:" + id + ")\u4e0d\u5b58\u5728,\u65e0\u6cd5\u5ba1\u6279");
        }
        QPayOrderDO payOrderDO = QPayOrderDO.payOrderDO;
        JPAUpdateClause jpaUpdateClause = this.jpaQueryFactory.update((EntityPath)payOrderDO).set(payOrderDO.procInstStatus, (Object)procInstStatus).where(new Predicate[]{payOrderDO.id.eq((Object)id)});
        switch (procInstStatus) {
            case NOTSUBMIT: {
                jpaUpdateClause.set((Path)payOrderDO.orderState, (Object)UdcEnum.APPLY_STATUS_DRAFT.getValueCode());
                break;
            }
            case INTERRUPT: {
                jpaUpdateClause.set((Path)payOrderDO.orderState, (Object)UdcEnum.APPLY_STATUS_DRAFT.getValueCode()).set((Path)payOrderDO.procInstId, (Object)null);
                break;
            }
            case APPROVING: {
                jpaUpdateClause.set((Path)payOrderDO.orderState, (Object)UdcEnum.APPLY_STATUS_DOING.getValueCode()).set(payOrderDO.submitTime, (Object)LocalDateTime.now());
                break;
            }
            case REJECTED: {
                jpaUpdateClause.set((Path)payOrderDO.orderState, (Object)UdcEnum.APPLY_STATUS_DRAFT.getValueCode()).set(payOrderDO.approvedTime, (Object)LocalDateTime.now()).set(payOrderDO.auditDate, (Object)LocalDateTime.now()).set(payOrderDO.auditUserId, (Object)Long.valueOf(commentInfo.getUserId())).set((Path)payOrderDO.auditRejection, (Object)commentInfo.getComment()).set((Path)payOrderDO.auditUser, (Object)commentInfo.getUserName());
                break;
            }
            case INVALID: {
                jpaUpdateClause.set((Path)payOrderDO.orderState, (Object)UdcEnum.APPLY_STATUS_VOID.getValueCode()).set(payOrderDO.approvedTime, (Object)LocalDateTime.now()).set(payOrderDO.auditDate, (Object)LocalDateTime.now()).set(payOrderDO.auditUserId, (Object)Long.valueOf(commentInfo.getUserId())).set((Path)payOrderDO.auditRejection, (Object)commentInfo.getComment()).set((Path)payOrderDO.auditUser, (Object)commentInfo.getUserName()).set((Path)payOrderDO.procInstId, (Object)null);
                break;
            }
            case APPROVED: {
                jpaUpdateClause.set((Path)payOrderDO.orderState, (Object)UdcEnum.APPLY_STATUS_COMPLETE.getValueCode()).set((Path)payOrderDO.proposedStatus, (Object)UdcEnum.DOC_PROPOSED_STATUS_DRAFT.getValueCode()).set(payOrderDO.approvedTime, (Object)LocalDateTime.now()).set(payOrderDO.auditDate, (Object)LocalDateTime.now()).set(payOrderDO.auditUserId, (Object)Long.valueOf(commentInfo.getUserId())).set((Path)payOrderDO.auditUser, (Object)commentInfo.getUserName());
                break;
            }
        }
        jpaUpdateClause.execute();
        PayOrderDTO orderDTO = this.payOrderRepoProc.queryById(id);
        String suppType2 = this.getSuppType2(orderDTO);
        List<RecOrderDO> data = this.recOrderRepoProc.findBySourceNo(orderDTO.getPayOrderNo());
        if (procInstStatus.equals((Object)ProcInstStatus.APPROVED)) {
            if ("INNER".equals(suppType2) && CollUtil.isEmpty(data)) {
                RecOrderSaveParam recOrderSaveParam = this.getRecOrderSaveParam(payOrderDTO, payOrderDtlDTOS);
                this.recOrderService.save(recOrderSaveParam);
            }
            log.info("\u4ed8\u6b3e\u5355\u5ba1\u6279\u901a\u8fc7\uff0c\u51c6\u5907\u5c06\u4ed8\u6b3e\u5355\u8054\u52a8\u7684\u6838\u9500\u5355\u5ba1\u6279\u901a\u8fc7");
            byPayId = this.finApPayVerApplyPayRepoProc.findByPayId(id);
            ids = this.finApPayVerApplyPayHeadRepoProc.findByPayId(byPayId);
            log.info("\u5ba1\u6279\u901a\u8fc7\u540e\uff0c\u5c06\u5bf9\u5e94\u5355\u636e\u6838\u9500\u6389\u5e76\u4e14\u5ba1\u6279\u901a\u8fc7,\u5e94\u4ed8\u4ed8\u6b3e\u6838\u9500\u5355ids:{}", (Object)JSONUtil.toJsonStr(ids));
            List applyDocNos = this.finApPayVerApplyRepoProc.findAllByIds(ids).stream().map(FinApPayVerApplyDO::getApplyDocNo).collect(Collectors.toList());
            FinApPayApplyApprovalDTO dto = new FinApPayApplyApprovalDTO();
            ArrayList<String> applyNos = new ArrayList<String>();
            applyNos.addAll(applyDocNos);
            dto.setApplyNos(applyNos);
            dto.setApprovalType(FinApPayApplyApprovalDTO.ApprovalType.APPROVE);
            this.finApPayVerApplyService.writeOffApprove(dto);
            for (Long idIn : ids) {
                this.finApPayVerApplyRepoProc.ApproveById(idIn);
            }
            log.info("\u4ed8\u6b3e\u5355\u5ba1\u6279\u901a\u8fc7\uff0c\u5b8c\u6210\u5c06\u4ed8\u6b3e\u5355\u8054\u52a8\u7684\u6838\u9500\u5355\u5ba1\u6279\u901a\u8fc7");
            this.finApPayVerApplyService.autoWriteoffPay(payOrderDTO);
        }
        if (procInstStatus.equals((Object)ProcInstStatus.REJECTED) || procInstStatus.equals((Object)ProcInstStatus.NOTSUBMIT)) {
            byPayId = this.finApPayVerApplyPayRepoProc.findByPayId(id);
            ids = this.finApPayVerApplyPayHeadRepoProc.findByPayId(byPayId);
            log.info("\u5ba1\u6279\u62d2\u7edd\u6216\u9a73\u56de,\u5220\u9664\u5e94\u4ed8\u4ed8\u6b3e\u6838\u9500\u5355ids:{}", (Object)JSONUtil.toJsonStr(ids));
            for (Long apPayVerApplyId : ids) {
                FinApPayVerApplyVO detail = this.finApPayVerApplyService.detail(apPayVerApplyId);
                List<Long> apDIds = detail.getApList().stream().filter(e -> e.getApDId() != null).map(FinApPayVerApplyApVO::getApDId).distinct().collect(Collectors.toList());
                Map<Long, BigDecimal> apDIdVerAmtMap = detail.getApList().stream().filter(e -> e.getApDId() != null).collect(Collectors.toMap(FinApPayVerApplyApVO::getApDId, FinApPayVerApplyApVO::getVerAmt));
                List<Long> payDIds = detail.getPayList().stream().filter(e -> e.getPayDId() != null).map(FinApPayVerApplyPayVO::getPayDId).distinct().collect(Collectors.toList());
                Map<Long, BigDecimal> payDIdVerAmtMap = detail.getPayList().stream().filter(e -> e.getPayDId() != null).collect(Collectors.toMap(FinApPayVerApplyPayVO::getPayDId, FinApPayVerApplyPayVO::getVerAmt));
                log.info("\u5ba1\u6279\u62d2\u7edd\u6216\u9a73\u56de,\u56de\u5199\u53c2\u6570:apDIdVerAmtMap:{},apDIds:{},payDIdVerAmtMap:{},payDIds:{}", new Object[]{JSONUtil.toJsonStr(apDIdVerAmtMap), apDIds, JSONUtil.toJsonStr(payDIdVerAmtMap), payDIds});
                this.payOrderDtlDomainService.resortVerAmt(apDIdVerAmtMap, apDIds);
                this.apOrderDtlDomainService.resortVerAmt(payDIdVerAmtMap, payDIds);
            }
            this.finApPayVerApplyRepoProc.deleteByIds(ids);
        }
        if (procInstStatus.equals((Object)ProcInstStatus.NOTSUBMIT) && "INNER".equals(suppType2) && CollUtil.isNotEmpty(data)) {
            throw new BusinessException("\u6539\u5355\u636e\u5df2\u7ecf\u751f\u6210\u5173\u8054\u7684\u6536\u6b3e\u5355\uff0c\u4e0d\u5141\u8bb8\u53d6\u6d88\u5ba1\u6279");
        }
    }

    private RecOrderSaveParam getRecOrderSaveParam(PayOrderDTO orderDTO, List<PayOrderDtlDTO> payOrderDtlDTOS) {
        List<RecOrderDO> bySourceNo;
        RecOrderSaveParam param = new RecOrderSaveParam();
        param.setOuCode(orderDTO.getSuppCode());
        param.setOuId(orderDTO.getSuppId());
        param.setOuName(orderDTO.getSuppName());
        param.setCustCode(orderDTO.getOuCode());
        param.setCustId(orderDTO.getOuId());
        param.setCustName(orderDTO.getOuName());
        param.setRecTypeCode("SKD01_SYS");
        param.setRecTypeName("\u6807\u51c6\u6536\u6b3e\u5355");
        param.setReDate(orderDTO.getApDate());
        param.setCurrCode(orderDTO.getCurrCode());
        param.setCurrName(orderDTO.getCurrName());
        param.setCreateMode("PAY");
        param.setRecOuId(orderDTO.getSuppId());
        param.setRecOuCode(orderDTO.getSuppCode());
        param.setRecOuName(orderDTO.getSuppName());
        param.setExchangeRate(orderDTO.getExchangeRate());
        param.setTotalAmt(orderDTO.getTotalAmt());
        param.setTotalCurAmt(orderDTO.getTotalCurAmt());
        param.setRealRecAmt(orderDTO.getRealPayAmt());
        param.setRealRecCurAmt(orderDTO.getRealPayCurAmt());
        param.setReFlag(orderDTO.getApFlag());
        param.setInitFlag(orderDTO.getInitFlag());
        param.setOrderState("COMPLETE");
        param.setRedState(orderDTO.getRedState());
        String redSourceNo = orderDTO.getRedSourceNo();
        if (StrUtil.isNotBlank((CharSequence)redSourceNo) && CollUtil.isNotEmpty(bySourceNo = this.recOrderRepoProc.findBySourceNo(redSourceNo))) {
            RecOrderDO recOrderDO = bySourceNo.get(0);
            param.setRedSourceNo(recOrderDO.getRecOrderNo());
            param.setRedSourceId(recOrderDO.getId());
        }
        param.setProposedStatus("DRAFT");
        param.setSourceNo(orderDTO.getPayOrderNo());
        List<RecOrderDtlSaveParam> orderDtlSaveParamList = payOrderDtlDTOS.stream().map(payOrderDtlDTO -> {
            RecOrderDtlSaveParam dtlSaveParam = new RecOrderDtlSaveParam();
            dtlSaveParam.setSourceLine(payOrderDtlDTO.getSourceLine());
            dtlSaveParam.setSourceLineId(payOrderDtlDTO.getSourceLineId());
            dtlSaveParam.setRecType(payOrderDtlDTO.getPayType());
            dtlSaveParam.setRecTypeName(payOrderDtlDTO.getPayTypeName());
            dtlSaveParam.setRecAccount(payOrderDtlDTO.getPayAccount());
            dtlSaveParam.setRecBank(payOrderDtlDTO.getPayBank());
            dtlSaveParam.setEs16(payOrderDtlDTO.getRecAccount());
            dtlSaveParam.setEs17(payOrderDtlDTO.getRecBank());
            dtlSaveParam.setTotalAmt(payOrderDtlDTO.getTotalAmt());
            dtlSaveParam.setTotalCurAmt(payOrderDtlDTO.getTotalCurAmt());
            dtlSaveParam.setTaxRate(BigDecimal.ZERO);
            dtlSaveParam.setTaxAmt(BigDecimal.ZERO);
            dtlSaveParam.setRealRecAmt(payOrderDtlDTO.getRealPayAmt());
            dtlSaveParam.setRealRecCurAmt(payOrderDtlDTO.getRealPayCurAmt());
            dtlSaveParam.setVerAmt(BigDecimal.ZERO);
            dtlSaveParam.setApplyVerAmTing(BigDecimal.ZERO);
            dtlSaveParam.setUnVerAmt(param.getTotalAmt());
            return dtlSaveParam;
        }).collect(Collectors.toList());
        param.setOrderDtlSaveParamList(orderDtlSaveParamList);
        return param;
    }

    private String getSuppType2(PayOrderDTO orderDTO) {
        Long suppId = orderDTO.getSuppId();
        List<PurSuppBaseDTO> bySuppIdBatch = this.rmiPurRpcService.findBySuppIdBatch(Collections.singletonList(suppId));
        if (CollUtil.isEmpty(bySuppIdBatch)) {
            throw new BusinessException("\u5355\u636e\u5bf9\u5e94\u4f9b\u5e94\u5546\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        PurSuppBaseDTO purSuppBaseDTO = bySuppIdBatch.get(0);
        return purSuppBaseDTO.getSuppType2();
    }

    @Override
    public ArrayList<String> taskAssignee(String businessKey, String customParams) {
        Long businessId = Long.valueOf(businessKey);
        PayOrderDTO payOrderDTO = this.payOrderRepoProc.queryById(businessId);
        if (payOrderDTO == null) {
            throw new com.elitescloud.cloudt.common.exception.BusinessException("\u5355\u636e(id:" + businessId + ")\u4e0d\u5b58\u5728,\u65e0\u6cd5\u5ba1\u6279");
        }
        SysUserIdFlowRoleRpcParam param = SysUserIdFlowRoleRpcParam.builder().ouIds(Collections.singletonList(payOrderDTO.getOuId())).flowRoleCodes(Collections.singletonList(customParams)).build();
        List userIdsByFlowRoles = this.sysUserFlowRoleRpcService.findUserIdsByFlowRoles(param);
        return userIdsByFlowRoles.stream().map(e -> "" + e).collect(Collectors.toCollection(ArrayList::new));
    }

    public PayOrderProcessServiceImpl(RecOrderRepoProc recOrderRepoProc, RmiPurRpcService rmiPurRpcService, ApOrderDtlDomainService apOrderDtlDomainService, PayOrderDtlDomainService payOrderDtlDomainService, FinApPayVerApplyRepoProc finApPayVerApplyRepoProc, FinApPayVerApplyPayRepoProc finApPayVerApplyPayRepoProc, FinApPayVerApplyPayHeadRepoProc finApPayVerApplyPayHeadRepoProc, SysUserFlowRoleRpcService sysUserFlowRoleRpcService, PayOrderRepoProc payOrderRepoProc, PayOrderDtlRepoProc payOrderDtlRepoProc, JPAQueryFactory jpaQueryFactory, FinApPayVerApplyService finApPayVerApplyService) {
        this.recOrderRepoProc = recOrderRepoProc;
        this.rmiPurRpcService = rmiPurRpcService;
        this.apOrderDtlDomainService = apOrderDtlDomainService;
        this.payOrderDtlDomainService = payOrderDtlDomainService;
        this.finApPayVerApplyRepoProc = finApPayVerApplyRepoProc;
        this.finApPayVerApplyPayRepoProc = finApPayVerApplyPayRepoProc;
        this.finApPayVerApplyPayHeadRepoProc = finApPayVerApplyPayHeadRepoProc;
        this.sysUserFlowRoleRpcService = sysUserFlowRoleRpcService;
        this.payOrderRepoProc = payOrderRepoProc;
        this.payOrderDtlRepoProc = payOrderDtlRepoProc;
        this.jpaQueryFactory = jpaQueryFactory;
        this.finApPayVerApplyService = finApPayVerApplyService;
    }
}

