/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.service.workflow.recorder;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.system.param.SysUserIdFlowRoleRpcParam;
import com.elitescloud.cloudt.system.service.SysUserFlowRoleRpcService;
import com.elitesland.fin.application.facade.param.payorder.PayOrderDtlSaveParam;
import com.elitesland.fin.application.facade.param.payorder.PayOrderSaveParam;
import com.elitesland.fin.application.service.payorder.PayOrderService;
import com.elitesland.fin.application.service.workflow.recorder.RecOrderProcessService;
import com.elitesland.fin.application.service.writeoff.FinArRecVerApplyService;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.domain.entity.payorder.PayOrderDO;
import com.elitesland.fin.domain.entity.recorder.QRecOrderDO;
import com.elitesland.fin.infr.dto.recorder.RecOrderDTO;
import com.elitesland.fin.infr.dto.recorder.RecOrderDtlDTO;
import com.elitesland.fin.infr.repo.payorder.PayOrderRepoProc;
import com.elitesland.fin.infr.repo.recorder.RecOrderDtlRepoProc;
import com.elitesland.fin.infr.repo.recorder.RecOrderRepoProc;
import com.elitesland.fin.rpc.sale.RmiSaleRpcService;
import com.elitesland.sale.dto.CrmCustBaseDTO;
import com.elitesland.workflow.CommentInfo;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class RecOrderProcessServiceImpl
implements RecOrderProcessService {
    private static final Logger log = LoggerFactory.getLogger(RecOrderProcessServiceImpl.class);
    @Autowired
    @Lazy
    private PayOrderService payOrderService;
    private final PayOrderRepoProc payOrderRepoProc;
    private final RmiSaleRpcService rmiSaleRpcService;
    private final SysUserFlowRoleRpcService sysUserFlowRoleRpcService;
    private final RecOrderRepoProc recOrderRepoProc;
    private final RecOrderDtlRepoProc recOrderDtlRepoProc;
    private final JPAQueryFactory jpaQueryFactory;
    private final FinArRecVerApplyService finArRecVerApplyService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void processStatusChange(long id, ProcInstStatus procInstStatus, CommentInfo commentInfo) {
        RecOrderDTO recOrderDTO = this.recOrderRepoProc.queryById(id);
        List<RecOrderDtlDTO> recOrderDtlDTOS = this.recOrderDtlRepoProc.queryByMasId(id);
        if (recOrderDTO == null) {
            throw new com.elitescloud.cloudt.common.exception.BusinessException("\u5355\u636e(id:" + id + ")\u4e0d\u5b58\u5728,\u65e0\u6cd5\u5ba1\u6279");
        }
        QRecOrderDO recOrderDO = QRecOrderDO.recOrderDO;
        JPAUpdateClause jpaUpdateClause = this.jpaQueryFactory.update((EntityPath)recOrderDO).set(recOrderDO.procInstStatus, (Object)procInstStatus).where(new Predicate[]{recOrderDO.id.eq((Object)id)});
        switch (procInstStatus) {
            case NOTSUBMIT: {
                jpaUpdateClause.set((Path)recOrderDO.orderState, (Object)UdcEnum.APPLY_STATUS_DRAFT.getValueCode());
                break;
            }
            case INTERRUPT: {
                jpaUpdateClause.set((Path)recOrderDO.orderState, (Object)UdcEnum.APPLY_STATUS_DRAFT.getValueCode()).set((Path)recOrderDO.procInstId, (Object)null);
                break;
            }
            case APPROVING: {
                jpaUpdateClause.set((Path)recOrderDO.orderState, (Object)UdcEnum.APPLY_STATUS_DOING.getValueCode()).set(recOrderDO.submitTime, (Object)LocalDateTime.now());
                break;
            }
            case REJECTED: {
                jpaUpdateClause.set((Path)recOrderDO.orderState, (Object)UdcEnum.APPLY_STATUS_DRAFT.getValueCode()).set(recOrderDO.approvedTime, (Object)LocalDateTime.now()).set(recOrderDO.auditDate, (Object)LocalDateTime.now()).set(recOrderDO.auditUserId, (Object)Long.valueOf(commentInfo.getUserId())).set((Path)recOrderDO.auditRejection, (Object)commentInfo.getComment()).set((Path)recOrderDO.auditUser, (Object)commentInfo.getUserName());
                break;
            }
            case INVALID: {
                jpaUpdateClause.set((Path)recOrderDO.orderState, (Object)UdcEnum.APPLY_STATUS_VOID.getValueCode()).set(recOrderDO.approvedTime, (Object)LocalDateTime.now()).set(recOrderDO.auditDate, (Object)LocalDateTime.now()).set(recOrderDO.auditUserId, (Object)Long.valueOf(commentInfo.getUserId())).set((Path)recOrderDO.auditRejection, (Object)commentInfo.getComment()).set((Path)recOrderDO.auditUser, (Object)commentInfo.getUserName()).set((Path)recOrderDO.procInstId, (Object)null);
                break;
            }
            case APPROVED: {
                jpaUpdateClause.set((Path)recOrderDO.orderState, (Object)UdcEnum.APPLY_STATUS_COMPLETE.getValueCode()).set((Path)recOrderDO.proposedStatus, (Object)UdcEnum.DOC_PROPOSED_STATUS_DRAFT.getValueCode()).set(recOrderDO.approvedTime, (Object)LocalDateTime.now()).set(recOrderDO.auditDate, (Object)LocalDateTime.now()).set(recOrderDO.auditUserId, (Object)Long.valueOf(commentInfo.getUserId())).set((Path)recOrderDO.auditUser, (Object)commentInfo.getUserName());
                break;
            }
        }
        jpaUpdateClause.execute();
        String custType2 = this.getCustType2(recOrderDTO);
        List<PayOrderDO> data = this.payOrderRepoProc.queryBySourceNo(recOrderDTO.getRecOrderNo());
        if (procInstStatus.equals((Object)ProcInstStatus.APPROVED)) {
            if ("C".equals(custType2) && CollUtil.isEmpty(data)) {
                PayOrderSaveParam payOrderSaveParam = this.getPayOrderSaveParam(recOrderDTO, recOrderDtlDTOS);
                this.payOrderService.save(payOrderSaveParam);
            }
            log.info("\u6536\u6b3e\u5355\u5ba1\u6279\u901a\u8fc7\uff0c\u5f00\u59cb\u81ea\u52a8\u6838\u9500");
            this.finArRecVerApplyService.autoWriteoffRec(recOrderDTO);
        }
        if (procInstStatus.equals((Object)ProcInstStatus.NOTSUBMIT) && "C".equals(custType2) && CollUtil.isNotEmpty(data)) {
            throw new BusinessException("\u6536\u6b3e\u5355\u5df2\u7ecf\u751f\u6210\u5173\u8054\u4ed8\u6b3e\u5355\uff0c\u4e0d\u5141\u8bb8\u53d6\u6d88\u5ba1\u6279");
        }
    }

    private PayOrderSaveParam getPayOrderSaveParam(RecOrderDTO recOrderDTO, List<RecOrderDtlDTO> recOrderDtlDTOS) {
        List<PayOrderDO> payOrderDOS;
        PayOrderSaveParam param = new PayOrderSaveParam();
        param.setOuId(recOrderDTO.getCustId());
        param.setOuCode(recOrderDTO.getCustCode());
        param.setOuName(recOrderDTO.getCustName());
        param.setSuppId(recOrderDTO.getOuId());
        param.setSuppCode(recOrderDTO.getOuCode());
        param.setSuppName(recOrderDTO.getOuName());
        param.setSourceNo(recOrderDTO.getRecOrderNo());
        param.setPayTypeCode("ap");
        param.setPayTypeName("\u6807\u51c6\u4ed8\u6b3e");
        param.setCreateMode("REC");
        param.setTotalAmt(recOrderDTO.getTotalAmt());
        param.setRealPayAmt(recOrderDTO.getRealRecAmt());
        param.setBuDate(recOrderDTO.getReDate());
        param.setInitFlag(recOrderDTO.getInitFlag());
        param.setTotalCurAmt(recOrderDTO.getTotalCurAmt());
        param.setRealPayCurAmt(recOrderDTO.getRealRecCurAmt());
        param.setApDate(recOrderDTO.getReDate());
        param.setApFlag(recOrderDTO.getReFlag());
        param.setExchangeRate(recOrderDTO.getExchangeRate());
        param.setOrderState("COMPLETE");
        param.setRedState(recOrderDTO.getRedState());
        String redSourceNo = recOrderDTO.getRedSourceNo();
        if (StrUtil.isNotBlank((CharSequence)redSourceNo) && CollUtil.isNotEmpty(payOrderDOS = this.payOrderRepoProc.queryBySourceNo(redSourceNo))) {
            PayOrderDO payOrderDO = payOrderDOS.get(0);
            param.setRedSourceNo(payOrderDO.getPayOrderNo());
            param.setRedSourceId(payOrderDO.getId());
        }
        Map<String, List<RecOrderDtlDTO>> groupedData = recOrderDtlDTOS.stream().collect(Collectors.groupingBy(e -> e.getRecBank() + e.getRecAccount()));
        param.setProposedStatus("DRAFT");
        List<PayOrderDtlSaveParam> payOrderDtlSaveParams = groupedData.entrySet().stream().map(entry -> {
            RecOrderDtlDTO payorderDtlDto = (RecOrderDtlDTO)((List)entry.getValue()).get(0);
            BigDecimal totalAmt = ((List)entry.getValue()).stream().filter(e -> e.getTotalAmt() != null).map(RecOrderDtlDTO::getTotalAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal totalCurAmt = ((List)entry.getValue()).stream().filter(e -> e.getTotalCurAmt() != null).map(RecOrderDtlDTO::getTotalCurAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
            PayOrderDtlSaveParam payOrderDtlSaveParam = new PayOrderDtlSaveParam();
            payOrderDtlSaveParam.setSourceLine(payorderDtlDto.getSourceLine());
            payOrderDtlSaveParam.setSourceLineId(payorderDtlDto.getSourceLineId());
            payOrderDtlSaveParam.setPayType(payorderDtlDto.getRecType());
            payOrderDtlSaveParam.setPayBank(payorderDtlDto.getRecBank());
            payOrderDtlSaveParam.setPayAccount(payorderDtlDto.getRecAccount());
            payOrderDtlSaveParam.setTotalAmt(totalAmt);
            payOrderDtlSaveParam.setTotalCurAmt(totalCurAmt);
            payOrderDtlSaveParam.setRecBank(payorderDtlDto.getRecBank());
            payOrderDtlSaveParam.setRecAccount(payorderDtlDto.getRecAccount());
            payOrderDtlSaveParam.setRealPayAmt(payorderDtlDto.getRealRecAmt());
            payOrderDtlSaveParam.setRealPayCurAmt(payorderDtlDto.getRealRecCurAmt());
            payOrderDtlSaveParam.setVerAmt(BigDecimal.ZERO);
            payOrderDtlSaveParam.setApplyVerAmTing(BigDecimal.ZERO);
            payOrderDtlSaveParam.setUnVerAmt(param.getTotalAmt());
            return payOrderDtlSaveParam;
        }).collect(Collectors.toList());
        param.setPayOrderDtlSaveParams(payOrderDtlSaveParams);
        return param;
    }

    private String getCustType2(RecOrderDTO recOrderDTO) {
        List<CrmCustBaseDTO> custBaseInfoList = this.rmiSaleRpcService.getCustBaseInfo(Collections.singletonList(recOrderDTO.getCustCode()));
        if (CollUtil.isEmpty(custBaseInfoList)) {
            throw new BusinessException("\u5ba2\u6237\u7f16\u7801" + recOrderDTO.getCustCode() + "\u5bf9\u5e94\u5ba2\u6237\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        CrmCustBaseDTO crmCustBaseDTO = custBaseInfoList.get(0);
        return crmCustBaseDTO.getCustType2();
    }

    @Override
    public ArrayList<String> taskAssignee(String businessKey, String customParams) {
        Long businessId = Long.valueOf(businessKey);
        RecOrderDTO recOrderDTO = this.recOrderRepoProc.queryById(businessId);
        if (recOrderDTO == null) {
            throw new com.elitescloud.cloudt.common.exception.BusinessException("\u5355\u636e(id:" + businessId + ")\u4e0d\u5b58\u5728,\u65e0\u6cd5\u5ba1\u6279");
        }
        SysUserIdFlowRoleRpcParam param = SysUserIdFlowRoleRpcParam.builder().ouIds(Collections.singletonList(recOrderDTO.getOuId())).flowRoleCodes(Collections.singletonList(customParams)).build();
        List userIdsByFlowRoles = this.sysUserFlowRoleRpcService.findUserIdsByFlowRoles(param);
        return userIdsByFlowRoles.stream().map(e -> "" + e).collect(Collectors.toCollection(ArrayList::new));
    }

    public RecOrderProcessServiceImpl(PayOrderRepoProc payOrderRepoProc, RmiSaleRpcService rmiSaleRpcService, SysUserFlowRoleRpcService sysUserFlowRoleRpcService, RecOrderRepoProc recOrderRepoProc, RecOrderDtlRepoProc recOrderDtlRepoProc, JPAQueryFactory jpaQueryFactory, FinArRecVerApplyService finArRecVerApplyService) {
        this.payOrderRepoProc = payOrderRepoProc;
        this.rmiSaleRpcService = rmiSaleRpcService;
        this.sysUserFlowRoleRpcService = sysUserFlowRoleRpcService;
        this.recOrderRepoProc = recOrderRepoProc;
        this.recOrderDtlRepoProc = recOrderDtlRepoProc;
        this.jpaQueryFactory = jpaQueryFactory;
        this.finArRecVerApplyService = finArRecVerApplyService;
    }
}

