/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.infr.repo.payorder;

import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.domain.entity.payorder.PayOrderDtlDO;
import com.elitesland.fin.domain.entity.payorder.QPayOrderDO;
import com.elitesland.fin.domain.entity.payorder.QPayOrderDtlDO;
import com.elitesland.fin.domain.param.payorder.PayOrderDtlPageParam;
import com.elitesland.fin.domain.param.payorder.PayOrderPageParam;
import com.elitesland.fin.infr.dto.payorder.PayOrderDtlDTO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class PayOrderDtlRepoProc {
    private final JPAQueryFactory jpaQueryFactory;
    private final QPayOrderDtlDO qPayOrderDtlDO = QPayOrderDtlDO.payOrderDtlDO;
    private final QPayOrderDO qPayOrderDO = QPayOrderDO.payOrderDO;

    public List<Long> queryBySourceNo(String sourceNo) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.qPayOrderDtlDO.masId).from((EntityPath)this.qPayOrderDtlDO)).where((Predicate)this.qPayOrderDtlDO.sourceNo.like("%" + sourceNo + "%"))).fetch();
    }

    public List<Long> queryUnverBySourceNo(PayOrderPageParam param) {
        String sourceNo = param.getSourceNoDtl();
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        if (StringUtils.isNotBlank((CharSequence)sourceNo)) {
            predicates.add(this.qPayOrderDtlDO.sourceNo.like("%" + sourceNo + "%"));
        }
        predicates.add(this.qPayOrderDtlDO.deleteFlag.eq((Object)0));
        if (StringUtils.isNotBlank((CharSequence)param.getWriteOfFAmtCon())) {
            if ("GT0".equals(param.getWriteOfFAmtCon())) {
                predicates.add(this.qPayOrderDtlDO.unVerAmt.gt((Number)BigDecimal.ZERO));
            } else if ("LT0".equals(param.getWriteOfFAmtCon())) {
                predicates.add(this.qPayOrderDtlDO.unVerAmt.lt((Number)BigDecimal.ZERO));
            }
        } else {
            predicates.add(this.qPayOrderDtlDO.unVerAmt.ne((Object)BigDecimal.ZERO));
        }
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.qPayOrderDtlDO.masId).from((EntityPath)this.qPayOrderDtlDO)).where(ExpressionUtils.allOf(predicates))).fetch();
    }

    public List<PayOrderDtlDTO> queryById(List<Long> ids) {
        return ((JPAQuery)this.select(PayOrderDtlDTO.class).where((Predicate)this.qPayOrderDtlDO.id.in(ids))).fetch();
    }

    public List<PayOrderDtlDTO> queryBySourceIdList(List<Long> sourceIdList) {
        return ((JPAQuery)this.selectJoin(PayOrderDtlDTO.class).where((Predicate)this.qPayOrderDtlDO.sourceId.in(sourceIdList).and((Predicate)this.qPayOrderDtlDO.masId.eq(this.qPayOrderDO.id)).and((Predicate)this.qPayOrderDO.orderState.eq((Object)"DRAFT")))).fetch();
    }

    @SysCodeProc
    public List<PayOrderDtlDTO> queryByMasId(Long masId) {
        return ((JPAQuery)this.select(PayOrderDtlDTO.class).where((Predicate)this.qPayOrderDtlDO.masId.in((Object[])new Long[]{masId}))).fetch();
    }

    public void deleteByMasIds(List<Long> masIds) {
        this.jpaQueryFactory.delete((EntityPath)this.qPayOrderDtlDO).where(new Predicate[]{this.qPayOrderDtlDO.masId.in(masIds)}).execute();
    }

    public PagingVO<PayOrderDtlDTO> page(PayOrderDtlPageParam param) {
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        if (param.getMisId() != null) {
            predicates.add(this.qPayOrderDtlDO.masId.eq((Object)param.getMisId()));
        }
        if (CollectionUtils.isNotEmpty(param.getMasIds())) {
            predicates.add(this.qPayOrderDtlDO.masId.in(param.getMasIds()));
        }
        JPAQuery query = (JPAQuery)this.select(PayOrderDtlDTO.class).where(ExpressionUtils.allOf(predicates));
        param.setPaging(query);
        param.fillOrders(query, this.qPayOrderDtlDO);
        return PagingVO.builder().total(query.fetchCount()).records(query.fetch()).build();
    }

    private <T> JPAQuery<T> select(Class<T> cls) {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(cls, (Expression[])new Expression[]{this.qPayOrderDtlDO.id, this.qPayOrderDtlDO.masId, this.qPayOrderDtlDO.payType, this.qPayOrderDtlDO.payBank, this.qPayOrderDtlDO.payAccount, this.qPayOrderDtlDO.recBank, this.qPayOrderDtlDO.recAccount, this.qPayOrderDtlDO.sourceNo, this.qPayOrderDtlDO.sourceLine, this.qPayOrderDtlDO.sourceId, this.qPayOrderDtlDO.sourceLineId, this.qPayOrderDtlDO.realPayAmt, this.qPayOrderDtlDO.realPayCurAmt, this.qPayOrderDtlDO.totalAmt, this.qPayOrderDtlDO.totalCurAmt, this.qPayOrderDtlDO.expensesType, this.qPayOrderDtlDO.buId, this.qPayOrderDtlDO.buName, this.qPayOrderDtlDO.buCode, this.qPayOrderDtlDO.verAmt, this.qPayOrderDtlDO.unVerAmt, this.qPayOrderDtlDO.applyVerAmTing, this.qPayOrderDtlDO.remark})).from((EntityPath)this.qPayOrderDtlDO);
    }

    private <T> JPAQuery<T> selectJoin(Class<T> cls) {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(cls, (Expression[])new Expression[]{this.qPayOrderDtlDO.id, this.qPayOrderDtlDO.masId, this.qPayOrderDtlDO.payType, this.qPayOrderDtlDO.payBank, this.qPayOrderDtlDO.payAccount, this.qPayOrderDtlDO.recBank, this.qPayOrderDtlDO.recAccount, this.qPayOrderDtlDO.sourceNo, this.qPayOrderDtlDO.sourceLine, this.qPayOrderDtlDO.sourceId, this.qPayOrderDtlDO.sourceLineId, this.qPayOrderDtlDO.realPayAmt, this.qPayOrderDtlDO.realPayCurAmt, this.qPayOrderDtlDO.totalAmt, this.qPayOrderDtlDO.totalCurAmt, this.qPayOrderDtlDO.expensesType, this.qPayOrderDtlDO.buId, this.qPayOrderDtlDO.buName, this.qPayOrderDtlDO.buCode, this.qPayOrderDtlDO.verAmt, this.qPayOrderDtlDO.unVerAmt, this.qPayOrderDtlDO.applyVerAmTing, this.qPayOrderDtlDO.remark})).from(new EntityPath[]{this.qPayOrderDtlDO, this.qPayOrderDO});
    }

    public List<PayOrderDtlDTO> queryByMasId(Collection<Long> masIds) {
        return ((JPAQuery)this.select(PayOrderDtlDTO.class).where((Predicate)this.qPayOrderDtlDO.masId.in(masIds))).fetch();
    }

    public List<PayOrderDtlDO> findAllByIdsIn(List<Long> ids) {
        return ((JPAQuery)this.jpaQueryFactory.selectFrom((EntityPath)this.qPayOrderDtlDO).where((Predicate)this.qPayOrderDtlDO.id.in(ids))).fetch();
    }

    public PayOrderDtlRepoProc(JPAQueryFactory jpaQueryFactory) {
        this.jpaQueryFactory = jpaQueryFactory;
    }
}

