/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.service.payorder;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.elitescloud.boot.core.support.customfield.common.CustomFieldBaseModelVo;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.exception.BusinessException;
import com.elitesland.fin.application.convert.payorder.PayOrderConvert;
import com.elitesland.fin.application.convert.paytype.PayTypeConvert;
import com.elitesland.fin.application.convert.writeoff.FinApPayVerApplyApHeadConvert;
import com.elitesland.fin.application.facade.dto.writeoff.FinApPayVerApplySaveDTO;
import com.elitesland.fin.application.facade.dto.writeoff.PayOrderAmtUpdateDTO;
import com.elitesland.fin.application.facade.param.payorder.ApOrderToPaySaveParam;
import com.elitesland.fin.application.facade.param.payorder.FinPayOrderDetailQuery;
import com.elitesland.fin.application.facade.param.payorder.PayOrderDtlSaveParam;
import com.elitesland.fin.application.facade.param.payorder.PayOrderSaveParam;
import com.elitesland.fin.application.facade.vo.aporder.ApOrderVO;
import com.elitesland.fin.application.facade.vo.payorder.PayOrderDtlVO;
import com.elitesland.fin.application.facade.vo.payorder.PayOrderVO;
import com.elitesland.fin.application.facade.vo.paytype.PayTypeVO;
import com.elitesland.fin.application.facade.vo.writeoff.FinApPayVerApplyApVO;
import com.elitesland.fin.application.facade.vo.writeoff.FinApPayVerApplyPayVO;
import com.elitesland.fin.application.facade.vo.writeoff.FinApPayVerApplyVO;
import com.elitesland.fin.application.service.aporder.ApOrderService;
import com.elitesland.fin.application.service.payorder.PayOrderService;
import com.elitesland.fin.application.service.paytype.PayTypeService;
import com.elitesland.fin.application.service.workflow.WorkFlowDefKey;
import com.elitesland.fin.application.service.writeoff.FinApPayVerApplyService;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.domain.entity.apordertopay.ApOrderToPay;
import com.elitesland.fin.domain.entity.apverrec.ApVerRecDtl;
import com.elitesland.fin.domain.entity.payorder.PayOrder;
import com.elitesland.fin.domain.entity.payorder.PayOrderDO;
import com.elitesland.fin.domain.entity.payorder.PayOrderDtl;
import com.elitesland.fin.domain.entity.payorder.PayOrderDtlDO;
import com.elitesland.fin.domain.entity.recorder.RecOrderDO;
import com.elitesland.fin.domain.param.aptype.ApTypePageParam;
import com.elitesland.fin.domain.param.payorder.PayOrderPageParam;
import com.elitesland.fin.domain.service.aporder.ApOrderDomainService;
import com.elitesland.fin.domain.service.aporder.ApOrderDtlDomainService;
import com.elitesland.fin.domain.service.apordertopay.ApOrderToPayDomainService;
import com.elitesland.fin.domain.service.aptype.ApTypeDomainService;
import com.elitesland.fin.domain.service.aptype.ApTypeOuDomainService;
import com.elitesland.fin.domain.service.apverrec.ApVerRecDomainService;
import com.elitesland.fin.domain.service.payorder.PayOrderDomainService;
import com.elitesland.fin.domain.service.payorder.PayOrderDtlDomainService;
import com.elitesland.fin.domain.service.paytype.PayTypeDomainService;
import com.elitesland.fin.infr.dto.aporder.ApOrderDTO;
import com.elitesland.fin.infr.dto.apordertopay.ApOrderToPayDTO;
import com.elitesland.fin.infr.dto.aptype.ApTypeDTO;
import com.elitesland.fin.infr.dto.aptype.ApTypeOuDTO;
import com.elitesland.fin.infr.dto.payorder.PayOrderDTO;
import com.elitesland.fin.infr.dto.payorder.PayOrderDtlDTO;
import com.elitesland.fin.infr.dto.paytype.PayTypeDTO;
import com.elitesland.fin.infr.repo.aporder.ApOrderDtlRepo;
import com.elitesland.fin.infr.repo.payorder.PayOrderDtlRepoProc;
import com.elitesland.fin.infr.repo.recorder.RecOrderRepoProc;
import com.elitesland.fin.repo.writeoff.FinApPayVerApplyPayHeadRepoProc;
import com.elitesland.fin.repo.writeoff.FinApPayVerApplyPayRepoProc;
import com.elitesland.fin.repo.writeoff.FinApPayVerApplyRepoProc;
import com.elitesland.fin.repo.writeoff.PayOrderDetailRepoProc;
import com.elitesland.fin.rpc.pur.RmiPurRpcService;
import com.elitesland.fin.rpc.workflow.WorkflowRpcService;
import com.elitesland.fin.rpc.ystsupp.RmiOrgOuRpcServiceService;
import com.elitesland.pur.dto.supp.PurSuppBaseDTO;
import com.elitesland.support.provider.flexField.service.FlexFieldUtilService;
import com.elitesland.support.provider.org.dto.OrgOuComRpcDTO;
import com.elitesland.support.provider.org.param.OrgOuComRpcParam;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.WorkflowConstant;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.Assert;

@Service
public class PayOrderServiceImpl
implements PayOrderService {
    private static final Logger log = LoggerFactory.getLogger(PayOrderServiceImpl.class);
    private final RecOrderRepoProc recOrderRepoProc;
    private final RmiPurRpcService rmiPurRpcService;
    private final TransactionTemplate transactionTemplate;
    private final ApTypeOuDomainService apTypeOuDomainService;
    private final ApTypeDomainService apTypeDomainService;
    private final PayTypeService payTypeService;
    private final ApOrderDtlRepo apOrderDtlRepo;
    private final FinApPayVerApplyPayHeadRepoProc finApPayVerApplyPayHeadRepoProc;
    private final FinApPayVerApplyPayRepoProc finApPayVerApplyPayRepoProc;
    private final RmiOrgOuRpcServiceService rmiOrgOuRpcServiceService;
    private final ApOrderDtlDomainService apOrderDtlDomainService;
    @Lazy
    @Autowired
    private FinApPayVerApplyService finApPayVerApplyService;
    private final PayOrderDomainService payOrderDomainService;
    private final PayOrderDtlDomainService payOrderDtlDomainService;
    private final PayTypeDomainService payTypeDomainService;
    private final ApOrderToPayDomainService apOrderToPayDomainService;
    private final ApOrderDomainService apOrderDomainService;
    private final ApVerRecDomainService apVerRecDomainService;
    private final WorkflowRpcService workflowRpcService;
    private final PayOrderDtlRepoProc payOrderDtlRepoProc;
    private final PayOrderDetailRepoProc payOrderDetailRepoProc;
    private final FlexFieldUtilService flexFieldUtilService;
    @Autowired
    private ApOrderService apOrderService;
    @Autowired
    private FinApPayVerApplyRepoProc finApPayVerApplyRepoProc;

    @Override
    @SysCodeProc
    public PagingVO<PayOrderVO> page(PayOrderPageParam param) {
        PagingVO<PayOrderDTO> page = this.payOrderDomainService.page(param);
        PagingVO<PayOrderVO> payOrderVOPagingVO = PayOrderConvert.INSTANCE.convertPage(page);
        if (payOrderVOPagingVO.isEmpty()) {
            return payOrderVOPagingVO;
        }
        List<Long> masIds = payOrderVOPagingVO.getRecords().stream().map(PayOrderVO::getId).collect(Collectors.toList());
        List<PayOrderDtlDTO> payOrderDtlDTOS = this.payOrderDtlRepoProc.queryByMasId(masIds);
        Map payorderDtlDTOMap = payOrderDtlDTOS.stream().collect(Collectors.groupingBy(PayOrderDtlDTO::getMasId, Collectors.toList()));
        payOrderVOPagingVO.getRecords().stream().forEach(v -> {
            BigDecimal verAmt = BigDecimal.ZERO;
            BigDecimal verAmting = BigDecimal.ZERO;
            BigDecimal unVerAmt = BigDecimal.ZERO;
            List payOrderDtlDTOS1 = (List)payorderDtlDTOMap.get(v.getId());
            if (CollUtil.isNotEmpty((Collection)payOrderDtlDTOS1)) {
                for (PayOrderDtlDTO payOrderDtlDTO : payOrderDtlDTOS1) {
                    if (payOrderDtlDTO.getVerAmt() != null) {
                        verAmt = verAmt.add(payOrderDtlDTO.getVerAmt());
                    }
                    if (payOrderDtlDTO.getApplyVerAmTing() != null) {
                        verAmting = verAmting.add(payOrderDtlDTO.getApplyVerAmTing());
                    }
                    if (payOrderDtlDTO.getUnVerAmt() == null) continue;
                    unVerAmt = unVerAmt.add(payOrderDtlDTO.getUnVerAmt());
                }
            }
            v.setVerAmt(verAmt);
            v.setApplyVerAmTing(verAmting);
            v.setUnVerAmt(unVerAmt);
            if (unVerAmt.add(verAmting).compareTo(BigDecimal.ZERO) == 0) {
                v.setVerState(UdcEnum.FIN_VERIFY_STATUS_YES.getValueCode());
            } else if (unVerAmt.add(verAmting).compareTo(v.getTotalAmt()) == 0) {
                v.setVerState(UdcEnum.FIN_VERIFY_STATUS_AWAIT.getValueCode());
            } else {
                v.setVerState(UdcEnum.FIN_VERIFY_STATUS_PART.getValueCode());
            }
        });
        this.flexFieldUtilService.handleFlexFieldShowNameForVO("PAY_ORDER", payOrderVOPagingVO.getRecords());
        return payOrderVOPagingVO;
    }

    @Override
    @SysCodeProc
    public PagingVO<PayOrderVO> writeoffPage(PayOrderPageParam param) {
        PagingVO<PayOrderDTO> page = this.payOrderDomainService.writeoffPage(param);
        PagingVO<PayOrderVO> payOrderVOPagingVO = PayOrderConvert.INSTANCE.convertPage(page);
        if (payOrderVOPagingVO.isEmpty()) {
            return payOrderVOPagingVO;
        }
        List<Long> masIds = payOrderVOPagingVO.getRecords().stream().map(PayOrderVO::getId).collect(Collectors.toList());
        List<PayOrderDtlDTO> payOrderDtlDTOS = this.payOrderDtlRepoProc.queryByMasId(masIds);
        Map payorderDtlDTOMap = payOrderDtlDTOS.stream().collect(Collectors.groupingBy(PayOrderDtlDTO::getMasId, Collectors.toList()));
        payOrderVOPagingVO.getRecords().stream().forEach(v -> {
            BigDecimal verAmt = BigDecimal.ZERO;
            BigDecimal verAmting = BigDecimal.ZERO;
            BigDecimal unVerAmt = BigDecimal.ZERO;
            List payOrderDtlDTOS1 = (List)payorderDtlDTOMap.get(v.getId());
            if (CollUtil.isNotEmpty((Collection)payOrderDtlDTOS1)) {
                for (PayOrderDtlDTO payOrderDtlDTO : payOrderDtlDTOS1) {
                    verAmt = verAmt.add(payOrderDtlDTO.getVerAmt());
                    verAmting = verAmting.add(payOrderDtlDTO.getApplyVerAmTing());
                    unVerAmt = unVerAmt.add(payOrderDtlDTO.getUnVerAmt());
                }
            }
            v.setVerAmt(verAmt);
            v.setApplyVerAmTing(verAmting);
            v.setUnVerAmt(unVerAmt);
            if (unVerAmt.add(verAmting).compareTo(BigDecimal.ZERO) == 0) {
                v.setVerState(UdcEnum.FIN_VERIFY_STATUS_YES.getValueCode());
            } else if (unVerAmt.add(verAmting).compareTo(v.getTotalAmt()) == 0) {
                v.setVerState(UdcEnum.FIN_VERIFY_STATUS_AWAIT.getValueCode());
            } else {
                v.setVerState(UdcEnum.FIN_VERIFY_STATUS_PART.getValueCode());
            }
        });
        return payOrderVOPagingVO;
    }

    @Override
    @SysCodeProc
    public PayOrderVO queryById(Long id) {
        PayOrderDTO payOrderDTO = this.payOrderDomainService.queryById(id, false);
        PayOrderVO payOrderVO = PayOrderConvert.INSTANCE.dtoToVo(payOrderDTO);
        this.flexFieldUtilService.handleSingleFlexFieldShowNameForVO("PAY_ORDER", (CustomFieldBaseModelVo)payOrderVO);
        return payOrderVO;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<List<Long>> deleteByIds(List<Long> ids) {
        List<Long> deleteByIds = this.payOrderDomainService.deleteByIds(ids);
        this.apOrderToPayDomainService.deleteByPayIds(ids);
        return ApiResult.ok(deleteByIds);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> save(PayOrderSaveParam param) {
        PayOrder payOrder = PayOrderConvert.INSTANCE.convertParam(param);
        if (param.getId() != null) {
            this.deleteBeforePushDate(param);
        }
        Long id = this.payOrderDomainService.save(payOrder);
        this.checkPushedAmt(payOrder);
        return ApiResult.ok((Object)id);
    }

    private void checkPushedAmt(PayOrder payOrder) {
        String createMode = payOrder.getCreateMode();
        if (!"AP".equals(createMode)) {
            return;
        }
        List<PayOrderDtl> apOrderDTOS = payOrder.getDtlList();
        List<Long> apOrderIds = apOrderDTOS.stream().filter(e -> e.getSourceId() != null).map(PayOrderDtl::getSourceId).distinct().collect(Collectors.toList());
        List<PayOrderDtlDTO> payOrderDtlDTOS = this.payOrderDtlDomainService.queryBySourceIdList(apOrderIds);
        Map<Long, List<PayOrderDtlDTO>> groupedPayOrderDtlDTOS = payOrderDtlDTOS.stream().collect(Collectors.groupingBy(PayOrderDtlDTO::getSourceId));
        HashMap<Long, BigDecimal> BigDecimalAmtMap = new HashMap<Long, BigDecimal>();
        for (Map.Entry<Long, List<PayOrderDtlDTO>> entry : groupedPayOrderDtlDTOS.entrySet()) {
            BigDecimal reduce = entry.getValue().stream().map(PayOrderDtlDTO::getTotalAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimalAmtMap.put(entry.getKey(), reduce);
        }
        apOrderDTOS.forEach(order -> {
            BigDecimal payAmt;
            if (BigDecimalAmtMap.get(order.getId()) != null && (payAmt = order.getTotalAmt().subtract((BigDecimal)BigDecimalAmtMap.get(order.getId())).subtract(order.getVerAmt())).compareTo(BigDecimal.ZERO) <= 0) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5e94\u4ed8\u5355\u53f7:" + order.getSourceNo() + ",\u53ef\u63a8\u91d1\u989d\u4e0d\u8db3,\u8bf7\u91cd\u65b0\u9009\u62e9!");
            }
        });
    }

    private void deleteBeforePushDate(PayOrderSaveParam param) {
        if (param.getCreateMode().equals(UdcEnum.FIN_PAY_DOC_CLS_AP.getValueCode())) {
            this.checkApOrderMoney(param);
            this.apOrderToPayDomainService.deleteByPayId(param.getId());
            this.saveApOrderToPay(param);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> submit(PayOrderSaveParam param) {
        PayOrder payOrder = PayOrderConvert.INSTANCE.convertParam(param);
        if (param.getId() != null) {
            this.deleteBefore(param);
        }
        this.checkPushedAmt(payOrder);
        Long id = this.payOrderDomainService.submit(payOrder);
        this.transactionTemplate.setPropagationBehavior(3);
        this.transactionTemplate.execute(trans -> {
            try {
                this.processAfterSubmit(payOrder);
            }
            catch (Exception exception) {
                trans.setRollbackOnly();
            }
            return null;
        });
        if (payOrder.getProcInstId() == null || WorkflowConstant.CAN_START_PROC_STATUSES.contains(payOrder.getProcInstStatus())) {
            String procInstName = "\u4ed8\u6b3e\u5355\u5ba1\u6838-" + payOrder.getPayOrderNo();
            String procKey = WorkFlowDefKey.FIN_PAY_ORDER.name();
            ProcessInfo processInfo = this.workflowRpcService.startProcess(procKey, procInstName, id.toString(), new HashMap<String, Object>());
            this.payOrderDomainService.updateWorkInfo(processInfo, id);
        }
        return ApiResult.ok((Object)id);
    }

    private void processAfterSubmit(PayOrder payOrder) {
        log.info("\u51c6\u5907\u751f\u6210\u6838\u9500\u5355\uff0c\u53c2\u6570{}", (Object)JSONUtil.toJsonStr((Object)payOrder));
        List<PayOrderDtl> dtlList = payOrder.getDtlList();
        if (CollUtil.isEmpty(dtlList)) {
            throw new com.elitescloud.boot.exception.BusinessException("\u4ed8\u6b3e\u5355\u660e\u7ec6\u4e0d\u5b58\u5728");
        }
        List<Long> apOrderIds = dtlList.stream().filter(e -> e.getSourceId() != null).distinct().map(PayOrderDtl::getSourceId).collect(Collectors.toList());
        List<ApOrderVO> apOrderVOList = this.apOrderService.getBatch(apOrderIds);
        BigDecimal totalAmt = this.payOrderDtlRepoProc.queryByMasId(payOrder.getId()).stream().map(PayOrderDtlDTO::getTotalAmt).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        Map<Long, BigDecimal> payAmtMap = this.payOrderDtlRepoProc.queryByMasId(payOrder.getId()).stream().collect(Collectors.toMap(PayOrderDtlDTO::getSourceId, PayOrderDtlDTO::getRealPayAmt));
        apOrderVOList.forEach(apOrderVO -> {
            if (payAmtMap.containsKey(apOrderVO.getId())) {
                apOrderVO.setVerAmt((BigDecimal)payAmtMap.get(apOrderVO.getId()));
            }
        });
        payOrder.setVerAmt(totalAmt);
        FinApPayVerApplySaveDTO save = new FinApPayVerApplySaveDTO();
        save.setApHeadSaveList(FinApPayVerApplyApHeadConvert.INSTANCE.VO2DOBatchApOrder(apOrderVOList));
        save.setPayHeadSaveList(FinApPayVerApplyApHeadConvert.INSTANCE.VO2DOBatchPayOrder(List.of(payOrder)));
        save.setHeadFlag(true);
        log.info("\u751f\u6210\u5e94\u4ed8\u4ed8\u6b3e\u6838\u9500\u5355,\u53c2\u6570save:{}", (Object)JSONUtil.toJsonStr((Object)save));
        Long id = this.finApPayVerApplyService.writeOffCreate(save);
        this.finApPayVerApplyRepoProc.updateStatusById(id);
    }

    private void deleteBefore(PayOrderSaveParam param) {
        if (param.getCreateMode().equals(UdcEnum.FIN_PAY_DOC_CLS_AP.getValueCode())) {
            this.checkApOrderMoney(param);
            this.apOrderToPayDomainService.deleteByPayId(param.getId());
            this.saveApOrderToPay(param);
        }
    }

    @Override
    public ApiResult<PayOrderVO> defaultValue() {
        PayTypeDTO payTypeDTO = this.payTypeDomainService.defaultValue();
        PayOrderVO payOrderVO = PayTypeConvert.INSTANCE.typeToOrder(payTypeDTO);
        if (payOrderVO == null) {
            return ApiResult.ok((Object)new PayOrderVO());
        }
        return ApiResult.ok((Object)payOrderVO);
    }

    @Override
    @SysCodeProc
    public PayOrderVO queryDetailsById(Long id) {
        PayOrderDTO payOrderDTO = this.payOrderDomainService.queryById(id, true);
        PayOrderVO payOrderVO = PayOrderConvert.INSTANCE.dtoToVo(payOrderDTO);
        this.flexFieldUtilService.handleSingleFlexFieldShowNameForVO("PAY_ORDER", (CustomFieldBaseModelVo)payOrderVO);
        return payOrderVO;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<String> saveByApOrder(ApOrderToPaySaveParam param) {
        List<ApOrderDTO> apOrderDTOS = this.apOrderDomainService.queryByIds(param.getIds());
        ArrayList ouCode = new ArrayList();
        ArrayList supCode = new ArrayList();
        ArrayList curr = new ArrayList();
        ArrayList apType = new ArrayList();
        List ouCodeList = this.apOrderDomainService.queryByIds(param.getIds()).stream().map(e -> e.getOuCode()).distinct().collect(Collectors.toList());
        OrgOuComRpcParam param1 = new OrgOuComRpcParam();
        param1.setOuCodeList(ouCodeList);
        List<OrgOuComRpcDTO> ouDtoByParam = this.rmiOrgOuRpcServiceService.findOuDtoByParam(param1);
        for (OrgOuComRpcDTO orgOuRpcDTO : ouDtoByParam) {
            if (!"OUTER".equals(orgOuRpcDTO.getOuType2())) continue;
            throw new com.elitescloud.boot.exception.BusinessException("\u5e94\u4ed8\u5355\u7684\u516c\u53f8\u5173\u8054\u7684\u5ba2\u6237\u7c7b\u578b\u4e3a\u5916\u90e8\u5ba2\u6237,\u4e0d\u80fd\u4e0b\u63a8\u751f\u6210\u4ed8\u6b3e\u5355");
        }
        apOrderDTOS.forEach(dto -> {
            if (!dto.getOrderState().equals(UdcEnum.APPLY_STATUS_COMPLETE.getValueCode())) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u53ea\u80fd\u9009\u62e9\u5ba1\u6838\u901a\u8fc7\u7684\u5e94\u4ed8\u5355\u636e!");
            }
            if (dto.getTotalAmt().compareTo(BigDecimal.ZERO) == 0) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u53ea\u80fd\u9009\u62e9\u5e94\u4ed8\u5355\u91d1\u989d\u4e0d\u4e3a0\u7684\u5355\u636e!");
            }
            ouCode.add(dto.getOuCode());
            supCode.add(dto.getSuppCode());
            curr.add(dto.getCurrCode());
            apType.add(dto.getApTypeCode());
        });
        List ou = ouCode.stream().distinct().collect(Collectors.toList());
        if (ou.size() > 1) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u8bf7\u9009\u62e9\u540c\u4e00\u5bb6\u516c\u53f8\u7684\u6570\u636e!");
        }
        List sup = supCode.stream().distinct().collect(Collectors.toList());
        if (sup.size() > 1) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u8bf7\u9009\u62e9\u540c\u4e00\u5bb6\u4f9b\u5e94\u5546\u7684\u6570\u636e!");
        }
        List currCode = curr.stream().distinct().collect(Collectors.toList());
        if (currCode.size() > 1) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u8bf7\u9009\u62e9\u540c\u4e00\u5e01\u79cd\u7684\u6570\u636e!");
        }
        List apTypeCode = apType.stream().distinct().collect(Collectors.toList());
        if (apTypeCode.size() > 1) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u8bf7\u9009\u62e9\u540c\u4e00\u5e94\u4ed8\u5355\u7c7b\u578b\u7684\u6570\u636e!");
        }
        List<PayOrderDtlDTO> payOrderDtlDTOS = this.payOrderDtlDomainService.queryBySourceIdList(param.getIds());
        Map<Long, List<PayOrderDtlDTO>> groupedPayOrderDtlDTOS = payOrderDtlDTOS.stream().collect(Collectors.groupingBy(PayOrderDtlDTO::getSourceId));
        HashMap<Long, BigDecimal> BigDecimalAmtMap = new HashMap<Long, BigDecimal>();
        for (Map.Entry<Long, List<PayOrderDtlDTO>> entry : groupedPayOrderDtlDTOS.entrySet()) {
            BigDecimal reduce = entry.getValue().stream().map(PayOrderDtlDTO::getTotalAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimalAmtMap.put(entry.getKey(), reduce);
        }
        apOrderDTOS.forEach(order -> {
            if (BigDecimalAmtMap.get(order.getId()) != null) {
                BigDecimal payAmt = order.getTotalAmt().subtract((BigDecimal)BigDecimalAmtMap.get(order.getId())).subtract(order.getVerAmt());
                if (payAmt.compareTo(BigDecimal.ZERO) <= 0) {
                    throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5e94\u4ed8\u5355\u53f7:" + order.getApOrderNo() + ",\u53ef\u63a8\u91d1\u989d\u4e0d\u8db3,\u8bf7\u91cd\u65b0\u9009\u62e9!");
                }
                order.setTotalAmt(payAmt);
            }
        });
        PayOrder payOrder = new PayOrder();
        this.getPayOrder(payOrder, param, apOrderDTOS);
        List<PayOrderDtl> dtl = this.getDtl(apOrderDTOS, param);
        payOrder.setDtlList(dtl);
        payOrder.setPayTypeCode("AP");
        payOrder.setPayTypeName("\u6807\u51c6\u4ed8\u6b3e");
        payOrder.setPayTypeId(this.getApTypeIdByCode("AP"));
        Long id = this.payOrderDomainService.save(payOrder);
        return ApiResult.ok((Object)id.toString());
    }

    private Long getApTypeIdByCode(String code) {
        if (StrUtil.isBlank((CharSequence)code)) {
            return null;
        }
        List payTypeVOList = (List)this.payTypeService.findAll().computeData();
        Optional<PayTypeVO> first = payTypeVOList.stream().filter(e -> e.getPayTypeCode().equals(code)).findFirst();
        return first.map(PayTypeVO::getId).orElse(null);
    }

    private ApTypeDTO selectApType(String sourceDoc, String sourceDocType, String sourceDocStatus, Long ouId, String ouCode) {
        ApTypePageParam apTypeParam = new ApTypePageParam();
        apTypeParam.setApTypeCode("YFD05_SYS");
        List<ApTypeDTO> apTypeDTOList = this.apTypeDomainService.selectMatchByParam(apTypeParam);
        if (CollectionUtil.isEmpty(apTypeDTOList)) {
            log.error("\u672a\u5339\u914d\u5230\u5e94\u4ed8\u5355\u7c7b\u578b\u7684\u914d\u7f6e\u89c4\u5219, \u6765\u6e90\u5355\u636e: {},\u6765\u6e90\u5355\u636e\u7c7b\u578b: {},\u6765\u6e90\u5355\u636e\u72b6\u6001:{}", new Object[]{sourceDoc, sourceDocType, sourceDocStatus});
            throw new com.elitescloud.boot.exception.BusinessException("\u672a\u5339\u914d\u5230\u5e94\u4ed8\u5355\u7c7b\u578b\u7684\u914d\u7f6e\u89c4\u5219");
        }
        if (CollectionUtil.isNotEmpty(apTypeDTOList) && apTypeDTOList.size() > 1) {
            log.error("\u5339\u914d\u5230\u591a\u6761\u5e94\u4ed8\u5355\u7c7b\u578b\u7684\u914d\u7f6e\u89c4\u5219, \u6765\u6e90\u5355\u636e: {},\u6765\u6e90\u5355\u636e\u7c7b\u578b: {},\u6765\u6e90\u5355\u636e\u72b6\u6001:{}", new Object[]{sourceDoc, sourceDocType, sourceDocStatus});
            throw new com.elitescloud.boot.exception.BusinessException("\u5339\u914d\u5230\u591a\u6761\u5e94\u4ed8\u5355\u7c7b\u578b\u7684\u914d\u7f6e\u89c4\u5219");
        }
        Long apTypeId = apTypeDTOList.get(0).getId();
        List<ApTypeOuDTO> apTypeOuDTOList = this.apTypeOuDomainService.queryByApTypeId(apTypeId);
        if (CollectionUtil.isEmpty(apTypeOuDTOList)) {
            log.error("\u5e94\u4ed8\u5355\u7684\u5206\u914d\u516c\u53f8\u4e3a\u7a7a, \u5e94\u4ed8\u5355\u7f16\u7801: {}", (Object)apTypeDTOList.get(0).getApTypeCode());
            throw new com.elitescloud.boot.exception.BusinessException("\u5e94\u4ed8\u5355\u7684\u5206\u914d\u516c\u53f8\u4e3a\u7a7a");
        }
        List apTypeOuCodeList = apTypeOuDTOList.stream().map(ApTypeOuDTO::getOuCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List apTypeOuIdList = apTypeOuDTOList.stream().map(ApTypeOuDTO::getOuId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        if (!apTypeOuIdList.contains(ouId) && !apTypeOuCodeList.contains(ouCode)) {
            log.error("\u5e94\u4ed8\u5355\u672a\u5206\u914d\u8be5\u516c\u53f8, \u5e94\u4ed8\u5355\u7f16\u7801: {},\u516c\u53f8ID: {},\u516c\u53f8\u7f16\u7801: {}", new Object[]{apTypeDTOList.get(0).getApTypeCode(), ouId, ouCode});
            throw new com.elitescloud.boot.exception.BusinessException("\u5e94\u4ed8\u5355\u672a\u5206\u914d\u8be5\u516c\u53f8");
        }
        return apTypeDTOList.get(0);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void approved(Long id) {
        PayOrderDTO payOrderDTO = this.payOrderDomainService.queryById(id, false);
        if (payOrderDTO.getCreateMode().equals(UdcEnum.FIN_PAY_DOC_CLS_AP.getValueCode()) && !payOrderDTO.getApFlag().booleanValue()) {
            List<PayOrderDtlDTO> payOrderDtlDTOS = this.payOrderDtlDomainService.queryByMasId(CollUtil.newArrayList((Object[])new Long[]{payOrderDTO.getId()}));
            List<Long> apIds = payOrderDtlDTOS.stream().map(PayOrderDtlDTO::getSourceId).collect(Collectors.toList());
            List<ApOrderDTO> apOrderDTOS = this.apOrderDomainService.queryByIds(apIds);
            ApOrderDTO apOrderDTO = apOrderDTOS.get(0);
            Map<Long, ApOrderDTO> apOrderDTOMap = apOrderDTOS.stream().collect(Collectors.toMap(ApOrderDTO::getId, t -> t));
            ArrayList<ApVerRecDtl> apVerRecDtls = new ArrayList<ApVerRecDtl>();
            List payVerDtls = payOrderDtlDTOS.stream().map(t -> {
                ApVerRecDtl apVerRecDtl = new ApVerRecDtl();
                apVerRecDtl.setOuCode(apOrderDTO.getOuCode());
                apVerRecDtl.setOuName(apOrderDTO.getOuName());
                apVerRecDtl.setOuId(apOrderDTO.getOuId());
                apVerRecDtl.setSuppCode(apOrderDTO.getSuppCode());
                apVerRecDtl.setSuppName(apOrderDTO.getSuppName());
                apVerRecDtl.setSuppId(apOrderDTO.getSuppId());
                apVerRecDtl.setCurrCode(apOrderDTO.getCurrCode());
                apVerRecDtl.setCurrName(apOrderDTO.getCurrName());
                apVerRecDtl.setAmt(t.getRealPayAmt());
                apVerRecDtl.setOrderId(t.getMasId());
                apVerRecDtl.setOrderNo(payOrderDTO.getPayOrderNo());
                apVerRecDtl.setOrderType("PAY");
                apVerRecDtl.setOrderName("\u4ed8\u6b3e\u5355");
                apVerRecDtl.setVerDate(LocalDateTime.now());
                apVerRecDtl.setBuDate(payOrderDTO.getBuDate());
                apVerRecDtl.setVerifyType(UdcEnum.FIN_VERIFY_TYPE_AUTO.getValueCode());
                return apVerRecDtl;
            }).collect(Collectors.toList());
            apVerRecDtls.addAll(payVerDtls);
            List apVerDtls = payOrderDtlDTOS.stream().map(t -> {
                ApVerRecDtl apVerRecDtl = new ApVerRecDtl();
                apVerRecDtl.setOuCode(apOrderDTO.getOuCode());
                apVerRecDtl.setOuName(apOrderDTO.getOuName());
                apVerRecDtl.setOuId(apOrderDTO.getOuId());
                apVerRecDtl.setSuppCode(apOrderDTO.getSuppCode());
                apVerRecDtl.setSuppName(apOrderDTO.getSuppName());
                apVerRecDtl.setSuppId(apOrderDTO.getSuppId());
                apVerRecDtl.setCurrCode(apOrderDTO.getCurrCode());
                apVerRecDtl.setCurrName(apOrderDTO.getCurrName());
                apVerRecDtl.setAmt(t.getRealPayAmt());
                apVerRecDtl.setOrderId(t.getSourceId());
                apVerRecDtl.setOrderNo(((ApOrderDTO)apOrderDTOMap.get(t.getSourceId())).getApOrderNo());
                apVerRecDtl.setOrderType("AP");
                apVerRecDtl.setOrderName("\u5e94\u4ed8\u5355");
                apVerRecDtl.setVerDate(LocalDateTime.now());
                apVerRecDtl.setBuDate(apOrderDTO.getBuDate());
                apVerRecDtl.setVerifyType(UdcEnum.FIN_VERIFY_TYPE_AUTO.getValueCode());
                return apVerRecDtl;
            }).collect(Collectors.toList());
            apVerRecDtls.addAll(apVerDtls);
            this.apVerRecDomainService.save(apVerRecDtls);
            apVerRecDtls.stream().forEach(t -> {
                if (t.getOrderType().equals("AP")) {
                    this.apOrderDomainService.updateVerAmt(t.getOrderId(), t.getAmt());
                } else if (t.getOrderType().equals("PAY")) {
                    this.payOrderDomainService.updateVerAmt(t.getOrderId(), t.getAmt());
                }
            });
        }
    }

    private List<PayOrderDtl> getDtl(List<ApOrderDTO> apOrderDTOS, ApOrderToPaySaveParam param) {
        return apOrderDTOS.stream().map(dto -> {
            PayOrderDtl dtl = new PayOrderDtl();
            dtl.setSourceId(dto.getId());
            dtl.setSourceNo(dto.getApOrderNo());
            dtl.setPayAccount(param.getPayAccount());
            dtl.setPayBank(param.getPayBank());
            dtl.setPayType(param.getPayType());
            dtl.setRecBank(param.getRecBank());
            dtl.setRecAccount(param.getRecAccount());
            dtl.setTotalAmt(dto.getTotalAmt());
            return dtl;
        }).collect(Collectors.toList());
    }

    private void getPayOrder(PayOrder payOrder, ApOrderToPaySaveParam param, List<ApOrderDTO> apOrderDTOS) {
        payOrder.setOrderState(UdcEnum.APPLY_STATUS_DRAFT.getValueCode());
        payOrder.setCreateMode(UdcEnum.FIN_PAY_DOC_CLS_AP.getValueCode());
        payOrder.setRemark(param.getRemark());
        ApOrderDTO apOrderDTO = apOrderDTOS.get(0);
        payOrder.setInOutCust(apOrderDTO.getInOutCust());
        payOrder.setOuId(apOrderDTO.getOuId());
        payOrder.setOuCode(apOrderDTO.getOuCode());
        payOrder.setOuName(apOrderDTO.getOuName());
        payOrder.setSuppCode(apOrderDTO.getSuppCode());
        payOrder.setSuppName(apOrderDTO.getSuppName());
        payOrder.setSuppId(apOrderDTO.getSuppId());
        payOrder.setApTypeId(apOrderDTO.getApTypeId());
        payOrder.setApTypeName(apOrderDTO.getApTypeName());
        payOrder.setApTypeCode(apOrderDTO.getApTypeCode());
        payOrder.setApFlag(false);
        payOrder.setInitFlag(false);
        payOrder.setLocalCurrCode(apOrderDTO.getLocalCurrCode());
        payOrder.setLocalCurrName(apOrderDTO.getLocalCurrName());
        payOrder.setCurrCode(apOrderDTO.getCurrCode());
        payOrder.setCurrName(apOrderDTO.getCurrName());
        payOrder.setExchangeRate(apOrderDTO.getExchangeRate());
        payOrder.setBuDate(LocalDateTime.now());
        payOrder.setApDate(LocalDateTime.now());
    }

    private void saveApOrderToPay(PayOrderSaveParam param) {
        List<ApOrderToPay> collect = param.getPayOrderDtlSaveParams().stream().map(dtl -> {
            ApOrderToPay apOrderToPay = new ApOrderToPay();
            apOrderToPay.setPayOrderId(param.getId());
            apOrderToPay.setApOrderId(dtl.getSourceId());
            apOrderToPay.setPayAmt(dtl.getTotalAmt());
            apOrderToPay.setSourceType(UdcEnum.FIN_PAY_DOC_CLS_AP.getValueCode());
            return apOrderToPay;
        }).collect(Collectors.toList());
        this.apOrderToPayDomainService.save(collect);
    }

    private void checkApOrderMoney(PayOrderSaveParam param) {
        List<PayOrderDtlSaveParam> payOrderDtlSaveParams = param.getPayOrderDtlSaveParams();
        List<Long> apOrderId = payOrderDtlSaveParams.stream().map(PayOrderDtlSaveParam::getSourceId).collect(Collectors.toList());
        List<ApOrderDTO> orderDTOS = this.apOrderDomainService.queryByIds(apOrderId);
        Map<Long, ApOrderDTO> apMap = orderDTOS.stream().collect(Collectors.toMap(ApOrderDTO::getId, t -> t));
        Map<Long, List<ApOrderToPayDTO>> apOrderToPayMap = this.apOrderToPayDomainService.queryByApId(apOrderId).stream().collect(Collectors.groupingBy(ApOrderToPayDTO::getApOrderId));
        HashMap<Long, BigDecimal> BigDecimalMap = new HashMap<Long, BigDecimal>();
        for (Map.Entry<Long, List<ApOrderToPayDTO>> entry : apOrderToPayMap.entrySet()) {
            BigDecimal reduce = entry.getValue().stream().filter(order -> !order.getPayOrderId().equals(param.getId())).map(ApOrderToPayDTO::getPayAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimalMap.put(entry.getKey(), reduce);
        }
        payOrderDtlSaveParams.forEach(order -> {
            if (BigDecimalMap.get(order.getSourceId()) != null) {
                PayOrderServiceImpl.payAmtCount(apMap, BigDecimalMap, order);
            }
        });
    }

    private static void payAmtCount(Map<Long, ApOrderDTO> apMap, HashMap<Long, BigDecimal> BigDecimalMap, PayOrderDtlSaveParam order) {
        if (apMap.get(order.getSourceId()) != null) {
            BigDecimal apOrderAmount = apMap.get(order.getSourceId()).getTotalAmt();
            BigDecimal verAmount = apMap.get(order.getSourceId()).getVerAmt();
            BigDecimal payAmt = apOrderAmount.subtract(verAmount).subtract(BigDecimalMap.get(order.getSourceId()));
            if (order.getTotalAmt().compareTo(payAmt) > 0) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5e94\u4ed8\u5355\u53f7:" + order.getSourceNo() + ",\u53ef\u63a8\u91d1\u989d\u4e0d\u8db3,\u8bf7\u91cd\u65b0\u9009\u62e9!");
            }
        }
    }

    private Map<Long, String> getSuppType2(List<Long> suppIds) {
        List<PurSuppBaseDTO> bySuppIdBatch = this.rmiPurRpcService.findBySuppIdBatch(suppIds);
        if (CollUtil.isEmpty(bySuppIdBatch)) {
            throw new com.elitescloud.boot.exception.BusinessException("\u5355\u636e\u5bf9\u5e94\u4f9b\u5e94\u5546\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        Map<Long, String> idAndSupptype2Map = bySuppIdBatch.stream().collect(Collectors.toMap(PurSuppBaseDTO::getId, PurSuppBaseDTO::getSuppType2));
        log.info("\u4f9b\u5e94\u5546idAndSupptype2Map\u5b57\u5178:{}", (Object)JSONUtil.toJsonStr(idAndSupptype2Map));
        return idAndSupptype2Map;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Void> cancelApprove(List<Long> ids) {
        List<PayOrderDO> payOrderDOS = this.payOrderDomainService.queryByIds(ids);
        List<Long> suppIds = payOrderDOS.stream().map(PayOrderDO::getSuppId).distinct().collect(Collectors.toList());
        List<String> payOrderNos = payOrderDOS.stream().map(PayOrderDO::getPayOrderNo).distinct().collect(Collectors.toList());
        Map<Long, String> suppType2Map = this.getSuppType2(suppIds);
        Map<String, List<RecOrderDO>> sourceNoDataMap = this.recOrderRepoProc.findBySourceNoList(payOrderNos).stream().collect(Collectors.groupingBy(RecOrderDO::getSourceNo));
        log.info("\u53c2\u6570,payOrderDOS:{},suppType2Map:{},sourceNoDataMap:{}", new Object[]{JSONUtil.toJsonStr(payOrderDOS), JSONUtil.toJsonStr(suppType2Map), JSONUtil.toJsonStr(sourceNoDataMap)});
        ArrayList<String> errorPayOrderNoList = new ArrayList<String>();
        for (PayOrderDO payOrderDO : payOrderDOS) {
            Long suppId = payOrderDO.getSuppId();
            String suppType2 = suppType2Map.get(suppId);
            List<RecOrderDO> data = sourceNoDataMap.get(payOrderDO.getPayOrderNo());
            if (!"INNER".equals(suppType2) || !CollUtil.isNotEmpty(data)) continue;
            errorPayOrderNoList.add(payOrderDO.getPayOrderNo());
        }
        if (CollUtil.isNotEmpty(errorPayOrderNoList)) {
            String jsonStr = String.join((CharSequence)",", errorPayOrderNoList);
            throw new com.elitescloud.boot.exception.BusinessException("\u5355\u636e\u5df2\u7ecf\u751f\u6210\u5173\u8054\u7684\u6536\u6b3e\u5355\uff0c\u4e0d\u5141\u8bb8\u53d6\u6d88\u5ba1\u6279,\u5355\u53f7:" + jsonStr);
        }
        this.checkCancelDoc(payOrderDOS);
        payOrderDOS.forEach(payOrderDTO -> {
            payOrderDTO.setOrderState(UdcEnum.APPLY_STATUS_DRAFT.getValueCode());
            payOrderDTO.setProposedStatus(null);
            payOrderDTO.setProcInstId(null);
            payOrderDTO.setProcInstStatus(null);
        });
        this.payOrderDomainService.saveAll(payOrderDOS);
        for (Long id : ids) {
            List<Long> byPayId = this.finApPayVerApplyPayRepoProc.findByPayId(id);
            List<Long> idsHeader = this.finApPayVerApplyPayHeadRepoProc.findByPayId(byPayId);
            log.info("\u5f00\u59cb\u5220\u9664\u5e94\u4ed8\u4ed8\u6b3e\u6838\u9500\u5355ids:{}", (Object)JSONUtil.toJsonStr(idsHeader));
            for (Long apPayVerApplyId : idsHeader) {
                FinApPayVerApplyVO detail = this.finApPayVerApplyService.writeOffDetail(apPayVerApplyId);
                List<Long> apDIds = detail.getApList().stream().filter(e -> e.getApDId() != null).map(FinApPayVerApplyApVO::getApDId).distinct().collect(Collectors.toList());
                Map<Long, BigDecimal> apDIdVerAmtMap = detail.getApList().stream().filter(e -> e.getApDId() != null).collect(Collectors.toMap(FinApPayVerApplyApVO::getApDId, FinApPayVerApplyApVO::getVerAmt));
                List<Long> payDIds = detail.getPayList().stream().filter(e -> e.getPayDId() != null).map(FinApPayVerApplyPayVO::getPayDId).distinct().collect(Collectors.toList());
                Map<Long, BigDecimal> payDIdVerAmtMap = detail.getPayList().stream().filter(e -> e.getPayDId() != null).collect(Collectors.toMap(FinApPayVerApplyPayVO::getPayDId, FinApPayVerApplyPayVO::getVerAmt));
                this.payOrderDtlDomainService.resortVerAmt(apDIdVerAmtMap, apDIds);
                this.apOrderDtlDomainService.resortVerAmt(payDIdVerAmtMap, payDIds);
            }
            this.finApPayVerApplyRepoProc.deleteByIds(idsHeader);
        }
        return ApiResult.ok();
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class, Exception.class})
    public ApiResult<Long> redPunch(Long id) {
        PayOrderDTO payOrderDTO = this.payOrderDomainService.queryById(id, false);
        this.checkRedPunch(payOrderDTO);
        PayOrder payOrder = this.payOrderDomainService.redPunchCreate(id);
        PayOrderSaveParam param = PayOrderConvert.INSTANCE.convert(payOrder);
        return this.submit(param);
    }

    void checkCancelDoc(List<PayOrderDO> payOrderDOS) {
        if (CollectionUtils.isEmpty(payOrderDOS)) {
            throw new com.elitescloud.boot.exception.BusinessException("\u5355\u636e\u4e0d\u5b58\u5728");
        }
        List<PayOrderDtlDTO> payOrderDtlDTOS = this.payOrderDtlRepoProc.queryByMasId(payOrderDOS.stream().map(BaseModel::getId).collect(Collectors.toList()));
        Map<Long, List<PayOrderDtlDTO>> listMap = payOrderDtlDTOS.stream().collect(Collectors.groupingBy(PayOrderDtlDTO::getMasId));
        payOrderDOS.forEach(payOrderDO -> {
            BigDecimal verAmt;
            String perfix = "\u5355\u53f7\uff1a" + payOrderDO.getPayOrderNo() + "-";
            if (!UdcEnum.DOC_PROPOSED_STATUS_DRAFT.getValueCode().equals(payOrderDO.getProposedStatus()) && !UdcEnum.DOC_PROPOSED_STATUS_PROPOSED_FAIL.getValueCode().equals(payOrderDO.getProposedStatus())) {
                throw new com.elitescloud.boot.exception.BusinessException(perfix + "\u62df\u5b9a\u72b6\u6001\u5fc5\u987b\u4e3a\u8349\u7a3f\u6216\u62df\u5b9a\u5931\u8d25");
            }
            if (listMap.containsKey(payOrderDO.getId()) && CollUtil.isNotEmpty((Collection)((Collection)listMap.get(payOrderDO.getId()))) && CollUtil.isNotEmpty((Collection)((Collection)listMap.get(payOrderDO.getId()))) && BigDecimal.ZERO.compareTo(verAmt = ((List)listMap.get(payOrderDO.getId())).stream().map(PayOrderDtlDTO::getVerAmt).reduce(BigDecimal.ZERO, BigDecimal::add)) != 0) {
                throw new com.elitescloud.boot.exception.BusinessException(perfix + "\u5df2\u6838\u9500\u91d1\u989d\u5fc5\u987b\u4e3a0");
            }
            if (!UdcEnum.APPLY_STATUS_COMPLETE.getValueCode().equals(payOrderDO.getOrderState())) {
                throw new com.elitescloud.boot.exception.BusinessException(perfix + "\u5355\u636e\u72b6\u6001\u5fc5\u987b\u4e3a\u5ba1\u6838\u901a\u8fc7");
            }
            if (Boolean.TRUE.equals(payOrderDO.getRedState())) {
                throw new com.elitescloud.boot.exception.BusinessException(perfix + "\u5355\u636e\u5df2\u7ea2\u51b2");
            }
        });
    }

    void checkRedPunch(PayOrderDTO payOrderDTO) {
        if (Objects.isNull(payOrderDTO)) {
            throw new com.elitescloud.boot.exception.BusinessException("\u5355\u636e\u4e0d\u5b58\u5728");
        }
        if (Boolean.TRUE.equals(payOrderDTO.getRedState())) {
            throw new com.elitescloud.boot.exception.BusinessException("\u5355\u636e\u5df2\u7ea2\u51b2");
        }
        if (Objects.nonNull(payOrderDTO.getRedSourceNo())) {
            throw new com.elitescloud.boot.exception.BusinessException("\u6765\u6e90\u5355\u636e\u4e0d\u53ef\u4e3a\u7ea2\u51b2\u5355\u636e");
        }
        if (BigDecimal.ZERO.compareTo(payOrderDTO.getVerAmt()) != 0) {
            throw new com.elitescloud.boot.exception.BusinessException("\u5df2\u6838\u9500\u91d1\u989d\u5fc5\u987b\u4e3a0");
        }
        if (!UdcEnum.APPLY_STATUS_COMPLETE.getValueCode().equals(payOrderDTO.getOrderState())) {
            throw new com.elitescloud.boot.exception.BusinessException("\u5355\u636e\u72b6\u6001\u5fc5\u987b\u4e3a\u5ba1\u6838\u901a\u8fc7");
        }
        if (!payOrderDTO.getCreateMode().equals(UdcEnum.FIN_PAY_DOC_CLS_MANU.getValueCode())) {
            throw new com.elitescloud.boot.exception.BusinessException("\u53ea\u5141\u8bb8\u7ea2\u51b2\u624b\u5de5\u751f\u6210\u7684\u6536\u6b3e\u5355");
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateMiddleVerAmt(Long payDId, BigDecimal amt) {
        PayOrderDtlDO detail = this.findDetail(payDId);
        this.doUpdateVerAmt(this.getUpdateMiddleVerAmtBuilder(amt, detail).build());
    }

    private PayOrderDtlDO findDetail(Long recDId) {
        PayOrderDtlDO detail = this.payOrderDetailRepoProc.getPayOrderDetailAmt(recDId);
        Assert.notNull((Object)detail, (String)("\u672a\u67e5\u8be2\u5230\u6536\u6b3e\u5355\u660e\u7ec6\uff0c\u660e\u7ec6ID:" + recDId));
        return detail;
    }

    private void doUpdateVerAmt(PayOrderAmtUpdateDTO update) {
        if (this.payOrderDetailRepoProc.updateExtVerAmt(update) == 0L) {
            throw new com.elitescloud.boot.exception.BusinessException("\u66f4\u65b0\u6838\u9500\u91d1\u989d\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
    }

    @NotNull
    private PayOrderAmtUpdateDTO.PayOrderAmtUpdateDTOBuilder getUpdateMiddleVerAmtBuilder(BigDecimal amt, PayOrderDtlDO detail) {
        BigDecimal unVerAmt = detail.getUnVerAmt().subtract(amt);
        BigDecimal verAmting = detail.getApplyVerAmTing().add(amt);
        if (detail.getTotalAmt().compareTo(unVerAmt.add(verAmting).add(detail.getVerAmt())) != 0) {
            throw new com.elitescloud.boot.exception.BusinessException("\u8bf7\u6838\u5bf9\u91d1\u989d\u6570\u636e");
        }
        return PayOrderAmtUpdateDTO.builder().payDId(detail.getId()).unVerAmt(unVerAmt).verAmting(verAmting).verAmt(detail.getVerAmt()).version(detail.getAuditDataVersion());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateVerAmt(Long recDId, BigDecimal amt, String verType) {
        PayOrderDtlDO detail = this.findDetail(recDId);
        this.doUpdateVerAmt(this.getUpdateVerAmtBuilder(amt, detail, verType).build());
    }

    @NotNull
    private PayOrderAmtUpdateDTO.PayOrderAmtUpdateDTOBuilder getUpdateVerAmtBuilder(BigDecimal amt, PayOrderDtlDO detail, String verType) {
        String infoStr = JSONUtil.toJsonStr((Object)detail);
        log.info("\u8ba1\u7b97\u6536\u6b3e\u5355\u6838\u9500\u91d1\u989d,{}-{}", (Object)amt, (Object)infoStr);
        if ("2".equals(verType)) {
            BigDecimal verAmt = detail.getVerAmt().subtract(amt);
            BigDecimal unVerAmt = detail.getUnVerAmt().add(amt);
            log.info("\u53d6\u6d88\u6838\u9500,{}-{}-{}", new Object[]{infoStr, verAmt, unVerAmt});
            if (detail.getTotalAmt().compareTo(unVerAmt.add(detail.getApplyVerAmTing()).add(verAmt)) != 0) {
                throw new com.elitescloud.boot.exception.BusinessException("\u8bf7\u6838\u5bf9\u91d1\u989d\u6570\u636e");
            }
            return PayOrderAmtUpdateDTO.builder().payDId(detail.getId()).unVerAmt(unVerAmt).verAmting(detail.getApplyVerAmTing()).verAmt(verAmt).version(detail.getAuditDataVersion());
        }
        BigDecimal verAmting = detail.getApplyVerAmTing().subtract(amt);
        BigDecimal verAmt = detail.getVerAmt().add(amt);
        log.info("\u6838\u9500\u901a\u8fc7,{}-{}-{}", new Object[]{infoStr, verAmting, verAmt});
        if (detail.getTotalAmt().compareTo(detail.getUnVerAmt().add(verAmting).add(verAmt)) != 0) {
            throw new com.elitescloud.boot.exception.BusinessException("\u8bf7\u6838\u5bf9\u91d1\u989d\u6570\u636e");
        }
        return PayOrderAmtUpdateDTO.builder().payDId(detail.getId()).unVerAmt(detail.getUnVerAmt()).verAmting(verAmting).verAmt(verAmt).version(detail.getAuditDataVersion());
    }

    @Override
    public List<PayOrderDtlVO> listPayOrderDetail(FinPayOrderDetailQuery query) {
        return this.payOrderDetailRepoProc.listRecOrderDetail(query);
    }

    public PayOrderServiceImpl(RecOrderRepoProc recOrderRepoProc, RmiPurRpcService rmiPurRpcService, TransactionTemplate transactionTemplate, ApTypeOuDomainService apTypeOuDomainService, ApTypeDomainService apTypeDomainService, PayTypeService payTypeService, ApOrderDtlRepo apOrderDtlRepo, FinApPayVerApplyPayHeadRepoProc finApPayVerApplyPayHeadRepoProc, FinApPayVerApplyPayRepoProc finApPayVerApplyPayRepoProc, RmiOrgOuRpcServiceService rmiOrgOuRpcServiceService, ApOrderDtlDomainService apOrderDtlDomainService, PayOrderDomainService payOrderDomainService, PayOrderDtlDomainService payOrderDtlDomainService, PayTypeDomainService payTypeDomainService, ApOrderToPayDomainService apOrderToPayDomainService, ApOrderDomainService apOrderDomainService, ApVerRecDomainService apVerRecDomainService, WorkflowRpcService workflowRpcService, PayOrderDtlRepoProc payOrderDtlRepoProc, PayOrderDetailRepoProc payOrderDetailRepoProc, FlexFieldUtilService flexFieldUtilService) {
        this.recOrderRepoProc = recOrderRepoProc;
        this.rmiPurRpcService = rmiPurRpcService;
        this.transactionTemplate = transactionTemplate;
        this.apTypeOuDomainService = apTypeOuDomainService;
        this.apTypeDomainService = apTypeDomainService;
        this.payTypeService = payTypeService;
        this.apOrderDtlRepo = apOrderDtlRepo;
        this.finApPayVerApplyPayHeadRepoProc = finApPayVerApplyPayHeadRepoProc;
        this.finApPayVerApplyPayRepoProc = finApPayVerApplyPayRepoProc;
        this.rmiOrgOuRpcServiceService = rmiOrgOuRpcServiceService;
        this.apOrderDtlDomainService = apOrderDtlDomainService;
        this.payOrderDomainService = payOrderDomainService;
        this.payOrderDtlDomainService = payOrderDtlDomainService;
        this.payTypeDomainService = payTypeDomainService;
        this.apOrderToPayDomainService = apOrderToPayDomainService;
        this.apOrderDomainService = apOrderDomainService;
        this.apVerRecDomainService = apVerRecDomainService;
        this.workflowRpcService = workflowRpcService;
        this.payOrderDtlRepoProc = payOrderDtlRepoProc;
        this.payOrderDetailRepoProc = payOrderDetailRepoProc;
        this.flexFieldUtilService = flexFieldUtilService;
    }
}

