/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.infr.repo.payorder;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.boot.core.support.customfield.service.impl.CustomFieldJpaServiceUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.fin.application.service.excel.entity.PayOrderExportEntity;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.domain.entity.payorder.PayOrderDO;
import com.elitesland.fin.domain.entity.payorder.QPayOrderDO;
import com.elitesland.fin.domain.param.payorder.PayOrderPageParam;
import com.elitesland.fin.domain.param.payorder.PayOrderParam;
import com.elitesland.fin.infr.dto.common.ApVerDTO;
import com.elitesland.fin.infr.dto.payorder.PayOrderDTO;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class PayOrderRepoProc {
    private final JPAQueryFactory jpaQueryFactory;
    private final QPayOrderDO qPayOrderDO = QPayOrderDO.payOrderDO;

    public List<PayOrderDO> queryBySourceNo(String sourceNo) {
        return ((JPAQuery)this.jpaQueryFactory.selectFrom((EntityPath)this.qPayOrderDO).where((Predicate)this.qPayOrderDO.sourceNo.eq((Object)sourceNo))).fetch();
    }

    public List<PayOrderDO> queryBySourceNoList(List<String> sourceNoList) {
        return ((JPAQuery)this.jpaQueryFactory.selectFrom((EntityPath)this.qPayOrderDO).where((Predicate)this.qPayOrderDO.sourceNo.in(sourceNoList))).fetch();
    }

    public PayOrderDTO queryById(Long id) {
        return (PayOrderDTO)((JPAQuery)((JPAQuery)this.select(PayOrderDTO.class).where((Predicate)this.qPayOrderDO.id.eq((Object)id))).where((Predicate)this.qPayOrderDO.deleteFlag.eq((Object)0))).fetchOne();
    }

    public void deleteByIds(List<Long> ids) {
        this.jpaQueryFactory.delete((EntityPath)this.qPayOrderDO).where(new Predicate[]{this.qPayOrderDO.id.in(ids)}).execute();
    }

    public List<PayOrderDTO> queryByPayTypeId(List<Long> ids) {
        return ((JPAQuery)this.select(PayOrderDTO.class).where((Predicate)this.qPayOrderDO.payTypeId.in(ids))).fetch();
    }

    public Long audit(List<Long> ids, String auditRejection, SysUserDTO user) {
        return this.jpaQueryFactory.update((EntityPath)this.qPayOrderDO).set(this.qPayOrderDO.auditDate, (Object)LocalDateTime.now()).set((Path)this.qPayOrderDO.auditRejection, (Object)auditRejection).set((Path)this.qPayOrderDO.auditUser, (Object)user.getUsername()).set(this.qPayOrderDO.auditUserId, (Object)user.getId()).where(new Predicate[]{this.qPayOrderDO.id.in(ids)}).execute();
    }

    public List<PayOrderDTO> queryByParam(PayOrderParam payOrderParam) {
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        if (!StringUtils.isEmpty((CharSequence)payOrderParam.getCurrCode())) {
            predicates.add(this.qPayOrderDO.currCode.eq((Object)payOrderParam.getCurrCode()));
        }
        if (payOrderParam.getSuppId() != null) {
            predicates.add(this.qPayOrderDO.suppId.eq((Object)payOrderParam.getSuppId()));
        }
        if (payOrderParam.getOuId() != null) {
            predicates.add(this.qPayOrderDO.ouId.eq((Object)payOrderParam.getOuId()));
        }
        if (payOrderParam.getBuDateStart() != null && payOrderParam.getBuDateEnd() != null) {
            predicates.add(this.qPayOrderDO.buDate.between((Comparable)payOrderParam.getBuDateStart(), (Comparable)payOrderParam.getBuDateEnd()));
        }
        predicates.add(this.qPayOrderDO.deleteFlag.eq((Object)0));
        predicates.add(this.qPayOrderDO.orderState.eq((Object)UdcEnum.APPLY_STATUS_COMPLETE.getValueCode()));
        return ((JPAQuery)this.select(PayOrderDTO.class).where(ExpressionUtils.allOf(predicates))).fetch();
    }

    public List<PayOrderDTO> queryByIds(List<Long> ids) {
        return ((JPAQuery)((JPAQuery)this.select(PayOrderDTO.class).where((Predicate)this.qPayOrderDO.id.in(ids))).where((Predicate)this.qPayOrderDO.deleteFlag.eq((Object)0))).fetch();
    }

    public PagingVO<PayOrderDTO> page(PayOrderPageParam param, List<Long> ids) {
        List<Predicate> predicates = this.pageWhere(param, ids);
        JPAQuery query = (JPAQuery)this.select(PayOrderDTO.class).where(ExpressionUtils.allOf(predicates));
        param.setPaging(query);
        param.fillOrders(query, this.qPayOrderDO);
        return PagingVO.builder().total(query.fetchCount()).records(query.fetch()).build();
    }

    private List<Predicate> pageWhere(PayOrderPageParam param, List<Long> ids) {
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        if (CollUtil.isNotEmpty(param.getInOutCustList())) {
            predicates.add((Predicate)this.qPayOrderDO.inOutCust.in(param.getInOutCustList()));
        }
        if (param.getApFlag() != null) {
            predicates.add((Predicate)this.qPayOrderDO.apFlag.eq(param.getApFlag()));
        }
        if (!StringUtils.isEmpty((CharSequence)param.getCreateMode())) {
            predicates.add((Predicate)this.qPayOrderDO.createMode.eq((Object)param.getCreateMode()));
        }
        if (param.getInitFlag() != null) {
            predicates.add((Predicate)this.qPayOrderDO.initFlag.eq(param.getInitFlag()));
        }
        if (param.getPayTypeId() != null) {
            predicates.add((Predicate)this.qPayOrderDO.payTypeId.eq((Object)param.getPayTypeId()));
        }
        if (!StringUtils.isEmpty((CharSequence)param.getVerState())) {
            predicates.add((Predicate)this.qPayOrderDO.verState.eq((Object)param.getVerState()));
        }
        if (Objects.nonNull(param.getRedState())) {
            predicates.add((Predicate)this.qPayOrderDO.redState.eq(param.getRedState()));
        }
        if (Objects.nonNull(param.getProposedStatus())) {
            predicates.add((Predicate)this.qPayOrderDO.proposedStatus.eq((Object)param.getProposedStatus()));
        }
        if (!StringUtils.isEmpty((CharSequence)param.getRedSourceNo())) {
            predicates.add((Predicate)this.qPayOrderDO.redSourceNo.like("%" + param.getRedSourceNo() + "%"));
        }
        if (!StringUtils.isEmpty((CharSequence)param.getOrderState())) {
            predicates.add((Predicate)this.qPayOrderDO.orderState.eq((Object)param.getOrderState()));
        }
        if (!StringUtils.isEmpty((CharSequence)param.getCurrCode())) {
            predicates.add((Predicate)this.qPayOrderDO.currCode.eq((Object)param.getCurrCode()));
        }
        if (!StringUtils.isEmpty((CharSequence)param.getSourceNo())) {
            predicates.add((Predicate)this.qPayOrderDO.sourceNo.like("%" + param.getSourceNo() + "%"));
        }
        if (!StringUtils.isEmpty((CharSequence)param.getPayOrderNo())) {
            predicates.add((Predicate)this.qPayOrderDO.payOrderNo.like("%" + param.getPayOrderNo() + "%"));
        }
        if (param.getSuppId() != null) {
            predicates.add((Predicate)this.qPayOrderDO.suppId.eq((Object)param.getSuppId()));
        }
        if (!StringUtils.isEmpty((CharSequence)param.getOperator())) {
            predicates.add((Predicate)this.qPayOrderDO.operator.like("%" + param.getOperator() + "%"));
        }
        if (param.getOuId() != null) {
            predicates.add((Predicate)this.qPayOrderDO.ouId.eq((Object)param.getOuId()));
        }
        if (null != param.getBuDateStart() && null != param.getBuDateEnd()) {
            predicates.add((Predicate)this.qPayOrderDO.buDate.between((Comparable)param.getBuDateStart(), (Comparable)param.getBuDateEnd()));
        }
        if (!CollUtil.isEmpty(ids)) {
            predicates.add((Predicate)this.qPayOrderDO.id.in(ids));
        }
        if (param.getTotalAmtFrom() != null) {
            predicates.add((Predicate)this.qPayOrderDO.totalAmt.goe((Number)param.getTotalAmtFrom()));
        }
        if (param.getTotalAmtTo() != null) {
            predicates.add((Predicate)this.qPayOrderDO.totalAmt.loe((Number)param.getTotalAmtTo()));
        }
        if (param.getOperUserId() != null) {
            predicates.add((Predicate)this.qPayOrderDO.operUserId.eq((Object)param.getOperUserId()));
        }
        if (null != param.getApDateStart() && null != param.getApDateEnd()) {
            predicates.add((Predicate)this.qPayOrderDO.apDate.between((Comparable)param.getApDateStart(), (Comparable)param.getApDateEnd()));
        }
        predicates.add((Predicate)this.qPayOrderDO.deleteFlag.eq((Object)0));
        Predicate customFieldPredicate = CustomFieldJpaServiceUtil.getPredicate((List)param.getConditions(), PayOrderDO.class);
        if (customFieldPredicate != null) {
            predicates.add(customFieldPredicate);
        }
        return predicates;
    }

    private <T> JPAQuery<T> select(Class<T> cls) {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(cls, (Expression[])new Expression[]{this.qPayOrderDO.id, this.qPayOrderDO.sourceNo, this.qPayOrderDO.suppId, this.qPayOrderDO.suppCode, this.qPayOrderDO.suppName, this.qPayOrderDO.ouCode, this.qPayOrderDO.ouId, this.qPayOrderDO.ouName, this.qPayOrderDO.apTypeId, this.qPayOrderDO.apTypeCode, this.qPayOrderDO.apTypeName, this.qPayOrderDO.payTypeId, this.qPayOrderDO.payTypeCode, this.qPayOrderDO.payTypeName, this.qPayOrderDO.payOrderNo, this.qPayOrderDO.currCode, this.qPayOrderDO.currName, this.qPayOrderDO.operator, this.qPayOrderDO.operUserId, this.qPayOrderDO.buType, this.qPayOrderDO.buDate, this.qPayOrderDO.totalAmt, this.qPayOrderDO.totalCurAmt, this.qPayOrderDO.auditUserId, this.qPayOrderDO.auditDate, this.qPayOrderDO.auditUser, this.qPayOrderDO.orderState, this.qPayOrderDO.exchangeRate, this.qPayOrderDO.initFlag, this.qPayOrderDO.realPayAmt, this.qPayOrderDO.realPayCurAmt, this.qPayOrderDO.apDate, this.qPayOrderDO.apFlag, this.qPayOrderDO.createTime, this.qPayOrderDO.creator, this.qPayOrderDO.modifyTime, this.qPayOrderDO.updater, this.qPayOrderDO.remark, this.qPayOrderDO.auditRejection, this.qPayOrderDO.createMode, this.qPayOrderDO.localCurrCode, this.qPayOrderDO.localCurrName, this.qPayOrderDO.verState, this.qPayOrderDO.verAmt, this.qPayOrderDO.auditDataVersion, this.qPayOrderDO.procInstId, this.qPayOrderDO.procInstStatus, this.qPayOrderDO.approvedTime, this.qPayOrderDO.submitTime, this.qPayOrderDO.addrNo, this.qPayOrderDO.suppAddrNo, this.qPayOrderDO.redState, this.qPayOrderDO.redSourceId, this.qPayOrderDO.redSourceNo, this.qPayOrderDO.proposedStatus, this.qPayOrderDO.inOutCust, this.qPayOrderDO.extensionInfo})).from((EntityPath)this.qPayOrderDO);
    }

    public ApVerDTO queryVerAmtById(Long id) {
        return (ApVerDTO)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(ApVerDTO.class, (Expression[])new Expression[]{this.qPayOrderDO.id, this.qPayOrderDO.totalAmt, this.qPayOrderDO.verAmt, this.qPayOrderDO.auditDataVersion})).from((EntityPath)this.qPayOrderDO)).where((Predicate)this.qPayOrderDO.id.eq((Object)id))).fetchOne();
    }

    public long updateVerAmt(ApVerDTO apVerDTO) {
        return this.jpaQueryFactory.update((EntityPath)this.qPayOrderDO).set((Path)this.qPayOrderDO.verState, (Object)apVerDTO.getVerState()).set(this.qPayOrderDO.verAmt, (Object)apVerDTO.getVerAmt()).set(this.qPayOrderDO.auditDataVersion, (Object)(apVerDTO.getAuditDataVersion() + 1)).where(new Predicate[]{this.qPayOrderDO.id.eq((Object)apVerDTO.getId()).and((Predicate)this.qPayOrderDO.totalAmt.goe((Number)apVerDTO.getVerAmt())).and((Predicate)this.qPayOrderDO.auditDataVersion.eq((Object)apVerDTO.getAuditDataVersion()))}).execute();
    }

    public void updateWorkInfo(ProcessInfo processInfo, Long id) {
        JPAUpdateClause jpaUpdateClause = this.jpaQueryFactory.update((EntityPath)this.qPayOrderDO).set(this.qPayOrderDO.procInstStatus, (Object)ProcInstStatus.APPROVING).set((Path)this.qPayOrderDO.procInstId, (Object)processInfo.getProcInstId()).set(this.qPayOrderDO.submitTime, (Object)LocalDateTime.now()).where(new Predicate[]{this.qPayOrderDO.id.eq((Object)id)});
        if (!Objects.equals(processInfo.getProcInstStatus(), ProcInstStatus.APPROVED)) {
            jpaUpdateClause.set(this.qPayOrderDO.procInstStatus, (Object)ProcInstStatus.APPROVING);
        }
        jpaUpdateClause.execute();
    }

    public void setNullRedFlag(Long id) {
        JPAUpdateClause jpaUpdateClause = this.jpaQueryFactory.update((EntityPath)this.qPayOrderDO).setNull((Path)this.qPayOrderDO.redState).where(new Predicate[]{this.qPayOrderDO.id.eq((Object)id)});
        jpaUpdateClause.execute();
    }

    public void setRedFlag(Long id, Boolean flag) {
        JPAUpdateClause jpaUpdateClause = this.jpaQueryFactory.update((EntityPath)this.qPayOrderDO).set((Path)this.qPayOrderDO.redState, (Object)flag).where(new Predicate[]{this.qPayOrderDO.id.eq((Object)id)});
        jpaUpdateClause.execute();
    }

    public PagingVO<PayOrderExportEntity> defaultExport(PayOrderPageParam param) {
        List<Predicate> predicates = this.pageWhere(param, null);
        Predicate predicate = ExpressionUtils.allOf(predicates);
        JPAQuery query = (JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(PayOrderExportEntity.class, (Expression[])new Expression[]{this.qPayOrderDO.sourceNo, this.qPayOrderDO.suppCode, this.qPayOrderDO.suppName, this.qPayOrderDO.ouCode, this.qPayOrderDO.ouName, this.qPayOrderDO.apTypeCode, this.qPayOrderDO.apTypeName, this.qPayOrderDO.payTypeCode, this.qPayOrderDO.payTypeName, this.qPayOrderDO.payOrderNo, this.qPayOrderDO.currCode, this.qPayOrderDO.currName, this.qPayOrderDO.operator, this.qPayOrderDO.buType, this.qPayOrderDO.buDate, this.qPayOrderDO.totalAmt, this.qPayOrderDO.totalCurAmt, this.qPayOrderDO.auditUserId, this.qPayOrderDO.auditDate, this.qPayOrderDO.auditUser, this.qPayOrderDO.orderState, this.qPayOrderDO.exchangeRate, this.qPayOrderDO.initFlag, this.qPayOrderDO.realPayAmt, this.qPayOrderDO.realPayCurAmt, this.qPayOrderDO.apDate, this.qPayOrderDO.apFlag, this.qPayOrderDO.createTime, this.qPayOrderDO.creator, this.qPayOrderDO.modifyTime, this.qPayOrderDO.updater, this.qPayOrderDO.remark, this.qPayOrderDO.auditRejection, this.qPayOrderDO.createMode, this.qPayOrderDO.localCurrCode, this.qPayOrderDO.localCurrName, this.qPayOrderDO.verState, this.qPayOrderDO.verAmt, this.qPayOrderDO.totalAmt.subtract(this.qPayOrderDO.verAmt).as("unVerAmt"), this.qPayOrderDO.approvedTime, this.qPayOrderDO.submitTime, this.qPayOrderDO.addrNo, this.qPayOrderDO.suppAddrNo, this.qPayOrderDO.redState, this.qPayOrderDO.redSourceNo, this.qPayOrderDO.proposedStatus})).from((EntityPath)this.qPayOrderDO)).where(predicate);
        param.setPaging(query);
        param.fillOrders(query, this.qPayOrderDO);
        return new PagingVO(query.fetchCount(), query.fetch());
    }

    public PayOrderRepoProc(JPAQueryFactory jpaQueryFactory) {
        this.jpaQueryFactory = jpaQueryFactory;
    }
}

