/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.rpc.ystsupp;

import cn.hutool.core.collection.CollectionUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.fin.rpc.ystsupp.RmiOrgStoreRpcServiceService;
import com.elitesland.support.provider.org.dto.OrgStoreBaseRpcDTO;
import com.elitesland.support.provider.org.param.OrgStoreBaseRpcParam;
import com.elitesland.support.provider.org.service.OrgStoreRpcService;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class RmiOrgStoreRpcServiceServiceImpl
implements RmiOrgStoreRpcServiceService {
    private static final Logger log = LoggerFactory.getLogger(RmiOrgStoreRpcServiceServiceImpl.class);
    private final OrgStoreRpcService orgStoreRpcService;

    @Override
    public List<OrgStoreBaseRpcDTO> findBaseStoreByCodes(List<String> storeCodeList) {
        block5: {
            if (CollectionUtil.isEmpty(storeCodeList)) {
                return Collections.EMPTY_LIST;
            }
            try {
                OrgStoreBaseRpcParam orgStoreBaseRpcParam = new OrgStoreBaseRpcParam();
                orgStoreBaseRpcParam.setStoreCodeList(storeCodeList);
                ApiResult apiResult = this.orgStoreRpcService.findOrgStoreBaseByParam(orgStoreBaseRpcParam);
                if (apiResult.isSuccess()) {
                    List rpcDTOList = (List)apiResult.getData();
                    if (CollectionUtil.isNotEmpty((Collection)rpcDTOList)) {
                        return rpcDTOList;
                    }
                    break block5;
                }
                throw new BusinessException(ApiCode.FAIL, "\u8c03\u7528\u57fa\u7840\u57df(findOrgStoreBaseByParam)\u67e5\u8be2\u95e8\u5e97\u5931\u8d25\uff1a" + apiResult.getErrorMsg());
            }
            catch (Exception e) {
                log.error("findBaseOuByCodes error:", (Throwable)e);
                throw new BusinessException(ApiCode.FAIL, "\u8c03\u7528\u57fa\u7840\u4e2d\u5fc3dubbo\u670d\u52a1\u5f02\u5e38\uff1a" + e);
            }
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public Map<String, OrgStoreBaseRpcDTO> findBaseStoreMapByCodes(List<String> storeCodeList) {
        List<OrgStoreBaseRpcDTO> rpcDTOList = this.findBaseStoreByCodes(storeCodeList);
        if (CollectionUtil.isEmpty(rpcDTOList)) {
            return new HashMap<String, OrgStoreBaseRpcDTO>();
        }
        Map<String, OrgStoreBaseRpcDTO> ouMap = rpcDTOList.stream().collect(Collectors.toMap(OrgStoreBaseRpcDTO::getStoreCode, t -> t, (t1, t2) -> t1));
        return ouMap;
    }

    public RmiOrgStoreRpcServiceServiceImpl(OrgStoreRpcService orgStoreRpcService) {
        this.orgStoreRpcService = orgStoreRpcService;
    }
}

