package com.elitesland.fin.application.facade.dto.writeoff;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 保存参数.
 *
 * @author shihao.ma
 * @since 2023/9/5
 */
@Getter
@Setter
@ApiModel(description = "保存参数")
public class FinApPayVerApplySaveDTO implements Serializable {

    private static final long serialVersionUID = -5502106554070998350L;

    @ApiModelProperty(value = "内外部客户")
    private String inOutCust;

    
    /**
     * 主键
     */
    @ApiModelProperty(value = "主键")
    private Long id;

    /**
     * 申请单号
     */
    @ApiModelProperty(value = "申请单号")
    private String applyDocNo;

    /**
     * 单据状态
     */
    @ApiModelProperty(value = "单据状态")
    private String state;

    /**
     * 核销状态
     */
    @ApiModelProperty(value = "核销状态")
    private String verState;

    /**
     * 核销金额
     */
    @ApiModelProperty(value = "核销金额")
    private BigDecimal verAmt;

    /**
     * 审批人ID
     */
    @ApiModelProperty(value = "审批人ID")
    private Long approvalId;

    /**
     * 审批人编码
     */
    @ApiModelProperty(value = "审批人编码")
    private String approvalCode;

    /**
     * 审批人名称
     */
    @ApiModelProperty(value = "审批人名称")
    private LocalDateTime approvalName;

    /**
     * 申请日期
     */
    @ApiModelProperty(value = "申请日期")
    private LocalDateTime applyDate;

    /**
     * 申请人ID
     */
    @ApiModelProperty(value = "申请人ID")
    private Long applyUserId;

    /**
     * 申请人编码
     */
    @ApiModelProperty(value = "申请人编码")
    private String applyUserCode;

    /**
     * 申请人名称
     */
    @ApiModelProperty(value = "申请人名称")
    private String applyUserName;

    /**
     * 核销申请 - 应收单明细
     */
    @ApiModelProperty(value = "核销申请 - 应收单明细")
    private List<FinApPayVerApplyApSaveDTO> apSaveList;

    /**
     * 核销申请 - 收款单明细
     */
    @ApiModelProperty(value = "核销申请 - 收款单明细")
    private List<FinApPayVerApplyPaySaveDTO> paySaveList;

    @ApiModelProperty(value = "核销申请 - 应收单")
    private List<FinApPayVerApplyApHeadSaveDTO> apHeadSaveList;

    @ApiModelProperty(value = "核销申请 - 收款单")
    private List<FinApPayVerApplyPayHeadSaveDTO> payHeadSaveList;

    @ApiModelProperty(value = "表头标识符")
    private Boolean headFlag;

    @ApiModelProperty("核销方案ID")
    private Long schemeId;

    @ApiModelProperty("核销方式")
    private String verMode;

    @ApiModelProperty("拟定状态,DRAFT：草稿，PROPOSING：拟定中，PROPOSED_FAIL：拟定失败，PROPOSED_SUCCESS：拟定成功，SENDING：传输中，SEND_FAIL：传输失败，SEND_SUCCESS：传输成功")
    private String proposedStatus;

    @ApiModelProperty("公司编码")
    private String ouCode;

    @ApiModelProperty("公司ID")
    private Long ouId;

    @ApiModelProperty("公司名称")
    private String ouName;

}
