package com.elitesland.fin.application.facade.dto.writeoff;

import com.elitesland.fin.application.facade.base.BaseModelDTO;
import com.elitesland.fin.application.facade.vo.recorder.RecOrderDtlVO;
import com.elitesland.workflow.enums.ProcInstStatus;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

/**
 * 保存参数.
 *
 * @author shihao.ma
 * @since 2023/9/5
 */
@Getter
@Setter
@ApiModel(description = "保存参数")
public class FinArRecVerApplyRecHeadSaveDTO extends BaseModelDTO {

    private static final long serialVersionUID = -2961960466643509169L;

    @ApiModelProperty("来源单号")
    private String sourceNo;

    @ApiModelProperty("销售公司编码")
    private String ouCode;

    @ApiModelProperty("销售公司ID")
    private Long ouId;

    @ApiModelProperty("销售公司名称")
    private String ouName;

    @ApiModelProperty("应收单类型定义ID")
    private Long arTypeId;

    @ApiModelProperty("应收单类型名称")
    private String arTypeName;

    @ApiModelProperty("应收单类型代码")
    private String arTypeCode;

    @ApiModelProperty("收款单类型ID")
    private Long recTypeId;

    @ApiModelProperty("收款单类型代码")
    private String recTypeCode;

    @ApiModelProperty("收款单类型名称")
    private String recTypeName;

    @ApiModelProperty("收款单号")
    private String recOrderNo;

    @ApiModelProperty("币种编码")
    private String currCode;

    @ApiModelProperty("币种")
    private String currName;

    @ApiModelProperty("本位币编码")
    private String localCurrCode;

    @ApiModelProperty("本位币名称")
    private String localCurrName;

    @ApiModelProperty("含税总金额")
    private BigDecimal totalAmt;

    @ApiModelProperty("含税总金额(本位币)")
    private BigDecimal totalCurAmt;

    @ApiModelProperty("审核人ID")
    private Long auditUserId;

    @ApiModelProperty("审核人")
    private String auditUser;

    @ApiModelProperty("审核时间")
    private LocalDateTime auditDate;

    @ApiModelProperty("单据状态")
    private String orderState;

    @ApiModelProperty("汇率")
    private BigDecimal exchangeRate;

    @ApiModelProperty("是否期初")
    private Boolean initFlag;

    @ApiModelProperty("实际收款金额")
    private BigDecimal realRecAmt;

    @ApiModelProperty("实际收款金额(本位币)")
    private BigDecimal realRecCurAmt;

    @ApiModelProperty("收款日期")
    private LocalDateTime reDate;

    @ApiModelProperty("是否预收")
    private Boolean reFlag;

    @ApiModelProperty("审核拒绝理由")
    private String auditRejection;

    @ApiModelProperty("单据来源")
    private String createMode;

    @ApiModelProperty("核销状态")
    private String verState;

    @ApiModelProperty("已核销金额")
    private BigDecimal verAmt;

    @ApiModelProperty("客户ID")
    private Long custId;

    @ApiModelProperty("客户编码")
    private String custCode;

    @ApiModelProperty("客户名称")
    private String custName;

    @ApiModelProperty("销售部门ID")
    private Long buId;

    @ApiModelProperty("销售部门编码")
    private String buCode;

    @ApiModelProperty("销售部门名称")
    private String buName;

    @ApiModelProperty("收款公司编码")
    private String recOuCode;

    @ApiModelProperty("收款公司ID")
    private Long recOuId;

    @ApiModelProperty("收款公司名称")
    private String recOuName;

    @ApiModelProperty("销售组织编码")
    private String orgCode;

    @ApiModelProperty("销售组织ID")
    private Long orgId;

    @ApiModelProperty("销售组织名称")
    private String orgName;

    @ApiModelProperty("税额")
    private BigDecimal taxAmt;

    @ApiModelProperty("单据类型")
    private String recOrderType;
    private String recOrderTypeName;

    @ApiModelProperty("销售业务员ID")
    private Long saleUserId;

    @ApiModelProperty("销售业务员")
    private String saleUser;

    @ApiModelProperty("未核销金额")
    private BigDecimal unVerAmt;

    @ApiModelProperty("创建人")
    private String creator;

    @ApiModelProperty("创建人ID")
    private Long createUserId;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("税额(本位币)")
    private BigDecimal taxCurAmt;

    @ApiModelProperty("创建时间")
    private LocalDateTime createTime;

    @ApiModelProperty("修改人")
    private String updater;

    @ApiModelProperty("修改时间")
    private LocalDateTime modifyTime;

    @ApiModelProperty("锁版本")
    private Integer auditDataVersion;

    @ApiModelProperty("流程实例ID")
    private String procInstId;

    @ApiModelProperty("流程实例状态")
    private ProcInstStatus procInstStatus;

    @ApiModelProperty("具体订单场景")
    private String docType;

    @ApiModelProperty("B端订单/C端订单")
    private String docType2;

    @ApiModelProperty("SO代表正向RSO代表退货负向")
    private String docCls;

    @ApiModelProperty("提交时间")
    private LocalDateTime submitTime;

    @ApiModelProperty("审批通过时间")
    private LocalDateTime approvedTime;

    @ApiModelProperty("明细信息")
    private List<RecOrderDtlVO> dtlVOList;

    @ApiModelProperty("地址号")
    private String addrNo;

    @ApiModelProperty("供应商地址号")
    private String suppAddrNo;

    @ApiModelProperty("支付凭证")
    private String applyFile;

    @ApiModelProperty("收款单id")
    private Long recId;

    @ApiModelProperty("发票号")
    private String invoiceNumber;

    @ApiModelProperty("红冲标志")
    private Boolean redFlushSign;

    @ApiModelProperty("第三方支付辅助")
    private String thirdPaymentAssistance;

    @ApiModelProperty("消费卡辅助")
    private String consumerCardSsistance;

    @ApiModelProperty("信用卡辅助")
    private String creditCardAssistance;

    @ApiModelProperty("结算方式")
    private String payType;

    @ApiModelProperty("收款银行账户")
    private String recBank;

    @ApiModelProperty("付款银行账户")
    private String payBank;

    @ApiModelProperty("核销申请中金额")
    private BigDecimal applyVerAmting;

    @ApiModelProperty(value = "核销申请 - 收款单明细")
    private List<FinArRecVerApplyRecSaveDTO> recSaveList;

    @ApiModelProperty(value = "业务员名称")
    private String salesmanName;

    @ApiModelProperty("扩展表ID")
    private Long extId;

    @ApiModelProperty("业务员名称")
    private String businessName;

    @ApiModelProperty(value = "业务员编码")
    private String salesmanCode;

    @ApiModelProperty("扩展信息字段")
    private Map<String, String> extensionInfo;
}
