package com.elitesland.fin.application.facade.vo.arorder;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.elitescloud.boot.core.support.customfield.common.CustomFieldAbstractVo;
import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @author wang.xl
 * @version V1.0
 * @Package com.elitesland.fin.application.facade.vo.arorder
 * @date 2022/4/12 16:14
 */
@Data
public class ArOrderVO extends CustomFieldAbstractVo implements Serializable, WriteoffVO {

    private static final long serialVersionUID = 3885513784926932000L;
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("主键ID")
    private Long id;

    @ApiModelProperty("来源单号")
    private String sourceNo;

    @ApiModelProperty("应收单编号")
    private String arOrderNo;

    @ApiModelProperty("销售公司编码")
    private String ouCode;

    @ApiModelProperty("销售公司ID")
    private Long ouId;

    @ApiModelProperty("销售公司名称")
    private String ouName;

    @ApiModelProperty("单据来源")
    @SysCode(sys = "yst-supp", mod = "DOC_CLS")
    private String createMode;
    private String createModeName;

    @ApiModelProperty("应收单类型定义ID")
    private Long arTypeId;

    @ApiModelProperty("应收单类型名称")
    private String arTypeName;

    @ApiModelProperty("应收单类型代码")
    private String arTypeCode;

    @ApiModelProperty("单据状态")
    @SysCode(sys = "yst-supp", mod = "APPLY_STATUS")
    private String orderState;
    private String orderStateName;

    @ApiModelProperty("业务日期")
    private LocalDateTime buDate;

    @ApiModelProperty("含税金额")
    private BigDecimal totalAmt;

    @ApiModelProperty("不含税金额")
    private BigDecimal exclTaxAmt;

    @ApiModelProperty("税额")
    private BigDecimal taxAmt;

    @ApiModelProperty("含税金额(本位币)")
    private BigDecimal totalCurAmt;

    @ApiModelProperty("不含税金额(本位币)")
    private BigDecimal exclTaxCurAmt;

    @ApiModelProperty("税额(本位币)")
    private BigDecimal taxCurAmt;

    @ApiModelProperty("币种编码")
    private String currCode;

    @ApiModelProperty("币种")
    private String currName;

    @ApiModelProperty("本位币编码")
    private String localCurrCode;

    @ApiModelProperty("本位币名称")
    private String localCurrName;

    @ApiModelProperty("审核人ID")
    private Long auditUserId;

    @ApiModelProperty("审核人")
    private String auditUser;

    @ApiModelProperty("审核日期")
    private LocalDateTime auditDate;

    @ApiModelProperty("汇率")
    private BigDecimal exchangeRate;

    @ApiModelProperty("是否含税")
    private Boolean taxFlag;

    @ApiModelProperty("是否期初")
    private Boolean initFlag;

    @ApiModelProperty("审核拒绝理由")
    private String auditRejection;

    @ApiModelProperty("客户ID")
    private Long custId;

    @ApiModelProperty("客户编码")
    private String custCode;

    @ApiModelProperty("客户名称")
    private String custName;

    @ApiModelProperty("部门ID")
    private Long buId;

    @ApiModelProperty("部门编码")
    private String buCode;

    @ApiModelProperty("部门名称")
    private String buName;

    @ApiModelProperty("业务类型")
    private String buType;


    @ApiModelProperty("核销状态")
    @SysCode(sys = "yst-fin", mod = "VERIFY_STATUS")
    private String verState;
    private String verStateName;

    @ApiModelProperty("已核销金额")
    private BigDecimal verAmt;

    @ApiModelProperty("未核销金额")
    private BigDecimal unVerAmt;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("组织ID")
    private Long orgId;

    @ApiModelProperty("组织编码")
    private String orgCode;

    @ApiModelProperty("组织名称")
    private String orgName;

    @ApiModelProperty("销售业务员ID")
    private Long saleUserId;

    @ApiModelProperty("销售业务员")
    private String saleUser;

    @ApiModelProperty("单据类型")
    private String arOrderType;

    @ApiModelProperty("总数量")
    private Long totalCount;

    @ExcelProperty("创建人")
    @ApiModelProperty(value = "创建人")
    private String creator;

    @ApiModelProperty(value = "创建日期")
    @ExcelIgnore
    private LocalDateTime createTime;

    @ApiModelProperty(value = "修改人")
    @ExcelIgnore
    private String updater;

    @ApiModelProperty("修改时间")
    @ExcelIgnore
    private LocalDateTime modifyTime;

    @ApiModelProperty("锁版本")
    private Integer auditDataVersion;

    @ApiModelProperty("流程实例ID")
    private String procInstId;

    @ApiModelProperty("流程实例状态")
    private ProcInstStatus procInstStatus;

    @ApiModelProperty("具体订单场景")
    private String docType;

    @ApiModelProperty("B端订单/C端订单")
    private String docType2;

    @ApiModelProperty("SO代表正向RSO代表退货负向")
    private String docCls;

    @ApiModelProperty("提交时间")
    private LocalDateTime submitTime;

    @ApiModelProperty("审批通过时间")
    private LocalDateTime approvedTime;

    @ApiModelProperty("明细数据")
    private List<ArOrderDtlVO> dtlList;

    @ApiModelProperty("结算方式")
    @SysCode(sys = "yst-fin", mod = "SETTLEMENT_TYPE")
    private String settlementType;
    private String settlementTypeName;

    @ApiModelProperty("扩展表关联字段")
    private Long relateId;

    @SysCode(sys = "yst-fin", mod = "DOC_PROPOSED_STATUS")
    @ApiModelProperty("拟定状态,DRAFT：草稿，PROPOSING：拟定中，PROPOSED_FAIL：拟定失败，PROPOSED_SUCCESS：拟定成功，SENDING：传输中，SEND_FAIL：传输失败，SEND_SUCCESS：传输成功")
    private String proposedStatus;
    private String proposedStatusName;

    @ApiModelProperty("订单客户")
    private String es1;

    @ApiModelProperty("发票号")
    private String es2;

    @ApiModelProperty("开票日期")
    private LocalDateTime es3;

    @ApiModelProperty("发票类型")
    private String es4;

    @ApiModelProperty("起算日期")
    private LocalDateTime es5;

    @ApiModelProperty("红冲标志")
    private String es6;

    @ApiModelProperty("红冲状态")
    private Boolean redState;

    @ApiModelProperty("红冲来源")
    private String redSourceNo;

    @ApiModelProperty("红冲来源")
    private Long redSourceId;
    @ApiModelProperty("核销申请中金额")
    private BigDecimal applyVerAmTing;

    @ApiModelProperty(value = "内外部客户")
    @SysCode(sys = "yst-sale", mod = "CUST_IN_OUT")
    private String inOutCust;
    private String inOutCustName;

    @ApiModelProperty("收款协议编码")
    private String protocolCode;
    @ApiModelProperty("收款协议名称")
    private String protocolName;
}
