package com.elitesland.fin.application.service.accountingengine;

import cn.hutool.core.lang.Assert;
import com.elitescloud.boot.core.base.UdcProvider;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.provider.TenantClientProvider;
import com.elitesland.fin.application.facade.dto.accountingengine.FinAccountEngineDTO;
import com.elitesland.fin.application.facade.dto.accountingengine.PageParam;
import com.elitesland.fin.application.facade.param.accountingengine.ManualProposedParam;
import com.elitesland.fin.application.facade.dto.accountingengine.FinAccountEngineConfigDTO;
import com.elitesland.fin.common.FinConstant;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.domain.entity.accountingengine.*;
import com.mysql.cj.MysqlType;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.sql.*;
import java.time.LocalDateTime;
import java.util.*;
import java.util.stream.Collectors;

@Service
@RequiredArgsConstructor
@Slf4j
public class FinAccountEngineJdbcServiceImpl implements FinAccountEngineJdbcService {
    private final UdcProvider udcProvider;

    private final TenantClientProvider tenantClientProvider;
    @Value("${fin.journal.batchSaveSize:1}")
    private int batchSize = 1;

    @Override
    public void closeConnection(Connection connection) {
        if (connection != null) {
            try {
                connection.close();
            } catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public Connection getJournalConnection(FinAccountEngineDTO finAccountEngineDO) throws ClassNotFoundException, SQLException {
        Class.forName(FinConstant.DRIVEN_NAME);
        Connection connection = DriverManager.getConnection(String.format(FinConstant.CONNECTION_NAME,
                        finAccountEngineDO.getJournalHost(),
                        finAccountEngineDO.getJournalPort(),
                        finAccountEngineDO.getJournalDatabase()),
                finAccountEngineDO.getJournalUser(),
                finAccountEngineDO.getJournalPassword());
        return connection;
    }

    @Override
    public Connection getEventTableConnection(FinEventTableDO finEventTableDO) throws ClassNotFoundException, SQLException {
        Class.forName(FinConstant.DRIVEN_NAME);
        Connection connection = DriverManager.getConnection(String.format(FinConstant.CONNECTION_NAME,
                        finEventTableDO.getHost(),
                        finEventTableDO.getPort(),
                        finEventTableDO.getDatabaseName()),
                finEventTableDO.getUserName(),
                finEventTableDO.getPassword());
        return connection;
    }

    @Override
    public int updateProposedStatus(FinEventTableDO finEventTableDO, Connection connection, Long masId, String proposedStatus) throws SQLException {
        String updateProposedStatusSql = "update " + finEventTableDO.getMasTable() + " set proposed_status='" + proposedStatus + "' where (proposed_status !='" +
                UdcEnum.DOC_PROPOSED_STATUS_PROPOSING.getValueCode() + "') and " + finEventTableDO.getMasTableColumn() + " = " + masId;
        PreparedStatement preparedStatement = connection.prepareStatement(updateProposedStatusSql);
        log.info("更新拟定状态sql:\n{}", updateProposedStatusSql);
        int res = preparedStatement.executeUpdate();
        try {
            preparedStatement.close();
        } catch (SQLException e) {
            e.printStackTrace();
        }
        Assert.isTrue(res == 1, "单据更新为拟定中失败");
        return res;
    }

    @Override
    public int batchUpdateProposedStatus(FinEventTableDO finEventTableDO, Connection connection, Set<Long> masIds, String proposedStatus) throws SQLException {
        if (CollectionUtils.isEmpty(masIds)) {
            return 0;
        }
        String masIdStr = getIdsJoinString(masIds);
        String updateProposedStatusSql = "update " + finEventTableDO.getMasTable() + " set proposed_status='" + proposedStatus + "' where (proposed_status ='" +
                UdcEnum.DOC_PROPOSED_STATUS_PROPOSING.getValueCode() + "') and " + finEventTableDO.getMasTableColumn() + " in (" + masIdStr + ")";
        log.info("批量更新单据拟定状态sql:\n{}", updateProposedStatusSql);
        PreparedStatement preparedStatement = connection.prepareStatement(updateProposedStatusSql);
        int res = preparedStatement.executeUpdate();
        try {
            preparedStatement.close();
        } catch (SQLException e) {
            e.printStackTrace();
        }
        //Assert.isTrue(res == masIds.size(), "批量更新单据拟定状态失败");
        return res;
    }

    @Override
    public List<Map> queryEventTableData(Connection connection, FinAccountEngineConfigDTO finAccountEngineConfigDTO, boolean manualFlag, ManualProposedParam manualProposedParam) throws SQLException {
        List<Long> docIds =manualProposedParam!=null? manualProposedParam.getDocIds():null;
        String proposedType = manualProposedParam!=null? manualProposedParam.getProposedType():null;
        FinEventTableDO finEventTableDO = finAccountEngineConfigDTO.getFinEventTableDO();
        FinAccountEngineDTO finAccountEngineDO = finAccountEngineConfigDTO.getFinAccountEngineDTO();
        ResultSet resultSet = null;
        PreparedStatement preparedStatement = null;
        String sql = buildSql(finAccountEngineConfigDTO, null, manualFlag, docIds,proposedType);
        //查询数据end
        sql = addTenantCondition(sql, finEventTableDO.getMasTable(), finEventTableDO.getTableName());
        log.info("查询事件表单数据,事件表单:{},会计引擎ID：{},业务单据查询sql:\n{}", finEventTableDO.getEventTable(), finAccountEngineDO.getId(), sql);
        try {
            preparedStatement = connection.prepareStatement(sql);
            resultSet = preparedStatement.executeQuery();
            List<Map> resultList = new ArrayList<>();
            String[] columnLabels = null;
            boolean isFirst = true;
            int columnCount = 0;
            // 处理查询结果集
            while (resultSet.next()) {
                Map<String, Object> map = new HashMap();
                if (isFirst) {
                    columnCount = resultSet.getMetaData().getColumnCount();
                    columnLabels = new String[columnCount];
                    for (int i = 1; i <= columnCount; i++) {
                        columnLabels[i - 1] = resultSet.getMetaData().getColumnLabel(i);
                        map.put(columnLabels[i - 1], resultSet.getObject(columnLabels[i - 1]));
                    }
                    isFirst = false;
                } else {
                    for (int i = 0; i < columnCount; i++) {
                        map.put(columnLabels[i], resultSet.getObject(columnLabels[i]));
                    }
                }
                resultList.add(map);
            }
            return resultList;
        } finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                } catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                } catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
    }
    private List<Map> purePageQueryEventTableData(Connection connection, FinAccountEngineConfigDTO finAccountEngineConfigDTO, boolean manualFlag, ManualProposedParam manualProposedParam, PageParam pageParam) throws SQLException {
        List<Long> docIds =manualProposedParam==null?null:manualProposedParam.getDocIds();
        String proposedType = manualProposedParam==null?null:manualProposedParam.getProposedType();
        FinEventTableDO finEventTableDO = finAccountEngineConfigDTO.getFinEventTableDO();
        FinAccountEngineDTO finAccountEngineDO = finAccountEngineConfigDTO.getFinAccountEngineDTO();
        ResultSet resultSet = null;
        PreparedStatement preparedStatement = null;
        String sql = buildSql(finAccountEngineConfigDTO, null, manualFlag, docIds,proposedType);
        //查询数据end
        sql = addTenantCondition(sql, finEventTableDO.getMasTable(), finEventTableDO.getTableName());
        //处理分页参数
        sql=handlePage(sql, finAccountEngineConfigDTO,pageParam.getLimit(),pageParam.getOffset());
        log.info("查询事件表单数据,事件表单:{},会计引擎ID：{},业务单据查询sql:\n{}", finEventTableDO.getEventTable(), finAccountEngineDO.getId(), sql);
        try {
            preparedStatement = connection.prepareStatement(sql);
            resultSet = preparedStatement.executeQuery();
            List<Map> resultList = new ArrayList<>();
            String[] columnLabels = null;
            boolean isFirst = true;
            int columnCount = 0;
            // 处理查询结果集
            while (resultSet.next()) {
                Map<String, Object> map = new HashMap();
                if (isFirst) {
                    columnCount = resultSet.getMetaData().getColumnCount();
                    columnLabels = new String[columnCount];
                    for (int i = 1; i <= columnCount; i++) {
                        columnLabels[i - 1] = resultSet.getMetaData().getColumnLabel(i);
                        map.put(columnLabels[i - 1], resultSet.getObject(columnLabels[i - 1]));
                    }
                    isFirst = false;
                } else {
                    for (int i = 0; i < columnCount; i++) {
                        map.put(columnLabels[i], resultSet.getObject(columnLabels[i]));
                    }
                }
                resultList.add(map);
            }
            return resultList;
        } finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                } catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                } catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
    }
    @Override
    public List<Map> pageQueryEventTableData(Connection connection, FinAccountEngineConfigDTO finAccountEngineConfigDTO, boolean manualFlag, ManualProposedParam manualProposedParam, PageParam pageParam) throws SQLException {
        int limit=pageParam.getLimit();
        int offset = pageParam.getOffset();
        List<Map> purePageData=purePageQueryEventTableData(connection, finAccountEngineConfigDTO,manualFlag, manualProposedParam,pageParam);
        if(CollectionUtils.isEmpty(purePageData)){
            return null;
        }
        if(finAccountEngineConfigDTO.isMasTableOnly()){
            pageParam.setOffset(limit+offset);
            return purePageData;
        }
        //处理整单分页情况
        //判断是否不够尾页，是尾页不做任何处理
        if(purePageData.size()<limit){
            pageParam.setOffset(limit+purePageData.size());
            return purePageData;
        }
        //取最后一条数据的主表ID
        long lastMainId=(long)purePageData.get(purePageData.size()-1).get("main_id");
        List<Long> lastDocIds=new ArrayList<>();
        lastDocIds.add(lastMainId);
        manualProposedParam.setDocIds(lastDocIds);
        //全量查询当前主表ID的所有数据
        List<Map> lastMainData= queryEventTableData(connection, finAccountEngineConfigDTO, manualFlag, manualProposedParam);
        if(CollectionUtils.isEmpty(lastMainData)){
            return purePageData;
        }
        Map<Object, List<Map>> purePageDataMap = purePageData.stream().collect(Collectors.groupingBy(v -> {
            return v.get("main_id");
        }, Collectors.toList()));
        List<Map> existLastMainData = purePageDataMap.get(lastMainId);
        Map<Object, Map> existLastMainDataMap = existLastMainData.stream().collect(Collectors.toMap(v -> {
            return v.get("detail_id");
        }, v -> v));
        //添加数据集
        purePageData.addAll(lastMainData.stream().filter(v -> {
            return !existLastMainDataMap.containsKey(v.get("detail_id"));
        }).collect(Collectors.toList()));
        //调整分页参数
        int diffSize=lastMainData.size()-existLastMainData.size();
        offset=offset+limit+diffSize;
        pageParam.setOffset(offset);
        return purePageData;
    }

    /**
     * 排序参数处理，主表必须参入排序
     * @param srcSql
     * @param finAccountEngineConfigDTO
     * @param page
     * @param pageSize
     * @return
     */
    private String handlePage(String srcSql, FinAccountEngineConfigDTO finAccountEngineConfigDTO, int limit, int offset){
        FinEventTableDO finEventTableDO = finAccountEngineConfigDTO.getFinEventTableDO();
        StringBuilder pageQueryClause=new StringBuilder();
        String tableOrder = finEventTableDO.getTableOrder();
        String masTableOrder = finEventTableDO.getMasTableOrder();
        if(StringUtils.isNotBlank(masTableOrder)){
            pageQueryClause.append(" order by ").append(finEventTableDO.getMasTable()).append(".").append(masTableOrder);
        }else{
            pageQueryClause.append(" order by ").append(finEventTableDO.getMasTable()).append(".").append(finEventTableDO.getMasTableColumn());
        }
        if(StringUtils.isNotBlank(tableOrder)){
            if(pageQueryClause.toString().length()<1){
                pageQueryClause.append(" order by ").append(finEventTableDO.getTableName()).append(".").append(tableOrder);
            }else{
                pageQueryClause.append(",").append(finEventTableDO.getTableName()).append(".").append(tableOrder);
            }
        }
        pageQueryClause.append(" limit ").append(limit).append(" offset ").append(offset);
        return srcSql+pageQueryClause.toString();
    }
    @Override
    public void deleteExistJournal(Connection eventTableConnection, Connection journalConnection, FinAccountEngineConfigDTO finAccountEngineConfigDTO, List<String> docNums, List<Long> docIds) {
        //查询表单docNum
        if (CollectionUtils.isEmpty(docNums)) {
            return;
        }
        FinAccountEngineDTO finAccountEngineDO = finAccountEngineConfigDTO.getFinAccountEngineDTO();
        FinEventTableDO finEventTableDO = finAccountEngineConfigDTO.getFinEventTableDO();
        String journalTable = finAccountEngineDO.getJournalTable();
        String docNumsString = docNums.stream().map(v -> "'".concat(v).concat("'")).reduce((v1, v2) -> v1.concat(",").concat(v2)).get();
        String docIdsString= docIds.stream().map(v -> "'".concat(v.toString()).concat("'")).reduce((v1, v2) -> v1.concat(",").concat(v2)).get();
        String sql = "delete from " + journalTable + " where doc_num in (" + docNumsString + ") or doc_num in (" + docIdsString + ")";
        log.info("手动拟定,事件表单:{},删除已有的会计凭证sql :\n{}", finEventTableDO.getEventTable(), sql);
        PreparedStatement preparedStatement = null;
        int result = 0;
        try {
            preparedStatement = journalConnection.prepareStatement(sql);
            result = preparedStatement.executeUpdate();
        } catch (SQLException e) {
            log.error("手动拟定,事件表单:{},删除已有的会计凭证异常", finEventTableDO.getEventTable(), e);
            throw new BusinessException("删除已有的会计凭证异常");
        } finally {
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                } catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }

    }

    @Override
    public String getDocNumStrsFromDocIds(Connection eventTableConnection, FinAccountEngineConfigDTO finAccountEngineConfigDTO, List<Long> docIds) {
        //查询表单docNum
        if (CollectionUtils.isEmpty(docIds)) {
            return null;
        }
        FinEventTableDO finEventTableDO = finAccountEngineConfigDTO.getFinEventTableDO();
        String masTable = finEventTableDO.getMasTable();
        String columnDocNum = finAccountEngineConfigDTO.getFinAccountEngineDTO().getColumnDocNum();
        Optional<String> docIdsStrs = docIds.stream().map(v -> v.toString()).reduce((v1, v2) -> {
            return v1.concat(",").concat(v2);
        });
        String sql = "select " + columnDocNum + "  from " + masTable + " where id in (" + docIdsStrs.get() + ")";
        log.info("会计分录生成，事件表单:{},根据docId查询docNum sql:\n{}", finEventTableDO.getEventTable(), sql);
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = eventTableConnection.prepareStatement(sql);
            resultSet = preparedStatement.executeQuery();
            String docNumStrs = "";
            while (resultSet.next()) {
                docNumStrs.concat(",").concat(resultSet.getString(columnDocNum));
            }
            return docNumStrs;
        } catch (SQLException e) {
            log.error("会计分录生成,事件表单:{},根据docId查询docNum异常", finEventTableDO.getEventTable(), e);
            throw new BusinessException("根据docId查询docNum异常");
        } finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                } catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                } catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public void finJournalBatchSave(FinAccountEngineDO finAccountEngineDO, Connection journalConnection, List<Map> saveMapList) {
        if (CollectionUtils.isEmpty(saveMapList)) {
            return;
        }
        Set keySet = saveMapList.get(0).keySet();
        List<Object> columnList = new ArrayList<>(keySet);
        Optional<String> stationsymbolCollect = columnList.stream().map(v -> "?").reduce((v1, v2) -> v1.concat(",").concat(v2));
        String sql = FinConstant.INSERT
                .concat(FinConstant.BLANK)
                .concat(FinConstant.INTO)
                .concat(FinConstant.BLANK)
                .concat(finAccountEngineDO.getJournalTable())
                .concat(FinConstant.BLANK)
                .concat(FinConstant.LEFT_PARENTHESIS)
                .concat(StringUtils.join(columnList, FinConstant.COMMA))
                .concat(FinConstant.RIGHT_PARENTHESIS)
                .concat(FinConstant.BLANK)
                .concat(FinConstant.VALUES)
                .concat(FinConstant.LEFT_PARENTHESIS)
                .concat(stationsymbolCollect.get())
                .concat(FinConstant.RIGHT_PARENTHESIS);
        log.info("插入会计分录sql: " + sql);
        PreparedStatement preparedStatement = null;
        try {
            int count = 0;
            preparedStatement = journalConnection.prepareStatement(sql);
            ;
            for (Map map : saveMapList) {
                Object value = null;
                for (int i = 0; i < columnList.size(); i++) {
                    value = map.get(columnList.get(i));
                    if (value instanceof String) {
                        preparedStatement.setString(i + 1, (String) value);
                    } else if (value instanceof BigDecimal) {
                        preparedStatement.setBigDecimal(i + 1, (BigDecimal) value);
                    } else if (value instanceof Long) {
                        preparedStatement.setLong(i + 1, (Long) value);
                    } else if (value instanceof Integer) {
                        preparedStatement.setInt(i + 1, (Integer) value);
                    } else if (value instanceof LocalDateTime) {
                        preparedStatement.setObject(i + 1, value, MysqlType.DATETIME);
                    } else if (value instanceof Timestamp){
                        preparedStatement.setObject(i + 1, value, MysqlType.DATETIME);
                    }else {
                        log.warn("异常类型字段{}:{}:{}", i, columnList.get(i), value);
                    }
                }
                preparedStatement.addBatch();
                count++;
                if (count % batchSize == 0) {
                    preparedStatement.executeBatch();
                    preparedStatement.clearBatch();
                }
            }
            if (count % batchSize != 0) {
                preparedStatement.executeBatch();
                preparedStatement.clearBatch();
            }
        } catch (SQLException e) {
            log.error("保存会计凭证失败", e);
            throw new BusinessException("保存会计凭证失败");
        } finally {
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                } catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private String addTenantCondition(String sql, String mainTableName, String detailTableName) {
        if (StringUtils.isBlank(sql)) {
            return sql;
        }
        long tenantId = -1L;
        if (tenantClientProvider.getSessionTenant() != null) {
            tenantId = tenantClientProvider.getSessionTenant().getId();
        }
        if (StringUtils.isNoneBlank(mainTableName)) {
            sql += " and " + mainTableName + ".tenant_id=" + tenantId;
            if (StringUtils.isNoneBlank(detailTableName)) {
                sql += " and " + detailTableName + ".tenant_id=" + tenantId;
            }
        }
        return sql;
    }

    private String buildSql(FinAccountEngineConfigDTO finAccountEngineConfigDTO,
                            List<FinAccEngDetConditionDO> finAccEngDetConditionDOList, boolean manualFlag, List<Long> docIds, String proposedType) {
        List<FinEventTableConditionDO> finEventTableProposedConditionList = finAccountEngineConfigDTO.getFinEventTableProposedConditionList();
        FinEventTableDO finEventTableDO = finAccountEngineConfigDTO.getFinEventTableDO();
        if (!finAccountEngineConfigDTO.isMasTableOnly()) {
            return FinConstant.SELECT
                    .concat(FinConstant.BLANK)
                    .concat(buildFields(finAccountEngineConfigDTO.getFinEventTableLineDOList()))
                    .concat(FinConstant.COMMA)
                    .concat(finAccountEngineConfigDTO.getFinEventTableDO().getMasTable().concat(FinConstant.POINT).concat(finAccountEngineConfigDTO.getFinEventTableDO().getMasTableColumn()).concat(" as main_id"))
                    .concat(FinConstant.COMMA)
                    .concat(finAccountEngineConfigDTO.getFinEventTableDO().getTableName().concat(FinConstant.POINT).concat("id").concat(" as detail_id"))
                    .concat(FinConstant.BLANK)
                    .concat(FinConstant.FROM)
                    .concat(FinConstant.BLANK)
                    .concat(finAccountEngineConfigDTO.getFinEventTableDO().getMasTable())
                    .concat(FinConstant.BLANK)
                    .concat(FinConstant.INNER)
                    .concat(FinConstant.BLANK)
                    .concat(FinConstant.JOIN)
                    .concat(FinConstant.BLANK)
                    .concat(finAccountEngineConfigDTO.getFinEventTableDO().getTableName())
                    .concat(FinConstant.BLANK)
                    .concat(FinConstant.WHERE)
                    .concat(FinConstant.BLANK)
                    .concat(finAccountEngineConfigDTO.getFinEventTableDO().getMasTable())
                    .concat(FinConstant.POINT)
                    .concat(finAccountEngineConfigDTO.getFinEventTableDO().getMasTableColumn())
                    .concat(FinConstant.BLANK)
                    .concat(FinConstant.EQUAL)
                    .concat(FinConstant.BLANK)
                    .concat(finAccountEngineConfigDTO.getFinEventTableDO().getTableName())
                    .concat(FinConstant.POINT)
                    .concat(finAccountEngineConfigDTO.getFinEventTableDO().getTableColumn())
                    .concat(FinConstant.BLANK)
                    .concat(FinConstant.AND)
                    .concat(FinConstant.BLANK)
                    .concat(buildWhere(finAccountEngineConfigDTO.getFinEventTableConditionDOList(), finAccEngDetConditionDOList, finEventTableProposedConditionList, finEventTableDO, manualFlag, docIds,proposedType));
        }
        return FinConstant.SELECT
                .concat(FinConstant.BLANK)
                .concat(buildFields(finAccountEngineConfigDTO.getFinEventTableLineDOList()))
                .concat(FinConstant.COMMA)
                .concat(finAccountEngineConfigDTO.getFinEventTableDO().getMasTable().concat(FinConstant.POINT).concat(finAccountEngineConfigDTO.getFinEventTableDO().getMasTableColumn()).concat(" as main_id"))
                .concat(FinConstant.BLANK)
                .concat(FinConstant.FROM)
                .concat(FinConstant.BLANK)
                .concat(finAccountEngineConfigDTO.getFinEventTableDO().getMasTable())
                .concat(FinConstant.BLANK)
                .concat(FinConstant.WHERE)
                .concat(FinConstant.BLANK)
                .concat(buildWhere(finAccountEngineConfigDTO.getFinEventTableConditionDOList(), finAccEngDetConditionDOList, finEventTableProposedConditionList, finEventTableDO, manualFlag, docIds,proposedType));
    }

    private String buildFields(List<FinEventTableLineDO> finEventTableLineDOList) {
        List<String> fieldList = finEventTableLineDOList.stream()
                .map(item -> item.getTableName().concat(FinConstant.POINT).concat(item.getColumnName()))
                .collect(Collectors.toList());

        return StringUtils.join(fieldList, FinConstant.COMMA);
    }

    private String buildWhere(List<FinEventTableConditionDO> finEventTableConditionDOList,
                              List<FinAccEngDetConditionDO> finAccEngDetConditionDOList, List<FinEventTableConditionDO> finEventTableProposedConditionList, FinEventTableDO finEventTableDO, boolean manualFlag, List<Long> docIds,String proposedType) {
        String whereSql = "proposed_status != 'PROPOSING' and proposed_status is not null ";
        if(StringUtils.isNotBlank(proposedType)){
           if(FinConstant.MANUAL_PROPOSED_TYPE_COMMON.equals(proposedType)){
               whereSql=whereSql.concat(" and proposed_status = '"+UdcEnum.DOC_PROPOSED_STATUS_DRAFT.getValueCode()+"' ");
           }else if(FinConstant.MANUAL_PROPOSED_TYPE_REPROPOSED.equals(proposedType)){
               whereSql=whereSql.concat(" and proposed_status in ('"+UdcEnum.DOC_PROPOSED_STATUS_PROPOSED_SUCCESS.getValueCode()+"','"+UdcEnum.DOC_PROPOSED_STATUS_PROPOSED_FAIL.getValueCode()+"') ");
           }else if(FinConstant.JOB_PROPOSED_TYPE_REPROPOSED.equals(proposedType)){
               whereSql=whereSql.concat(" and proposed_status in ('"+UdcEnum.DOC_PROPOSED_STATUS_DRAFT.getValueCode()+"','"+UdcEnum.DOC_PROPOSED_STATUS_PROPOSED_FAIL.getValueCode()+"') ");
           }
        }
        List<String> wheres = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(finEventTableConditionDOList)) {
            wheres.addAll(finEventTableConditionDOList.stream().map(item ->
                            buildWhere(item.getConditionType(),
                                    item.getTableName(),
                                    item.getColumnName(),
                                    item.getValueFrom(),
                                    item.getValueTo()))
                    .collect(Collectors.toList()));
        }
       /* if(CollectionUtils.isNotEmpty(finAccEngDetConditionDOList)){
            wheres.addAll(finAccEngDetConditionDOList.stream().map(item ->
                            buildWhere(item.getConditionType(),
                                    item.getTableName(),
                                    item.getColumnName(),
                                    item.getValueFrom(),
                                    item.getValueTo()))
                    .collect(Collectors.toList()));
        }*/
        if (CollectionUtils.isNotEmpty(wheres)) {
            whereSql = whereSql.concat(" and ").concat(StringUtils.join(wheres, FinConstant.BLANK.concat(FinConstant.AND).concat(FinConstant.BLANK)));
        }
        if(CollectionUtils.isNotEmpty(docIds)){
            String masIdStr = getIdsJoinString(docIds);
            whereSql=whereSql.concat(FinConstant.BLANK.concat(FinConstant.AND).concat(FinConstant.BLANK).concat(finEventTableDO.getMasTable()
                    .concat(FinConstant.POINT).concat(finEventTableDO.getMasTableColumn()).concat(FinConstant.BLANK).
                    concat("in ").concat("(" + masIdStr + ")")));
        }
        if (manualFlag) {
            return whereSql;
        }
        if (CollectionUtils.isEmpty(finEventTableProposedConditionList)) {
            return whereSql;
        }
        List<String> proposedConditions = finEventTableProposedConditionList.stream().map(item ->
                        buildWhere(item.getConditionType(),
                                item.getTableName(),
                                item.getColumnName(),
                                item.getValueFrom(),
                                item.getValueTo()))
                .collect(Collectors.toList());
        String ngWhereSql = StringUtils.join(proposedConditions, FinConstant.BLANK.concat(FinConstant.AND).concat(FinConstant.BLANK));
        return whereSql.concat(FinConstant.BLANK.concat(FinConstant.AND).concat(FinConstant.BLANK).concat("!("))
                .concat(FinConstant.BLANK).concat(ngWhereSql).concat(FinConstant.BLANK).concat(")");
    }

    private String buildWhere(String conditionType, String tableName, String columnName, String valueFrom, String valueTo) {

        Map<String, String> eventTableConditionUdc = udcProvider.getValueMapByUdcCode(UdcEnum.EVENT_TABLE_CONDITION_EQUAL.getModel(), UdcEnum.EVENT_TABLE_CONDITION_EQUAL.getCode());
        conditionType = eventTableConditionUdc.get(conditionType);

        String concat = tableName
                .concat(FinConstant.POINT)
                .concat(columnName)
                .concat(FinConstant.BLANK);

        if (UdcEnum.EVENT_TABLE_CONDITION_BETWEEN_AND.getValueCode().equals(conditionType)) {
            return concat
                    .concat(FinConstant.BETWEEN)
                    .concat(FinConstant.BLANK)
                    .concat("'")
                    .concat(valueFrom)
                    .concat("'")
                    .concat(FinConstant.BLANK)
                    .concat(FinConstant.AND)
                    .concat(FinConstant.BLANK)
                    .concat("'")
                    .concat(valueTo)
                    .concat("'");
        }

        concat = concat.concat(conditionType)
                .concat(FinConstant.BLANK);

        if (valueFrom != null) {
            concat = concat.concat("'" + valueFrom + "'");
        }

        return concat;
    }

    private String getIdsJoinString(Collection<Long> ids) {
        String masIdStr = null;
        if (ids.size() == 1) {
            masIdStr = ids.toArray()[0].toString();
        } else {
            StringBuilder sb = new StringBuilder();
            for (Long masId : ids) {
                sb.append(masId.toString().concat(","));
            }
            masIdStr = sb.substring(0, sb.length() - 1);
        }
        return masIdStr;
    }
}
