package com.elitesland.fin.application.service.accountingengine;

import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.convert.accountingengine.FinJournalConvert;
import com.elitesland.fin.application.facade.dto.accountingengine.FinSetOfBookDTO;
import com.elitesland.fin.application.facade.dto.accountingengine.FinSetOfBookLineDTO;
import com.elitesland.fin.application.facade.param.accountingengine.FinJournalParam;
import com.elitesland.fin.application.facade.vo.accountingengine.FinJournalVO;
import com.elitesland.fin.repo.accountingengine.FinJournalRepo;
import com.elitesland.fin.repo.accountingengine.FinJournalRepoProc;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * @author gyj
 * @date 2023/10/10
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class FinJournalServiceImpl implements FinJournalService {


    private final FinJournalRepo finJournalRepo;

    private final FinJournalRepoProc finJournalRepoProc;
    private final FinSetOfBookService finSetOfBookService;
    private final FinSetOfBookLineService finSetOfBookLineService;



    @SysCodeProc
    @Override
    public PagingVO<FinJournalVO> page(FinJournalParam finJournalParam) {
        PagingVO<FinJournalVO> finJournalVOPagingVO = FinJournalConvert.INSTANCE.DTOToVO(finJournalRepoProc.page(finJournalParam));
        if(CollectionUtils.isNotEmpty(finJournalVOPagingVO.getRecords())){
            List<String> sobCodes = finJournalVOPagingVO.getRecords().stream().map(v -> v.getSobLedgerCode()).collect(Collectors.toList());
            List<FinSetOfBookDTO> finSetOfBookDTOS = finSetOfBookService.findBySobCodes(sobCodes);
            if(CollectionUtils.isEmpty(finSetOfBookDTOS)){
                return finJournalVOPagingVO;
            }
            List<Long> sobIds = finSetOfBookDTOS.stream().map(v -> v.getId()).collect(Collectors.toList());
            List<FinSetOfBookLineDTO> finSetOfBookLineDTOList = finSetOfBookLineService.findByMasIds(sobIds);
            if(CollectionUtils.isEmpty(finSetOfBookLineDTOList)){
                return finJournalVOPagingVO;
            }
            finSetOfBookLineDTOList=finSetOfBookLineDTOList.stream().filter(v->Boolean.TRUE.equals(v.getFlexibleFlag())&& StringUtils.isNotBlank(v.getFlexibleCode())).collect(Collectors.toList());
            if(CollectionUtils.isEmpty(finSetOfBookLineDTOList)){
                return finJournalVOPagingVO;
            }
            List<FinSetOfBookLineDTO> finSetOfBookLineDTOListFinal = finSetOfBookLineDTOList;
            Map<String, Map<String, FinSetOfBookLineDTO>> setOfBookLineMap = finSetOfBookDTOS.stream().collect(Collectors.toMap(v -> v.getSobCode(), v -> finSetOfBookLineDTOListFinal.stream().filter(w -> v.getId().equals(w.getMasId())).collect(Collectors.toMap(j -> j.getColumnName(), j -> j))));
            for (FinJournalVO record : finJournalVOPagingVO.getRecords()) {
                String sobLedgerCode = record.getSobLedgerCode();
                Map<String, FinSetOfBookLineDTO> stringFinSetOfBookLineDTOMap = setOfBookLineMap.get(sobLedgerCode);
                if(stringFinSetOfBookLineDTOMap!=null){
                    Set<String> SetOfBookLineColumnNames = stringFinSetOfBookLineDTOMap.keySet();

                }
            }
        }
        return finJournalVOPagingVO;
    }

}
