package com.elitesland.fin.application.service.aporder;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.param.aporder.ApOrderSaveParam;
import com.elitesland.fin.application.facade.param.aporder.FinApOrderDetailQuery;
import com.elitesland.fin.application.facade.vo.aporder.ApOrderDtlVO;
import com.elitesland.fin.application.facade.vo.aporder.ApOrderVO;
import com.elitesland.fin.domain.param.aporder.ApOrderPageParam;

import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.util.List;

/**
 * @author wang.xl
 * @version V1.0
 * @Package com.elitesland.fin.application.service.aporder
 * @date 2022/3/16 16:06
 */
public interface ApOrderService {

    PagingVO<ApOrderVO> page(ApOrderPageParam apOrderPageParam);

    ApOrderVO get(Long id);

    List<ApOrderVO> getBatch(List<Long> ids);

    ApiResult<Long> audit(Long id);

    ApiResult<Long> refush(List<Long> id, String content);

    ApiResult<Long> del(List<Long> ids);

    /**
     * 新增-应付单
     * 状态为草稿状态
     *
     * @param apOrderSaveParam
     * @return
     */
    ApiResult<Long> save(ApOrderSaveParam apOrderSaveParam);

    /**
     * 提交-校验明细金额，汇总金额，单头金额
     * 状态为-已提交
     *
     * @param apOrderSaveParam
     * @return
     */
    ApiResult<Long> commit(ApOrderSaveParam apOrderSaveParam);

    /**
     * 修改-应付单
     * @param apOrderSaveParam
     * @return
     */
    ApiResult<Long> update(ApOrderSaveParam apOrderSaveParam);

    /**
     * 获取应付单详情和明细汇总信息
     * @param id
     * @return
     */
    ApOrderVO getApOrderAndDtl(Long id);

    void exportExl(HttpServletResponse response, ApOrderPageParam apOrderPageParam);

    /**
     * 取消审批
     * @param ids
     * @return
     */
    ApiResult<Void> cancelApprove(List<Long> ids);

    /**
     * 红冲
     * @param id
     * @return
     */
    ApiResult<Long> redPunch(Long id);
    public PagingVO<ApOrderVO> writeoffPage(ApOrderPageParam apOrderPageParam);
    /**
     * 更新核销中金额.
     *
     * @param arDId 明细ID
     * @param amt   金额
     */
    void updateMiddleVerAmt(Long apDId, BigDecimal amt);

    /**
     * 更新核销金额.
     *
     * @param arDId 明细ID
     * @param amt   金额
     * @param verType   核销类型
     */
    void updateVerAmt(Long apDId, BigDecimal amt,String verType);

    /**
     * 查询明细集合.
     *
     * @param query 查询条件
     * @return 查询结果集
     */
    List<ApOrderDtlVO> listApOrderDetail(FinApOrderDetailQuery query);
}
