package com.elitesland.fin.application.service.arorder;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.map.MapUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.dto.resp.SysCurrencyRespDTO;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.fin.application.convert.arorder.ArOrderRecordConvert;
import com.elitesland.fin.application.facade.param.arorder.ApArOrderParam;
import com.elitesland.fin.common.FinConstant;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.domain.entity.aporder.ApOrder;
import com.elitesland.fin.domain.entity.aporder.ApOrderDtl;
import com.elitesland.fin.domain.entity.aporder.ApOrderDtlGroup;
import com.elitesland.fin.domain.entity.arorder.ArOrder;
import com.elitesland.fin.domain.entity.arorder.ArOrderDtl;
import com.elitesland.fin.domain.param.aptype.ApTypePageParam;
import com.elitesland.fin.domain.param.artype.ArTypePageParam;
import com.elitesland.fin.domain.service.aporder.ApOrderDomainService;
import com.elitesland.fin.domain.service.aptype.ApTypeDomainService;
import com.elitesland.fin.domain.service.aptype.ApTypeOuDomainService;
import com.elitesland.fin.domain.service.arorder.ArOrderDomainService;
import com.elitesland.fin.domain.service.artype.ArTypeDomainService;
import com.elitesland.fin.domain.service.artype.ArTypeOuDomainService;
import com.elitesland.fin.infr.dto.aptype.ApTypeDTO;
import com.elitesland.fin.infr.dto.aptype.ApTypeOuDTO;
import com.elitesland.fin.infr.dto.arorder.ApArOrderHandleDTO;
import com.elitesland.fin.infr.dto.artype.ArTypeDTO;
import com.elitesland.fin.infr.dto.artype.ArTypeOuDTO;
import com.elitesland.fin.rpc.pur.PurSuppOutService;
import com.elitesland.fin.rpc.sale.RmiSaleRpcService;
import com.elitesland.fin.rpc.system.SystemRpcService;
import com.elitesland.inv.dto.invTrn.InvTrnDRpcDTO;
import com.elitesland.inv.dto.invTrn.InvTrnDRpcDtoParam;
import com.elitesland.inv.dto.invstk.InvIoFinReceiptRpcDTO;
import com.elitesland.inv.dto.invstk.InvIoFinReceiptRpcDtoParam;
import com.elitesland.inv.dto.invstk.InvIoFinReceiptSaveRpcParam;
import com.elitesland.inv.provider.InvStkProvider;
import com.elitesland.inv.provider.InvTrnProvider;
import com.elitesland.order.param.SalDoDFinQueryDTO;
import com.elitesland.order.param.SalDoDFinRespDTO;
import com.elitesland.order.service.SalDoDRpcService;
import com.elitesland.pur.dto.gr.PurGrDParamRpcDTO;
import com.elitesland.pur.dto.gr.PurGrDRpcDTO;
import com.elitesland.pur.dto.supp.PurSuppBaseRpcDTO;
import com.elitesland.pur.provider.PurGrDProvider;
import com.elitesland.sale.api.vo.resp.crm.CustBaseDTO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.support.TransactionTemplate;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDateTime;
import java.util.*;
import java.util.stream.Collectors;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2024/03/27
 * @Version 1.0
 * @Content:
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class ApArOrderServiceImpl implements ApArOrderService{

    private final InvStkProvider invStkProvider;
    private final ArTypeDomainService arTypeDomainService;
    private final ArTypeOuDomainService arTypeOuDomainService;
    private final ApTypeDomainService apTypeDomainService;
    private final ApTypeOuDomainService apTypeOuDomainService;
    private final TransactionTemplate transactionTemplate;
    private final SystemRpcService systemRpcService;
    private final ArOrderDomainService arOrderDomainService;
    private final ApOrderDomainService apOrderDomainService;
    private final SalDoDRpcService salDoDRpcService;
    private final PurGrDProvider purGrDProvider;
    private final InvTrnProvider invTrnProvider;
    private final PurSuppOutService purSuppOutService;
    private final RmiSaleRpcService rmiSaleRpcService;

    /**
     * 逻辑性库存流水定时自动生成对应财务单据(应收单与应付单)
     *
     * @param param 入参
     * @return 出参
     */
    @Override
    public void logicInvIoJobAutoCreateApArOrder(String param){

        ApArOrderParam apArOrderParam = new ApArOrderParam();
        if (StringUtils.isNotBlank(param)) {
            JSONObject jsonObject = JSONObject.parseObject(param);
            ApArOrderParam apArOrderJobParam = JSONObject.toJavaObject(jsonObject, ApArOrderParam.class);
            if (Objects.nonNull(apArOrderJobParam)) {
                ArOrderRecordConvert.INSTANCE.oldApArOrderToNewParam(apArOrderJobParam,apArOrderParam);
            }
        }

        logicInvIoCreateApArOrder(apArOrderParam);
    }

    @Override
    public void logicInvIoCreateApArOrder(ApArOrderParam param) {
        log.info("登录人信息：{}", SecurityContextUtil.currentUser());
        log.info("逻辑性库存流水自动生成对应财务单据任务参数:{}", JSON.toJSONString(param));

        InvIoFinReceiptRpcDtoParam invIoFinReceiptRpcDtoParam = new InvIoFinReceiptRpcDtoParam();
        invIoFinReceiptRpcDtoParam.setIdList(null);
        invIoFinReceiptRpcDtoParam.setSceneCodeList(param.getSceneCodeList());
        invIoFinReceiptRpcDtoParam.setFinInterFlagList(param.getFinInterFlagList());
        List<InvIoFinReceiptRpcDTO> invIoFinReceiptRpcDTOList = invStkProvider.selectLogicInvIoByParam(invIoFinReceiptRpcDtoParam);
        if (CollectionUtil.isEmpty(invIoFinReceiptRpcDTOList)){
            log.info("未查询到逻辑性库存流水");
            return;
        }

        //库存流水生成的公司间应收单收款协议默认为供应商主数据上维护的付款协议。
        //库存流水生成的公司间应付单付款协议默认为供应商主数据上维护的付款协议。
        List<String> suppCodeList = invIoFinReceiptRpcDTOList.stream().map(InvIoFinReceiptRpcDTO::getSuppCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        Map<String, PurSuppBaseRpcDTO> suppMap = purSuppOutService.findSimpleSuppMapByCodes(suppCodeList);

        List<String> custCodeList = invIoFinReceiptRpcDTOList.stream().map(InvIoFinReceiptRpcDTO::getCustCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        Map<String, CustBaseDTO> custMap = rmiSaleRpcService.findBaseCustMapByCodes(custCodeList);

        Map<String, List<InvIoFinReceiptRpcDTO>> srcDocNoListMap = invIoFinReceiptRpcDTOList.stream().collect(Collectors.groupingBy(i -> i.getSrcDocNo()));
        for (Map.Entry<String, List<InvIoFinReceiptRpcDTO>> srcDocNoEntry : srcDocNoListMap.entrySet()) {

            String srcDocNoKey = srcDocNoEntry.getKey();
            List<InvIoFinReceiptRpcDTO> srcDocNoList = srcDocNoEntry.getValue();

            Boolean logicInvIoCreateFlag = false;
            //设置事务传播行为
            transactionTemplate.setPropagationBehavior(TransactionDefinition.PROPAGATION_REQUIRES_NEW);
            logicInvIoCreateFlag = transactionTemplate.execute(trans -> {
                //ApArOrderHandleDTO handleDTO = new ApArOrderHandleDTO();

                try {

                    List<InvIoFinReceiptRpcDTO> soLogicDeliveryList = srcDocNoList.stream().filter(invIoFinReceiptRpcDTO -> Objects.equals(invIoFinReceiptRpcDTO.getSceneCode(),FinConstant.SCENE_CODE_SO_LOGIC_DELIVERY)).collect(Collectors.toList());
                    List<InvIoFinReceiptRpcDTO> soLogicReceiptList = srcDocNoList.stream().filter(invIoFinReceiptRpcDTO -> Objects.equals(invIoFinReceiptRpcDTO.getSceneCode(),FinConstant.SCENE_CODE_SO_LOGIC_RECEIPT)).collect(Collectors.toList());
                    List<InvIoFinReceiptRpcDTO> poLogicReceiptList = srcDocNoList.stream().filter(invIoFinReceiptRpcDTO -> Objects.equals(invIoFinReceiptRpcDTO.getSceneCode(),FinConstant.SCENE_CODE_PO_LOGIC_RECEIPT)).collect(Collectors.toList());
                    List<InvIoFinReceiptRpcDTO> poLogicReturnList = srcDocNoList.stream().filter(invIoFinReceiptRpcDTO -> Objects.equals(invIoFinReceiptRpcDTO.getSceneCode(),FinConstant.SCENE_CODE_PO_LOGIC_RETURN)).collect(Collectors.toList());

                    //Map<String, List<InvIoFinReceiptRpcDTO>> spliceGroupListMap = srcDocNoList.stream().collect(Collectors.groupingBy(i -> arSpliceGroupKey(i)));

                    Map<String, List<InvIoFinReceiptRpcDTO>> soLogicDeliveryListMap = soLogicDeliveryList.stream().collect(Collectors.groupingBy(i -> arSpliceGroupKey(i)));
                    Map<String, List<InvIoFinReceiptRpcDTO>> soLogicReceiptListMap = soLogicReceiptList.stream().collect(Collectors.groupingBy(i -> arSpliceGroupKey(i)));
                    Map<String, List<InvIoFinReceiptRpcDTO>> poLogicReceiptListMap = poLogicReceiptList.stream().collect(Collectors.groupingBy(i -> apSpliceGroupKey(i)));
                    Map<String, List<InvIoFinReceiptRpcDTO>> poLogicReturnListMap = poLogicReturnList.stream().collect(Collectors.groupingBy(i -> apSpliceGroupKey(i)));

                    //src_doc_no生成应收单和应付单必须同时生成，并且含税金额相等

                    //ApArOrderHandleDTO apArOrderHandleDTO = new ApArOrderHandleDTO();
                    List<ArOrder> arOrderList = new ArrayList<>();
                    List<ApOrder> apOrderList = new ArrayList<>();

                    if (MapUtil.isNotEmpty(soLogicDeliveryListMap)){
                        ApArOrderHandleDTO soLogicDeliveryHandleDTO = logicInvIoHandle(soLogicDeliveryListMap,srcDocNoKey,suppMap,custMap);
                        arOrderList.addAll(soLogicDeliveryHandleDTO.getArOrderList());
                        apOrderList.addAll(soLogicDeliveryHandleDTO.getApOrderList());
                    }
                    if (MapUtil.isNotEmpty(soLogicReceiptListMap)){
                        ApArOrderHandleDTO soLogicReceiptHandleDTO = logicInvIoHandle(soLogicReceiptListMap,srcDocNoKey,suppMap,custMap);
                        arOrderList.addAll(soLogicReceiptHandleDTO.getArOrderList());
                        apOrderList.addAll(soLogicReceiptHandleDTO.getApOrderList());
                    }
                    if (MapUtil.isNotEmpty(poLogicReceiptListMap)){
                        ApArOrderHandleDTO poLogicReceiptHandleDTO = logicInvIoHandle(poLogicReceiptListMap,srcDocNoKey,suppMap,custMap);
                        arOrderList.addAll(poLogicReceiptHandleDTO.getArOrderList());
                        apOrderList.addAll(poLogicReceiptHandleDTO.getApOrderList());
                    }
                    if (MapUtil.isNotEmpty(poLogicReturnListMap)){
                        ApArOrderHandleDTO poLogicReturnHandleDTO = logicInvIoHandle(poLogicReturnListMap,srcDocNoKey,suppMap,custMap);
                        arOrderList.addAll(poLogicReturnHandleDTO.getArOrderList());
                        apOrderList.addAll(poLogicReturnHandleDTO.getApOrderList());
                    }


                    BigDecimal arAllTotalAmt = arOrderList.stream().filter(Objects::nonNull).map(ArOrder::getTotalAmt).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
                    BigDecimal apAllTotalAmt = apOrderList.stream().filter(Objects::nonNull).map(ApOrder::getTotalAmt).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);

                    if (arAllTotalAmt.compareTo(apAllTotalAmt) != 0 ){
                        log.error("来源单据编号: {} 逻辑性库存流水自动生成应收单和应付单的含税金额不相等",srcDocNoKey);
                        throw new BusinessException("来源单据编号:("+srcDocNoKey+")逻辑性库存流水自动生成应收单和应付单的含税金额不相等");
                    }


                    return true;
                } catch (Exception e) {
                    log.error("来源单据编号: {} 逻辑性库存流水自动生成对应财务单据发生错误,错误原因: {}",srcDocNoKey, e.getMessage());
                    trans.setRollbackOnly();
                    //throw new BusinessException("来源单据编号:("+srcDocNoKey+")生成对应财务单据失败:"+e.getMessage());
                }

                return false;
            });

            List<Long> invIoIds = srcDocNoList.stream().map(InvIoFinReceiptRpcDTO::getId).collect(Collectors.toList());
            InvIoFinReceiptSaveRpcParam invIoFinReceiptSaveRpcParam = new InvIoFinReceiptSaveRpcParam();
            invIoFinReceiptSaveRpcParam.setIdList(invIoIds);
            if (logicInvIoCreateFlag){
                invIoFinReceiptSaveRpcParam.setFinInterFlag(FinConstant.FIN_INTER_FLAG_1);
                invStkProvider.updateFinInterFlag(invIoFinReceiptSaveRpcParam);
            }else {
                invIoFinReceiptSaveRpcParam.setFinInterFlag(FinConstant.FIN_INTER_FLAG_2);
                invStkProvider.updateFinInterFlag(invIoFinReceiptSaveRpcParam);
            }
        }

    }

    private ApArOrderHandleDTO logicInvIoHandle(Map<String, List<InvIoFinReceiptRpcDTO>> spliceGroupListMap, String srcDocNoKey,
                                                Map<String, PurSuppBaseRpcDTO> suppMap,Map<String, CustBaseDTO> custMap){

        ApArOrderHandleDTO apArOrderHandleDTO = new ApArOrderHandleDTO();
        List<ArOrder> arOrderList = new ArrayList<>();
        List<ApOrder> apOrderList = new ArrayList<>();

        for (Map.Entry<String, List<InvIoFinReceiptRpcDTO>> spliceGroupEntry : spliceGroupListMap.entrySet()) {
            String spliceGroupKey = spliceGroupEntry.getKey();
            List<InvIoFinReceiptRpcDTO> spliceGroupList = spliceGroupEntry.getValue();

            //同一key的场景编码是一致的
            String sceneCode = spliceGroupList.get(0).getSceneCode();
            if (Objects.equals(sceneCode,FinConstant.SCENE_CODE_SO_LOGIC_DELIVERY)){
                ArOrder arOrder = assembleArOrder(spliceGroupList,custMap);
                arOrderList.add(arOrder);
            }else if (Objects.equals(sceneCode,FinConstant.SCENE_CODE_SO_LOGIC_RECEIPT)){
                ArOrder arOrder = assembleArOrder(spliceGroupList,custMap);
                arOrderList.add(arOrder);
            }else if (Objects.equals(sceneCode,FinConstant.SCENE_CODE_PO_LOGIC_RECEIPT)){
                ApOrder apOrder = assembleApOrder(spliceGroupList,suppMap);
                apOrderList.add(apOrder);
            }else if (Objects.equals(sceneCode,FinConstant.SCENE_CODE_PO_LOGIC_RETURN)){
                ApOrder apOrder = assembleApOrder(spliceGroupList,suppMap);
                apOrderList.add(apOrder);
            }else {
                log.info("该单号("+srcDocNoKey+")的场景码("+sceneCode+")未匹配到对应的逻辑性库存流水场景");
                throw new BusinessException("该单号("+srcDocNoKey+")的场景码("+sceneCode+")未匹配到对应的逻辑性库存流水场景");

            }

        }

        apArOrderHandleDTO.setArOrderList(arOrderList);
        apArOrderHandleDTO.setApOrderList(apOrderList);
        return apArOrderHandleDTO;

    }


    /**
     *
     *  应收单
     */
    private ArOrder assembleArOrder(List<InvIoFinReceiptRpcDTO> spliceGroupList,Map<String, CustBaseDTO> custMap){
        ArOrder arOrder = new ArOrder();

        InvIoFinReceiptRpcDTO invIoFinReceiptRpcDTO = spliceGroupList.get(0);
        String sceneCode = invIoFinReceiptRpcDTO.getSceneCode();


        //来源单据配库存流水  来源单据类型  取对应流水的场景码（逻辑性出入库那个）
        // 状态审核通过（流水都默认审核通过） 匹配后取对应的应收单类型
        ArTypeDTO arTypeDTO = selectArType(UdcEnum.FIN_AR_DOC_CLS_INVIO.getValueCode(),sceneCode,UdcEnum.DOC_STATUS_INVIO_SUCCESS.getValueCode(),invIoFinReceiptRpcDTO.getOuId(),invIoFinReceiptRpcDTO.getOuCode());
        //是否自动审核
        Boolean isAuto = arTypeDTO.getAutoAudit();

        arOrder.setSourceNo(invIoFinReceiptRpcDTO.getSrcDocNo());
        //自动生成
        arOrder.setArOrderNo(null);
        arOrder.setOuCode(invIoFinReceiptRpcDTO.getOuCode());
        arOrder.setOuId(invIoFinReceiptRpcDTO.getOuId());
        arOrder.setOuName(invIoFinReceiptRpcDTO.getOuName());
        arOrder.setCreateMode(invIoFinReceiptRpcDTO.getSrcDocCls());
        arOrder.setArTypeId(arTypeDTO.getId());
        arOrder.setArTypeName(arTypeDTO.getArTypeName());
        arOrder.setArTypeCode(arTypeDTO.getArTypeCode());
        if (isAuto) {
            arOrder.setOrderState(UdcEnum.APPLY_STATUS_COMPLETE.getValueCode());
        }else {
            arOrder.setOrderState(UdcEnum.APPLY_STATUS_DRAFT.getValueCode());
        }

        arOrder.setBuDate(invIoFinReceiptRpcDTO.getIoDate());

        arOrder.setCurrCode(invIoFinReceiptRpcDTO.getCurrCode());
        arOrder.setCurrName(invIoFinReceiptRpcDTO.getCurrCodeName());
        arOrder.setLocalCurrCode("CNY");
        arOrder.setLocalCurrName("人民币");
        arOrder.setAuditUserId(null);
        arOrder.setAuditUser(null);
        arOrder.setAuditDate(null);
        arOrder.setExchangeRate(null);
        arOrder.setOperUserId(null);
        arOrder.setOperator(null);
        arOrder.setTaxFlag(true);
        arOrder.setInitFlag(false);
        arOrder.setAuditRejection(null);
        arOrder.setCustId(invIoFinReceiptRpcDTO.getCustId());
        arOrder.setCustCode(invIoFinReceiptRpcDTO.getCustCode());
        arOrder.setCustName(invIoFinReceiptRpcDTO.getCustName());
        arOrder.setBuId(invIoFinReceiptRpcDTO.getBuId());
        arOrder.setBuCode(invIoFinReceiptRpcDTO.getBuCode());
        arOrder.setBuName(invIoFinReceiptRpcDTO.getBuName());
        arOrder.setBuType(null);
        //TODO 付款条件
        //arOrder.setPayMentName();
        //arOrder.setPayMentId();
        //arOrder.setPayMentCode();
        arOrder.setProtocolCode(null);
        arOrder.setVerState(UdcEnum.FIN_VERIFY_STATUS_AWAIT.getValueCode());
        arOrder.setVerAmt(BigDecimal.ZERO);
        arOrder.setOrgId(invIoFinReceiptRpcDTO.getBuId());
        arOrder.setOrgCode(invIoFinReceiptRpcDTO.getBuCode());
        arOrder.setOrgName(invIoFinReceiptRpcDTO.getBuName());
        arOrder.setSaleUserId(null);
        arOrder.setSaleUser(null);
        arOrder.setArOrderType(null);
        arOrder.setProcInstId(null);
        arOrder.setProcInstStatus(null);
        arOrder.setSubmitTime(invIoFinReceiptRpcDTO.getCreateTime());
        arOrder.setApprovedTime(null);

        arOrder.setDocType2("B");//B端订单
        if (Objects.equals(sceneCode,FinConstant.SCENE_CODE_SO_LOGIC_DELIVERY)){
            arOrder.setDocCls("SO");
        }else if (Objects.equals(sceneCode,FinConstant.SCENE_CODE_SO_LOGIC_RECEIPT)){
            arOrder.setDocCls("RSO");
        }
        /*arOrder.settenantId();
        arOrder.setBelongOrgId();
        arOrder.setTenantOrgId);
        arOrder.setRemark();*/
        arOrder.setCreateUserId(invIoFinReceiptRpcDTO.getCreateUserId());
        arOrder.setCreator(invIoFinReceiptRpcDTO.getCreator());
        arOrder.setCreateTime(invIoFinReceiptRpcDTO.getCreateTime());
        /*arOrder.setModifyUserId();
        arOrder.setUpdater();
        arOrder.setModifyTime();
        arOrder.setDeleteFlag();
        arOrder.setAuditDataVersion();
        arOrder.setSecBuId();
        arOrder.setSecUserId();
        arOrder.setSecOuId();*/
        arOrder.setSettlementType(null);
        String es1 = Objects.isNull(invIoFinReceiptRpcDTO.getCustId()) ? null : String.valueOf(invIoFinReceiptRpcDTO.getCustId());
        arOrder.setEs1(es1);
        arOrder.setEs2(null);
        arOrder.setEs3(null);
        arOrder.setEs4(null);
        arOrder.setEs5(null);
        arOrder.setEs6(UdcEnum.RED_STATE_NO.getValueCode());
        /*arOrder.setEs7();
        arOrder.setEs8();
        arOrder.setEs9();
        arOrder.setEs10();
        arOrder.RelateId();
        arOrder.setJournalState();*/


        String docType = null;
        //处理组装明细
        List<ArOrderDtl> arOrderDtlList = assembleArOrderDtl(arOrder,spliceGroupList,null,sceneCode,docType,custMap);
        arOrder.setDtlList(arOrderDtlList);
        //根据明细汇总
        BigDecimal totalAmt = arOrderDtlList.stream().map(ArOrderDtl::getTotalAmt).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal exclTaxAmt = arOrderDtlList.stream().map(ArOrderDtl::getExclTaxAmt).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal taxAmt = arOrderDtlList.stream().map(ArOrderDtl::getTaxAmt).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal totalCurAmt = arOrderDtlList.stream().map(ArOrderDtl::getTotalCurAmt).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal exclTaxCurAmt = arOrderDtlList.stream().map(ArOrderDtl::getExclTaxCurAmt).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal taxCurAmt = arOrderDtlList.stream().map(ArOrderDtl::getTaxCurAmt).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);

        arOrder.setTotalAmt(totalAmt);
        arOrder.setExclTaxAmt(exclTaxAmt);
        arOrder.setTaxAmt(taxAmt);
        arOrder.setTotalCurAmt(totalCurAmt);
        arOrder.setExclTaxCurAmt(exclTaxCurAmt);
        arOrder.setTaxCurAmt(taxCurAmt);


        //订单的UDC值 SY SY2
        //String docType = salDoDFinRespDTOList.get(0).getDocType();
        arOrder.setDocType(docType);

        Long arOrderId = null;
        //自动审核
        if (isAuto) {
            arOrder.setAuditDate(LocalDateTime.now());
            arOrder.setAuditUser("系统自动审核");
            SysUserDTO user = systemRpcService.getUserByName("admin");
            arOrder.setAuditUserId(user.getId());
            arOrderId = arOrderDomainService.commit(arOrder, isAuto);
        }else {
            //新增为草稿
            arOrderId = arOrderDomainService.save(arOrder);
        }

        return arOrder;
    }

    /**
     *
     *  应收单明细
     */
    private List<ArOrderDtl> assembleArOrderDtl(ArOrder arOrder,List<InvIoFinReceiptRpcDTO> spliceGroupList,
                                                Long masId, String sceneCode,String docType,Map<String, CustBaseDTO> custMap){

        List<Long> purGrdIds = spliceGroupList.stream().filter(invIoSpliceGroupDto ->
                Objects.equals(invIoSpliceGroupDto.getSrcDocCls(),UdcEnum.DOC_CLS_GR.getValueCode()) ||
                        Objects.equals(invIoSpliceGroupDto.getSrcDocCls(),UdcEnum.DOC_CLS_RGR.getValueCode()))
                .map(InvIoFinReceiptRpcDTO::getSrcDocDid).distinct().collect(Collectors.toList());
        List<PurGrDRpcDTO> purGrDRpcDTOList = selectPurGrdById(purGrdIds);

        List<Long> salDodIds = spliceGroupList.stream().filter(invIoSpliceGroupDto ->
                Objects.equals(invIoSpliceGroupDto.getSrcDocCls(),UdcEnum.DOC_CLS_DO.getValueCode()) ||
                        Objects.equals(invIoSpliceGroupDto.getSrcDocCls(),UdcEnum.DOC_CLS_RDO.getValueCode()))
                .map(InvIoFinReceiptRpcDTO::getSrcDocDid).distinct().collect(Collectors.toList());
        List<SalDoDFinRespDTO> salDoDRpcDTOList = selectSalDodById(salDodIds);

        if (CollectionUtil.isNotEmpty(salDoDRpcDTOList)){
            docType = salDoDRpcDTOList.get(0).getDocType();
        }

        List<Long> invTrndIds = spliceGroupList.stream().filter(invIoSpliceGroupDto ->
                Objects.equals(invIoSpliceGroupDto.getSrcDocCls(),UdcEnum.DOC_CLS_STKTRN.getValueCode()))
                .map(InvIoFinReceiptRpcDTO::getSrcDocDid).distinct().collect(Collectors.toList());
        List<InvTrnDRpcDTO> invTrnDRpcDTOList = selectInvTrndById(invTrndIds);

        Map<Long,PurGrDRpcDTO> purGrDMap = CollectionUtil.isEmpty(purGrDRpcDTOList) ? new HashMap<>() : purGrDRpcDTOList.stream().collect(Collectors.toMap(PurGrDRpcDTO::getId, t -> t, (t1, t2) -> t1));
        Map<Long,SalDoDFinRespDTO> salDoDMap = CollectionUtil.isEmpty(salDoDRpcDTOList) ? new HashMap<>() : salDoDRpcDTOList.stream().collect(Collectors.toMap(SalDoDFinRespDTO::getId, t -> t, (t1, t2) -> t1));
        Map<Long,InvTrnDRpcDTO> invTrnDMap = CollectionUtil.isEmpty(invTrnDRpcDTOList) ? new HashMap<>() : invTrnDRpcDTOList.stream().collect(Collectors.toMap(InvTrnDRpcDTO::getId, t -> t, (t1, t2) -> t1));

        Set<String> currCodes = new HashSet<>();
        if (CollectionUtil.isNotEmpty(purGrDRpcDTOList)){
            Set<String> purGrCurrCodes = purGrDRpcDTOList.stream().map(PurGrDRpcDTO::getCurrCode).filter(Objects::nonNull).distinct().collect(Collectors.toSet());
            if (CollectionUtil.isNotEmpty(purGrCurrCodes)){
                currCodes.addAll(purGrCurrCodes);
            }
        }
        if (CollectionUtil.isNotEmpty(salDoDRpcDTOList)){
            Set<String> salDoCurrCodes = salDoDRpcDTOList.stream().map(SalDoDFinRespDTO::getCurrCode).filter(Objects::nonNull).distinct().collect(Collectors.toSet());
            if (CollectionUtil.isNotEmpty(salDoCurrCodes)){
                currCodes.addAll(salDoCurrCodes);
            }
        }

        Map<String, String> currMap = selectCurrByCode(currCodes);

        List<ArOrderDtl> arOrderDtlList = spliceGroupList.stream().map(invIoFinReceiptRpcDTO -> {
            PurGrDRpcDTO purGrDRpcDTO = purGrDMap.get(invIoFinReceiptRpcDTO.getSrcDocDid());
            SalDoDFinRespDTO salDoDRpcDTO = salDoDMap.get(invIoFinReceiptRpcDTO.getSrcDocDid());
            InvTrnDRpcDTO invTrnDRpcDTO = invTrnDMap.get(invIoFinReceiptRpcDTO.getSrcDocDid());

            CustBaseDTO custBaseDTO = custMap.get(invIoFinReceiptRpcDTO.getCustCode());

            ArOrderDtl arOrderDtl = new ArOrderDtl();
            arOrderDtl.setId(null);
            arOrderDtl.setMasId(masId);
            arOrderDtl.setSourceNo(invIoFinReceiptRpcDTO.getSrcDocNo());
            //根据inv_io.src_doc_did获取

            Boolean purGrdFlag = false;
            if (Objects.equals(invIoFinReceiptRpcDTO.getSrcDocCls(),UdcEnum.DOC_CLS_GR.getValueCode()) ||
                    Objects.equals(invIoFinReceiptRpcDTO.getSrcDocCls(),UdcEnum.DOC_CLS_RGR.getValueCode())){
                purGrdFlag = true;
            }
            Boolean salDodFlag = false;
            if (Objects.equals(invIoFinReceiptRpcDTO.getSrcDocCls(),UdcEnum.DOC_CLS_DO.getValueCode()) ||
                    Objects.equals(invIoFinReceiptRpcDTO.getSrcDocCls(),UdcEnum.DOC_CLS_RDO.getValueCode())){
                salDodFlag = true;
            }

            if (purGrdFlag && Objects.nonNull(purGrDRpcDTO)){
                if (Objects.nonNull(purGrDRpcDTO.getLineNo())){
                    arOrderDtl.setSourceLine(purGrDRpcDTO.getLineNo().intValue());
                }
                if (StringUtils.isNotBlank(purGrDRpcDTO.getCurrCode())) {
                    arOrder.setCurrCode(purGrDRpcDTO.getCurrCode());
                    arOrder.setCurrName(currMap.get(purGrDRpcDTO.getCurrCode()));
                }
                if (Objects.nonNull(purGrDRpcDTO.getCurrRate())){
                    arOrder.setExchangeRate(BigDecimal.valueOf(purGrDRpcDTO.getCurrRate()));
                }

            }else if (salDodFlag && Objects.nonNull(salDoDRpcDTO)){
                if (Objects.nonNull(salDoDRpcDTO.getLineNo())){
                    arOrderDtl.setSourceLine(salDoDRpcDTO.getLineNo().intValue());
                }
                if (StringUtils.isNotBlank(salDoDRpcDTO.getCurrCode())) {
                    arOrder.setCurrCode(salDoDRpcDTO.getCurrCode());
                    arOrder.setCurrName(currMap.get(salDoDRpcDTO.getCurrCode()));

                }
                if (Objects.nonNull(salDoDRpcDTO.getCurrRate())){
                    arOrder.setExchangeRate(salDoDRpcDTO.getCurrRate());
                }
                if (Objects.nonNull(salDoDRpcDTO.getAgentEmpId())){
                    arOrder.setSaleUserId(salDoDRpcDTO.getAgentEmpId());
                    arOrder.setSaleUser(salDoDRpcDTO.getAgentName());
                }

            }else if (Objects.equals(invIoFinReceiptRpcDTO.getSrcDocCls(),UdcEnum.DOC_CLS_STKTRN.getValueCode())){
                if (Objects.nonNull(invTrnDRpcDTO) && Objects.nonNull(invTrnDRpcDTO.getLineNo())){
                    arOrderDtl.setSourceLine(invTrnDRpcDTO.getLineNo().intValue());
                }

                // TODO 库存调拨单没有币种，先默认人民币
                arOrder.setCurrCode("CNY");
                arOrder.setCurrName("人民币");
                arOrder.setExchangeRate(BigDecimal.ONE);

            }else {
                arOrderDtl.setSourceLine(null);
            }


            arOrderDtl.setItemId(invIoFinReceiptRpcDTO.getItemId());
            arOrderDtl.setItemCode(invIoFinReceiptRpcDTO.getItemCode());
            arOrderDtl.setItemName(invIoFinReceiptRpcDTO.getItemName());
            //库存流水没有就根据对应发货单明细查找
            arOrderDtl.setItemType(invIoFinReceiptRpcDTO.getSpec());
            //库存流水没有就根据对应发货单明细查找
            arOrderDtl.setSmallCateCode(invIoFinReceiptRpcDTO.getItemCateCode());
            arOrderDtl.setSmallCateName(invIoFinReceiptRpcDTO.getItemCateName());
            arOrderDtl.setUom(invIoFinReceiptRpcDTO.getUom());
            arOrderDtl.setUomName(invIoFinReceiptRpcDTO.getUomName());

            BigDecimal qty = invIoFinReceiptRpcDTO.getQty().abs();

            BigDecimal price = invIoFinReceiptRpcDTO.getSalePrice();
            BigDecimal taxRate = invIoFinReceiptRpcDTO.getTaxRateOut();
            if(Objects.isNull(price)){
                log.info("流水("+invIoFinReceiptRpcDTO.getId()+")的含税单价为空");
                throw new BusinessException("流水("+invIoFinReceiptRpcDTO.getId()+")的含税单价为空");
            }
            if(Objects.isNull(taxRate)){
                log.info("流水("+invIoFinReceiptRpcDTO.getId()+")的税率为空");
                throw new BusinessException("流水("+invIoFinReceiptRpcDTO.getId()+")的税率为空");
            }
            BigDecimal exclTaxPrice = price.divide((BigDecimal.ONE.add(taxRate)), 6, RoundingMode.HALF_UP);
            BigDecimal totalAmt = price.multiply(qty).setScale(2, RoundingMode.HALF_UP);
            BigDecimal exclTaxAmt = totalAmt.divide((BigDecimal.ONE.add(taxRate)),2, RoundingMode.HALF_UP);
            BigDecimal taxAmt = totalAmt.subtract(exclTaxAmt).setScale(2, RoundingMode.HALF_UP);

            if (Objects.equals(sceneCode,FinConstant.SCENE_CODE_SO_LOGIC_DELIVERY)){
                arOrderDtl.setQty(qty);
                arOrderDtl.setExclTaxPrice(exclTaxPrice);
                arOrderDtl.setPrice(price);
                arOrderDtl.setTaxRate(taxRate);
                arOrderDtl.setTotalAmt(totalAmt);
                arOrderDtl.setExclTaxAmt(exclTaxAmt);
                arOrderDtl.setTaxAmt(taxAmt);
                arOrderDtl.setTotalCurAmt(totalAmt);
                arOrderDtl.setExclTaxCurAmt(exclTaxAmt);
                arOrderDtl.setTaxCurAmt(taxAmt);
            }else if (Objects.equals(sceneCode,FinConstant.SCENE_CODE_SO_LOGIC_RECEIPT)){
                arOrderDtl.setQty(qty.negate());
                arOrderDtl.setExclTaxPrice(exclTaxPrice);
                arOrderDtl.setPrice(price);
                arOrderDtl.setTaxRate(taxRate);
                arOrderDtl.setTotalAmt(totalAmt.negate());
                arOrderDtl.setExclTaxAmt(exclTaxAmt.negate());
                arOrderDtl.setTaxAmt(taxAmt.negate());
                arOrderDtl.setTotalCurAmt(totalAmt.negate());
                arOrderDtl.setExclTaxCurAmt(exclTaxAmt.negate());
                arOrderDtl.setTaxCurAmt(taxAmt.negate());
            }


            arOrderDtl.setBuCode(null);
            arOrderDtl.setBuId(null);
            arOrderDtl.setBuName(null);
            arOrderDtl.setExpensesType(null);
             /*arOrderDtl.settenantId();
            arOrderDtl.setBelongOrgId();
            arOrderDtl.setTenantOrgId);
            arOrderDtl.setRemark();*/
            arOrderDtl.setCreateUserId(invIoFinReceiptRpcDTO.getCreateUserId());
            arOrderDtl.setCreator(invIoFinReceiptRpcDTO.getCreator());
            arOrderDtl.setCreateTime(invIoFinReceiptRpcDTO.getCreateTime());
            /*arOrderDtl.setModifyUserId();
            arOrderDtl.setUpdater();
            arOrderDtl.setModifyTime();
            arOrderDtl.setDeleteFlag();
            arOrderDtl.setAuditDataVersion();
            arOrderDtl.setSecBuId();
            arOrderDtl.setSecUserId();
            arOrderDtl.setSecOuId();*/
            arOrderDtl.setEs11(invIoFinReceiptRpcDTO.getSrcDocNo());
            arOrderDtl.setEs12(invIoFinReceiptRpcDTO.getSrcDocDid());
            arOrderDtl.setEs13(String.valueOf(invIoFinReceiptRpcDTO.getCustId()));
            arOrderDtl.setEs14(invIoFinReceiptRpcDTO.getCustCode());
            arOrderDtl.setEs15(null);
            arOrderDtl.setEs16(null);
            arOrderDtl.setEs17(null);
            arOrderDtl.setEs18(null);
            arOrderDtl.setEs19(null);
            if (Objects.nonNull(custBaseDTO)){
                if (StringUtils.isBlank(custBaseDTO.getPaymentTerm())){
                    throw new BusinessException("流水("+invIoFinReceiptRpcDTO.getId()+")的客户("+invIoFinReceiptRpcDTO.getCustCode()+")的收款协议为空");

                }else {
                    arOrderDtl.setEs19(custBaseDTO.getPaymentTerm());
                    arOrderDtl.setProtocolCode(custBaseDTO.getPaymentTerm());
                }

            }else {
                throw new BusinessException("流水("+invIoFinReceiptRpcDTO.getId()+")的客户信息不存在");

            }
            arOrderDtl.setEs20(null);
            arOrderDtl.setEs21(null);
            arOrderDtl.setEs22(null);
            arOrderDtl.setEs23(null);
            arOrderDtl.setEs24(null);
            //arOrderDtl.setEs25();
            arOrderDtl.setRelateId(null);

            return arOrderDtl;
        }).collect(Collectors.toList());

        return arOrderDtlList;
    }

    /**
     *
     *  应付单
     */
    private ApOrder assembleApOrder(List<InvIoFinReceiptRpcDTO> spliceGroupList,Map<String, PurSuppBaseRpcDTO> suppMap){
        ApOrder apOrder = new ApOrder();

        InvIoFinReceiptRpcDTO invIoFinReceiptRpcDTO = spliceGroupList.get(0);
        String sceneCode = invIoFinReceiptRpcDTO.getSceneCode();

        apOrder.setId(null);
        apOrder.setSourceNo(invIoFinReceiptRpcDTO.getSrcDocNo());
        //自动生成
        apOrder.setApOrderNo(null);
        apOrder.setOuCode(invIoFinReceiptRpcDTO.getOuCode());
        apOrder.setOuId(invIoFinReceiptRpcDTO.getOuId());
        apOrder.setOuName(invIoFinReceiptRpcDTO.getOuName());
        apOrder.setCreateMode(invIoFinReceiptRpcDTO.getSrcDocCls());

        //来源单据配库存流水  来源单据类型  取对应流水的场景码（逻辑性出入库那个）
        // 状态审核通过（流水都默认审核通过） 匹配后取对应的应收单类型
        // 应付单怎么匹配类型配置，没有自动审核 传一个默认编码
        ApTypeDTO apTypeDTO = selectApType(UdcEnum.FIN_AR_DOC_CLS_INVIO.getValueCode(),sceneCode,UdcEnum.DOC_STATUS_INVIO_SUCCESS.getValueCode(),invIoFinReceiptRpcDTO.getOuId(),invIoFinReceiptRpcDTO.getOuCode());
        //是否自动审核
        //Boolean isAuto = apTypeDTO.getAutoAudit();
        Boolean isAuto = false;

        apOrder.setApTypeId(apTypeDTO.getId());
        apOrder.setApTypeCode(apTypeDTO.getApTypeCode());
        apOrder.setApTypeName(apTypeDTO.getApTypeName());
        if (isAuto) {
            apOrder.setOrderState(UdcEnum.APPLY_STATUS_COMPLETE.getValueCode());
        }else {
            apOrder.setOrderState(UdcEnum.APPLY_STATUS_DRAFT.getValueCode());
        }
        apOrder.setBuDate(invIoFinReceiptRpcDTO.getIoDate());

        apOrder.setCurrCode(invIoFinReceiptRpcDTO.getCurrCode());
        apOrder.setCurrName(invIoFinReceiptRpcDTO.getCurrCodeName());
        apOrder.setAuditUserId(null);
        apOrder.setAuditUser(null);
        apOrder.setAuditDate(null);
        apOrder.setExchangeRate(null);
        apOrder.setOperUserId(null);
        apOrder.setOperator(null);
        apOrder.setTaxFlag(true);
        apOrder.setInitFlag(false);
        apOrder.setAuditRejection(null);
        apOrder.setSuppId(invIoFinReceiptRpcDTO.getSuppId());
        apOrder.setSuppCode(invIoFinReceiptRpcDTO.getSuppCode());
        apOrder.setSuppName(invIoFinReceiptRpcDTO.getSuppName());
        apOrder.setBuId(invIoFinReceiptRpcDTO.getBuId());
        apOrder.setBuCode(invIoFinReceiptRpcDTO.getBuCode());
        apOrder.setBuName(invIoFinReceiptRpcDTO.getBuName());
        apOrder.setBuType(null);
        //TODO 付款条件
        apOrder.setPayMentName("立即");
        apOrder.setPayMentId("1");
        apOrder.setPayMentCode(" A00");
        apOrder.setProtocolCode(null);
        apOrder.setTaxRate(null);
        apOrder.setLocalCurrCode(invIoFinReceiptRpcDTO.getCurrCode());
        apOrder.setLocalCurrName(invIoFinReceiptRpcDTO.getCurrCodeName());
        apOrder.setVerState((UdcEnum.FIN_VERIFY_STATUS_AWAIT.getValueCode()));
        apOrder.setVerAmt(BigDecimal.ZERO);
        apOrder.setProcInstId(null);
        apOrder.setProcInstStatus(null);
        apOrder.setSubmitTime(invIoFinReceiptRpcDTO.getCreateTime());
        apOrder.setApprovedTime(null);
        apOrder.setAddrNo(null);
        apOrder.setSuppAddrNo(null);
        /*apOrder.setTenantId();
        apOrder.setBelongOrgId();
        apOrder.setTenantOrgId);
        apOrder.setRemark();*/
        apOrder.setCreateUserId(invIoFinReceiptRpcDTO.getCreateUserId());
        apOrder.setCreator(invIoFinReceiptRpcDTO.getCreator());
        apOrder.setCreateTime(invIoFinReceiptRpcDTO.getCreateTime());
        /*apOrder.setModifyUserId();
        apOrder.setUpdater();
        apOrder.setModifyTime();
        apOrder.setDeleteFlag();
        apOrder.setAuditDataVersion();
        apOrder.setSecBuId();
        apOrder.setSecUserId();
        apOrder.setSecOuId();*/
        //List<Long> srcDocDids = spliceGroupList.stream().map(InvIoFinReceiptRpcDTO::getSrcDocDid).distinct().collect(Collectors.toList());




        List<ApOrderDtl> apOrderDtlList = assembleApOrderDtl(apOrder,spliceGroupList,null,sceneCode,suppMap);
        apOrder.setApOrderDtlList(apOrderDtlList);
        //根据明细汇总
        BigDecimal totalAmt = apOrderDtlList.stream().map(ApOrderDtl::getTotalAmt).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal exclTaxAmt = apOrderDtlList.stream().map(ApOrderDtl::getExclTaxAmt).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal taxAmt = apOrderDtlList.stream().map(ApOrderDtl::getTaxAmt).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal totalCurAmt = apOrderDtlList.stream().map(ApOrderDtl::getTotalCurAmt).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal exclTaxCurAmt = apOrderDtlList.stream().map(ApOrderDtl::getExclTaxCurAmt).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal taxCurAmt = apOrderDtlList.stream().map(ApOrderDtl::getTaxCurAmt).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);

        apOrder.setTotalAmt(totalAmt);
        apOrder.setExclTaxAmt(exclTaxAmt);
        apOrder.setTaxAmt(taxAmt);
        apOrder.setTotalCurAmt(totalCurAmt);
        apOrder.setExclTaxCurAmt(exclTaxCurAmt);
        apOrder.setTaxCurAmt(taxCurAmt);


        // 汇总列表数据添加
        List<ApOrderDtlGroup> apOrderDtlGroups = this.genDtlGroup(apOrder);
        apOrder.setApOrderDtlGroupList(apOrderDtlGroups);



        Long apOrderId = null;
        //TODO 应付单目前没有自动审核，
        //自动审核
        if (isAuto) {
            apOrder.setAuditDate(LocalDateTime.now());
            apOrder.setAuditUser("系统自动审核");
            SysUserDTO user = systemRpcService.getUserByName("admin");
            apOrder.setAuditUserId(user.getId());
            //apOrderId = apOrderDomainService.commit(apOrder);

        }else {
            //新增为草稿
            apOrderId = apOrderDomainService.save(apOrder);
        }

        return apOrder;
    }

    /**
     *
     *  应付单明细
     */
    private List<ApOrderDtl> assembleApOrderDtl( ApOrder apOrder,List<InvIoFinReceiptRpcDTO> spliceGroupList,
                                                Long masId, String sceneCode,Map<String, PurSuppBaseRpcDTO> suppMap){

        List<Long> purGrdIds = spliceGroupList.stream().filter(invIoSpliceGroupDto ->
                Objects.equals(invIoSpliceGroupDto.getSrcDocCls(),UdcEnum.DOC_CLS_GR.getValueCode()) ||
                        Objects.equals(invIoSpliceGroupDto.getSrcDocCls(),UdcEnum.DOC_CLS_RGR.getValueCode()))
                .map(InvIoFinReceiptRpcDTO::getSrcDocDid).distinct().collect(Collectors.toList());
        List<PurGrDRpcDTO> purGrDRpcDTOList = selectPurGrdById(purGrdIds);

        List<Long> salDodIds = spliceGroupList.stream().filter(invIoSpliceGroupDto ->
                Objects.equals(invIoSpliceGroupDto.getSrcDocCls(),UdcEnum.DOC_CLS_DO.getValueCode()) ||
                        Objects.equals(invIoSpliceGroupDto.getSrcDocCls(),UdcEnum.DOC_CLS_RDO.getValueCode()))
                .map(InvIoFinReceiptRpcDTO::getSrcDocDid).distinct().collect(Collectors.toList());
        List<SalDoDFinRespDTO> salDoDRpcDTOList = selectSalDodById(salDodIds);

        List<Long> invTrndIds = spliceGroupList.stream().filter(invIoSpliceGroupDto ->
                Objects.equals(invIoSpliceGroupDto.getSrcDocCls(),UdcEnum.DOC_CLS_STKTRN.getValueCode()))
                .map(InvIoFinReceiptRpcDTO::getSrcDocDid).distinct().collect(Collectors.toList());
        List<InvTrnDRpcDTO> invTrnDRpcDTOList = selectInvTrndById(invTrndIds);

        Map<Long,PurGrDRpcDTO> purGrDMap = CollectionUtil.isEmpty(purGrDRpcDTOList) ? new HashMap<>() : purGrDRpcDTOList.stream().collect(Collectors.toMap(PurGrDRpcDTO::getId, t -> t, (t1, t2) -> t1));
        Map<Long,SalDoDFinRespDTO> salDoDMap = CollectionUtil.isEmpty(salDoDRpcDTOList) ? new HashMap<>() : salDoDRpcDTOList.stream().collect(Collectors.toMap(SalDoDFinRespDTO::getId, t -> t, (t1, t2) -> t1));
        Map<Long,InvTrnDRpcDTO> invTrnDMap = CollectionUtil.isEmpty(invTrnDRpcDTOList) ? new HashMap<>() : invTrnDRpcDTOList.stream().collect(Collectors.toMap(InvTrnDRpcDTO::getId, t -> t, (t1, t2) -> t1));

        Set<String> currCodes = new HashSet<>();
        if (CollectionUtil.isNotEmpty(purGrDRpcDTOList)){
            Set<String> purGrCurrCodes = purGrDRpcDTOList.stream().map(PurGrDRpcDTO::getCurrCode).filter(Objects::nonNull).distinct().collect(Collectors.toSet());
            if (CollectionUtil.isNotEmpty(purGrCurrCodes)){
                currCodes.addAll(purGrCurrCodes);
            }
        }
        if (CollectionUtil.isNotEmpty(salDoDRpcDTOList)){
            Set<String> salDoCurrCodes = salDoDRpcDTOList.stream().map(SalDoDFinRespDTO::getCurrCode).filter(Objects::nonNull).distinct().collect(Collectors.toSet());
            if (CollectionUtil.isNotEmpty(salDoCurrCodes)){
                currCodes.addAll(salDoCurrCodes);
            }
        }
        Map<String, String> currMap = selectCurrByCode(currCodes);

        List<ApOrderDtl> apOrderDtlList = spliceGroupList.stream().map(invIoFinReceiptRpcDTO -> {
            PurGrDRpcDTO purGrDRpcDTO = purGrDMap.get(invIoFinReceiptRpcDTO.getSrcDocDid());
            SalDoDFinRespDTO salDoDRpcDTO = salDoDMap.get(invIoFinReceiptRpcDTO.getSrcDocDid());
            InvTrnDRpcDTO invTrnDRpcDTO = invTrnDMap.get(invIoFinReceiptRpcDTO.getSrcDocDid());
            PurSuppBaseRpcDTO purSuppBaseRpcDTO = suppMap.get(invIoFinReceiptRpcDTO.getSuppCode());

            ApOrderDtl apOrderDtl = new ApOrderDtl();

            //apOrderDtl.setId();
            apOrderDtl.setMasId(masId);
            apOrderDtl.setSourceNo(invIoFinReceiptRpcDTO.getSrcDocNo());
            //根据inv_io.src_doc_did获取
            Boolean purGrdFlag = false;
            if (Objects.equals(invIoFinReceiptRpcDTO.getSrcDocCls(),UdcEnum.DOC_CLS_GR.getValueCode()) ||
                    Objects.equals(invIoFinReceiptRpcDTO.getSrcDocCls(),UdcEnum.DOC_CLS_RGR.getValueCode())){
                purGrdFlag = true;
            }
            Boolean salDodFlag = false;
            if (Objects.equals(invIoFinReceiptRpcDTO.getSrcDocCls(),UdcEnum.DOC_CLS_DO.getValueCode()) ||
                    Objects.equals(invIoFinReceiptRpcDTO.getSrcDocCls(),UdcEnum.DOC_CLS_RDO.getValueCode())){
                salDodFlag = true;
            }

            if (purGrdFlag && Objects.nonNull(purGrDRpcDTO)){
                if (Objects.nonNull(purGrDRpcDTO.getLineNo())){
                    apOrderDtl.setSourceLine(purGrDRpcDTO.getLineNo().intValue());
                }
                if (StringUtils.isNotBlank(purGrDRpcDTO.getCurrCode())) {
                    apOrder.setCurrCode(purGrDRpcDTO.getCurrCode());
                    apOrder.setCurrName(currMap.get(purGrDRpcDTO.getCurrCode()));
                    apOrder.setLocalCurrCode(purGrDRpcDTO.getCurrCode());
                    apOrder.setLocalCurrName(currMap.get(purGrDRpcDTO.getCurrCode()));

                }
                if (Objects.nonNull(purGrDRpcDTO.getCurrRate())){
                    apOrder.setExchangeRate(BigDecimal.valueOf(purGrDRpcDTO.getCurrRate()));
                }

            }else if (salDodFlag && Objects.nonNull(salDoDRpcDTO)){
                if (Objects.nonNull(salDoDRpcDTO.getLineNo())){
                    apOrderDtl.setSourceLine(salDoDRpcDTO.getLineNo().intValue());
                }
                if (StringUtils.isNotBlank(salDoDRpcDTO.getCurrCode())) {
                    apOrder.setCurrCode(salDoDRpcDTO.getCurrCode());
                    apOrder.setCurrName(currMap.get(salDoDRpcDTO.getCurrCode()));
                    apOrder.setLocalCurrCode(salDoDRpcDTO.getCurrCode());
                    apOrder.setLocalCurrName(currMap.get(salDoDRpcDTO.getCurrCode()));

                }
                if (Objects.nonNull(salDoDRpcDTO.getCurrRate())){
                    apOrder.setExchangeRate(salDoDRpcDTO.getCurrRate());
                }
                if (Objects.nonNull(salDoDRpcDTO.getAgentEmpId())){
                    //apOrder.setSaleUserId(salDoDRpcDTO.getAgentEmpId());
                    //apOrder.setSaleUser(salDoDRpcDTO.getAgentName());
                }

            }else if (Objects.equals(invIoFinReceiptRpcDTO.getSrcDocCls(),UdcEnum.DOC_CLS_STKTRN.getValueCode())){
                if (Objects.nonNull(invTrnDRpcDTO) && Objects.nonNull(invTrnDRpcDTO.getLineNo())){
                    apOrderDtl.setSourceLine(invTrnDRpcDTO.getLineNo().intValue());
                }
                // TODO 库存调拨单没有币种，先默认人民币
                apOrder.setCurrCode("CNY");
                apOrder.setCurrName("人民币");
                apOrder.setLocalCurrCode("CNY");
                apOrder.setLocalCurrName("人民币");
                apOrder.setExchangeRate(BigDecimal.ONE);

            }else {
                apOrderDtl.setSourceLine(null);
            }
            apOrderDtl.setItemId(invIoFinReceiptRpcDTO.getItemId());
            apOrderDtl.setItemCode(invIoFinReceiptRpcDTO.getItemCode());
            apOrderDtl.setItemName(invIoFinReceiptRpcDTO.getItemName());
            // 库存流水没有就根据对应采购收货单明细查找
            apOrderDtl.setItemType(invIoFinReceiptRpcDTO.getSpec());
            // 库存流水没有就根据对应采购退货出库单明细查找
            apOrderDtl.setSmallCateCode(invIoFinReceiptRpcDTO.getItemCateCode());
            apOrderDtl.setSmallCateName(invIoFinReceiptRpcDTO.getItemCateName());
            apOrderDtl.setUom(invIoFinReceiptRpcDTO.getUom());
            apOrderDtl.setUomName(invIoFinReceiptRpcDTO.getUomName());

            BigDecimal qty = invIoFinReceiptRpcDTO.getQty().abs();

            BigDecimal price = invIoFinReceiptRpcDTO.getPurchsaPrice();
            BigDecimal taxRate = invIoFinReceiptRpcDTO.getTaxRate();
            if(Objects.isNull(price)){
                log.info("流水("+invIoFinReceiptRpcDTO.getId()+")的含税单价为空");
                throw new BusinessException("流水("+invIoFinReceiptRpcDTO.getId()+")的含税单价为空");
            }
            if(Objects.isNull(taxRate)){
                log.info("流水("+invIoFinReceiptRpcDTO.getId()+")的税率为空");
                throw new BusinessException("流水("+invIoFinReceiptRpcDTO.getId()+")的税率为空");
            }
            BigDecimal exclTaxPrice = price.divide((BigDecimal.ONE.add(taxRate)), 6, RoundingMode.HALF_UP);
            BigDecimal totalAmt = price.multiply(qty).setScale(2, RoundingMode.HALF_UP);
            BigDecimal exclTaxAmt = totalAmt.divide((BigDecimal.ONE.add(taxRate)),2, RoundingMode.HALF_UP);
            BigDecimal taxAmt = totalAmt.subtract(exclTaxAmt).setScale(2, RoundingMode.HALF_UP);

            if (Objects.equals(sceneCode,FinConstant.SCENE_CODE_PO_LOGIC_RECEIPT)){
                apOrderDtl.setQty(qty);
                apOrderDtl.setExclTaxPrice(exclTaxPrice);
                apOrderDtl.setPrice(price);
                apOrderDtl.setTaxRate(taxRate);
                apOrderDtl.setTotalAmt(totalAmt);
                apOrderDtl.setExclTaxAmt(exclTaxAmt);
                apOrderDtl.setTaxAmt(taxAmt);
                apOrderDtl.setTotalCurAmt(totalAmt);
                apOrderDtl.setExclTaxCurAmt(exclTaxAmt);
                apOrderDtl.setTaxCurAmt(taxAmt);
            }else if (Objects.equals(sceneCode,FinConstant.SCENE_CODE_PO_LOGIC_RETURN)){
                apOrderDtl.setQty(qty.negate());
                apOrderDtl.setExclTaxPrice(exclTaxPrice);
                apOrderDtl.setPrice(price);
                apOrderDtl.setTaxRate(taxRate);
                apOrderDtl.setTotalAmt(totalAmt.negate());
                apOrderDtl.setExclTaxAmt(exclTaxAmt.negate());
                apOrderDtl.setTaxAmt(taxAmt.negate());
                apOrderDtl.setTotalCurAmt(totalAmt.negate());
                apOrderDtl.setExclTaxCurAmt(exclTaxAmt.negate());
                apOrderDtl.setTaxCurAmt(taxAmt.negate());
            }


             /*apOrderDtl.setTenantId();
            apOrderDtl.setBelongOrgId();
            apOrderDtl.setTenantOrgId);
            apOrderDtl.setRemark();*/
            apOrderDtl.setCreateUserId(invIoFinReceiptRpcDTO.getCreateUserId());
            apOrderDtl.setCreator(invIoFinReceiptRpcDTO.getCreator());
            apOrderDtl.setCreateTime(invIoFinReceiptRpcDTO.getCreateTime());
            /*apOrderDtl.setModifyUserId();
            apOrderDtl.setUpdater();
            apOrderDtl.setModifyTime();
            apOrderDtl.setDeleteFlag();
            apOrderDtl.setAuditDataVersion();
            apOrderDtl.setSecBuId();
            apOrderDtl.setSecUserId();
            apOrderDtl.setSecOuId();*/
            apOrderDtl.setSourceNo(invIoFinReceiptRpcDTO.getSrcDocNo());
            // 没有这个字段
            apOrderDtl.setSourceNoDid(invIoFinReceiptRpcDTO.getSrcDocDid());
            if (Objects.nonNull(purSuppBaseRpcDTO)){
                if (StringUtils.isBlank(purSuppBaseRpcDTO.getProtocolCode())){
                    throw new BusinessException("流水("+invIoFinReceiptRpcDTO.getId()+")的供应商("+invIoFinReceiptRpcDTO.getSuppCode()+")的付款协议为空");

                }else {
                    apOrderDtl.setProtocolCode(purSuppBaseRpcDTO.getProtocolCode());
                }

            }else {
                throw new BusinessException("流水("+invIoFinReceiptRpcDTO.getId()+")的供应商不存在");

            }
            return apOrderDtl;
        }).collect(Collectors.toList());

        return apOrderDtlList;

    }


    /**
     * 根据明细生成汇总List
     *
     * @return
     */
    public List<ApOrderDtlGroup> genDtlGroup(ApOrder apOrder) {
        // 获取明细的List
        List<ApOrderDtl> res = apOrder.getApOrderDtlList();
        Map<String, List<ApOrderDtl>> collectMaps = res.stream().collect(Collectors.groupingBy(ApOrderDtl::getItemCode));
        List<ApOrderDtlGroup> resList = new ArrayList<>();
        for (Map.Entry<String,List<ApOrderDtl>> entry : collectMaps.entrySet()) {
            ApOrderDtlGroup apOrderDtlGroup = new ApOrderDtlGroup();
            List<ApOrderDtl> apOrderDtlList = entry.getValue();
            // 对集合中元素进行计算
            // 数量的总和
            BigDecimal qtySum = apOrderDtlList.stream().map(ApOrderDtl::getQty).reduce(BigDecimal.ZERO, BigDecimal::add);
            // 税额的总和
            BigDecimal taxAmtSum = apOrderDtlList.stream().map(ApOrderDtl::getTaxAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
            // 税额（本位币）taxCurAmt
            BigDecimal taxCurAmtSum = apOrderDtlList.stream().map(ApOrderDtl::getTaxCurAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
            // 不含税金额 exclTaxAmt
            BigDecimal exclTaxAmtSum = apOrderDtlList.stream().map(ApOrderDtl::getExclTaxAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
            // 不含税金额（本位币）exclTaxCurAmt
            BigDecimal exclTaxCurAmtSum = apOrderDtlList.stream().map(ApOrderDtl::getExclTaxCurAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
            // 含税金额 totalAmt
            BigDecimal totalAmtSum = apOrderDtlList.stream().map(ApOrderDtl::getTotalAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
            // 含税金额（本位币）totalCurAmt
            BigDecimal totalCurAmtSum = apOrderDtlList.stream().map(ApOrderDtl::getTotalCurAmt).reduce(BigDecimal.ZERO, BigDecimal::add);

            // 拼接返回对象
            apOrderDtlGroup.setItemId(apOrderDtlList.get(0).getItemId());
            apOrderDtlGroup.setItemCode(apOrderDtlList.get(0).getItemCode());
            apOrderDtlGroup.setItemName(apOrderDtlList.get(0).getItemName());
            apOrderDtlGroup.setSmallCateCode(apOrderDtlList.get(0).getSmallCateCode());
            apOrderDtlGroup.setSmallCateName(apOrderDtlList.get(0).getSmallCateName());
            apOrderDtlGroup.setQty(qtySum);
            apOrderDtlGroup.setTotalAmt(totalAmtSum);
            apOrderDtlGroup.setExclTaxAmt(exclTaxAmtSum);
            apOrderDtlGroup.setTaxAmt(taxAmtSum);
            apOrderDtlGroup.setTotalCurAmt(totalCurAmtSum);
            apOrderDtlGroup.setExclTaxCurAmt(exclTaxCurAmtSum);
            apOrderDtlGroup.setTaxCurAmt(taxCurAmtSum);
            resList.add(apOrderDtlGroup);
            // 页面选择参数 (设置费用部门/费用类型)
        }
        return resList;
    }


    /**
     * 查询应收单类型的配置规则
     *
     * @param sourceDoc 来源单据
     * @param sourceDocType 来源单据类型
     * @param sourceDocStatus 来源单据状态
     * @param ouId 公司ID
     * @param ouCode 公司编码
     * @return
     */
    private ArTypeDTO selectArType(String sourceDoc,String sourceDocType,String sourceDocStatus,Long ouId,String ouCode){

        //1.来源单据，来源单据类型，来源单据状态等入参，调用该接口时判断是否命中应收单类型的配置规则
        ArTypePageParam arTypePageParam = new ArTypePageParam();
        arTypePageParam.setSourceDoc(sourceDoc);
        arTypePageParam.setSourceDocType(sourceDocType);
        arTypePageParam.setSourceDocStatus(sourceDocStatus);
        List<ArTypeDTO> arTypeDTOList = arTypeDomainService.arOrderAutoSelectMatchByParam(arTypePageParam);
        if (CollectionUtil.isEmpty(arTypeDTOList)){
            log.error("未匹配到应收单类型的配置规则, 来源单据: {},来源单据类型: {},来源单据状态:{}",
                    sourceDoc, sourceDocType,sourceDocStatus);
            throw new BusinessException("未匹配到应收单类型的配置规则");
        }
        if (CollectionUtil.isNotEmpty(arTypeDTOList) && arTypeDTOList.size() > 1 ){
            log.error("匹配到多条应收单类型的配置规则, 来源单据: {},来源单据类型: {},来源单据状态:{}",
                    sourceDoc, sourceDocType,sourceDocStatus);
            throw new BusinessException("匹配到多条应收单类型的配置规则");
        }

        //2.注意调用规则时判断该公司是否分配该规则，如果没分配的话给出提示未分配公司
        Long arTypeId = arTypeDTOList.get(0).getId();
        List<ArTypeOuDTO> arTypeOuDTOList = arTypeOuDomainService.queryByArTypeId(arTypeId);
        if (CollectionUtil.isEmpty(arTypeOuDTOList)){
            log.error("应收单的分配公司为空, 应收单编码: {}", arTypeDTOList.get(0).getArTypeCode());
            throw new BusinessException("应收单的分配公司为空");
        }
        List<String> arTypeOuCodeList = arTypeOuDTOList.stream().map(ArTypeOuDTO::getOuCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<Long> arTypeOuIdList = arTypeOuDTOList.stream().map(ArTypeOuDTO::getOuId).filter(Objects::nonNull).distinct().collect(Collectors.toList());

        if (!arTypeOuIdList.contains(ouId) && !arTypeOuCodeList.contains(ouCode)){
            log.error("应收单未分配该公司, 应收单编码: {},公司ID: {},公司编码: {}", arTypeDTOList.get(0).getArTypeCode(),ouId,ouCode);
            throw new BusinessException("应收单未分配该公司");
        }

        return arTypeDTOList.get(0);
    }

    /**
     * 查询应付单类型的配置规则
     *
     * @param sourceDoc 来源单据
     * @param sourceDocType 来源单据类型
     * @param sourceDocStatus 来源单据状态
     * @param ouId 公司ID
     * @param ouCode 公司编码
     * @return
     */
    private ApTypeDTO selectApType(String sourceDoc,String sourceDocType,String sourceDocStatus,Long ouId,String ouCode){

        //1.来源单据，来源单据类型，来源单据状态等入参，调用该接口时判断是否命中应收单类型的配置规则
        ApTypePageParam apTypeParam = new ApTypePageParam();
        /*apTypeParam.setSourceDoc(sourceDoc);
        apTypeParam.setSourceDocType(sourceDocType);
        apTypeParam.setSourceDocStatus(sourceDocStatus);*/
        //传一个默认编码
        apTypeParam.setApTypeCode(FinConstant.AP_TYPE_CODE_YFD05_SYS);
        List<ApTypeDTO> apTypeDTOList = apTypeDomainService.selectMatchByParam(apTypeParam);
        if (CollectionUtil.isEmpty(apTypeDTOList)){
            log.error("未匹配到应付单类型的配置规则, 来源单据: {},来源单据类型: {},来源单据状态:{}",
                    sourceDoc, sourceDocType,sourceDocStatus);
            throw new BusinessException("未匹配到应付单类型的配置规则");
        }
        if (CollectionUtil.isNotEmpty(apTypeDTOList) && apTypeDTOList.size() > 1 ){
            log.error("匹配到多条应付单类型的配置规则, 来源单据: {},来源单据类型: {},来源单据状态:{}",
                    sourceDoc, sourceDocType,sourceDocStatus);
            throw new BusinessException("匹配到多条应付单类型的配置规则");
        }

        //2.注意调用规则时判断该公司是否分配该规则，如果没分配的话给出提示未分配公司
        Long apTypeId = apTypeDTOList.get(0).getId();
        List<ApTypeOuDTO> apTypeOuDTOList = apTypeOuDomainService.queryByApTypeId(apTypeId);
        if (CollectionUtil.isEmpty(apTypeOuDTOList)){
            log.error("应付单的分配公司为空, 应付单编码: {}", apTypeDTOList.get(0).getApTypeCode());
            throw new BusinessException("应付单的分配公司为空");
        }
        List<String> apTypeOuCodeList = apTypeOuDTOList.stream().map(ApTypeOuDTO::getOuCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<Long> apTypeOuIdList = apTypeOuDTOList.stream().map(ApTypeOuDTO::getOuId).filter(Objects::nonNull).distinct().collect(Collectors.toList());

        if (!apTypeOuIdList.contains(ouId) && !apTypeOuCodeList.contains(ouCode)){
            log.error("应付单未分配该公司, 应付单编码: {},公司ID: {},公司编码: {}", apTypeDTOList.get(0).getApTypeCode(),ouId,ouCode);
            throw new BusinessException("应付单未分配该公司");
        }

        return apTypeDTOList.get(0);
    }

    private String arSpliceGroupKey(InvIoFinReceiptRpcDTO invIoFinReceiptRpcDTO){
        String spliceGroupKey = invIoFinReceiptRpcDTO.getOuId() + FinConstant.LINE_SPLIT +
                invIoFinReceiptRpcDTO.getBuId() + FinConstant.LINE_SPLIT +
                invIoFinReceiptRpcDTO.getIoDate().toLocalDate() + FinConstant.LINE_SPLIT +
                invIoFinReceiptRpcDTO.getCustId() + FinConstant.LINE_SPLIT +
                //FinConstant.LINE_SPLIT + invIoFinReceiptRpcDTO.getCreateUserId() + FinConstant.LINE_SPLIT + invIoFinReceiptRpcDTO.getCreator() +
                //FinConstant.LINE_SPLIT + invIoFinReceiptRpcDTO.getWhId() + FinConstant.LINE_SPLIT + invIoFinReceiptRpcDTO.getDeter2() +
                invIoFinReceiptRpcDTO.getCurrCode() + FinConstant.LINE_SPLIT +
                FinConstant.LINE_SPLIT + invIoFinReceiptRpcDTO.getSrcDocCls() + FinConstant.LINE_SPLIT + invIoFinReceiptRpcDTO.getSrcDocId() +
                FinConstant.LINE_SPLIT + invIoFinReceiptRpcDTO.getSrcDocNo() + FinConstant.LINE_SPLIT + invIoFinReceiptRpcDTO.getSceneCode()
        ;

        return spliceGroupKey;
    }

    private String apSpliceGroupKey(InvIoFinReceiptRpcDTO invIoFinReceiptRpcDTO){
        String spliceGroupKey = invIoFinReceiptRpcDTO.getOuId() + FinConstant.LINE_SPLIT +
                invIoFinReceiptRpcDTO.getBuId() + FinConstant.LINE_SPLIT +
                invIoFinReceiptRpcDTO.getIoDate().toLocalDate() + FinConstant.LINE_SPLIT +
                invIoFinReceiptRpcDTO.getSuppId() + FinConstant.LINE_SPLIT +
                invIoFinReceiptRpcDTO.getIoCode() + FinConstant.LINE_SPLIT +
                //FinConstant.LINE_SPLIT + invIoFinReceiptRpcDTO.getCreateUserId() + FinConstant.LINE_SPLIT + invIoFinReceiptRpcDTO.getCreator() +
                //FinConstant.LINE_SPLIT + invIoFinReceiptRpcDTO.getWhId() + FinConstant.LINE_SPLIT + invIoFinReceiptRpcDTO.getDeter2() +
                invIoFinReceiptRpcDTO.getCurrCode() + FinConstant.LINE_SPLIT +
                FinConstant.LINE_SPLIT + invIoFinReceiptRpcDTO.getSrcDocCls() + FinConstant.LINE_SPLIT + invIoFinReceiptRpcDTO.getSrcDocId() +
                FinConstant.LINE_SPLIT + invIoFinReceiptRpcDTO.getSrcDocNo() +
                FinConstant.LINE_SPLIT + invIoFinReceiptRpcDTO.getSceneCode()
                ;

        return spliceGroupKey;
    }

    private List<SalDoDFinRespDTO> selectSalDodById(List<Long> srcDocDids){
        if (CollectionUtil.isEmpty(srcDocDids)){
            log.info("根据明细ID查询订单(sal_do_d)的入参为空");
            //throw new BusinessException("根据明细ID查询订单(sal_do_d)的入参为空");
            return Collections.EMPTY_LIST;
        }
        SalDoDFinQueryDTO salDoDFinQueryDTO = new SalDoDFinQueryDTO();
        salDoDFinQueryDTO.setIds(srcDocDids);
        ApiResult<List<SalDoDFinRespDTO>> apiResult = salDoDRpcService.queryDodByFinParam(salDoDFinQueryDTO);
        if (!apiResult.isSuccess()){
            log.info("根据明细ID查询订单失败："+apiResult.getMsg());
            throw new BusinessException("根据明细ID查询订单失败："+apiResult.getMsg());
        }
        List<SalDoDFinRespDTO> salDoDFinRespDTOList = apiResult.getData();
        if (CollectionUtil.isEmpty(salDoDFinRespDTOList)){
            log.info("根据明细ID查询订单(sal_do_d)的出参为空,明细ID :{}",srcDocDids);
            throw new BusinessException("根据明细ID查询订单(sal_do_d)的出参为空,明细ID: "+srcDocDids);
        }

        return salDoDFinRespDTOList;

    }

    private List<PurGrDRpcDTO> selectPurGrdById(List<Long> srcDocDids){
        if (CollectionUtil.isEmpty(srcDocDids)){
            log.info("根据明细ID查询采购(pur_gr_d)的入参为空");
           // throw new BusinessException("根据明细ID查询采购(pur_gr_d)的入参为空");
            return Collections.EMPTY_LIST;
        }
        PurGrDParamRpcDTO purGrDParamRpcDTO = new PurGrDParamRpcDTO();
        purGrDParamRpcDTO.setIds(srcDocDids);
        List<PurGrDRpcDTO> purGrDRpcDTOList = purGrDProvider.findGrdByParam(purGrDParamRpcDTO);
        if (CollectionUtil.isEmpty(purGrDRpcDTOList)){
            log.info("根据明细ID查询采购(pur_gr_d)的出参为空,明细ID :{}",srcDocDids);
            throw new BusinessException("根据明细ID查询采购(pur_gr_d)的出参为空,明细ID: "+srcDocDids);
        }

        return purGrDRpcDTOList;

    }

    private List<InvTrnDRpcDTO> selectInvTrndById(List<Long> srcDocDids){
        if (CollectionUtil.isEmpty(srcDocDids)){
            log.info("根据明细ID查询库存(inv_trn_d)的入参为空");
            // throw new BusinessException("根据明细ID查询库存(inv_trn_d)的入参为空");
            return Collections.EMPTY_LIST;
        }
        InvTrnDRpcDtoParam invTrnDRpcDtoParam = new InvTrnDRpcDtoParam();
        invTrnDRpcDtoParam.setIds(srcDocDids);
        List<InvTrnDRpcDTO> invTrnDRpcDTOList = invTrnProvider.queryDodByParam(invTrnDRpcDtoParam);
        if (CollectionUtil.isEmpty(invTrnDRpcDTOList)){
            log.info("根据明细ID查询库存(inv_trn_d)的出参为空,明细ID :{}",srcDocDids);
            throw new BusinessException("根据明细ID查询库存(inv_trn_d)的出参为空,明细ID: "+srcDocDids);
        }

        return invTrnDRpcDTOList;

    }

    private Map<String, String> selectCurrByCode(Set<String> currCodes){
        if (CollectionUtil.isEmpty(currCodes)){
            return new HashMap<>();
        }

        List<SysCurrencyRespDTO> currencyRespDTOS = systemRpcService.findCurrByCodes(currCodes);
        if (CollectionUtil.isEmpty(currencyRespDTOS)){
            return new HashMap<>();
        }
        return currencyRespDTOS.stream().collect(Collectors.toMap(i -> i.getCurrCode(), i -> i.getCurrName(), (o, n) -> n));
    }


}
