package com.elitesland.fin.application.service.excel.exp;

import com.elitescloud.boot.excel.common.DataExport;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.utils.excel.convert.ExcelConvertUtils;
import com.elitesland.fin.application.facade.param.adjusttoorder.AdjustToOrderParam;
import com.elitesland.fin.application.facade.vo.adjusttoorder.AdjustToOrderVO;
import com.elitesland.fin.application.service.adjusttoorder.AdjustToOrderService;
import com.elitesland.fin.application.service.excel.entity.AdjustToExportEntity;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Service;

import java.util.List;

import static com.elitesland.fin.application.service.excel.ExportConstants.FIN_ADJUST_TO_EXPORT;

@Service
@AllArgsConstructor
public class AdjustToExportUsingParamServiceImpl implements DataExport<AdjustToExportEntity, AdjustToOrderParam> {
    private final AdjustToOrderService adjustToOrderService;
    @Override
    public String getTmplCode() {
        return FIN_ADJUST_TO_EXPORT;
    }
    
    @Override
    public PagingVO<AdjustToExportEntity> executeExport(AdjustToOrderParam queryParam) {
        PagingVO<AdjustToOrderVO> page = adjustToOrderService.page(queryParam);
        
        if (!page.isEmpty()) {
            return new PagingVO<>(
                        page.getTotal(),
                        ExcelConvertUtils.convertLoosely(page.getRecords(), AdjustToExportEntity.class)
                    );
        }
        
        return new PagingVO<>(0, List.of());
    }
}
