package com.elitesland.fin.application.service.unionpay;


import com.elitesland.fin.application.facade.param.account.AccountStorageFollowReq;
import com.elitesland.fin.application.facade.param.account.AccountStorageQueryReq;
import com.elitesland.fin.application.service.unionpay.entity.req.SendPayReq;

import java.util.Map;

/**
 * @author sunxw
 * @description 智联交互service
 * @Date 2023/5/18
 */
public interface UnionPayService {

    /**
     * 发起支付
     * pay请求参数
     * @return map:支付接口的实时响应类
     */
    Map<String,Object> sendPay(SendPayReq payReq);

    /**
     * 支付回调
     * @param data
     */
    void payCallBack(Map<String,String> data);

    /**
     * 后续类交易
     * @param req
     * @return
     */
    String followPay(AccountStorageFollowReq req);

    /**
     * 后续类交易回调
     * @param data
     */
    void followPayCallback(Map<String, String> data);

    /**
     * 交易查询
     * @param req
     * @return
     */
    String queryPay(AccountStorageQueryReq req);
}
