package com.elitesland.fin.application.service.writeoff;

import com.elitesland.fin.application.convert.writeoff.FinApPayVerApplyPayHeadConvert;
import com.elitesland.fin.application.facade.dto.writeoff.FinApPayVerApplyPayHeadSaveDTO;
import com.elitesland.fin.application.facade.param.writeoff.FinApPayVerApplyQuery;
import com.elitesland.fin.application.facade.vo.writeoff.FinApPayVerApplyPayHeadVO;
import com.elitesland.fin.common.FinFlexFieldCodeConstant;
import com.elitesland.fin.domain.entity.writeoff.FinApPayVerApplyPayHeadDO;
import com.elitesland.fin.repo.writeoff.FinApPayVerApplyPayHeadRepo;
import com.elitesland.fin.repo.writeoff.FinApPayVerApplyPayHeadRepoProc;
import com.elitesland.support.provider.flexField.service.FlexFieldUtilService;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 核销申请.
 *
 * @author shihao.ma
 * @since 2023/9/6
 */
@Service
@RequiredArgsConstructor
public class FinApPayVerApplyPayHeadServiceImpl implements FinApPayVerApplyPayHeadService {

    private final FinApPayVerApplyPayHeadRepoProc finApPayVerApplyPayHeadRepoProc;

    private final FinApPayVerApplyPayHeadRepo finApPayVerApplyPayHeadRepo;
    private final FlexFieldUtilService flexFieldUtilService;


    @Override
    public Long create(Long masId, FinApPayVerApplyPayHeadSaveDTO param) {
        Assert.notNull(masId, "主表ID不能为Null");

        FinApPayVerApplyPayHeadDO entity = FinApPayVerApplyPayHeadConvert.INSTANCE.DTO2DO(param);
        entity.setMasId(masId);
        flexFieldUtilService.handFlexFieldValueFeference(FinFlexFieldCodeConstant.FIN_AP_PAY_VER_APPLY_PAY_HEAD, entity);
        return finApPayVerApplyPayHeadRepo.save(entity).getId();
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteByMasId(Collection<Long> masIds) {
        finApPayVerApplyPayHeadRepoProc.deleteByMasId(masIds);
    }

    @Override
    public List<FinApPayVerApplyPayHeadVO> listByMasIds(Collection<Long> masIds) {
        return finApPayVerApplyPayHeadRepoProc.listByMasIds(masIds)
                .stream()
                .map(FinApPayVerApplyPayHeadConvert.INSTANCE::DO2VO)
                .collect(Collectors.toList());
    }

	@Override
	public List<FinApPayVerApplyPayHeadVO> listByIds(FinApPayVerApplyQuery query,Collection<Long> ids) {
		return finApPayVerApplyPayHeadRepoProc.listByIds(query,ids)
				.stream()
				.map(FinApPayVerApplyPayHeadConvert.INSTANCE::DO2VO)
				.collect(Collectors.toList());
	}
}
