package com.elitesland.fin.application.service.writeoff;

import com.elitescloud.boot.exception.BusinessException;
import com.elitesland.fin.application.convert.writeoff.FinArRecVerApplySettleConvert;
import com.elitesland.fin.application.facade.dto.writeoff.FinArRecVerApplySettleSaveDTO;
import com.elitesland.fin.application.facade.vo.writeoff.FinArRecVerApplySettleVO;
import com.elitesland.fin.domain.entity.writeoff.FinArRecVerApplySettleDO;
import com.elitesland.fin.repo.writeoff.FinArRecVerApplySettleRepoProc;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 核销申请明细拆分.
 *
 * @author shihao.ma
 * @since 2023/9/19
 */
@Service
@RequiredArgsConstructor
public class FinArRecVerApplySettleServiceImpl implements FinArRecVerApplySettleService {

    private final FinArRecVerApplySettleRepoProc finArRecVerApplySettleRepoProc;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void createBatch(Long masId, List<FinArRecVerApplySettleSaveDTO> saveList) {
        Assert.notNull(masId, "主表ID不能为Null");
        if (CollectionUtils.isEmpty(saveList)) {
            return;
        }
        finArRecVerApplySettleRepoProc.save(saveList.stream()
                .map(e -> {
                    FinArRecVerApplySettleDO entity = FinArRecVerApplySettleConvert.INSTANCE.save2Do(e);
                    entity.setMasId(masId);
                    return entity;
                }).collect(Collectors.toList()));
    }

    @Override
    public List<FinArRecVerApplySettleVO> listByMasIds(Collection<Long> masIds) {
        return finArRecVerApplySettleRepoProc.listByMasIds(masIds)
                .stream()
                .map(FinArRecVerApplySettleConvert.INSTANCE::entity2Vo)
                .collect(Collectors.toList());
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void updateBatchNo(Collection<Long> masIds, String bachNo) {
        if (finArRecVerApplySettleRepoProc.updateBatchNo(masIds, bachNo) <=0) {
            throw new BusinessException("更新核销处理编号失败!");
        }
    }

	/**
	 * 更新核销处理核销类型
	 * @param masIds
	 * @param verFlag
	 */
	@Override
	@Transactional(rollbackFor = Exception.class)
	public void updateVerFlag(Collection<Long> masIds, String verFlag) {
		if (finArRecVerApplySettleRepoProc.updateVerFlag(masIds, verFlag) <=0) {
			throw new BusinessException("更新核销处理编号失败!");
		}
	}

	/**
	 * 更新核销批次号-应收
	 * @param arDid
	 * @param batchNo
	 */
	@Override
	@Transactional(rollbackFor = Exception.class)
	public void updateBatchNoByArDid(String arDid, String batchNo) {
		if (finArRecVerApplySettleRepoProc.updateBatchNoByArDid(arDid, batchNo) <=0) {
			throw new BusinessException("更新核销批次号失败!");
		}
	}

	/**
	 * 更新核销批次号-应收
	 * @param rcDid
	 * @param batchNo
	 */
	@Override
	@Transactional(rollbackFor = Exception.class)
	public void updateBatchNoByRcDid(String rcDid, String batchNo) {
		if (finArRecVerApplySettleRepoProc.updateBatchNoByRcDid(rcDid, batchNo) <=0) {
			throw new BusinessException("更新核销批次号失败!");
		}
	}
}
