package com.elitesland.fin.domain.entity.arorder;

import cn.hutool.core.lang.Assert;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.exception.BusinessException;
import com.elitesland.fin.common.UdcEnum;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @author wang.xl
 * @version V1.0
 * @Package com.elitesland.fin.domain.entity.arorder
 * @date 2022/4/12 16:43
 */
@Data
public class ArOrderDtl {

    private Long id;

    private Long masId;

    private String sourceNo;

    private Integer sourceLine;

    private Long itemId;

    private String itemCode;

    private String itemName;

    private String itemType;

    private String smallCateCode;

    private String smallCateName;

    private String uom;

    private String uomName;

    private BigDecimal qty;

    private BigDecimal exclTaxPrice;

    private BigDecimal price;

    private BigDecimal taxRate;

    private BigDecimal totalAmt;

    private BigDecimal exclTaxAmt;

    private BigDecimal taxAmt;

    private BigDecimal totalCurAmt;

    private BigDecimal exclTaxCurAmt;

    private BigDecimal taxCurAmt;

    private String buCode;

    private Long buId;

    private String buName;

    private String expensesType;

    private String remark;

    @ApiModelProperty("扩展表关联字段")
    private Long relateId;

    @ApiModelProperty("发货单号")
    private String es11;

    @ApiModelProperty("发货单明细ID（开票申请单）")
    private Long es12;

    @ApiModelProperty("订单客户")
    private String es13;

    @ApiModelProperty("客户编码")
    private String es14;

    @ApiModelProperty("未税单价")
    private BigDecimal es15;

    @ApiModelProperty("税码")
    private String es16;

    @ApiModelProperty("发票号")
    private String es17;

    @ApiModelProperty("发票类型")
    private String es18;

    @ApiModelProperty("收款协议")
    private String es19;

    @ApiModelProperty("业务员编码")
    private String es20;

    @ApiModelProperty("币种")
    private String es21;

    @ApiModelProperty("汇率")
    private BigDecimal es22;

    @ApiModelProperty("起算日期")
    private LocalDateTime es23;

    @ApiModelProperty("到期付款日")
    private LocalDateTime es24;

    @ApiModelProperty("具体订单场景")
    private String docType;

    @ApiModelProperty("B端订单/C端订单")
    private String docType2;

    @ApiModelProperty("传SO代表正向，传RSO代表退货负向")
    private String docCls;
    @ApiModelProperty("未核销金额")
    private BigDecimal unVerAmt;

    @ApiModelProperty("已核销金额")
    private BigDecimal verAmt;

    @ApiModelProperty("核销申请中金额")
    private BigDecimal applyVerAmTing;
//
//    @ApiModelProperty("第三方应收单明细id")
//    private Long es25;

    @ApiModelProperty("创建人ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long createUserId;

    @ApiModelProperty("创建时间")
    private LocalDateTime createTime;

    @ApiModelProperty("创建人")
    private String creator;

    @ApiModelProperty("收款协议编码")
    private String protocolCode;
    /**
     * 字段必填校验
     */
    public void check(String createMode) {
        // 若是手工
        if (createMode.equals(UdcEnum.FIN_AR_DOC_CLS_MANU.getValueCode())) {

            // 商品信息
            Assert.notNull(this.itemId, "商品信息 itemId is null");
            Assert.notEmpty(this.itemCode, "商品信息 itemCode is null");
            Assert.notEmpty(this.itemName, "商品信息 itemName is null");
            // 单位信息
            Assert.notEmpty(this.uom, "单位信息 uom is null");
            Assert.notEmpty(this.uomName, "单位信息 uomName is null");
            // 含税单价
            Assert.notNull(this.price, "单价 price is null");
            // 不含税单价
            Assert.notNull(this.exclTaxPrice, "不含税单价 exclTaxPrice is null");
            // 数量
            Assert.notNull(this.qty, "数量 qty is null");
            // 税率
            Assert.notNull(this.taxRate, "税率 taxRate is null");
            // 含税金额
            Assert.notNull(this.totalAmt, "含税金额 totalAmt is null");
            Assert.notNull(this.totalCurAmt, "含税金额(本位币) totalCurAmt is null");
            // 税额
            Assert.notNull(this.taxAmt, "税额 taxAmt is null");
            Assert.notNull(this.taxCurAmt, "税额(本位币) taxCurAmt is null");
            // 不含税金额
            Assert.notNull(this.exclTaxAmt, "不含税金额 exclTaxAmt is null");
            Assert.notNull(this.exclTaxCurAmt, "不含税金额(本位币) exclTaxCurAmt is null");

            if (BigDecimal.ZERO.compareTo(this.qty) == 0) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "数量不能为0 !");
            }
            if (this.price.compareTo(BigDecimal.ZERO) < 0) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "含税单价需大于等于0 !");
            }
            if (this.exclTaxPrice.compareTo(BigDecimal.ZERO) < 0) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "不含税单价需大于等于0 !");
            }
        }
        // 销售订单
        if (createMode.equals(UdcEnum.FIN_AR_DOC_CLS_SO.getValueCode())) {
            // 来源单号
            Assert.notNull(this.sourceNo, "来源单号 sourceNo is null");
            Assert.notNull(this.sourceLine, "来源行号 sourceLine is null");
            Assert.notNull(this.itemId, "商品id itemId is null");
            Assert.notEmpty(this.itemCode, "商品编码 itemCode is null");
            Assert.notEmpty(this.itemName, "商品名称 itemName is null");
            Assert.notNull(this.itemType, "规格型号 itemType is null");
            // 小类信息
            Assert.notNull(this.smallCateCode, "小类编码 smallCateCode is null");
            Assert.notNull(this.smallCateName, "小类名称 smallCateName is null");

            Assert.notNull(this.uom, "单位 uom is null");
            Assert.notNull(this.qty, "数量 qty is null");
            Assert.notNull(this.price, "单价 price is null");
            Assert.notNull(this.totalAmt, "含税金额 totalAmt is null");
            Assert.notNull(this.taxRate, "税率 taxRate is null");
            Assert.notNull(this.taxAmt, "税额 taxAmt is null");
            Assert.notNull(this.exclTaxAmt, "不含税金额 exclTaxAmt is null");

        }
        //TODO 明细协议必填校验
       // Assert.notEmpty(this.protocolCode, "收款协议 protocolCode is null");

    }

}
