package com.elitesland.fin.domain.entity.writeoff;

import com.elitescloud.boot.core.support.customfield.common.CustomFieldBaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.time.LocalDateTime;

/**
 * 应付付款核销申请单-应付单
 * @author gyj
 */
@Entity
@Table(name = "fin_ap_pay_ver_apply_ap_head")
@DynamicInsert
@DynamicUpdate
@Comment("应付付款核销申请单-应付单")
@Getter
@Setter
@Accessors(chain = true)
public class FinApPayVerApplyApHeadDO   extends CustomFieldBaseModel {
private static final long serialVersionUID =39696237752654810L;

	@Column(name = "in_out_cust", columnDefinition = "varchar(40)  comment '内外部客户'")
	private String inOutCust;
	/**
	 * 主表id
	 * nullable : false
	 * default  : null
	 */
	@ApiModelProperty(value = "主表id")
    @JsonSerialize(using = ToStringSerializer.class)
	@Column(name = "mas_id", nullable = true)
	private Long masId;

	/**
	 * 来源单号
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "来源单号")
	@Column(name = "source_no", nullable = true, length = 32)
	private String sourceNo;

	/**
	 * 应付单编号
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "应付单编号")
	@Column(name = "ap_order_no", nullable = true, length = 32)
	private String apOrderNo;

	/**
	 * 公司编码
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "公司编码")
	@Column(name = "ou_code", nullable = true, length = 32)
	private String ouCode;

	/**
	 * 公司ID
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "公司ID")
    @JsonSerialize(using = ToStringSerializer.class)
	@Column(name = "ou_id", nullable = true)
	private Long ouId;

	/**
	 * 公司名称
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "公司名称")
	@Column(name = "ou_name", nullable = true, length = 32)
	private String ouName;

	/**
	 * 单据来源
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "单据来源")
	@Column(name = "create_mode", nullable = true, length = 32)
	private String createMode;

	/**
	 * 应收单类型定义ID
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "应收单类型定义ID")
    @JsonSerialize(using = ToStringSerializer.class)
	@Column(name = "ap_type_id", nullable = true)
	private Long apTypeId;

	/**
	 * 应付单类型名称
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "应付单类型名称")
	@Column(name = "ap_type_name", nullable = true, length = 32)
	private String apTypeName;

	/**
	 * 应付单类型代码
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "应付单类型代码")
	@Column(name = "ap_type_code", nullable = true, length = 32)
	private String apTypeCode;

	/**
	 * 单据状态
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "单据状态")
	@Column(name = "order_state", nullable = true, length = 32)
	private String orderState;

	/**
	 * 业务日期
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "业务日期")
	@Column(name = "bu_date", nullable = true)
	private LocalDateTime buDate;

	/**
	 * 含税总金额
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "含税总金额")
	@Column(name = "total_amt", nullable = true, length = 18)
	private Double totalAmt;

	/**
	 * 不含税总金额
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "不含税总金额")
	@Column(name = "excl_tax_amt", nullable = true, length = 18)
	private Double exclTaxAmt;

	/**
	 * 税额
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "税额")
	@Column(name = "tax_amt", nullable = true, length = 18)
	private Double taxAmt;

	/**
	 * 含税总金额(本位币)
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "含税总金额(本位币)")
	@Column(name = "total_cur_amt", nullable = true, length = 18)
	private Double totalCurAmt;

	/**
	 * 不含税总金额(本位币)
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "不含税总金额(本位币)")
	@Column(name = "excl_tax_cur_amt", nullable = true, length = 18)
	private Double exclTaxCurAmt;

	/**
	 * 税额(本位币)
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "税额(本位币)")
	@Column(name = "tax_cur_amt", nullable = true, length = 18)
	private Double taxCurAmt;

	/**
	 * 币种编码
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "币种编码")
	@Column(name = "curr_code", nullable = true, length = 32)
	private String currCode;

	/**
	 * 币种
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "币种")
	@Column(name = "curr_name", nullable = true, length = 32)
	private String currName;

	/**
	 * 本位币编码
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "本位币编码")
	@Column(name = "local_curr_code", nullable = true, length = 32)
	private String localCurrCode;

	/**
	 * 本位币名称
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "本位币名称")
	@Column(name = "local_curr_name", nullable = true, length = 32)
	private String localCurrName;

	/**
	 * 审核人ID
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "审核人ID")
    @JsonSerialize(using = ToStringSerializer.class)
	@Column(name = "audit_user_id", nullable = true)
	private Long auditUserId;

	/**
	 * 审核人
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "审核人")
	@Column(name = "audit_user", nullable = true, length = 32)
	private String auditUser;

	/**
	 * 审核日期
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "审核日期")
	@Column(name = "audit_date", nullable = true)
	private LocalDateTime auditDate;

	/**
	 * 汇率
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "汇率")
	@Column(name = "exchange_rate", nullable = true, length = 18)
	private Double exchangeRate;

	/**
	 * 经办人ID
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "经办人ID")
    @JsonSerialize(using = ToStringSerializer.class)
	@Column(name = "oper_user_id", nullable = true)
	private Long operUserId;

	/**
	 * 经办人
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "经办人")
	@Column(name = "operator", nullable = true, length = 32)
	private String operator;

	/**
	 * 是否含税
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "是否含税")
	@Column(name = "tax_flag", nullable = true, length = 1)
	private Boolean taxFlag;

	/**
	 * 是否期初
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "是否期初")
	@Column(name = "init_flag", nullable = true, length = 1)
	private Boolean initFlag;

	/**
	 * 审核拒绝理由
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "审核拒绝理由")
	@Column(name = "audit_rejection", nullable = true, length = 128)
	private String auditRejection;

	/**
	 * 供应商ID
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "供应商ID")
    @JsonSerialize(using = ToStringSerializer.class)
	@Column(name = "supp_id", nullable = true)
	private Long suppId;

	/**
	 * 供应商编号
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "供应商编号")
	@Column(name = "supp_code", nullable = true, length = 32)
	private String suppCode;

	/**
	 * 供应商名称
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "供应商名称")
	@Column(name = "supp_name", nullable = true, length = 32)
	private String suppName;

	/**
	 * 部门ID
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "部门ID")
    @JsonSerialize(using = ToStringSerializer.class)
	@Column(name = "bu_id", nullable = true)
	private Long buId;

	/**
	 * 部门编码
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "部门编码")
	@Column(name = "bu_code", nullable = true, length = 32)
	private String buCode;

	/**
	 * 部门名称
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "部门名称")
	@Column(name = "bu_name", nullable = true, length = 32)
	private String buName;

	/**
	 * 业务类型
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "业务类型")
	@Column(name = "bu_type", nullable = true, length = 32)
	private String buType;

	/**
	 * 付款条件
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "付款条件")
	@Column(name = "pay_ment_name", nullable = true, length = 32)
	private String payMentName;

	/**
	 * 付款条件id
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "付款条件id")
	@Column(name = "pay_ment_id", nullable = true, length = 20)
	private String payMentId;

	/**
	 * 付款条件code
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "付款条件code")
	@Column(name = "pay_ment_code", nullable = true, length = 32)
	private String payMentCode;

	/**
	 * 核销状态
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "核销状态")
	@Column(name = "ver_state", nullable = true, length = 32)
	private String verState;

	/**
	 * 已核销金额
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "已核销金额")
	@Column(name = "ver_amt", nullable = true, length = 18)
	private Double verAmt;

	/**
	 * 未核销金额
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "未核销金额")
	@Column(name = "un_ver_amt", nullable = true, length = 18)
	private Double unVerAmt;

	/**
	 * 组织ID
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "组织ID")
    @JsonSerialize(using = ToStringSerializer.class)
	@Column(name = "org_id", nullable = true)
	private Long orgId;

	/**
	 * 组织编码
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "组织编码")
	@Column(name = "org_code", nullable = true, length = 32)
	private String orgCode;

	/**
	 * 组织名称
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "组织名称")
	@Column(name = "org_name", nullable = true, length = 32)
	private String orgName;

	/**
	 * 单据类型
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "单据类型")
	@Column(name = "ap_order_type", nullable = true, length = 32)
	private String apOrderType;

	/**
	 * 流程实例ID
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "流程实例ID")
	@Column(name = "proc_inst_id", nullable = true, length = 64)
	private String procInstId;

	/**
	 * 流程实例状态
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "流程实例状态")
	@Column(name = "proc_inst_status", nullable = true, length = 32)
	private String procInstStatus;

	/**
	 * 提交时间
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "提交时间")
	@Column(name = "submit_time", nullable = true)
	private LocalDateTime submitTime;

	/**
	 * 审批通过时间
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "审批通过时间")
	@Column(name = "approved_time", nullable = true)
	private LocalDateTime approvedTime;

	/**
	 * 具体采购订单场景
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "具体采购订单场景")
	@Column(name = "doc_type", nullable = true, length = 32)
	private String docType;

	/**
	 * B端订单/C端采购订单
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "B端订单/C端采购订单")
	@Column(name = "doc_type2", nullable = true, length = 32)
	private String docType2;

	/**
	 * 传PO代表正向，传RNS代表退货负向
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "传PO代表正向，传RNS代表退货负向")
	@Column(name = "doc_cls", nullable = true, length = 32)
	private String docCls;

	/**
	 * 所属组织ID
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "所属组织ID")
    @JsonSerialize(using = ToStringSerializer.class)
	@Column(name = "belong_org_id", nullable = true)
	private Long belongOrgId;

	/**
	 * 租户组织ID
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "租户组织ID")
    @JsonSerialize(using = ToStringSerializer.class)
	@Column(name = "tenant_org_id", nullable = true)
	private Long tenantOrgId;

	/**
	 * 结算方式
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "结算方式")
	@Column(name = "settlement_type", nullable = true, length = 32)
	private String settlementType;

	/**
	 * 应付单主表扩展表关联id
	 * nullable : true
	 * default  : null
	 */
/*	@ApiModelProperty(value = "应付单主表扩展表关联id")
    @JsonSerialize(using = ToStringSerializer.class)
	@Column(name = "relate_id", nullable = true)
	private Long relateId;*/

	/**
	 * 订单客户
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "订单客户")
	@Column(name = "order_customer", nullable = true, length = 32)
	private String orderCustomer;

	/**
	 * 发票号
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "发票号")
	@Column(name = "invoice_number", nullable = true, length = 32)
	private String invoiceNumber;

	/**
	 * 开票日期
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "开票日期")
	@Column(name = "inv_date", nullable = true)
	private LocalDateTime invDate;

	/**
	 * 发票类型
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "发票类型")
	@Column(name = "inv_type", nullable = true, length = 32)
	private String invType;

	/**
	 * 起算日期
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "起算日期")
	@Column(name = "start_date", nullable = true)
	private LocalDateTime startDate;

	/**
	 * 红冲标志
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "红冲标志")
	@Column(name = "red_flush_sign", nullable = true, length = 1)
	private Boolean redFlushSign;

/*	*//**
	 * 第三方支付辅助
	 * nullable : true
	 * default  : null
	 *//*
	@ApiModelProperty(value = "第三方支付辅助")
	@Column(name = "third_payment_assistance", nullable = true, length = 32)
	private String thirdPaymentAssistance;

	*//**
	 * 消费卡辅助
	 * nullable : true
	 * default  : null
	 *//*
	@ApiModelProperty(value = "消费卡辅助")
	@Column(name = "consumer_card_ssistance", nullable = true, length = 32)
	private String consumerCardSsistance;

	*//**
	 * 信用卡辅助
	 * nullable : true
	 * default  : null
	 *//*
	@ApiModelProperty(value = "信用卡辅助")
	@Column(name = "credit_card_assistance", nullable = true, length = 32)
	private String creditCardAssistance;*/

	/**
	 * 核销申请中金额
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "核销申请中金额")
	@Column(name = "apply_ver_amting", nullable = true, length = 16)
	private Double applyVerAmting;

	/**
	 * 业务员编码
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "业务员编码")
	@Column(name = "salesman_code", nullable = true, length = 32)
	private String salesmanCode;
}
