package com.elitesland.fin.domain.entity.writeoff;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * 应收收款核销申请单.
 *
 * @author shihao.ma
 * @since 2023/9/6
 */
@Entity
@Table(name = "fin_ar_rec_ver_apply",
        indexes = {
                @Index(name = "idx_applyDocNo", columnList = "applyDocNo", unique = true)
        })
@DynamicInsert
@DynamicUpdate
@Comment("应收收款核销申请单")
@Getter
@Setter
@Accessors(chain = true)
public class FinArRecVerApplyDO extends BaseModel {

    private static final long serialVersionUID = -5618723622648366293L;

    @Column(name = "in_out_cust", columnDefinition = "varchar(40)  comment '内外部客户'")
    private String inOutCust;

    @Comment("核销申请单号")
    @Column(nullable = false, length = 64)
    private String applyDocNo;

    @Comment("单据状态")
    @Column(nullable = false, length = 16)
    private String state;

    @Comment("核销状态")
    @Column(nullable = false, length = 16)
    private String verState;

    @Comment("核销金额")
    @Column(precision = 20, scale = 4)
    private BigDecimal verAmt;

    @Comment("申请日期")
    @Column()
    private LocalDateTime applyDate;

    @Comment("申请人ID")
    @Column()
    private Long applyUserId;

    @Comment("申请人编码")
    @Column(length = 32)
    private String applyUserCode;

    @Comment("申请人名称")
    @Column(length = 32)
    private String applyUserName;

    @Comment("审批日期")
    @Column()
    private LocalDateTime approvalDate;

    @Comment("审批人ID")
    @Column()
    private Long approvalUserId;

    @Comment("审批人编码")
    @Column(length = 32)
    private String approvalUserCode;

    @Comment("审批人名称")
    @Column(length = 32)
    private String approvalUserName;

    @Comment("审批意见")
    @Column(length = 64)
    private String approvalRemark;

    @Column(name = "head_flag", columnDefinition = "tinyint(1)  comment '表头标识符'")
    private Boolean headFlag;
/*
	@Comment("推送nc失败原因")
	@Column()
	private String erpLog;*/

    @Comment("拟定状态，DRAFT：草稿，PROPOSING：拟定中，PROPOSED_FAIL：拟定失败，PROPOSED_SUCCESS：拟定成功，SENDING：传输中，SEND_FAIL：传输失败，SEND_SUCCESS：传输成功")
    @Column(name = "proposed_status", columnDefinition = "varchar(100) comment ''")
    private String proposedStatus;

    @Comment("公司编码")
    @Column(columnDefinition = "varchar(32)")
    private String ouCode;

    @Comment("公司ID")
    @Column(columnDefinition = "bigint(20)")
    private Long ouId;

    @Comment("公司名称")
    @Column(columnDefinition = "varchar(32)")
    private String ouName;

    @Comment("核销方案ID")
    @Column(name="scheme_id")
    private Long schemeId;

    @Comment("核销方式")
    @Column(name="ver_mode")
    private String verMode;
    @Override
    public boolean equals(Object o) {
        if (super.equals(o)) {
            return o instanceof FinArRecVerApplyDO;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}
