package com.elitesland.fin.domain.entity.writeoff;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * 应收收款核销申请单明细-收款单.
 *
 * @author shihao.ma
 * @since 2023/9/6
 */
@Entity
@Table(name = "fin_ar_rec_ver_apply_rec",
        indexes = {
                @Index(name = "idx_masId", columnList = "masId")
        })
@DynamicInsert
@DynamicUpdate
@Comment("应收收款核销申请单明细-收款单")
@Getter
@Setter
@Accessors(chain = true)
public class FinArRecVerApplyRecDO extends BaseModel {

    private static final long serialVersionUID = 257498122806579926L;

    @Comment("主表ID")
    @Column(nullable = false)
    private Long masId;

    @Comment("收款单ID")
    @Column(nullable = false)
    private Long recId;

    @Comment("收款单号")
    @Column(nullable = false, length = 64)
    private String recDocNo;

    @Comment("收款单明细ID")
    @Column(name = "rec_d_id")
    private Long recDId;

    @Comment("第三方收款单ID")
    @Column(nullable = false)
    private Long outRecId;

    @Comment("第三方收款单号")
    @Column(nullable = false, length = 64)
    private String outRecDocNo;

    @Comment("第三方收款单明细ID")
    @Column(name = "out_rec_d_id", length = 32)
    private String outRecDId;

    @Comment("收款单类型ID")
    @Column()
    private Long recTypeId;

    @Comment("收款单类型编码")
    @Column(length = 32)
    private String recTypeCode;

    @Comment("收款单类型名称")
    @Column(length = 32)
    private String recTypeName;

    @Comment("公司ID")
    @Column()
    private Long ouId;

    @Comment("公司编码")
    @Column(length = 32)
    private String ouCode;

    @Comment("公司名称")
    @Column(length = 32)
    private String ouName;

    @Comment("部门ID")
    @Column()
    private Long buId;

    @Comment("部门编码")
    @Column(length = 32)
    private String buCode;

    @Comment("部门名称")
    @Column(length = 32)
    private String buName;

    @Comment("业务员ID")
    @Column(length = 32)
    private Long salesmanId;

    @Comment("业务员编码")
    @Column(length = 32)
    private String salesmanCode;

    @Comment("业务员名称")
    @Column(length = 32)
    private String salesmanName;

    @Comment("发票号")
    @Column(length = 32)
    private String invoiceNumber;

    @Comment("开票日期")
    @Column()
    private LocalDateTime invDate;

    @Comment("发票类型")
    @Column(length = 16)
    private String invType;

    @Comment("客户ID")
    @Column(length = 32)
    private Long custId;

    @Comment("客户编码")
    @Column(length = 32)
    private String custCode;

    @Comment("客户名称")
    @Column(length = 32)
    private String custName;

    @Comment("收款业务类型")
    @Column(length = 32)
    private String recBuType;

    @Comment("收款性质")
    @Column(length = 32)
    private String recNat;

    @Comment("含税总金额")
    @Column(precision = 20, scale = 4)
    private BigDecimal totalAmt;

    @Comment("收款银行账户")
    @Column(length = 32)
    private String recBank;

    @Comment("付款银行账户")
    @Column(length = 32)
    private String payBank;

    @Comment("收款单单据日期")
    @Column()
    private LocalDateTime recDate;

    @Comment("备注")
    @Column()
    private String remark;

    @Comment("未核销金额")
    @Column(precision = 20, scale = 4)
    private BigDecimal notVerAmt;

    @Comment("本次核销金额")
    @Column(precision = 20, scale = 4)
    private BigDecimal verAmt;

    @Override
    public boolean equals(Object o) {
        if (super.equals(o)) {
            return o instanceof FinArRecVerApplyRecDO;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}
