package com.elitesland.fin.domain.service.aporder;

import com.elitesland.fin.domain.param.aporder.ApOrderDtlPageParam;
import com.elitesland.fin.infr.dto.aporder.ApOrderDtlDTO;
import com.elitescloud.cloudt.common.base.PagingVO;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * @author wang.xl
 * @version V1.0
 * @Package com.elitesland.fin.domain.service.aporder
 * @date 2022/3/17 11:56
 */
public interface ApOrderDtlDomainService {

    PagingVO<ApOrderDtlDTO> page(ApOrderDtlPageParam apOrderDtlPageParam);

    Long del(List<Long> ids);

    /**
     * 回写单据核销金额，更新核销状态
     *
     * @param apDIdVerAmtMap
     * @param apDIds
     */
    void updateVerAmt(Map<Long, BigDecimal> apDIdVerAmtMap, List<Long> apDIds);

    /**
     * 将审批取消的核销金额，从明细减去，还原核销状态
     *
     * @param apDIdVerAmtMap
     * @param apDIds
     */
    void resortVerAmt(Map<Long, BigDecimal> apDIdVerAmtMap, List<Long> apDIds);
}
